/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class SCS2OutputWriter
implements JointDesiredOutputWriter {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ControllerInput controllerInput;
    private final ControllerOutput controllerOutput;
    private final boolean writeBeforeEstimatorTick;
    private final List<JointController> jointControllers = new ArrayList<JointController>();
    private final Map<String, JointController> jointControllerMap = new HashMap<String, JointController>();
    private final YoDouble unstableVelocityThreshold = new YoDouble("unstableVelocityThreshold", this.registry);
    private final YoInteger unstableVelocityNumberThreshold = new YoInteger("unstableVelocityNumberThreshold", this.registry);
    private final YoDouble unstableVelocityLowDampingScale = new YoDouble("unstableVelocityLowDampingScale", this.registry);
    private final YoDouble unstableVelocityLowDampingDuration = new YoDouble("unstableVelocityLowDampingDuration", this.registry);
    private JointDesiredOutputWriter customWriter;

    public SCS2OutputWriter(ControllerInput controllerInput, ControllerOutput controllerOutput, boolean writeBeforeEstimatorTick) {
        this(controllerInput, controllerOutput, writeBeforeEstimatorTick, null);
    }

    public SCS2OutputWriter(ControllerInput controllerInput, ControllerOutput controllerOutput, boolean writeBeforeEstimatorTick, JointDesiredOutputWriter customWriter) {
        this.controllerInput = controllerInput;
        this.controllerOutput = controllerOutput;
        this.writeBeforeEstimatorTick = writeBeforeEstimatorTick;
        this.customWriter = customWriter;
        if (customWriter != null) {
            this.registry.addChild(customWriter.getYoVariableRegistry());
        }
        this.unstableVelocityThreshold.set(0.45);
        this.unstableVelocityNumberThreshold.set(10);
        this.unstableVelocityLowDampingScale.set(0.25);
        this.unstableVelocityLowDampingDuration.set(0.5);
    }

    public void setJointDesiredOutputList(JointDesiredOutputListBasics jointDesiredOutputList) {
        if (this.customWriter != null) {
            this.customWriter.setJointDesiredOutputList(jointDesiredOutputList);
        }
        this.jointControllers.clear();
        for (int i = 0; i < jointDesiredOutputList.getNumberOfJointsWithDesiredOutput(); ++i) {
            OneDoFJointReadOnly controllerJoint = jointDesiredOutputList.getOneDoFJoint(i);
            JointDesiredOutputBasics jointDesiredOutput = jointDesiredOutputList.getJointDesiredOutput(i);
            if (controllerJoint instanceof CrossFourBarJointBasics) {
                JointController jointController;
                CrossFourBarJointBasics controllerFourBarJoint = (CrossFourBarJointBasics)controllerJoint;
                if (this.controllerOutput.getInput().findJoint(controllerFourBarJoint.getName()) != null) {
                    OneDoFJointStateBasics simJointInput = this.controllerOutput.getOneDoFJointOutput(controllerJoint);
                    OneDoFJointReadOnly simJointOutput = (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerJoint.getName());
                    jointController = new OneDoFJointController(simJointOutput, simJointInput, (JointDesiredOutputReadOnly)jointDesiredOutput, this.registry);
                    this.jointControllers.add(jointController);
                    this.jointControllerMap.put(controllerFourBarJoint.getName(), jointController);
                    continue;
                }
                OneDoFJointStateBasics[] simInputs = new OneDoFJointStateBasics[]{this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointA()), this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointB()), this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointC()), this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointD())};
                OneDoFJointReadOnly[] simOutputs = new OneDoFJointReadOnly[]{(OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointA().getName()), (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointB().getName()), (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointC().getName()), (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointD().getName())};
                jointController = new CrossFourBarJointController(controllerFourBarJoint, simOutputs, simInputs, (JointDesiredOutputReadOnly)jointDesiredOutput, this.registry);
                this.jointControllers.add(jointController);
                this.jointControllerMap.put(controllerFourBarJoint.getName(), jointController);
                continue;
            }
            OneDoFJointStateBasics simJointInput = this.controllerOutput.getOneDoFJointOutput(controllerJoint);
            OneDoFJointReadOnly simJointOutput = (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerJoint.getName());
            OneDoFJointController jointController = new OneDoFJointController(simJointOutput, simJointInput, (JointDesiredOutputReadOnly)jointDesiredOutput, this.registry);
            this.jointControllers.add(jointController);
            this.jointControllerMap.put(simJointOutput.getName(), jointController);
        }
    }

    protected void write() {
        for (int i = 0; i < this.jointControllers.size(); ++i) {
            this.jointControllers.get(i).doControl();
        }
    }

    public void writeBefore(long timestamp) {
        if (this.customWriter != null) {
            this.customWriter.writeBefore(timestamp);
        }
        if (this.writeBeforeEstimatorTick) {
            this.write();
        }
    }

    public void writeAfter() {
        if (this.customWriter != null) {
            this.customWriter.writeAfter();
        }
        if (!this.writeBeforeEstimatorTick) {
            this.write();
        }
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public void setOneDoFJointConfigurationCorruptor(String jointName, OneDoFJointCommandCorruptor corruptor) {
        JointController outputWriter = this.jointControllerMap.get(jointName);
        if (outputWriter == null) {
            LogTools.error((String)("Couldn't find joint output writer for joint {}." + jointName));
            return;
        }
        outputWriter.setJointConfigurationCorruptor(corruptor);
    }

    public void setOneDoFJointVelocityCorruptor(String jointName, OneDoFJointCommandCorruptor corruptor) {
        JointController outputWriter = this.jointControllerMap.get(jointName);
        if (outputWriter == null) {
            LogTools.error((String)("Couldn't find joint output writer for joint {}." + jointName));
            return;
        }
        outputWriter.setJointVelocityCorruptor(corruptor);
    }

    public void setOneDoFJointEffortCorruptor(String jointName, OneDoFJointCommandCorruptor corruptor) {
        JointController outputWriter = this.jointControllerMap.get(jointName);
        if (outputWriter == null) {
            LogTools.error((String)("Couldn't find joint output writer for joint {}." + jointName));
            return;
        }
        outputWriter.setJointEffortCorruptor(corruptor);
    }

    private class OneDoFJointController
    implements JointController {
        private final OneDoFJointReadOnly simOutput;
        private final OneDoFJointStateBasics simInput;
        private final JointDesiredOutputReadOnly jointDesiredOutput;
        private final YoDouble kp;
        private final YoDouble kd;
        private final YoDouble yoPositionError;
        private final YoDouble yoVelocityError;
        private final YoDouble yoControllerTau;
        private final YoDouble yoPositionTau;
        private final YoDouble yoVelocityTau;
        private final YoInteger unstableVelocityCounter;
        private final YoDouble previousVelocity;
        private final YoDouble unstableVelocityStartTime;
        private OneDoFJointCommandCorruptor jointConfigurationCorruptor = null;
        private OneDoFJointCommandCorruptor jointVelocityCorruptor = null;
        private OneDoFJointCommandCorruptor jointEffortCorruptor = null;

        public OneDoFJointController(OneDoFJointReadOnly simOutput, OneDoFJointStateBasics simInput, JointDesiredOutputReadOnly jointDesiredOutput, YoRegistry registry) {
            this.simOutput = simOutput;
            this.simInput = simInput;
            this.jointDesiredOutput = jointDesiredOutput;
            String prefix = simOutput.getName() + "LowLevel";
            this.kp = new YoDouble(prefix + "Kp", registry);
            this.kd = new YoDouble(prefix + "Kd", registry);
            this.yoPositionError = new YoDouble(prefix + "PositionError", registry);
            this.yoVelocityError = new YoDouble(prefix + "VelocityError", registry);
            this.yoControllerTau = new YoDouble(prefix + "ControllerTau", registry);
            this.yoPositionTau = new YoDouble(prefix + "PositionTau", registry);
            this.yoVelocityTau = new YoDouble(prefix + "VelocityTau", registry);
            this.unstableVelocityCounter = new YoInteger(prefix + "UnstableVelocityCounter", registry);
            this.previousVelocity = new YoDouble(prefix + "PreviousVelocity", registry);
            this.unstableVelocityStartTime = new YoDouble(prefix + "UnstableVelocityStartTime", registry);
        }

        @Override
        public void setJointConfigurationCorruptor(OneDoFJointCommandCorruptor jointConfigurationCorruptor) {
            this.jointConfigurationCorruptor = jointConfigurationCorruptor;
        }

        @Override
        public void setJointVelocityCorruptor(OneDoFJointCommandCorruptor jointVelocityCorruptor) {
            this.jointVelocityCorruptor = jointVelocityCorruptor;
        }

        @Override
        public void setJointEffortCorruptor(OneDoFJointCommandCorruptor jointEffortCorruptor) {
            this.jointEffortCorruptor = jointEffortCorruptor;
        }

        @Override
        public void doControl() {
            double velocityError;
            double positionError;
            if (this.jointDesiredOutput.hasDesiredTorque()) {
                double tau_d = this.jointDesiredOutput.getDesiredTorque();
                if (this.jointEffortCorruptor != null) {
                    tau_d = this.jointEffortCorruptor.corruptCommand(tau_d, this.simOutput);
                }
                this.yoControllerTau.set(tau_d);
            } else {
                this.yoControllerTau.set(0.0);
            }
            if (this.jointDesiredOutput.hasDesiredPosition()) {
                double q_d = this.jointDesiredOutput.getDesiredPosition();
                if (this.jointConfigurationCorruptor != null) {
                    q_d = this.jointConfigurationCorruptor.corruptCommand(q_d, this.simOutput);
                }
                positionError = q_d - this.simOutput.getQ();
            } else {
                positionError = 0.0;
            }
            if (this.jointDesiredOutput.hasDesiredVelocity()) {
                double qd_d = this.jointDesiredOutput.getDesiredVelocity();
                if (this.jointVelocityCorruptor != null) {
                    qd_d = this.jointVelocityCorruptor.corruptCommand(qd_d, this.simOutput);
                }
                velocityError = qd_d - this.simOutput.getQd();
            } else {
                velocityError = 0.0;
            }
            if (this.jointDesiredOutput.hasPositionFeedbackMaxError()) {
                positionError = MathTools.clamp((double)positionError, (double)this.jointDesiredOutput.getPositionFeedbackMaxError());
            }
            if (this.jointDesiredOutput.hasVelocityFeedbackMaxError()) {
                velocityError = MathTools.clamp((double)velocityError, (double)this.jointDesiredOutput.getVelocityFeedbackMaxError());
            }
            this.yoPositionError.set(positionError);
            this.yoVelocityError.set(velocityError);
            this.kp.set(this.jointDesiredOutput.hasStiffness() ? this.jointDesiredOutput.getStiffness() : 0.0);
            this.kd.set(this.jointDesiredOutput.hasDamping() ? this.jointDesiredOutput.getDamping() : 0.0);
            this.updateUnstableVelocityCounter();
            double time = SCS2OutputWriter.this.controllerInput.getTime();
            if (this.unstableVelocityCounter.getValue() >= SCS2OutputWriter.this.unstableVelocityNumberThreshold.getValue()) {
                this.unstableVelocityStartTime.set(time);
            }
            if (time - this.unstableVelocityStartTime.getValue() <= SCS2OutputWriter.this.unstableVelocityLowDampingDuration.getValue()) {
                double alpha = MathTools.clamp((double)((time - this.unstableVelocityStartTime.getValue()) / SCS2OutputWriter.this.unstableVelocityLowDampingDuration.getValue()), (double)0.0, (double)1.0);
                this.kd.mul(EuclidCoreTools.interpolate((double)SCS2OutputWriter.this.unstableVelocityLowDampingScale.getValue(), (double)1.0, (double)alpha));
            }
            this.yoPositionTau.set(this.kp.getValue() * this.yoPositionError.getValue());
            this.yoVelocityTau.set(this.kd.getValue() * this.yoVelocityError.getValue());
            this.simInput.setEffort(this.yoControllerTau.getValue() + this.yoPositionTau.getValue() + this.yoVelocityTau.getValue());
            this.previousVelocity.set(this.simOutput.getQd());
        }

        private void updateUnstableVelocityCounter() {
            boolean unstable;
            boolean bl = unstable = this.simOutput.getQd() * this.previousVelocity.getValue() < 0.0;
            if (unstable) {
                boolean bl2 = unstable = !EuclidCoreTools.epsilonEquals((double)this.simOutput.getQd(), (double)this.previousVelocity.getValue(), (double)SCS2OutputWriter.this.unstableVelocityThreshold.getValue());
            }
            if (unstable) {
                this.unstableVelocityCounter.set(Math.min(this.unstableVelocityCounter.getValue() + 1, SCS2OutputWriter.this.unstableVelocityNumberThreshold.getValue()));
            } else {
                this.unstableVelocityCounter.set(Math.max(this.unstableVelocityCounter.getValue() - 1, 0));
            }
        }
    }

    private class CrossFourBarJointController
    implements JointController {
        private final CrossFourBarJoint localFourBarJoint;
        private final OneDoFJointReadOnly[] simOutputs;
        private final int[] torqueSourceIndices;
        private final OneDoFJointStateBasics[] simInputs;
        private final JointDesiredOutputReadOnly jointDesiredOutput;
        private final YoDouble kp;
        private final YoDouble kd;
        private final YoDouble yoPositionError;
        private final YoDouble yoVelocityError;
        private final YoDouble yoControllerTau;
        private final YoDouble yoPositionTau;
        private final YoDouble yoVelocityTau;
        private final YoInteger unstableVelocityCounter;
        private final YoDouble previousVelocity;
        private final YoDouble unstableVelocityStartTime;
        private OneDoFJointCommandCorruptor jointConfigurationCorruptor = null;
        private OneDoFJointCommandCorruptor jointVelocityCorruptor = null;
        private OneDoFJointCommandCorruptor jointEffortCorruptor = null;

        public CrossFourBarJointController(CrossFourBarJointBasics controllerFourBarJoint, OneDoFJointReadOnly[] simOutputs, OneDoFJointStateBasics[] simInputs, JointDesiredOutputReadOnly jointDesiredOutput, YoRegistry registry) {
            this.simOutputs = simOutputs;
            this.simInputs = simInputs;
            this.jointDesiredOutput = jointDesiredOutput;
            this.localFourBarJoint = CrossFourBarJoint.cloneCrossFourBarJoint((CrossFourBarJointReadOnly)controllerFourBarJoint, (ReferenceFrame)ReferenceFrameTools.constructARootFrame((String)"dummy"), (String)"");
            this.torqueSourceIndices = controllerFourBarJoint.getJointA().isLoopClosure() || controllerFourBarJoint.getJointD().isLoopClosure() ? new int[]{1, 2} : new int[]{0, 3};
            String prefix = controllerFourBarJoint.getName() + "LowLevel";
            this.kp = new YoDouble(prefix + "Kp", registry);
            this.kd = new YoDouble(prefix + "Kd", registry);
            this.yoPositionError = new YoDouble(prefix + "PositionError", registry);
            this.yoVelocityError = new YoDouble(prefix + "VelocityError", registry);
            this.yoControllerTau = new YoDouble(prefix + "ControllerTau", registry);
            this.yoPositionTau = new YoDouble(prefix + "PositionTau", registry);
            this.yoVelocityTau = new YoDouble(prefix + "VelocityTau", registry);
            this.unstableVelocityCounter = new YoInteger(prefix + "UnstableVelocityCounter", registry);
            this.previousVelocity = new YoDouble(prefix + "PreviousVelocity", registry);
            this.unstableVelocityStartTime = new YoDouble(prefix + "UnstableVelocityStartTime", registry);
        }

        @Override
        public void setJointConfigurationCorruptor(OneDoFJointCommandCorruptor jointConfigurationCorruptor) {
            this.jointConfigurationCorruptor = jointConfigurationCorruptor;
        }

        @Override
        public void setJointVelocityCorruptor(OneDoFJointCommandCorruptor jointVelocityCorruptor) {
            this.jointVelocityCorruptor = jointVelocityCorruptor;
        }

        @Override
        public void setJointEffortCorruptor(OneDoFJointCommandCorruptor jointEffortCorruptor) {
            this.jointEffortCorruptor = jointEffortCorruptor;
        }

        @Override
        public void doControl() {
            double velocityError;
            double positionError;
            this.updateFourBarJoint();
            if (this.jointDesiredOutput.hasDesiredTorque()) {
                double tau_d = this.jointDesiredOutput.getDesiredTorque();
                if (this.jointEffortCorruptor != null) {
                    tau_d = this.jointEffortCorruptor.corruptCommand(tau_d, (OneDoFJointReadOnly)this.localFourBarJoint);
                }
                this.yoControllerTau.set(tau_d);
            } else {
                this.yoControllerTau.set(0.0);
            }
            if (this.jointDesiredOutput.hasDesiredPosition()) {
                double q_d = this.jointDesiredOutput.getDesiredPosition();
                if (this.jointConfigurationCorruptor != null) {
                    q_d = this.jointConfigurationCorruptor.corruptCommand(q_d, (OneDoFJointReadOnly)this.localFourBarJoint);
                }
                positionError = q_d - this.localFourBarJoint.getQ();
            } else {
                positionError = 0.0;
            }
            if (this.jointDesiredOutput.hasDesiredVelocity()) {
                double qd_d = this.jointDesiredOutput.getDesiredVelocity();
                if (this.jointVelocityCorruptor != null) {
                    qd_d = this.jointVelocityCorruptor.corruptCommand(qd_d, (OneDoFJointReadOnly)this.localFourBarJoint);
                }
                velocityError = qd_d - this.localFourBarJoint.getQd();
            } else {
                velocityError = 0.0;
            }
            if (this.jointDesiredOutput.hasPositionFeedbackMaxError()) {
                positionError = MathTools.clamp((double)positionError, (double)this.jointDesiredOutput.getPositionFeedbackMaxError());
            }
            if (this.jointDesiredOutput.hasVelocityFeedbackMaxError()) {
                velocityError = MathTools.clamp((double)velocityError, (double)this.jointDesiredOutput.getVelocityFeedbackMaxError());
            }
            this.yoPositionError.set(positionError);
            this.yoVelocityError.set(velocityError);
            this.kp.set(this.jointDesiredOutput.hasStiffness() ? this.jointDesiredOutput.getStiffness() : 0.0);
            this.kd.set(this.jointDesiredOutput.hasDamping() ? this.jointDesiredOutput.getDamping() : 0.0);
            this.updateUnstableVelocityCounter();
            double time = SCS2OutputWriter.this.controllerInput.getTime();
            if (this.unstableVelocityCounter.getValue() >= SCS2OutputWriter.this.unstableVelocityNumberThreshold.getValue()) {
                this.unstableVelocityStartTime.set(time);
            }
            if (time - this.unstableVelocityStartTime.getValue() <= SCS2OutputWriter.this.unstableVelocityLowDampingDuration.getValue()) {
                double alpha = MathTools.clamp((double)((time - this.unstableVelocityStartTime.getValue()) / SCS2OutputWriter.this.unstableVelocityLowDampingDuration.getValue()), (double)0.0, (double)1.0);
                this.kd.mul(EuclidCoreTools.interpolate((double)SCS2OutputWriter.this.unstableVelocityLowDampingScale.getValue(), (double)1.0, (double)alpha));
            }
            this.yoPositionTau.set(this.kp.getValue() * this.yoPositionError.getValue());
            this.yoVelocityTau.set(this.kd.getValue() * this.yoVelocityError.getValue());
            double tau_actuated = this.localFourBarJoint.computeActuatedJointTau(this.yoControllerTau.getValue() + this.yoPositionTau.getValue() + this.yoVelocityTau.getValue());
            for (OneDoFJointStateBasics simInput : this.simInputs) {
                if (simInput == null) continue;
                simInput.setEffort(0.0);
            }
            for (int torqueSourceIndex : this.torqueSourceIndices) {
                double tau = 0.5 * tau_actuated / this.localFourBarJoint.getFourBarFunction().getLoopJacobian().get(torqueSourceIndex);
                this.simInputs[torqueSourceIndex].setEffort(tau);
            }
            this.previousVelocity.set(this.localFourBarJoint.getQd());
        }

        private void updateFourBarJoint() {
            this.localFourBarJoint.setQ(this.simOutputs[this.torqueSourceIndices[0]].getQ() + this.simOutputs[this.torqueSourceIndices[1]].getQ());
            this.localFourBarJoint.setQd(this.simOutputs[this.torqueSourceIndices[0]].getQd() + this.simOutputs[this.torqueSourceIndices[1]].getQd());
            this.localFourBarJoint.updateFrame();
        }

        private void updateUnstableVelocityCounter() {
            boolean unstable;
            boolean bl = unstable = this.localFourBarJoint.getQd() * this.previousVelocity.getValue() < 0.0;
            if (unstable) {
                boolean bl2 = unstable = !EuclidCoreTools.epsilonEquals((double)this.localFourBarJoint.getQd(), (double)this.previousVelocity.getValue(), (double)SCS2OutputWriter.this.unstableVelocityThreshold.getValue());
            }
            if (unstable) {
                this.unstableVelocityCounter.set(Math.min(this.unstableVelocityCounter.getValue() + 1, SCS2OutputWriter.this.unstableVelocityNumberThreshold.getValue()));
            } else {
                this.unstableVelocityCounter.set(Math.max(this.unstableVelocityCounter.getValue() - 1, 0));
            }
        }
    }

    private static interface JointController {
        public void setJointConfigurationCorruptor(OneDoFJointCommandCorruptor var1);

        public void setJointVelocityCorruptor(OneDoFJointCommandCorruptor var1);

        public void setJointEffortCorruptor(OneDoFJointCommandCorruptor var1);

        public void doControl();
    }

    public static interface OneDoFJointCommandCorruptor {
        public double corruptCommand(double var1, OneDoFJointReadOnly var3);
    }
}

