/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.AvatarEstimatorThreadFactory;
import us.ihmc.avatar.AvatarSimulatedHandControlThread;
import us.ihmc.avatar.AvatarStepGeneratorThread;
import us.ihmc.avatar.ControllerTask;
import us.ihmc.avatar.EstimatorTask;
import us.ihmc.avatar.HumanoidSteppingPluginEnvironmentalConstraints;
import us.ihmc.avatar.StepGeneratorTask;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.SimulatedDRCRobotTimeProvider;
import us.ihmc.avatar.factory.BarrierScheduledRobotController;
import us.ihmc.avatar.factory.DisposableRobotController;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.avatar.factory.SimulatedHandControlTask;
import us.ihmc.avatar.factory.SingleThreadedRobotController;
import us.ihmc.avatar.initialSetup.OffsetAndYawRobotInitialSetup;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.logging.IntraprocessYoVariableLogger;
import us.ihmc.avatar.scs2.SCS2AvatarSimulation;
import us.ihmc.avatar.scs2.SCS2JointDesiredOutputWriterFactory;
import us.ihmc.avatar.scs2.SCS2OutputWriter;
import us.ihmc.avatar.scs2.SCS2PIDLidarTorqueController;
import us.ihmc.avatar.scs2.SCS2SimulatedHandOutputWriter;
import us.ihmc.avatar.scs2.SCS2SimulatedHandSensorReader;
import us.ihmc.avatar.scs2.SCS2StateEstimatorDebugVariables;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextDataFactory;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepAdjustment;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScriptParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeightMapBasedFootstepAdjustment;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ExternalControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ExternalTransitionControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.StandReadyControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.pushRecoveryController.PushRecoveryControllerParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.ComponentBasedFootstepDataMessageGeneratorFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.HumanoidSteppingPluginFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.JoystickBasedSteppingPluginFactory;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.Packet;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.BarrierScheduler;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.conversion.YoGraphicConversionTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicator;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicatorInterface;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.physics.CollidableHelper;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.scs2.SimulationConstructionSet2;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.parameters.ContactPointBasedContactParameters;
import us.ihmc.scs2.simulation.parameters.ContactPointBasedContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;
import us.ihmc.scs2.simulation.physicsEngine.contactPointBased.ContactPointBasedPhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedPhysicsEngine;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.controller.SimControllerInput;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.simulatedSensors.SCS2SensorReaderFactory;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReader;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReaderFactory;
import us.ihmc.sensorProcessing.stateEstimation.SensorProcessingConfiguration;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.simulationConstructionSetTools.tools.TerrainObjectDefinitionTools;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationToolkit.RobotDefinitionTools;
import us.ihmc.simulationconstructionset.dataBuffer.MirroredYoVariableRegistry;
import us.ihmc.stateEstimation.humanoid.StateEstimatorControllerFactory;
import us.ihmc.tools.factories.FactoryFieldNotSetException;
import us.ihmc.tools.factories.FactoryTools;
import us.ihmc.tools.factories.OptionalFactoryField;
import us.ihmc.tools.factories.RequiredFactoryField;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SCS2AvatarSimulationFactory {
    protected final RequiredFactoryField<DRCRobotModel> robotModel = new RequiredFactoryField("robotModel");
    protected final RequiredFactoryField<HighLevelHumanoidControllerFactory> highLevelHumanoidControllerFactory = new RequiredFactoryField("highLevelHumanoidControllerFactory");
    protected final ArrayList<TerrainObjectDefinition> terrainObjectDefinitions = new ArrayList();
    protected final OptionalFactoryField<Boolean> enableSCS1YoGraphics = new OptionalFactoryField("enableSCS1YoGraphics", (Object)false);
    protected final OptionalFactoryField<Boolean> enableSCS2YoGraphics = new OptionalFactoryField("enableSCS2YoGraphics", (Object)true);
    protected final OptionalFactoryField<RealtimeROS2Node> realtimeROS2Node = new OptionalFactoryField("realtimeROS2Node");
    protected final OptionalFactoryField<Double> simulationDT = new OptionalFactoryField("simulationDT");
    protected final OptionalFactoryField<RobotInitialSetup<HumanoidFloatingRootJointRobot>> robotInitialSetup = new OptionalFactoryField("robotInitialSetup");
    protected final OptionalFactoryField<Double> gravity = new OptionalFactoryField("gravity", (Object)-9.81);
    protected final OptionalFactoryField<Boolean> createYoVariableServer = new OptionalFactoryField("createYoVariableServer", (Object)false);
    protected final OptionalFactoryField<Boolean> logToFile = new OptionalFactoryField("logToFile", (Object)false);
    protected final OptionalFactoryField<PelvisPoseCorrectionCommunicatorInterface> externalPelvisCorrectorSubscriber = new OptionalFactoryField("externalPelvisCorrectorSubscriber");
    protected final OptionalFactoryField<Integer> simulationDataBufferSize = new OptionalFactoryField("simulationDataBufferSize", (Object)8192);
    protected final OptionalFactoryField<Integer> simulationDataRecordTickPeriod = new OptionalFactoryField("simulationDataRecordTickPeriod");
    protected final OptionalFactoryField<Boolean> usePerfectSensors = new OptionalFactoryField("usePerfectSensors", (Object)false);
    protected final OptionalFactoryField<SCS2JointDesiredOutputWriterFactory> outputWriterFactory = new OptionalFactoryField("outputWriterFactory", (in, out) -> new SCS2OutputWriter(in, out, true));
    protected final OptionalFactoryField<HighLevelControllerName> initialState = new OptionalFactoryField("initialControllerState", (Object)HighLevelControllerName.WALKING);
    protected final OptionalFactoryField<Boolean> runMultiThreaded = new OptionalFactoryField("runMultiThreaded", (Object)true);
    protected final OptionalFactoryField<Boolean> initializeEstimatorToActual = new OptionalFactoryField("initializeEstimatorToActual", (Object)true);
    protected final OptionalFactoryField<Boolean> showGUI = new OptionalFactoryField("showGUI", (Object)true);
    protected final OptionalFactoryField<Boolean> automaticallyStartSimulation = new OptionalFactoryField("automaticallyStartSimulation", (Object)false);
    protected final OptionalFactoryField<Boolean> useImpulseBasedPhysicsEngine = new OptionalFactoryField("useImpulseBasePhysicsEngine", (Object)false);
    protected final OptionalFactoryField<Boolean> useBulletPhysicsEngine = new OptionalFactoryField("useBulletPhysicsEngine", (Object)false);
    protected final OptionalFactoryField<Consumer<RobotDefinition>> bulletCollisionMutator = new OptionalFactoryField("bulletCollisionMutator");
    protected final OptionalFactoryField<ContactParametersReadOnly> impulseBasedPhysicsEngineContactParameters = new OptionalFactoryField("impulseBasedPhysicsEngineParameters");
    protected final OptionalFactoryField<RobotContactPointParameters.GroundContactModelParameters> groundContactModelParameters = new OptionalFactoryField("groundContactModelParameters");
    protected final OptionalFactoryField<Boolean> enableSimulatedRobotDamping = new OptionalFactoryField("enableSimulatedRobotDamping", (Object)true);
    protected final OptionalFactoryField<Boolean> useRobotDefinitionCollisions = new OptionalFactoryField("useRobotDefinitionCollisions", (Object)false);
    protected final OptionalFactoryField<List<Robot>> secondaryRobots = new OptionalFactoryField("secondaryRobots", new ArrayList());
    protected final OptionalFactoryField<String> simulationName = new OptionalFactoryField("simulationName");
    private final OptionalFactoryField<Boolean> useHeadingAndVelocityScript = new OptionalFactoryField("useHeadingAndVelocityScript");
    private final OptionalFactoryField<HeightMap> heightMapForFootstepZ = new OptionalFactoryField("heightMapForFootstepZ");
    private final OptionalFactoryField<HeadingAndVelocityEvaluationScriptParameters> headingAndVelocityEvaluationScriptParameters = new OptionalFactoryField("headingAndVelocityEvaluationScriptParameters");
    private final OptionalFactoryField<StateEstimatorControllerFactory> secondaryStateEstimatorFactory = new OptionalFactoryField("SecondaryStateEstimatorFactory");
    protected RobotDefinition robotDefinition;
    protected Robot robot;
    protected YoVariableServer yoVariableServer;
    protected IntraprocessYoVariableLogger intraprocessYoVariableLogger;
    protected SimulationConstructionSet2 simulationConstructionSet;
    protected JointDesiredOutputWriter simulationOutputWriter;
    protected HumanoidRobotContextData masterContext;
    protected AvatarEstimatorThread estimatorThread;
    protected AvatarControllerThread controllerThread;
    protected AvatarStepGeneratorThread stepGeneratorThread;
    protected DisposableRobotController robotController;
    protected SimulatedDRCRobotTimeProvider simulatedRobotTimeProvider;
    protected PelvisPoseCorrectionCommunicatorInterface pelvisPoseCorrectionCommunicator;
    protected final CollidableHelper collidableHelper = new CollidableHelper();
    protected final String robotCollisionName = "robot";
    protected final String terrainCollisionName = "terrain";

    public SCS2AvatarSimulation createAvatarSimulation() {
        this.simulationDataRecordTickPeriod.setDefaultValue((Object)((int)Math.max(1.0, ((DRCRobotModel)this.robotModel.get()).getControllerDT() / (Double)this.simulationDT.get())));
        FactoryTools.checkAllFactoryFieldsAreSet((Object)this);
        this.setupSimulationConstructionSet();
        this.setupYoVariableServer();
        this.setupSimulationOutputWriter();
        this.setupStateEstimationThread();
        this.setupControllerThread();
        this.setupStepGeneratorThread();
        this.setupMultiThreadedRobotController();
        this.setupLidarController();
        this.initializeStateEstimatorToActual();
        this.setupSimulatedRobotTimeProvider();
        SCS2AvatarSimulation avatarSimulation = new SCS2AvatarSimulation();
        avatarSimulation.setRobotModel((DRCRobotModel)this.robotModel.get());
        avatarSimulation.setRobotInitialSetup((RobotInitialSetup)this.robotInitialSetup.get());
        avatarSimulation.setSimulationConstructionSet(this.simulationConstructionSet);
        avatarSimulation.setHighLevelHumanoidControllerFactory((HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get());
        avatarSimulation.setYoVariableServer(this.yoVariableServer);
        avatarSimulation.setIntraprocessYoVariableLogger(this.intraprocessYoVariableLogger);
        avatarSimulation.setMasterContext(this.masterContext);
        avatarSimulation.setControllerThread(this.controllerThread);
        avatarSimulation.setEstimatorThread(this.estimatorThread);
        avatarSimulation.setStepGeneratorThread(this.stepGeneratorThread);
        avatarSimulation.setOutputWriter(this.simulationOutputWriter);
        avatarSimulation.setRobotController(this.robotController);
        avatarSimulation.setRobot(this.robot);
        avatarSimulation.setSimulatedRobotTimeProvider(this.simulatedRobotTimeProvider);
        avatarSimulation.setFullHumanoidRobotModel(this.controllerThread.getFullRobotModel());
        avatarSimulation.setShowGUI((Boolean)this.showGUI.get());
        avatarSimulation.setAutomaticallyStartSimulation((Boolean)this.automaticallyStartSimulation.get());
        if (this.realtimeROS2Node.hasBeenSet()) {
            avatarSimulation.setRealTimeROS2Node((RealtimeROS2Node)this.realtimeROS2Node.get());
        }
        FactoryTools.disposeFactory((Object)this);
        return avatarSimulation;
    }

    private void setupSimulationConstructionSet() {
        RobotCollisionModel collisionModel;
        DRCRobotModel robotModel = (DRCRobotModel)this.robotModel.get();
        this.robotDefinition = robotModel.getRobotDefinition();
        if (((Boolean)this.useBulletPhysicsEngine.get()).booleanValue() && this.bulletCollisionMutator.hasValue()) {
            ((Consumer)this.bulletCollisionMutator.get()).accept(this.robotDefinition);
        }
        if (!((Boolean)this.enableSimulatedRobotDamping.get()).booleanValue()) {
            for (JointDefinition joint : this.robotDefinition.getAllJoints()) {
                if (!(joint instanceof OneDoFJointDefinition)) continue;
                ((OneDoFJointDefinition)joint).setDamping(0.0);
            }
        }
        if (!((Boolean)this.useRobotDefinitionCollisions.get()).booleanValue() && (collisionModel = robotModel.getSimulationRobotCollisionModel(this.collidableHelper, "robot", "terrain")) != null) {
            RobotDefinitionTools.addCollisionsToRobotDefinition((List)collisionModel.getRobotCollidables(robotModel.createFullRobotModel().getElevator()), (RobotDefinition)this.robotDefinition);
        }
        ((RobotInitialSetup)this.robotInitialSetup.get()).initializeRobotDefinition(this.robotDefinition);
        Set lastSimulatedJoints = robotModel.getJointMap().getLastSimulatedJoints();
        lastSimulatedJoints.forEach(lastSimulatedJoint -> this.robotDefinition.addSubtreeJointsToIgnore(lastSimulatedJoint));
        PhysicsEngineFactory physicsEngineFactory = this.useImpulseBasedPhysicsEngine.hasValue() && (Boolean)this.useImpulseBasedPhysicsEngine.get() != false ? (inertialFrame, rootRegistry) -> {
            ImpulseBasedPhysicsEngine physicsEngine = new ImpulseBasedPhysicsEngine(inertialFrame, rootRegistry);
            if (this.impulseBasedPhysicsEngineContactParameters.hasValue()) {
                physicsEngine.setGlobalContactParameters((ContactParametersReadOnly)this.impulseBasedPhysicsEngineContactParameters.get());
            }
            return physicsEngine;
        } : (this.useBulletPhysicsEngine.hasValue() && (Boolean)this.useBulletPhysicsEngine.get() != false ? (inertialFrame, rootRegistry) -> new BulletPhysicsEngine(inertialFrame, rootRegistry) : (inertialFrame, rootRegistry) -> {
            if (this.groundContactModelParameters.hasValue()) {
                robotModel.getContactPointParameters().setGroundContactModelParameters((RobotContactPointParameters.GroundContactModelParameters)this.groundContactModelParameters.get());
            }
            ContactPointBasedPhysicsEngine physicsEngine = new ContactPointBasedPhysicsEngine(inertialFrame, rootRegistry);
            RobotContactPointParameters.GroundContactModelParameters contactModelParameters = robotModel.getContactPointParameters().getGroundContactModelParameters(((Double)this.simulationDT.get()).doubleValue());
            ContactPointBasedContactParameters parameters = ContactPointBasedContactParameters.defaultParameters();
            parameters.setKz(contactModelParameters.getZStiffness());
            parameters.setBz(contactModelParameters.getZDamping());
            parameters.setKxy(contactModelParameters.getXYStiffness());
            parameters.setBxy(contactModelParameters.getXYDamping());
            physicsEngine.setGroundContactParameters((ContactPointBasedContactParametersReadOnly)parameters);
            return physicsEngine;
        });
        String name = this.simulationName.hasValue() ? (String)this.simulationName.get() : Session.retrieveCallerName();
        this.simulationConstructionSet = new SimulationConstructionSet2(name, physicsEngineFactory);
        this.simulationConstructionSet.initializeBufferSize(((Integer)this.simulationDataBufferSize.get()).intValue());
        this.simulationConstructionSet.initializeBufferRecordTickPeriod(((Integer)this.simulationDataRecordTickPeriod.get()).intValue());
        if (this.terrainObjectDefinitions.isEmpty()) {
            throw new FactoryFieldNotSetException("terrainObjectDefinitions");
        }
        for (TerrainObjectDefinition terrainObjectDefinition : this.terrainObjectDefinitions) {
            this.simulationConstructionSet.addTerrainObject(terrainObjectDefinition);
        }
        this.robot = this.simulationConstructionSet.addRobot(this.robotDefinition);
        this.robot.addThrottledController((Controller)new SCS2StateEstimatorDebugVariables(this.simulationConstructionSet.getInertialFrame(), (Double)this.gravity.get(), robotModel.getEstimatorDT(), (ControllerInput)this.robot.getControllerManager().getControllerInput()), robotModel.getEstimatorDT());
        for (Robot secondaryRobot : (List)this.secondaryRobots.get()) {
            this.simulationConstructionSet.addRobot(secondaryRobot);
        }
        this.simulationConstructionSet.setDT(((Double)this.simulationDT.get()).doubleValue());
    }

    private void setupYoVariableServer() {
        if (((Boolean)this.createYoVariableServer.get()).booleanValue()) {
            this.yoVariableServer = new YoVariableServer(this.getClass(), ((DRCRobotModel)this.robotModel.get()).getLogModelProvider(), ((DRCRobotModel)this.robotModel.get()).getLogSettings(), ((DRCRobotModel)this.robotModel.get()).getEstimatorDT());
        }
    }

    private void setupSimulationOutputWriter() {
        this.simulationOutputWriter = ((SCS2JointDesiredOutputWriterFactory)this.outputWriterFactory.get()).build((ControllerInput)this.robot.getControllerManager().getControllerInput(), this.robot.getControllerManager().getControllerOutput());
    }

    private void setupStateEstimationThread() {
        String robotName = ((DRCRobotModel)this.robotModel.get()).getSimpleRobotName();
        StateEstimatorParameters stateEstimatorParameters = ((DRCRobotModel)this.robotModel.get()).getStateEstimatorParameters();
        SimControllerInput controllerInput = this.robot.getControllerManager().getControllerInput();
        SCS2SensorReaderFactory sensorReaderFactory = (Boolean)this.usePerfectSensors.get() != false ? SCS2SensorReaderFactory.newPerfectSensorReaderFactory((SimControllerInput)controllerInput) : SCS2SensorReaderFactory.newSensorReaderFactory((SimControllerInput)controllerInput, (SensorProcessingConfiguration)stateEstimatorParameters);
        ROS2Topic outputTopic = null;
        ROS2Topic inputTopic = null;
        if (this.realtimeROS2Node.hasBeenSet()) {
            outputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
            inputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        }
        if (this.externalPelvisCorrectorSubscriber.hasValue()) {
            this.pelvisPoseCorrectionCommunicator = (PelvisPoseCorrectionCommunicatorInterface)this.externalPelvisCorrectorSubscriber.get();
        } else if (this.realtimeROS2Node.hasBeenSet()) {
            this.pelvisPoseCorrectionCommunicator = new PelvisPoseCorrectionCommunicator((RealtimeROS2Node)this.realtimeROS2Node.get(), outputTopic);
            ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)((RealtimeROS2Node)this.realtimeROS2Node.get()), StampedPosePacket.class, (ROS2Topic)inputTopic, s -> this.pelvisPoseCorrectionCommunicator.receivedPacket((Packet)((StampedPosePacket)s.takeNextData())));
        }
        HumanoidRobotContextDataFactory contextDataFactory = new HumanoidRobotContextDataFactory();
        AvatarEstimatorThreadFactory avatarEstimatorThreadFactory = new AvatarEstimatorThreadFactory();
        if (this.realtimeROS2Node.hasBeenSet()) {
            avatarEstimatorThreadFactory.setROS2Info((RealtimeROS2Node)this.realtimeROS2Node.get(), robotName);
        }
        avatarEstimatorThreadFactory.configureWithDRCRobotModel((DRCRobotModel)this.robotModel.get(), (RobotInitialSetup)this.robotInitialSetup.get());
        avatarEstimatorThreadFactory.setSensorReaderFactory((SensorReaderFactory)sensorReaderFactory);
        avatarEstimatorThreadFactory.setHumanoidRobotContextDataFactory(contextDataFactory);
        avatarEstimatorThreadFactory.setExternalPelvisCorrectorSubscriber(this.pelvisPoseCorrectionCommunicator);
        avatarEstimatorThreadFactory.setJointDesiredOutputWriter(this.simulationOutputWriter);
        avatarEstimatorThreadFactory.setGravity((Double)this.gravity.get());
        if (this.secondaryStateEstimatorFactory.hasBeenSet()) {
            avatarEstimatorThreadFactory.addSecondaryStateEstimatorFactory((StateEstimatorControllerFactory)this.secondaryStateEstimatorFactory.get());
        }
        this.estimatorThread = avatarEstimatorThreadFactory.createAvatarEstimatorThread();
    }

    private void setupControllerThread() {
        String robotName = ((DRCRobotModel)this.robotModel.get()).getSimpleRobotName();
        HumanoidRobotContextDataFactory contextDataFactory = new HumanoidRobotContextDataFactory();
        RealtimeROS2Node ros2Node = null;
        if (this.realtimeROS2Node.hasBeenSet()) {
            ros2Node = (RealtimeROS2Node)this.realtimeROS2Node.get();
        }
        this.controllerThread = new AvatarControllerThread(robotName, (DRCRobotModel)this.robotModel.get(), (RobotInitialSetup)this.robotInitialSetup.get(), ((DRCRobotModel)this.robotModel.get()).getSensorInformation(), (HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get(), contextDataFactory, null, ros2Node, (Double)this.gravity.get());
        if (((Boolean)this.enableSCS1YoGraphics.get()).booleanValue()) {
            this.simulationConstructionSet.addYoGraphics((Collection)YoGraphicConversionTools.toYoGraphicDefinitions((YoGraphicsListRegistry)this.controllerThread.getSCS1YoGraphicsListRegistry()));
        }
        if (((Boolean)this.enableSCS2YoGraphics.get()).booleanValue()) {
            this.simulationConstructionSet.addYoGraphic((YoGraphicDefinition)this.controllerThread.getSCS2YoGraphics());
        }
    }

    private void setupStepGeneratorThread() {
        ComponentBasedFootstepDataMessageGeneratorFactory steppingFactory;
        HumanoidRobotContextDataFactory contextDataFactory = new HumanoidRobotContextDataFactory();
        HumanoidSteppingPluginEnvironmentalConstraints stepSnapperUpdatable = null;
        boolean useHeadingAndVelocityScript = this.useHeadingAndVelocityScript.hasValue() ? (Boolean)this.useHeadingAndVelocityScript.get() : false;
        HeadingAndVelocityEvaluationScriptParameters parameters = null;
        if (this.headingAndVelocityEvaluationScriptParameters.hasValue()) {
            parameters = (HeadingAndVelocityEvaluationScriptParameters)this.headingAndVelocityEvaluationScriptParameters.get();
        }
        if (useHeadingAndVelocityScript || parameters != null) {
            ComponentBasedFootstepDataMessageGeneratorFactory componentBasedFootstepDataMessageGeneratorFactory = new ComponentBasedFootstepDataMessageGeneratorFactory();
            componentBasedFootstepDataMessageGeneratorFactory.setRegistry();
            componentBasedFootstepDataMessageGeneratorFactory.setUseHeadingAndVelocityScript(useHeadingAndVelocityScript);
            if (parameters != null) {
                componentBasedFootstepDataMessageGeneratorFactory.setHeadingAndVelocityEvaluationScriptParameters(parameters);
            }
            if (this.heightMapForFootstepZ.hasValue() && this.heightMapForFootstepZ.get() != null) {
                componentBasedFootstepDataMessageGeneratorFactory.setFootStepAdjustment((FootstepAdjustment)new HeightMapBasedFootstepAdjustment((HeightMap)this.heightMapForFootstepZ.get()));
            }
            steppingFactory = componentBasedFootstepDataMessageGeneratorFactory;
        } else {
            JoystickBasedSteppingPluginFactory joystickPluginFactory = new JoystickBasedSteppingPluginFactory();
            if (this.heightMapForFootstepZ.hasValue()) {
                joystickPluginFactory.setFootStepAdjustment((FootstepAdjustment)new HeightMapBasedFootstepAdjustment((HeightMap)this.heightMapForFootstepZ.get()));
            } else {
                stepSnapperUpdatable = new HumanoidSteppingPluginEnvironmentalConstraints((RobotContactPointParameters<RobotSide>)((DRCRobotModel)this.robotModel.get()).getContactPointParameters(), ((DRCRobotModel)this.robotModel.get()).getWalkingControllerParameters().getSteppingParameters(), ((DRCRobotModel)this.robotModel.get()).getSteppingEnvironmentalConstraintParameters());
                stepSnapperUpdatable.setShouldSnapToRegions(true);
            }
            steppingFactory = joystickPluginFactory;
        }
        RealtimeROS2Node ros2Node = null;
        if (this.realtimeROS2Node.hasBeenSet()) {
            ros2Node = (RealtimeROS2Node)this.realtimeROS2Node.get();
        }
        this.stepGeneratorThread = new AvatarStepGeneratorThread((HumanoidSteppingPluginFactory)steppingFactory, contextDataFactory, ((HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get()).getStatusOutputManager(), ((HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get()).getCommandInputManager(), (DRCRobotModel)this.robotModel.get(), stepSnapperUpdatable, ros2Node);
        if (((Boolean)this.enableSCS1YoGraphics.get()).booleanValue()) {
            this.simulationConstructionSet.addYoGraphics((Collection)YoGraphicConversionTools.toYoGraphicDefinitions((YoGraphicsListRegistry)this.stepGeneratorThread.getSCS1YoGraphicsListRegistry()));
        }
        if (((Boolean)this.enableSCS2YoGraphics.get()).booleanValue()) {
            this.simulationConstructionSet.addYoGraphic((YoGraphicDefinition)this.stepGeneratorThread.getSCS2YoGraphics());
        }
    }

    private void setupMultiThreadedRobotController() {
        DRCRobotModel robotModel = (DRCRobotModel)this.robotModel.get();
        FullHumanoidRobotModel masterFullRobotModel = robotModel.createFullRobotModel();
        ((RobotInitialSetup)this.robotInitialSetup.get()).initializeFullRobotModel(masterFullRobotModel);
        this.masterContext = new HumanoidRobotContextData(masterFullRobotModel);
        int estimatorDivisor = (int)Math.round(robotModel.getEstimatorDT() / (Double)this.simulationDT.get());
        int controllerDivisor = (int)Math.round(robotModel.getControllerDT() / (Double)this.simulationDT.get());
        int stepGeneratorDivisor = (int)Math.round(robotModel.getStepGeneratorDT() / (Double)this.simulationDT.get());
        int handControlDivisor = (int)Math.round(robotModel.getSimulatedHandControlDT() / (Double)this.simulationDT.get());
        EstimatorTask estimatorTask = new EstimatorTask(this.estimatorThread, estimatorDivisor, (Double)this.simulationDT.get(), masterFullRobotModel);
        ControllerTask controllerTask = new ControllerTask("Controller", this.controllerThread, controllerDivisor, (Double)this.simulationDT.get(), masterFullRobotModel);
        StepGeneratorTask stepGeneratorTask = new StepGeneratorTask("StepGenerator", this.stepGeneratorThread, stepGeneratorDivisor, (Double)this.simulationDT.get(), masterFullRobotModel);
        SimulatedHandControlTask handControlTask = null;
        AvatarSimulatedHandControlThread handControlThread = null;
        if (this.realtimeROS2Node.hasBeenSet() && (handControlThread = robotModel.createSimulatedHandController((RealtimeROS2Node)this.realtimeROS2Node.get())) != null) {
            List<String> fingerJointNames = handControlThread.getControlledOneDoFJoints().stream().map(JointReadOnly::getName).collect(Collectors.toList());
            SCS2SimulatedHandSensorReader handSensorReader = new SCS2SimulatedHandSensorReader((ControllerInput)this.robot.getControllerManager().getControllerInput(), fingerJointNames);
            SCS2SimulatedHandOutputWriter handOutputWriter = new SCS2SimulatedHandOutputWriter((ControllerInput)this.robot.getControllerManager().getControllerInput(), this.robot.getControllerManager().getControllerOutput());
            handControlTask = new SimulatedHandControlTask(handSensorReader, handControlThread, handOutputWriter, handControlDivisor, (Double)this.simulationDT.get());
        }
        if (this.simulationOutputWriter != null) {
            ((HumanoidRobotControlTask)estimatorTask).addRunnableOnSchedulerThread(() -> {
                if (this.estimatorThread.getHumanoidRobotContextData().getControllerRan()) {
                    this.simulationOutputWriter.writeAfter();
                }
            });
        }
        SensorReader sensorReader = this.estimatorThread.getSensorReader();
        ((HumanoidRobotControlTask)estimatorTask).addRunnableOnSchedulerThread(() -> {
            long newTimestamp = sensorReader.read(this.masterContext.getSensorDataContext());
            this.masterContext.setTimestamp(newTimestamp);
        });
        if (this.simulationOutputWriter != null) {
            ((HumanoidRobotControlTask)estimatorTask).addRunnableOnSchedulerThread(() -> {
                if (this.estimatorThread.getHumanoidRobotContextData().getControllerRan()) {
                    this.simulationOutputWriter.writeBefore(this.estimatorThread.getHumanoidRobotContextData().getTimestamp());
                }
            });
        }
        ArrayList<HumanoidRobotControlTask> tasks = new ArrayList<HumanoidRobotControlTask>();
        tasks.add(estimatorTask);
        tasks.add(controllerTask);
        tasks.add(stepGeneratorTask);
        if (handControlTask != null) {
            tasks.add(handControlTask);
        }
        String controllerName = "DRCSimulation";
        if (!((Boolean)this.runMultiThreaded.get()).booleanValue()) {
            LogTools.warn((String)"Running simulation in single threaded mode");
            this.robotController = new SingleThreadedRobotController<HumanoidRobotContextData>(controllerName, tasks, this.masterContext);
        } else {
            BarrierScheduler.TaskOverrunBehavior overrunBehavior = BarrierScheduler.TaskOverrunBehavior.BUSY_WAIT;
            this.robotController = new BarrierScheduledRobotController(controllerName, tasks, this.masterContext, overrunBehavior, (Double)this.simulationDT.get());
            tasks.forEach(task -> new Thread((Runnable)((Object)task), ((Object)task).getClass().getSimpleName() + "Thread").start());
        }
        if (this.logToFile.hasValue() && ((Boolean)this.logToFile.get()).booleanValue()) {
            ArrayList<RegistrySendBufferBuilder> builders = new ArrayList<RegistrySendBufferBuilder>();
            builders.add(new RegistrySendBufferBuilder(this.estimatorThread.getYoRegistry(), this.estimatorThread.getFullRobotModel().getElevator(), null));
            builders.add(new RegistrySendBufferBuilder(this.controllerThread.getYoVariableRegistry(), (Boolean)this.enableSCS1YoGraphics.get() != false ? this.controllerThread.getSCS1YoGraphicsListRegistry() : null, (Boolean)this.enableSCS2YoGraphics.get() != false ? this.controllerThread.getSCS2YoGraphics() : null));
            builders.add(new RegistrySendBufferBuilder(this.stepGeneratorThread.getYoVariableRegistry(), (Boolean)this.enableSCS1YoGraphics.get() != false ? this.stepGeneratorThread.getSCS1YoGraphicsListRegistry() : null, (Boolean)this.enableSCS2YoGraphics.get() != false ? this.stepGeneratorThread.getSCS2YoGraphics() : null));
            this.intraprocessYoVariableLogger = new IntraprocessYoVariableLogger(this.getClass().getSimpleName(), robotModel.getLogModelProvider(), builders, 100000, robotModel.getEstimatorDT());
            ((HumanoidRobotControlTask)estimatorTask).addCallbackPostTask(() -> this.intraprocessYoVariableLogger.update(this.estimatorThread.getHumanoidRobotContextData().getTimestamp()));
        }
        if (this.yoVariableServer != null) {
            this.yoVariableServer.setMainRegistry(this.estimatorThread.getYoRegistry(), SCS2AvatarSimulationFactory.createYoVariableServerJointList(this.estimatorThread.getFullRobotModel().getElevator()), (Boolean)this.enableSCS1YoGraphics.get() != false ? this.estimatorThread.getSCS1YoGraphicsListRegistry() : null, (Boolean)this.enableSCS2YoGraphics.get() != false ? this.estimatorThread.getSCS2YoGraphics() : null);
            ((HumanoidRobotControlTask)estimatorTask).addCallbackPostTask(() -> this.yoVariableServer.update(this.estimatorThread.getHumanoidRobotContextData().getTimestamp(), this.estimatorThread.getYoRegistry()));
            this.yoVariableServer.addRegistry(this.controllerThread.getYoVariableRegistry(), (Boolean)this.enableSCS1YoGraphics.get() != false ? this.controllerThread.getSCS1YoGraphicsListRegistry() : null, (Boolean)this.enableSCS2YoGraphics.get() != false ? this.controllerThread.getSCS2YoGraphics() : null);
            ((HumanoidRobotControlTask)controllerTask).addCallbackPostTask(() -> this.yoVariableServer.update(this.controllerThread.getHumanoidRobotContextData().getTimestamp(), this.controllerThread.getYoVariableRegistry()));
            this.yoVariableServer.addRegistry(this.stepGeneratorThread.getYoVariableRegistry(), (Boolean)this.enableSCS1YoGraphics.get() != false ? this.stepGeneratorThread.getSCS1YoGraphicsListRegistry() : null, (Boolean)this.enableSCS2YoGraphics.get() != false ? this.stepGeneratorThread.getSCS2YoGraphics() : null);
            ((HumanoidRobotControlTask)stepGeneratorTask).addCallbackPostTask(() -> this.yoVariableServer.update(this.stepGeneratorThread.getHumanoidRobotContextData().getTimestamp(), this.stepGeneratorThread.getYoVariableRegistry()));
        }
        final ArrayList<MirroredYoVariableRegistry> mirroredRegistries = new ArrayList<MirroredYoVariableRegistry>();
        mirroredRegistries.add(SCS2AvatarSimulationFactory.setupWithMirroredRegistry(this.estimatorThread.getYoRegistry(), estimatorTask, this.robotController.getYoRegistry()));
        mirroredRegistries.add(SCS2AvatarSimulationFactory.setupWithMirroredRegistry(this.controllerThread.getYoVariableRegistry(), controllerTask, this.robotController.getYoRegistry()));
        mirroredRegistries.add(SCS2AvatarSimulationFactory.setupWithMirroredRegistry(this.stepGeneratorThread.getYoVariableRegistry(), stepGeneratorTask, this.robotController.getYoRegistry()));
        if (handControlThread != null) {
            mirroredRegistries.add(SCS2AvatarSimulationFactory.setupWithMirroredRegistry(handControlThread.getYoVariableRegistry(), handControlTask, this.robotController.getYoRegistry()));
        }
        this.robot.getRegistry().addChild(this.robotController.getYoRegistry());
        this.robot.getControllerManager().addController(new Controller(){

            public void initialize() {
                mirroredRegistries.forEach(mirror -> mirror.updateChangedValues());
                FloatingJointBasics rootJoint = (FloatingJointBasics)SCS2AvatarSimulationFactory.this.robot.getRootBody().getChildrenJoints().get(0);
                RigidBodyTransform rootJointTransform = new RigidBodyTransform((Orientation3DReadOnly)rootJoint.getJointPose().getOrientation(), (Tuple3DReadOnly)rootJoint.getJointPose().getPosition());
                TObjectDoubleHashMap jointPositions = new TObjectDoubleHashMap();
                SubtreeStreams.fromChildren(OneDoFJointBasics.class, (RigidBodyReadOnly)SCS2AvatarSimulationFactory.this.robot.getRootBody()).forEach(arg_0 -> 1.lambda$initialize$1((TObjectDoubleMap)jointPositions, arg_0));
                SCS2AvatarSimulationFactory.this.estimatorThread.initializeStateEstimators(rootJointTransform, (TObjectDoubleMap<String>)jointPositions);
                SCS2AvatarSimulationFactory.this.controllerThread.initialize();
                SCS2AvatarSimulationFactory.this.stepGeneratorThread.initialize();
                SCS2AvatarSimulationFactory.this.masterContext.set(SCS2AvatarSimulationFactory.this.estimatorThread.getHumanoidRobotContextData());
                SCS2AvatarSimulationFactory.this.robotController.initialize();
                mirroredRegistries.forEach(mirror -> mirror.updateValuesFromOriginal());
            }

            public void doControl() {
                SCS2AvatarSimulationFactory.this.robotController.doControl();
            }

            public void pause() {
                if (SCS2AvatarSimulationFactory.this.robotController instanceof BarrierScheduledRobotController) {
                    ((BarrierScheduledRobotController)SCS2AvatarSimulationFactory.this.robotController).waitUntilTasksDone();
                }
            }

            private static /* synthetic */ void lambda$initialize$1(TObjectDoubleMap jointPositions, OneDoFJointBasics joint) {
                jointPositions.put((Object)joint.getName(), joint.getQ());
            }
        });
    }

    public static List<JointBasics> createYoVariableServerJointList(RigidBodyBasics rootBody) {
        ArrayList<JointBasics> joints = new ArrayList<JointBasics>();
        for (JointBasics joint : rootBody.childrenSubtreeIterable()) {
            if (joint instanceof CrossFourBarJoint) {
                joints.addAll(((CrossFourBarJoint)joint).getFourBarFunction().getLoopJoints());
                continue;
            }
            joints.add(joint);
        }
        return joints;
    }

    private static MirroredYoVariableRegistry setupWithMirroredRegistry(YoRegistry registry, HumanoidRobotControlTask owner, YoRegistry schedulerRegistry) {
        MirroredYoVariableRegistry mirroredRegistry = new MirroredYoVariableRegistry(registry);
        owner.addRunnableOnSchedulerThread(() -> {
            mirroredRegistry.updateValuesFromOriginal();
            mirroredRegistry.updateChangedValues();
        });
        schedulerRegistry.addChild((YoRegistry)mirroredRegistry);
        return mirroredRegistry;
    }

    private void setupLidarController() {
        AvatarRobotLidarParameters lidarParameters = ((DRCRobotModel)this.robotModel.get()).getSensorInformation().getLidarParameters(0);
        if (lidarParameters != null && lidarParameters.getLidarSpindleJointName() != null) {
            SimControllerInput controllerInput = this.robot.getControllerManager().getControllerInput();
            ControllerOutput controllerOutput = this.robot.getControllerManager().getControllerOutput();
            this.robot.getControllerManager().addController((Controller)new SCS2PIDLidarTorqueController((ControllerInput)controllerInput, controllerOutput, lidarParameters.getLidarSpindleJointName(), lidarParameters.getLidarSpindleVelocity(), (Double)this.simulationDT.get()));
        }
    }

    private void initializeStateEstimatorToActual() {
        if (((Boolean)this.initializeEstimatorToActual.get()).booleanValue()) {
            LogTools.info((String)"Initializing estimator to actual");
            ((RobotInitialSetup)this.robotInitialSetup.get()).initializeRobot((RigidBodyBasics)this.robot.getRootBody());
            this.robot.updateFrames();
            FloatingJointBasics rootJoint = (FloatingJointBasics)this.robot.getRootBody().getChildrenJoints().get(0);
            RigidBodyTransform rootJointTransform = new RigidBodyTransform((Orientation3DReadOnly)rootJoint.getJointPose().getOrientation(), (Tuple3DReadOnly)rootJoint.getJointPose().getPosition());
            TObjectDoubleHashMap jointPositions = new TObjectDoubleHashMap();
            SubtreeStreams.fromChildren(OneDoFJointBasics.class, (RigidBodyReadOnly)this.robot.getRootBody()).forEach(arg_0 -> SCS2AvatarSimulationFactory.lambda$initializeStateEstimatorToActual$15((TObjectDoubleMap)jointPositions, arg_0));
            this.estimatorThread.initializeStateEstimators(rootJointTransform, (TObjectDoubleMap<String>)jointPositions);
        }
    }

    private void setupSimulatedRobotTimeProvider() {
        this.simulatedRobotTimeProvider = new SimulatedDRCRobotTimeProvider((Double)this.simulationDT.get());
        this.robot.getControllerManager().addController(() -> this.simulatedRobotTimeProvider.doControl());
    }

    public void setSimulationName(String simulationName) {
        this.simulationName.set((Object)simulationName);
    }

    public void setRobotModel(DRCRobotModel robotModel) {
        this.robotModel.set((Object)robotModel);
        this.simulationDT.setDefaultValue((Object)robotModel.getSimulateDT());
        this.robotInitialSetup.setDefaultValue(robotModel.getDefaultRobotInitialSetup(0.0, 0.0));
    }

    public HighLevelHumanoidControllerFactory setDefaultHighLevelHumanoidControllerFactory() {
        DRCRobotModel robotModel = (DRCRobotModel)this.robotModel.get();
        HighLevelControllerParameters highLevelControllerParameters = robotModel.getHighLevelControllerParameters();
        WalkingControllerParameters walkingControllerParameters = robotModel.getWalkingControllerParameters();
        PushRecoveryControllerParameters pushRecoveryControllerParameters = robotModel.getPushRecoveryControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = robotModel.getCoPTrajectoryParameters();
        HumanoidRobotSensorInformation sensorInformation = robotModel.getSensorInformation();
        SideDependentList feetForceSensorNames = sensorInformation.getFeetForceSensorNames();
        SideDependentList wristForceSensorNames = sensorInformation.getWristForceSensorNames();
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
        ArrayList additionalContactNames = contactPointParameters.getAdditionalContactNames();
        ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionalContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
        }
        HighLevelHumanoidControllerFactory controllerFactory = new HighLevelHumanoidControllerFactory(contactableBodiesFactory, feetForceSensorNames, wristForceSensorNames, highLevelControllerParameters, walkingControllerParameters, pushRecoveryControllerParameters, copTrajectoryParameters, robotModel.getSplitFractionCalculatorParameters());
        HighLevelControllerName fallbackControllerState = highLevelControllerParameters.getFallbackControllerState();
        controllerFactory.useDefaultDoNothingControlState();
        controllerFactory.useDefaultWalkingControlState();
        if (pushRecoveryControllerParameters != null) {
            controllerFactory.useDefaultPushRecoveryControlState();
        }
        controllerFactory.addRequestableTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, HighLevelControllerName.WALKING);
        controllerFactory.addRequestableTransition(HighLevelControllerName.WALKING, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        controllerFactory.addRequestableTransition(HighLevelControllerName.WALKING, HighLevelControllerName.PUSH_RECOVERY);
        controllerFactory.addFinishedTransition(HighLevelControllerName.PUSH_RECOVERY, HighLevelControllerName.WALKING);
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, fallbackControllerState);
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.WALKING, fallbackControllerState);
        if (!this.initialState.hasValue()) {
            controllerFactory.setInitialState(HighLevelControllerName.WALKING);
        } else {
            controllerFactory.setInitialState((HighLevelControllerName)this.initialState.get());
        }
        if (this.realtimeROS2Node.hasBeenSet()) {
            controllerFactory.createControllerNetworkSubscriber(robotModel.getSimpleRobotName(), (RealtimeROS2Node)this.realtimeROS2Node.get());
        }
        this.setHighLevelHumanoidControllerFactory(controllerFactory);
        return controllerFactory;
    }

    public HighLevelHumanoidControllerFactory setDefaultHighLevelHumanoidControllerFactory(boolean useVelocityAndHeadingScript, HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters) {
        HighLevelHumanoidControllerFactory controllerFactory = this.highLevelHumanoidControllerFactory.hasBeenSet() ? (HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get() : this.setDefaultHighLevelHumanoidControllerFactory();
        this.setComponentBasedFootstepDataMessageGeneratorParameters(useVelocityAndHeadingScript, walkingScriptParameters);
        return controllerFactory;
    }

    public void setHighLevelHumanoidControllerFactory(HighLevelHumanoidControllerFactory highLevelHumanoidControllerFactory) {
        this.highLevelHumanoidControllerFactory.set((Object)highLevelHumanoidControllerFactory);
    }

    public HighLevelHumanoidControllerFactory getHighLevelHumanoidControllerFactory() {
        return (HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get();
    }

    public void addTerrainObjectDefinition(TerrainObjectDefinition terrainObjectDefinition) {
        this.terrainObjectDefinitions.add(terrainObjectDefinition);
    }

    public void setCommonAvatarEnvrionmentInterface(CommonAvatarEnvironmentInterface environment) {
        this.addTerrainObjectDefinition(TerrainObjectDefinitionTools.toTerrainObjectDefinition((CommonAvatarEnvironmentInterface)environment, (CollidableHelper)this.collidableHelper, (String)"terrain", (String[])new String[]{"robot"}));
    }

    public void setRobotInitialSetup(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup) {
        this.robotInitialSetup.set(robotInitialSetup);
    }

    public void setStartingLocationOffset(OffsetAndYawRobotInitialSetup startingLocationOffset) {
        ((RobotInitialSetup)this.robotInitialSetup.get()).setInitialYaw(startingLocationOffset.getYaw());
        ((RobotInitialSetup)this.robotInitialSetup.get()).setInitialGroundHeight(startingLocationOffset.getGroundHeight());
        ((RobotInitialSetup)this.robotInitialSetup.get()).setOffset((Tuple3DReadOnly)startingLocationOffset.getAdditionalOffset());
    }

    public void setSimulationDT(double simulationDT) {
        this.simulationDT.set((Object)simulationDT);
    }

    public void setSimulationDataBufferSize(int simulationDataBufferSize) {
        this.simulationDataBufferSize.set((Object)simulationDataBufferSize);
    }

    public void setSimulationDataRecordTimePeriod(double simulationDataRecordTimePeriod) {
        this.simulationDataRecordTickPeriod.set((Object)((int)Math.max(1.0, simulationDataRecordTimePeriod / (Double)this.simulationDT.get())));
    }

    public void setSimulationDataRecordTickPeriod(int simulationDataRecordTickPeriod) {
        this.simulationDataRecordTickPeriod.set((Object)simulationDataRecordTickPeriod);
    }

    public void setUsePerfectSensors(boolean usePerfectSensors) {
        this.usePerfectSensors.set((Object)usePerfectSensors);
    }

    public void setOutputWriterFactory(SCS2JointDesiredOutputWriterFactory outputWriterFactory) {
        this.outputWriterFactory.set((Object)outputWriterFactory);
    }

    public void setRunMultiThreaded(boolean runMultiThreaded) {
        this.runMultiThreaded.set((Object)runMultiThreaded);
    }

    public void setInitializeEstimatorToActual(boolean initializeEstimatorToActual) {
        this.initializeEstimatorToActual.set((Object)initializeEstimatorToActual);
    }

    public void setShowGUI(boolean showGUI) {
        this.showGUI.set((Object)showGUI);
    }

    public void setRealtimeROS2Node(RealtimeROS2Node realtimeROS2Node) {
        this.realtimeROS2Node.set((Object)realtimeROS2Node);
    }

    public void setCreateYoVariableServer(boolean createYoVariableServer) {
        this.createYoVariableServer.set((Object)createYoVariableServer);
    }

    public void setLogToFile(boolean logToFile) {
        this.logToFile.set((Object)logToFile);
    }

    public void setGravity(double gravity) {
        this.gravity.set((Object)gravity);
    }

    public void setEnableSCS1YoGraphics(boolean enableSCS1YoGraphics) {
        this.enableSCS1YoGraphics.set((Object)enableSCS1YoGraphics);
    }

    public void setEnableSCS2YoGraphics(boolean enableSCS2YoGraphics) {
        this.enableSCS2YoGraphics.set((Object)enableSCS2YoGraphics);
    }

    public void setAutomaticallyStartSimulation(boolean automaticallyStartSimulation) {
        this.automaticallyStartSimulation.set((Object)automaticallyStartSimulation);
    }

    public void setExternalPelvisCorrectorSubscriber(PelvisPoseCorrectionCommunicatorInterface externalPelvisCorrectorSubscriber) {
        this.externalPelvisCorrectorSubscriber.set((Object)externalPelvisCorrectorSubscriber);
    }

    public void setUseImpulseBasedPhysicsEngine(boolean useImpulseBasedPhysicsEngine) {
        this.useImpulseBasedPhysicsEngine.set((Object)useImpulseBasedPhysicsEngine);
    }

    public void setImpulseBasedPhysicsEngineContactParameters(ContactParametersReadOnly contactParameters) {
        this.impulseBasedPhysicsEngineContactParameters.set((Object)contactParameters);
    }

    public void setGroundContactModelParameters(RobotContactPointParameters.GroundContactModelParameters groundContactModelParameters) {
        this.groundContactModelParameters.set((Object)groundContactModelParameters);
    }

    public void setUseBulletPhysicsEngine(boolean useBulletPhysicsEngine) {
        this.useBulletPhysicsEngine.set((Object)useBulletPhysicsEngine);
    }

    public void setBulletCollisionMutator(Consumer<RobotDefinition> bulletCollisionMutator) {
        this.bulletCollisionMutator.set(bulletCollisionMutator);
    }

    public void setEnableSimulatedRobotDamping(boolean enableSimulatedRobotDamping) {
        this.enableSimulatedRobotDamping.set((Object)enableSimulatedRobotDamping);
    }

    public void setUseRobotDefinitionCollisions(boolean useRobotDefinitionCollisions) {
        this.useRobotDefinitionCollisions.set((Object)useRobotDefinitionCollisions);
    }

    public void addSecondaryRobot(Robot secondaryRobot) {
        ((List)this.secondaryRobots.get()).add(secondaryRobot);
    }

    public void setSecondaryStateEstimatorFactory(StateEstimatorControllerFactory secondaryStateEstimatorFactory) {
        this.secondaryStateEstimatorFactory.set((Object)secondaryStateEstimatorFactory);
    }

    public void setComponentBasedFootstepDataMessageGeneratorParameters(boolean useHeadingAndVelocityScript, HeadingAndVelocityEvaluationScriptParameters headingAndVelocityEvaluationScriptParameters) {
        this.setComponentBasedFootstepDataMessageGeneratorParameters(useHeadingAndVelocityScript, null, headingAndVelocityEvaluationScriptParameters);
    }

    public void setComponentBasedFootstepDataMessageGeneratorParameters(boolean useHeadingAndVelocityScript, HeightMap heightMapForFootstepZ, HeadingAndVelocityEvaluationScriptParameters headingAndVelocityEvaluationScriptParameters) {
        this.useHeadingAndVelocityScript.set((Object)useHeadingAndVelocityScript);
        this.heightMapForFootstepZ.set((Object)heightMapForFootstepZ);
        this.headingAndVelocityEvaluationScriptParameters.set((Object)headingAndVelocityEvaluationScriptParameters);
    }

    public void setInitialState(HighLevelControllerName initialState) {
        this.initialState.set((Object)initialState);
    }

    public void setupDefaultExternalControllerFactory() {
        HighLevelHumanoidControllerFactory highLevelControllerFactory = (HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get();
        if (highLevelControllerFactory == null) {
            throw new RuntimeException("You must call this.setDefaultHighLevelHumanoidCointrollerFactory first!");
        }
        highLevelControllerFactory.addCustomControlState((HighLevelControllerStateFactory)new StandReadyControllerStateFactory());
        highLevelControllerFactory.addCustomControlState((HighLevelControllerStateFactory)new ExternalControllerStateFactory());
        highLevelControllerFactory.addCustomControlState((HighLevelControllerStateFactory)new ExternalTransitionControllerStateFactory());
        highLevelControllerFactory.addRequestableTransition(HighLevelControllerName.STAND_READY, HighLevelControllerName.EXTERNAL_TRANSITION_STATE);
        highLevelControllerFactory.addRequestableTransition(HighLevelControllerName.EXTERNAL_TRANSITION_STATE, HighLevelControllerName.EXTERNAL);
        highLevelControllerFactory.addControllerFailureTransition(HighLevelControllerName.EXTERNAL_TRANSITION_STATE, ((DRCRobotModel)this.robotModel.get()).getHighLevelControllerParameters().getFallbackControllerState());
        highLevelControllerFactory.addControllerFailureTransition(HighLevelControllerName.EXTERNAL, ((DRCRobotModel)this.robotModel.get()).getHighLevelControllerParameters().getFallbackControllerState());
    }

    private static /* synthetic */ void lambda$initializeStateEstimatorToActual$15(TObjectDoubleMap jointPositions, OneDoFJointBasics joint) {
        jointPositions.put((Object)joint.getName(), joint.getQ());
    }
}

