/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.visualizer;

import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.NullGraphics3DAdapter;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.common.DiscoveryStatus;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.PausablePeriodicThread;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class SCSROS2Visualizer {
    private Participant participant;
    private final YoRegistry yoRegistry = new YoRegistry(this.getClass().getSimpleName());
    private final SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("Robot"), (Graphics3DAdapter)new NullGraphics3DAdapter(), new SimulationConstructionSetParameters());
    private final Stopwatch stopwatch = new Stopwatch().start();
    private final YoDouble timeElapsed = new YoDouble("timeElapsed", this.yoRegistry);
    private final YoLong numberOfParticipants = new YoLong("numberOfParticipants", this.yoRegistry);
    private final YoLong numberOfPublishers = new YoLong("numberOfPublishers", this.yoRegistry);
    private final YoLong numberOfSubscribers = new YoLong("numberOfSubscribers", this.yoRegistry);
    private final YoLong numberOfEndpoints = new YoLong("numberOfEndpoints", this.yoRegistry);
    private final PausablePeriodicThread updateThread;
    private boolean paused = false;

    public SCSROS2Visualizer() {
        ExceptionTools.handle(this::setupROS2Debugger, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        this.scs.addYoRegistry(this.yoRegistry);
        this.scs.setDT(1.0, 1);
        this.scs.setupGraph(this.timeElapsed.getName());
        this.scs.setupGraph(this.numberOfParticipants.getName());
        this.scs.setupGraph(this.numberOfPublishers.getName());
        this.scs.setupGraph(this.numberOfSubscribers.getName());
        this.scs.setupGraph(this.numberOfEndpoints.getName());
        this.scs.skipLoadingDefaultConfiguration();
        this.scs.hideViewport();
        this.scs.changeBufferSize(200);
        this.scs.setScrollGraphsEnabled(false);
        this.scs.getGUI().getFrame().setSize(1200, 800);
        JToggleButton pauseButton = new JToggleButton("Pause");
        pauseButton.addActionListener(e -> {
            this.paused = pauseButton.isSelected();
            this.scs.setScrollGraphsEnabled(this.paused);
        });
        this.scs.addButton((AbstractButton)pauseButton);
        this.scs.startOnAThread();
        while (!this.scs.hasSimulationThreadStarted()) {
            ThreadTools.sleep((long)200L);
        }
        this.updateThread = new PausablePeriodicThread(this.getClass().getSimpleName(), UnitConversions.hertzToSeconds((double)5.0), this::update);
        this.updateThread.start();
    }

    private void setupROS2Debugger() throws Exception {
        int domainID = NetworkParameters.getRTPSDomainID();
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        ParticipantAttributes attributes = domain.createParticipantAttributes(domainID, this.getClass().getSimpleName());
        this.participant = domain.createParticipant(attributes, (participant, info) -> {
            if (!info.getGuid().equals((Object)this.participant.getGuid())) {
                if (info.getStatus() == DiscoveryStatus.DISCOVERED_RTPSPARTICIPANT) {
                    this.numberOfParticipants.add(1L);
                    LogTools.info((String)"Discovered participant: {}", (Object)info.getName());
                } else if (info.getStatus() == DiscoveryStatus.REMOVED_RTPSPARTICIPANT) {
                    this.numberOfParticipants.subtract(1L);
                    LogTools.info((String)"Participant removed: {}", (Object)info.getName());
                }
            }
        });
        this.participant.registerEndpointDiscoveryListeners((isAlive, guid, participantGuid, typeName, topicName, userDefinedId, typeMaxSerialized, topicKind) -> {
            this.numberOfPublishers.add(1L);
            this.numberOfEndpoints.add(1L);
            LogTools.info((String)"Discovered publisher on topic: {}", (Object)topicName);
        }, (isAlive, guid, expectsInlineQos, participantGuid, typeName, topicName, userDefinedId, javaTopicKind) -> {
            this.numberOfSubscribers.add(1L);
            this.numberOfEndpoints.add(1L);
            LogTools.info((String)"Discovered subscriber on topic: {}", (Object)topicName);
        });
    }

    private void update() {
        this.timeElapsed.set(this.stopwatch.totalElapsed());
        if (!this.paused) {
            int bufferSize = this.scs.getDataBuffer().getBufferSize();
            if (this.scs.getDataBuffer().getCurrentIndex() == bufferSize - 2) {
                this.scs.changeBufferSize(bufferSize + bufferSize / 2);
            }
            this.scs.tickAndUpdate();
        }
    }

    public static void main(String[] args) {
        new SCSROS2Visualizer();
    }
}

