/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import us.ihmc.avatar.ros2.networkTest.SSHJClient;
import us.ihmc.avatar.ros2.networkTest.SSHJClientWithSFTP;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;

public class SSHJTools {
    public static void sessionWithSFTP(String address, String username, String password, Consumer<SSHJClientWithSFTP> action) {
        ExceptionTools.handle(() -> SSHJTools.connectAndAuthenticateClientWithSFTP(address, sshClient -> ExceptionTools.handle(() -> sshClient.authPassword(username, password), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE), action), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public static void sessionWithSFTP(String address, String username, Consumer<SSHJClientWithSFTP> action) {
        ExceptionTools.handle(() -> SSHJTools.connectAndAuthenticateClientWithSFTP(address, sshClient -> SSHJTools.authWithSSHKey(username, sshClient), action), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public static void session(String address, String username, Consumer<SSHJClient> action) {
        ExceptionTools.handle(() -> SSHJTools.connectAndAuthenticateClient(address, sshClient -> SSHJTools.authWithSSHKey(username, sshClient), action), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public static void authWithSSHKey(String username, SSHClient sshClient) {
        Path userSSHConfigFolder = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ssh");
        Stream list = (Stream)ExceptionTools.handle(() -> Files.list(userSSHConfigFolder), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        ArrayList<String> privateKeyFiles = new ArrayList<String>();
        for (Path path : list.collect(Collectors.toList())) {
            if (!Files.isRegularFile(path, new LinkOption[0]) || path.getFileName().toString() == "config" || path.getFileName().toString() == "known_hosts" || path.getFileName().toString().endsWith(".pub")) continue;
            String absoluteNormalizedString = path.toAbsolutePath().normalize().toString();
            privateKeyFiles.add(absoluteNormalizedString);
        }
        LogTools.info((String)"Passing keys to authPublicKey: {}", privateKeyFiles);
        ExceptionTools.handle(() -> sshClient.authPublickey(username, privateKeyFiles.toArray(new String[0])), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public static void connectAndAuthenticateClientWithSFTP(String address, Consumer<SSHClient> authenticate, Consumer<SSHJClientWithSFTP> action) throws IOException {
        SSHJTools.connectAndAuthenticateInternal(address, authenticate, sshClient -> {
            SFTPClient sftpClient = (SFTPClient)ExceptionTools.handle(() -> ((SSHClient)sshClient).newSFTPClient(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            action.accept(new SSHJClientWithSFTP((SSHClient)sshClient, sftpClient));
        });
    }

    public static void connectAndAuthenticateClient(String address, Consumer<SSHClient> authenticate, Consumer<SSHJClient> action) throws IOException {
        SSHJTools.connectAndAuthenticateInternal(address, authenticate, sshClient -> action.accept(new SSHJClient((SSHClient)sshClient)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectAndAuthenticateInternal(String address, Consumer<SSHClient> authenticate, Consumer<SSHClient> runnable) throws IOException {
        SSHClient sshClient = new SSHClient();
        ExceptionTools.handle(() -> sshClient.loadKnownHosts(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        ExceptionTools.handle(() -> sshClient.connect(address), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        try {
            authenticate.accept(sshClient);
            runnable.accept(sshClient);
        }
        finally {
            sshClient.disconnect();
        }
    }
}

