/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest;

import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import us.ihmc.avatar.ros2.networkTest.SSHJClient;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;

public class SSHJClientWithSFTP
extends SSHJClient {
    private final SFTPClient sftpClient;

    public SSHJClientWithSFTP(SSHClient sshClient, SFTPClient sftpClient) {
        super(sshClient);
        this.sftpClient = sftpClient;
    }

    public void put(String source, String dest) {
        LogTools.info((String)"Putting $source to ${ssh.remoteHostname}:$dest");
        ExceptionTools.handle(() -> this.sftpClient.put(source, dest), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public void get(String source, String dest) {
        LogTools.info((String)"Getting ${ssh.remoteHostname}:$source to $dest");
        ExceptionTools.handle(() -> this.sftpClient.get(source, dest), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }
}

