/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.channel.direct.Session;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;

public class SSHJClient {
    private final SSHClient sshClient;

    public SSHJClient(SSHClient sshClient) {
        this.sshClient = sshClient;
    }

    public Integer exec(String command) {
        return this.exec(command, 5.0);
    }

    public Integer exec(String command, double timeout) {
        return this.exec(command, timeout, sshjCommand -> {
            LogTools.info((String)((ByteArrayOutputStream)ExceptionTools.handle(() -> IOUtils.readFully((InputStream)sshjCommand.getInputStream()), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE)).toString());
            LogTools.error((String)((ByteArrayOutputStream)ExceptionTools.handle(() -> IOUtils.readFully((InputStream)sshjCommand.getErrorStream()), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE)).toString());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer exec(String command, double timeout, Consumer<Session.Command> sshjCommandConsumer) {
        Session.Command sshjCommand;
        Session session = null;
        try {
            Session finalSession = session = (Session)ExceptionTools.handle(() -> ((SSHClient)this.sshClient).startSession(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            LogTools.info((String)"Executing on {}: {}", (Object)this.sshClient.getRemoteHostname(), (Object)command);
            sshjCommand = (Session.Command)ExceptionTools.handle(() -> finalSession.exec(command), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            LogTools.info((String)"Done with exec");
            Session.Command finalSSHJCommand = sshjCommand;
            sshjCommandConsumer.accept(finalSSHJCommand);
            ExceptionTools.handle(() -> finalSSHJCommand.join((long)(timeout * 1.0E9), TimeUnit.NANOSECONDS), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            ExceptionTools.handle(() -> ((Session.Command)finalSSHJCommand).close(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            LogTools.info((String)"** exit status: {}", (Object)sshjCommand.getExitStatus());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sshjCommand.getExitStatus() == null ? -1 : sshjCommand.getExitStatus();
    }
}

