/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import org.apache.commons.lang3.mutable.MutableLong;
import us.ihmc.avatar.ros2.networkTest.ROS2NetworkTestMachine;
import us.ihmc.avatar.ros2.networkTest.ROS2NetworkTestProfile;
import us.ihmc.avatar.ros2.networkTest.SSHJTools;
import us.ihmc.avatar.ros2.networkTest.profiles.IntegersAt100HzNetworkTestProfile;
import us.ihmc.avatar.ros2.networkTest.profiles.IntegersAt1HzNetworkTestProfile;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.NullGraphics3DAdapter;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataVisualizer.BasicYoVariablesUpdatedListener;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.PausablePeriodicThread;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ROS2NetworkTest {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final double UPDATE_PERIOD = UnitConversions.hertzToSeconds((double)100.0);
    private final YoRegistry yoRegistry = new YoRegistry(this.getClass().getSimpleName());
    private PausablePeriodicThread yoServerUpdateThread;
    private ConcurrentLinkedDeque<YoVariableClient> yoVariableClients = new ConcurrentLinkedDeque();
    private YoVariableServer yoVariableServer;
    private SimulationConstructionSet scs;
    private boolean paused;
    private YoDouble experimentTime;
    private final HashMap<String, ROS2NetworkTestProfile> profiles = new HashMap();

    public ROS2NetworkTest(List<String> args) {
        LocalDateTime startTime;
        this.addProfile(IntegersAt1HzNetworkTestProfile.class);
        this.addProfile(IntegersAt100HzNetworkTestProfile.class);
        String profileName = args.get(args.indexOf("--profile") + 1);
        ROS2NetworkTestProfile profile = this.profiles.get(profileName);
        LogTools.info((String)"Running profile: {}", (Object)profileName);
        this.experimentTime = new YoDouble(ROS2NetworkTestMachine.getLocalMachine().getMachineName() + "Time", profile.getYoRegistry());
        LocalDateTime now = LocalDateTime.now();
        if (!args.contains("--startTime")) {
            LogTools.info((String)"Running as host.");
            startTime = now.plusSeconds(15L);
            String formattedStartTime = startTime.format(dateTimeFormatter);
            LogTools.info((String)"Starting nodes at {}", (Object)formattedStartTime);
            ArrayList yoVariableClients = new ArrayList();
            ConcurrentLinkedDeque clientUpdateListeners = new ConcurrentLinkedDeque();
            Object variableSynchronizer = new Object();
            profile.getRemoteMachines().parallelStream().forEach(remoteMachine -> {
                try {
                    ThreadTools.startAThread(() -> SSHJTools.sessionWithSFTP(remoteMachine.getSSHHostname(), remoteMachine.getUsername(), connection -> connection.exec(remoteMachine.getDeployDirectory() + "/ROS2NetworkTest --profile " + profileName + " --startTime " + formattedStartTime)), (String)"RemoteTestExecutor");
                    ThreadTools.sleepSeconds((double)10.0);
                    BasicYoVariablesUpdatedListener clientUpdateListener = new BasicYoVariablesUpdatedListener(this.yoRegistry);
                    YoVariableClient yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)clientUpdateListener);
                    LogTools.info((String)"Connecting to {}:{}", (Object)remoteMachine.getIPAddress(), (Object)8008);
                    yoVariableClient.start(remoteMachine.getIPAddress(), 8008);
                    yoVariableClient.setVariableSynchronizer(variableSynchronizer);
                    clientUpdateListeners.add(clientUpdateListener);
                    yoVariableClients.add(yoVariableClient);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            });
            for (BasicYoVariablesUpdatedListener clientUpdateListener : clientUpdateListeners) {
                if (!clientUpdateListener.isHandshakeComplete()) {
                    LogTools.info((String)"Waiting for handshake...");
                }
                while (!clientUpdateListener.isHandshakeComplete()) {
                    ThreadTools.sleep((long)100L);
                }
                LogTools.info((String)"Handshake complete.");
            }
            LogTools.info((String)"Starting SCS");
            this.scs = new SimulationConstructionSet(new Robot("robot"), (Graphics3DAdapter)new NullGraphics3DAdapter(), new SimulationConstructionSetParameters());
            this.yoRegistry.addChild(profile.getYoRegistry());
            this.scs.addYoRegistry(this.yoRegistry);
            YoDouble yoTime = (YoDouble)this.scs.getRootRegistry().findVariable("t");
            this.scs.setDT(UPDATE_PERIOD, 1);
            this.scs.setupGraph(yoTime.getName());
            this.scs.skipLoadingDefaultConfiguration();
            this.scs.hideViewport();
            this.scs.changeBufferSize(4096);
            this.scs.getGUI().getFrame().setSize(1600, 900);
            this.scs.setScrollGraphsEnabled(false);
            JToggleButton pauseButton = new JToggleButton("Pause/End");
            pauseButton.addActionListener(e -> {
                this.paused = pauseButton.isSelected();
                this.scs.setScrollGraphsEnabled(this.paused);
            });
            this.scs.addButton((AbstractButton)pauseButton);
            List<ROS2NetworkTestMachine> remoteMachines = profile.getRemoteMachines();
            String[] nanoTimeGraphs = new String[remoteMachines.size() + 1];
            nanoTimeGraphs[0] = this.experimentTime.getName();
            for (int i = 0; i < remoteMachines.size(); ++i) {
                nanoTimeGraphs[i + 1] = remoteMachines.get(i).getMachineName() + "Time";
            }
            this.scs.setupGraph(nanoTimeGraphs);
            for (Object[] objectArray : profile.getGraphsToSetup()) {
                LogTools.info((String)"Setting up graph: {}", (Object)Arrays.toString(objectArray));
                this.scs.setupGraph((String[])objectArray);
            }
            this.scs.startOnAThread();
            while (!this.scs.hasSimulationThreadStarted()) {
                ThreadTools.sleep((long)200L);
            }
            new PausablePeriodicThread("SCSUpdater", UPDATE_PERIOD, () -> {
                if (!this.paused) {
                    yoTime.add(UPDATE_PERIOD);
                    Object object = variableSynchronizer;
                    synchronized (object) {
                        this.experimentTime.set(Conversions.nanosecondsToSeconds((long)(-LocalDateTime.now().until(startTime, ChronoUnit.NANOS))));
                        profile.updateDerivativeVariables(this.yoRegistry);
                        int bufferSize = this.scs.getDataBuffer().getBufferSize();
                        if (this.scs.getDataBuffer().getCurrentIndex() == bufferSize - 2) {
                            this.scs.changeBufferSize(bufferSize + bufferSize / 2);
                        }
                        this.scs.tickAndUpdate();
                    }
                }
            }).start();
        } else {
            if (!args.contains("--startTime")) {
                throw new RuntimeException("Client mode requires a time to start specified with --startTime");
            }
            LogTools.info((String)"Running as client.");
            String startTimeString = args.get(args.indexOf("--startTime") + 1);
            LogTools.info((String)"Start time: {}", (Object)startTimeString);
            startTime = LocalDateTime.parse(startTimeString, dateTimeFormatter);
            this.yoVariableServer = new YoVariableServer(profile.getMachineName() + profileName, null, new DataServerSettings(false), UPDATE_PERIOD);
            this.yoVariableServer.setMainRegistry(profile.getYoRegistry(), null);
            LogTools.info((String)"Starting YoVariableServer...");
            this.yoVariableServer.start();
            LogTools.info((String)"Starting server update thread...");
            MutableLong timestamp = new MutableLong();
            this.yoServerUpdateThread = new PausablePeriodicThread("YoServerUpdate", UPDATE_PERIOD, () -> {
                this.experimentTime.set(Conversions.nanosecondsToSeconds((long)(-LocalDateTime.now().until(startTime, ChronoUnit.NANOS))));
                this.yoVariableServer.update(timestamp.getAndAdd(Conversions.secondsToNanoseconds((double)UPDATE_PERIOD)));
            });
            this.yoServerUpdateThread.start();
        }
        if (!args.contains("--profile")) {
            throw new RuntimeException("Must select a profile with --profile");
        }
        LogTools.info((String)"Waiting to start test...");
        ThreadTools.sleep((long)LocalDateTime.now().until(startTime, ChronoUnit.MILLIS));
        LogTools.info((String)"Starting test");
        profile.runExperiment();
        LogTools.info((String)"Experiment finished.");
        ThreadTools.sleepSeconds((double)7.0);
        LogTools.info((String)"Stopping experiment...");
        this.paused = true;
        if (this.scs != null) {
            this.scs.setScrollGraphsEnabled(true);
        }
        if (this.yoServerUpdateThread != null) {
            this.yoServerUpdateThread.destroy();
        }
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
        }
        for (YoVariableClient yoVariableClient : this.yoVariableClients) {
            yoVariableClient.stop();
        }
        profile.destroy();
    }

    private void addProfile(Class<? extends ROS2NetworkTestProfile> clazz) {
        this.profiles.put(clazz.getSimpleName(), (ROS2NetworkTestProfile)ExceptionTools.handle(clazz::newInstance, (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION));
    }

    public static void main(String[] args) {
        new ROS2NetworkTest(Arrays.asList(args));
    }
}

