/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros.subscriber;

import controller_msgs.msg.dds.ArmTrajectoryMessage;
import controller_msgs.msg.dds.OneDoFJointTrajectoryMessage;
import ihmc_common_msgs.msg.dds.TrajectoryPoint1DMessage;
import java.util.ArrayList;
import trajectory_msgs.JointTrajectory;
import trajectory_msgs.JointTrajectoryPoint;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.idl.IDLSequence;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;

public class RosArmJointTrajectorySubscriber
extends AbstractRosTopicSubscriber<JointTrajectory> {
    private final PacketCommunicator packetCommunicator;
    private final ArrayList<String> leftArmNames = new ArrayList();
    private final ArrayList<String> rightArmNames = new ArrayList();

    public RosArmJointTrajectorySubscriber(PacketCommunicator controllerCommunicationBridge, FullHumanoidRobotModel fullRobotModel) {
        super("trajectory_msgs/JointTrajectory");
        this.packetCommunicator = controllerCommunicationBridge;
        ArmJointName[] armJointNames = fullRobotModel.getRobotSpecificJointNames().getArmJointNames();
        for (int i = 0; i < armJointNames.length; ++i) {
            ArmJointName jointName = armJointNames[i];
            this.leftArmNames.add(fullRobotModel.getArmJoint(RobotSide.LEFT, jointName).getName());
            this.rightArmNames.add(fullRobotModel.getArmJoint(RobotSide.RIGHT, jointName).getName());
        }
    }

    public void onNewMessage(JointTrajectory rosMessage) {
        RobotSide robotSide;
        if (this.leftArmNames.equals(rosMessage.getJointNames())) {
            robotSide = RobotSide.LEFT;
        } else if (this.rightArmNames.equals(rosMessage.getJointNames())) {
            robotSide = RobotSide.RIGHT;
        } else {
            System.out.println(this.getHelp());
            System.err.println(this.getHelp());
            return;
        }
        int numberOfJoints = rosMessage.getJointNames().size();
        int numberOfWaypoints = rosMessage.getPoints().size();
        ArmTrajectoryMessage ihmcMessage = HumanoidMessageTools.createArmTrajectoryMessage((RobotSide)robotSide);
        IDLSequence.Object jointTrajectoryMessages = ihmcMessage.getJointspaceTrajectory().getJointTrajectoryMessages();
        for (int i = 0; i < numberOfJoints; ++i) {
            jointTrajectoryMessages.add();
        }
        for (int waypointIndex = 0; waypointIndex < numberOfWaypoints; ++waypointIndex) {
            double[] positions = ((JointTrajectoryPoint)rosMessage.getPoints().get(waypointIndex)).getPositions();
            double[] velocities = ((JointTrajectoryPoint)rosMessage.getPoints().get(waypointIndex)).getVelocities();
            if (positions.length != numberOfJoints || positions.length != velocities.length) {
                String msg = "Number of joints positions or velocities in JointTrajectoryPoint inconsistent with expected number of joints " + numberOfJoints;
                System.out.println(msg);
                System.err.println(msg);
            }
            long nsecs = ((JointTrajectoryPoint)rosMessage.getPoints().get(waypointIndex)).getTimeFromStart().totalNsecs();
            double time = Conversions.nanosecondsToSeconds((long)nsecs);
            for (int jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                ((TrajectoryPoint1DMessage)((OneDoFJointTrajectoryMessage)jointTrajectoryMessages.get(jointIndex)).getTrajectoryPoints().add()).set(HumanoidMessageTools.createTrajectoryPoint1DMessage((double)time, (double)positions[jointIndex], (double)velocities[jointIndex]));
            }
        }
        ihmcMessage.setDestination(PacketDestination.CONTROLLER.ordinal());
        this.packetCommunicator.send((Packet)ihmcMessage);
    }

    private String getHelp() {
        int i;
        Object helpText = "Expected arm joint names for the left side are:\n";
        for (i = 0; i < this.leftArmNames.size(); ++i) {
            helpText = (String)helpText + this.leftArmNames.get(i) + " ";
        }
        helpText = (String)helpText + "\nFor a right side trajectory please provide:\n";
        for (i = 0; i < this.rightArmNames.size(); ++i) {
            helpText = (String)helpText + this.rightArmNames.get(i) + " ";
        }
        helpText = (String)helpText + "\nIt is required to provide the full list of joint angles in the correct order.";
        return helpText;
    }
}

