/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import org.ros.message.Time;
import perception_msgs.msg.dds.SimulatedLidarScanPacket;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.communication.net.ObjectConsumer;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosLidarPublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class RosSCSLidarPublisher
implements ObjectConsumer<SimulatedLidarScanPacket> {
    private final RosLidarPublisher[] lidarPublisher;
    private final RosMainNode rosMainNode;
    private final RobotROSClockCalculator rosClockCalculator;
    private final AvatarRobotLidarParameters[] lidarParameters;
    private final int nSensors;

    public RosSCSLidarPublisher(ObjectCommunicator localObjectCommunicator, RosMainNode rosMainNode, RobotROSClockCalculator rosClockCalculator, FullRobotModel fullRobotModel, AvatarRobotLidarParameters[] lidarParameters) {
        this.nSensors = lidarParameters.length;
        this.rosMainNode = rosMainNode;
        this.rosClockCalculator = rosClockCalculator;
        this.lidarParameters = lidarParameters;
        this.lidarPublisher = new RosLidarPublisher[this.nSensors];
        for (int sensorId = 0; sensorId < this.nSensors; ++sensorId) {
            this.lidarPublisher[sensorId] = new RosLidarPublisher(false);
            String rosTopic = lidarParameters[sensorId].getRosTopic();
            rosMainNode.attachPublisher(rosTopic, (RosTopicPublisher)this.lidarPublisher[sensorId]);
        }
        localObjectCommunicator.attachListener(SimulatedLidarScanPacket.class, (ObjectConsumer)this);
    }

    public void consumeObject(SimulatedLidarScanPacket simLidarScan) {
        if (this.rosMainNode.isStarted()) {
            int sensorId = simLidarScan.getSensorId();
            long timestamp = this.rosClockCalculator.computeROSTime(simLidarScan.getLidarScanParameters().getTimestamp(), simLidarScan.getLidarScanParameters().getTimestamp());
            Time time = Time.fromNano((long)timestamp);
            String frameId = this.lidarParameters[sensorId].getEndFrameForRosTransform();
            this.lidarPublisher[sensorId].publish(simLidarScan, frameId, time);
        }
    }
}

