/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.IMUPacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.SpatialVectorMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.ros.message.Time;
import us.ihmc.avatar.ros.IHMCROSTranslationRuntimeTools;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.ros.RosTfPublisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.robotics.partNames.JointNameMap;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.parameters.AvatarRobotRosVisionSensorInformation;
import us.ihmc.sensorProcessing.parameters.HumanoidForceSensorInformation;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosImuPublisher;
import us.ihmc.utilities.ros.publisher.RosInt32Publisher;
import us.ihmc.utilities.ros.publisher.RosJointStatePublisher;
import us.ihmc.utilities.ros.publisher.RosLastReceivedMessagePublisher;
import us.ihmc.utilities.ros.publisher.RosOdometryPublisher;
import us.ihmc.utilities.ros.publisher.RosStringPublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.publisher.RosWrenchPublisher;

public class RosRobotConfigurationDataPublisher
implements PacketConsumer<RobotConfigurationData>,
Runnable,
CloseableAndDisposable {
    public static final String JOINT_STATE_TOPIC = "/output/joint_states";
    public static final String WORLD_FRAME = "world";
    private final IHMCCommunicationKryoNetClassList netClassList = new IHMCCommunicationKryoNetClassList();
    private final RosTfPublisher tfPublisher;
    private final HashMap<RosJointStatePublisher, JointStatePublisherHelper> additionalJointStatePublisherMap = new HashMap();
    private RosJointStatePublisher[] additionalJointStatePublishers = new RosJointStatePublisher[0];
    private final RosJointStatePublisher jointStatePublisher;
    private final String[] imuROSFrameIDs;
    private final RosImuPublisher[] imuPublishers;
    private final RosOdometryPublisher pelvisOdometryPublisher;
    private final RosStringPublisher robotMotionStatusPublisher;
    private final RosInt32Publisher robotBehaviorPublisher;
    private final RosLastReceivedMessagePublisher lastReceivedMessagePublisher;
    private final ForceSensorDefinition[] forceSensorDefinitions;
    private final IMUDefinition[] imuDefinitions;
    private final ArrayList<String> nameList = new ArrayList();
    private final RosMainNode rosMainNode;
    private final RobotROSClockCalculator rosClockCalculator;
    private final ArrayBlockingQueue<RobotConfigurationData> availableRobotConfigurationData = new ArrayBlockingQueue(30);
    private final JointNameMap<?> jointMap;
    private final int jointNameHash;
    private boolean publishForceSensorInformation = false;
    private final SideDependentList<Integer> feetForceSensorIndexes = new SideDependentList();
    private final SideDependentList<Integer> handForceSensorIndexes = new SideDependentList();
    private final SideDependentList<RosWrenchPublisher> footForceSensorPublishers = new SideDependentList();
    private final SideDependentList<RosWrenchPublisher> wristForceSensorPublishers = new SideDependentList();
    private final SideDependentList<float[]> footForceSensorWrenches = new SideDependentList();
    private final SideDependentList<float[]> wristForceSensorWrenches = new SideDependentList();
    private final List<ImmutableTriple<String, String, RigidBodyTransform>> staticTransforms;
    private volatile boolean running = true;

    public RosRobotConfigurationDataPublisher(FullRobotModelFactory sdfFullRobotModelFactory, RealtimeROS2Node ros2Node, ROS2Topic<?> robotConfigurationTopicName, RosMainNode rosMainNode, RobotROSClockCalculator rosClockCalculator, AvatarRobotRosVisionSensorInformation sensorInformation, HumanoidForceSensorInformation forceSensorInformation, JointNameMap<?> jointMap, String rosNameSpace, RosTfPublisher tfPublisher) {
        FullRobotModel fullRobotModel = sdfFullRobotModelFactory.createFullRobotModel();
        this.forceSensorDefinitions = fullRobotModel.getForceSensorDefinitions();
        this.imuDefinitions = fullRobotModel.getIMUDefinitions();
        this.rosMainNode = rosMainNode;
        this.rosClockCalculator = rosClockCalculator;
        this.tfPublisher = tfPublisher;
        this.jointMap = jointMap;
        this.staticTransforms = sensorInformation.getStaticTransformsForRos();
        boolean latched = false;
        this.jointStatePublisher = new RosJointStatePublisher(latched);
        this.pelvisOdometryPublisher = new RosOdometryPublisher(latched);
        this.robotMotionStatusPublisher = new RosStringPublisher(latched);
        this.robotBehaviorPublisher = new RosInt32Publisher(latched);
        this.lastReceivedMessagePublisher = new RosLastReceivedMessagePublisher(latched);
        this.imuROSFrameIDs = new String[this.imuDefinitions.length];
        this.imuPublishers = new RosImuPublisher[this.imuDefinitions.length];
        for (int sensorNumber = 0; sensorNumber < this.imuDefinitions.length; ++sensorNumber) {
            IMUDefinition imuDefinition = this.imuDefinitions[sensorNumber];
            String imuName = imuDefinition.getName();
            RosImuPublisher rosImuPublisher = new RosImuPublisher(latched);
            this.imuROSFrameIDs[sensorNumber] = imuDefinition.getName() + "_Frame";
            this.imuPublishers[sensorNumber] = rosImuPublisher;
            rosMainNode.attachPublisher(rosNameSpace + "/output/imu/" + imuName, (RosTopicPublisher)rosImuPublisher);
        }
        if (forceSensorInformation != null) {
            this.publishForceSensorInformation = true;
            SideDependentList feetForceSensorNames = forceSensorInformation.getFeetForceSensorNames();
            SideDependentList handForceSensorNames = forceSensorInformation.getWristForceSensorNames();
            for (RobotSide robotSide : RobotSide.values()) {
                this.footForceSensorPublishers.put((Enum)robotSide, (Object)new RosWrenchPublisher(latched));
                this.feetForceSensorIndexes.put((Enum)robotSide, (Object)this.getForceSensorIndex((String)feetForceSensorNames.get((Enum)robotSide), this.forceSensorDefinitions));
                if (handForceSensorNames == null || handForceSensorNames.isEmpty()) continue;
                this.handForceSensorIndexes.put((Enum)robotSide, (Object)this.getForceSensorIndex((String)handForceSensorNames.get((Enum)robotSide), this.forceSensorDefinitions));
                this.wristForceSensorPublishers.put((Enum)robotSide, (Object)new RosWrenchPublisher(latched));
            }
        }
        OneDoFJointBasics[] joints = fullRobotModel.getControllableOneDoFJoints();
        for (int i = 0; i < joints.length; ++i) {
            this.nameList.add(joints[i].getName());
        }
        this.jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])joints, (ForceSensorDefinition[])this.forceSensorDefinitions, (IMUDefinition[])this.imuDefinitions);
        rosMainNode.attachPublisher(rosNameSpace + JOINT_STATE_TOPIC, (RosTopicPublisher)this.jointStatePublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/robot_pose", (RosTopicPublisher)this.pelvisOdometryPublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/robot_motion_status", (RosTopicPublisher)this.robotMotionStatusPublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/behavior", (RosTopicPublisher)this.robotBehaviorPublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/last_robot_config_received", (RosTopicPublisher)this.lastReceivedMessagePublisher);
        if (this.publishForceSensorInformation) {
            rosMainNode.attachPublisher(rosNameSpace + "/output/foot_force_sensor/left", (RosTopicPublisher)this.footForceSensorPublishers.get((Enum)RobotSide.LEFT));
            rosMainNode.attachPublisher(rosNameSpace + "/output/foot_force_sensor/right", (RosTopicPublisher)this.footForceSensorPublishers.get((Enum)RobotSide.RIGHT));
            if (!this.wristForceSensorPublishers.isEmpty()) {
                rosMainNode.attachPublisher(rosNameSpace + "/output/wrist_force_sensor/left", (RosTopicPublisher)this.wristForceSensorPublishers.get((Enum)RobotSide.LEFT));
                rosMainNode.attachPublisher(rosNameSpace + "/output/wrist_force_sensor/right", (RosTopicPublisher)this.wristForceSensorPublishers.get((Enum)RobotSide.RIGHT));
            }
        }
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)ros2Node, RobotConfigurationData.class, robotConfigurationTopicName, s -> this.receivedPacket((RobotConfigurationData)s.takeNextData()));
        Thread t = new Thread((Runnable)this, "RosRobotJointStatePublisher");
        t.start();
    }

    private int getForceSensorIndex(String forceSensorName, ForceSensorDefinition[] forceSensorDefinitions) {
        for (int i = 0; i < forceSensorDefinitions.length; ++i) {
            if (!forceSensorDefinitions[i].getSensorName().equals(forceSensorName)) continue;
            return i;
        }
        return -1;
    }

    public void receivedPacket(RobotConfigurationData robotConfigurationData) {
        if (!this.availableRobotConfigurationData.offer(robotConfigurationData)) {
            this.availableRobotConfigurationData.clear();
        }
    }

    public void setAdditionalJointStatePublishing(String topicName, String ... jointNames) {
        RosJointStatePublisher jointStatePublisher = new RosJointStatePublisher(false);
        this.rosMainNode.attachPublisher(topicName, (RosTopicPublisher)jointStatePublisher);
        JointStatePublisherHelper pubData = new JointStatePublisherHelper(jointStatePublisher, jointNames);
        this.additionalJointStatePublisherMap.put(jointStatePublisher, pubData);
        this.rebuildKeySetArray();
    }

    private void rebuildKeySetArray() {
        Set<RosJointStatePublisher> keySet = this.additionalJointStatePublisherMap.keySet();
        this.additionalJointStatePublishers = new RosJointStatePublisher[keySet.size()];
        this.additionalJointStatePublishers = keySet.toArray(this.additionalJointStatePublishers);
    }

    @Override
    public void run() {
        while (this.running) {
            RobotConfigurationData robotConfigurationData;
            try {
                robotConfigurationData = this.availableRobotConfigurationData.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (!this.rosMainNode.isStarted()) continue;
            float[] jointAngles = robotConfigurationData.getJointAngles().toArray();
            float[] jointVelocities = robotConfigurationData.getJointVelocities().toArray();
            float[] jointTorques = robotConfigurationData.getJointTorques().toArray();
            long timeStamp = this.rosClockCalculator.computeROSTime(robotConfigurationData.getWallTime(), robotConfigurationData.getMonotonicTime());
            Time t = Time.fromNano((long)timeStamp);
            if (robotConfigurationData.getJointNameHash() != this.jointNameHash) {
                throw new RuntimeException("Joint names do not match for RobotConfigurationData");
            }
            for (int i = 0; i < this.additionalJointStatePublishers.length; ++i) {
                RobotSide[] jointStatePublisher = this.additionalJointStatePublishers[i];
                JointStatePublisherHelper pubData = this.additionalJointStatePublisherMap.get(jointStatePublisher);
                pubData.publish(jointAngles, jointVelocities, jointTorques, t);
            }
            RigidBodyTransform pelvisTransform = new RigidBodyTransform((Orientation3DReadOnly)robotConfigurationData.getRootOrientation(), (Tuple3DReadOnly)robotConfigurationData.getRootPosition());
            this.jointStatePublisher.publish(this.nameList, jointAngles, jointVelocities, jointTorques, t);
            if (this.publishForceSensorInformation) {
                for (RobotSide robotSide : RobotSide.values()) {
                    float[] arrayToPublish = new float[6];
                    ((SpatialVectorMessage)robotConfigurationData.getForceSensorData().get(((Integer)this.feetForceSensorIndexes.get((Enum)robotSide)).intValue())).getAngularPart().get(0, arrayToPublish);
                    ((SpatialVectorMessage)robotConfigurationData.getForceSensorData().get(((Integer)this.feetForceSensorIndexes.get((Enum)robotSide)).intValue())).getLinearPart().get(3, arrayToPublish);
                    this.footForceSensorWrenches.put((Enum)robotSide, (Object)arrayToPublish);
                    ((RosWrenchPublisher)this.footForceSensorPublishers.get((Enum)robotSide)).publish(timeStamp, (float[])this.footForceSensorWrenches.get((Enum)robotSide));
                    if (this.handForceSensorIndexes.isEmpty()) continue;
                    arrayToPublish = new float[6];
                    ((SpatialVectorMessage)robotConfigurationData.getForceSensorData().get(((Integer)this.handForceSensorIndexes.get((Enum)robotSide)).intValue())).getAngularPart().get(0, arrayToPublish);
                    ((SpatialVectorMessage)robotConfigurationData.getForceSensorData().get(((Integer)this.handForceSensorIndexes.get((Enum)robotSide)).intValue())).getLinearPart().get(3, arrayToPublish);
                    this.wristForceSensorWrenches.put((Enum)robotSide, (Object)arrayToPublish);
                    ((RosWrenchPublisher)this.wristForceSensorPublishers.get((Enum)robotSide)).publish(timeStamp, (float[])this.wristForceSensorWrenches.get((Enum)robotSide));
                }
            }
            for (int sensorNumber = 0; sensorNumber < Math.min(this.imuDefinitions.length, robotConfigurationData.getImuSensorData().size()); ++sensorNumber) {
                RosImuPublisher rosImuPublisher = this.imuPublishers[sensorNumber];
                IMUPacket imuPacket = (IMUPacket)robotConfigurationData.getImuSensorData().get(sensorNumber);
                rosImuPublisher.publish(timeStamp, imuPacket, this.imuROSFrameIDs[sensorNumber]);
            }
            this.pelvisOdometryPublisher.publish(timeStamp, pelvisTransform, (Vector3DReadOnly)robotConfigurationData.getPelvisLinearVelocity(), (Vector3DReadOnly)robotConfigurationData.getPelvisAngularVelocity(), this.jointMap.getUnsanitizedRootJointInSdf(), WORLD_FRAME);
            this.robotMotionStatusPublisher.publish(RobotMotionStatus.fromByte((byte)robotConfigurationData.getRobotMotionStatus()).name());
            this.robotBehaviorPublisher.publish(RobotMotionStatus.fromByte((byte)robotConfigurationData.getRobotMotionStatus()).getBehaviorId());
            this.tfPublisher.publish(pelvisTransform, timeStamp, WORLD_FRAME, this.jointMap.getUnsanitizedRootJointInSdf());
            if (this.staticTransforms != null) {
                for (int i = 0; i < this.staticTransforms.size(); ++i) {
                    ImmutableTriple<String, String, RigidBodyTransform> staticTransformTriplet = this.staticTransforms.get(i);
                    String from = (String)staticTransformTriplet.getLeft();
                    String to = (String)staticTransformTriplet.getMiddle();
                    RigidBodyTransform staticTransform = (RigidBodyTransform)staticTransformTriplet.getRight();
                    this.tfPublisher.publish(staticTransform, timeStamp, from, to);
                }
            }
            if (robotConfigurationData.getLastReceivedPacketTypeId() == -1) continue;
            Class packetClass = this.netClassList.getClass(robotConfigurationData.getLastReceivedPacketTypeId());
            if (packetClass == null) {
                System.err.println("Could not get packet class for ID " + robotConfigurationData.getLastReceivedPacketTypeId());
                continue;
            }
            String messageType = IHMCROSTranslationRuntimeTools.getROSMessageTypeStringFromIHMCMessageClass(packetClass);
            if (messageType == null) continue;
            this.lastReceivedMessagePublisher.publish(messageType, robotConfigurationData.getLastReceivedPacketUniqueId(), timeStamp, robotConfigurationData.getLastReceivedPacketRobotTimestamp());
        }
    }

    public void closeAndDispose() {
        this.running = false;
    }

    private class JointStatePublisherHelper {
        private final RosJointStatePublisher jointStatePublisher;
        private final ArrayList<String> jointNames = new ArrayList();
        private final int[] jointIndices;
        private final double[] jointAnglesSubSet;
        private final double[] jointVelocitiesSubSet;
        private final double[] jointJointTorquesSubSet;

        public JointStatePublisherHelper(RosJointStatePublisher jointStatePublisher, String[] jointNames) {
            this.jointStatePublisher = jointStatePublisher;
            this.jointIndices = new int[jointNames.length];
            for (int i = 0; i < jointNames.length; ++i) {
                int index = RosRobotConfigurationDataPublisher.this.nameList.indexOf(jointNames[i]);
                if (index == -1) {
                    LogTools.error((String)("DID NOT FIND JOINT " + jointNames[i]));
                    continue;
                }
                this.jointNames.add(jointNames[i]);
                this.jointIndices[i] = index;
            }
            this.jointAnglesSubSet = new double[this.jointNames.size()];
            this.jointVelocitiesSubSet = new double[this.jointNames.size()];
            this.jointJointTorquesSubSet = new double[this.jointNames.size()];
        }

        public void publish(float[] jointAngles, float[] jointVelocities, float[] jointTorques, Time t) {
            for (int i = 0; i < this.jointIndices.length; ++i) {
                this.jointAnglesSubSet[i] = jointAngles[this.jointIndices[i]];
                this.jointVelocitiesSubSet[i] = jointVelocities[this.jointIndices[i]];
                this.jointJointTorquesSubSet[i] = jointTorques[this.jointIndices[i]];
            }
            this.jointStatePublisher.publish(this.jointNames, this.jointAnglesSubSet, this.jointVelocitiesSubSet, this.jointJointTorquesSubSet, t);
        }
    }
}

