/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import java.util.concurrent.ArrayBlockingQueue;
import us.ihmc.avatar.ros.RosSupportPolygonPublisher;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosBoolPublisher;
import us.ihmc.utilities.ros.publisher.RosPoint2dPublisher;
import us.ihmc.utilities.ros.publisher.RosPoint32Publisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class RosCapturabilityBasedStatusPublisher
implements PacketConsumer<CapturabilityBasedStatus>,
Runnable {
    private final ArrayBlockingQueue<CapturabilityBasedStatus> availableCapturabilityStatus = new ArrayBlockingQueue(30);
    private final RosPoint2dPublisher capturePointPublisher = new RosPoint2dPublisher(false);
    private final RosPoint2dPublisher desiredCapturePointPublisher = new RosPoint2dPublisher(false);
    private final RosPoint32Publisher centerOfMassPublisher = new RosPoint32Publisher(false);
    private final RosBoolPublisher isInDoubleSupportPublisher = new RosBoolPublisher(false);
    private final SideDependentList<RosSupportPolygonPublisher> supportPolygonPublishers = new SideDependentList();
    private final RosMainNode rosMainNode;

    public RosCapturabilityBasedStatusPublisher(RosMainNode rosMainNode, String rosNameSpace) {
        this.rosMainNode = rosMainNode;
        for (RobotSide value : RobotSide.values) {
            RosSupportPolygonPublisher rosSupportPolygonPublisher = new RosSupportPolygonPublisher(false);
            this.supportPolygonPublishers.put((Enum)value, (Object)rosSupportPolygonPublisher);
            this.rosMainNode.attachPublisher(rosNameSpace + "/output/capturability/" + value.getCamelCaseNameForStartOfExpression() + "_foot_support_polygon", (RosTopicPublisher)rosSupportPolygonPublisher);
        }
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/capturability/capture_point", (RosTopicPublisher)this.capturePointPublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/capturability/desired_capture_point", (RosTopicPublisher)this.desiredCapturePointPublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/capturability/center_of_mass", (RosTopicPublisher)this.centerOfMassPublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/capturability/is_in_double_support", (RosTopicPublisher)this.isInDoubleSupportPublisher);
        new Thread((Runnable)this, this.getClass().getName()).start();
    }

    public void receivedPacket(CapturabilityBasedStatus packet) {
        if (!this.availableCapturabilityStatus.offer(packet)) {
            this.availableCapturabilityStatus.clear();
        }
    }

    @Override
    public void run() {
        while (true) {
            CapturabilityBasedStatus capturabilityBasedStatus;
            try {
                capturabilityBasedStatus = this.availableCapturabilityStatus.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (!this.rosMainNode.isStarted()) continue;
            this.capturePointPublisher.publish((Point2DBasics)new Point2D((Tuple3DReadOnly)capturabilityBasedStatus.getCapturePoint2d()));
            this.desiredCapturePointPublisher.publish((Point2DBasics)new Point2D((Tuple3DReadOnly)capturabilityBasedStatus.getDesiredCapturePoint2d()));
            this.centerOfMassPublisher.publish((Point3DBasics)capturabilityBasedStatus.getCenterOfMass3d());
            this.isInDoubleSupportPublisher.publish(HumanoidMessageTools.unpackIsInDoubleSupport((CapturabilityBasedStatus)capturabilityBasedStatus));
        }
    }
}

