/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.RobotConfigurationData;
import us.ihmc.avatar.ros.DRCROSPPSTimestampOffsetProvider;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.log.LogTools;
import us.ihmc.utilities.ros.RosNodeInterface;

public class RobotROSClockCalculatorFromPPSOffset
implements RobotROSClockCalculator {
    private final DRCROSPPSTimestampOffsetProvider ppsTimestampOffsetProvider;

    public RobotROSClockCalculatorFromPPSOffset(DRCROSPPSTimestampOffsetProvider ppsTimestampOffsetProvider) {
        LogTools.info((String)"Using PPS offset provider: {}", (Object)ppsTimestampOffsetProvider.getClass().getSimpleName());
        this.ppsTimestampOffsetProvider = ppsTimestampOffsetProvider;
    }

    @Override
    public void subscribeToROS1Topics(RosNodeInterface ros1Node) {
        this.ppsTimestampOffsetProvider.subscribeToROS1Topics(ros1Node);
    }

    @Override
    public void unsubscribeFromROS1Topics(RosNodeInterface ros1Node) {
        this.ppsTimestampOffsetProvider.unsubscribeFromROS1Topics(ros1Node);
    }

    @Override
    public void receivedRobotConfigurationData(RobotConfigurationData robotConfigurationData) {
        this.ppsTimestampOffsetProvider.receivedPacket((Packet)robotConfigurationData);
    }

    @Override
    public long computeROSTime(long wallTime, long monotonicTime) {
        return this.ppsTimestampOffsetProvider.adjustRobotTimeStampToRosClock(monotonicTime);
    }

    @Override
    public long computeRobotMonotonicTime(long rosTime) {
        return this.ppsTimestampOffsetProvider.adjustTimeStampToRobotClock(rosTime);
    }

    @Override
    public boolean offsetIsDetermined() {
        return this.ppsTimestampOffsetProvider.offsetIsDetermined();
    }

    @Override
    public long getCurrentTimestampOffset() {
        return this.ppsTimestampOffsetProvider.getCurrentTimestampOffset();
    }
}

