/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.HandDesiredConfigurationMessage;
import java.net.URI;
import java.net.URISyntaxException;
import org.ros.node.DefaultNodeMainExecutor;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeMain;
import org.ros.node.NodeMainExecutor;
import us.ihmc.avatar.ros.ROSiRobotCommunicator;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.humanoidRobotics.communication.subscribers.HandDesiredConfigurationMessageSubscriber;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.utilities.ros.RosTools;

public class ROSiRobotCommandDispatcher
implements Runnable {
    private final HandDesiredConfigurationMessageSubscriber handDesiredConfigurationMessageSubscriber = new HandDesiredConfigurationMessageSubscriber(null);
    private final ROSiRobotCommunicator rosHandCommunicator;

    public ROSiRobotCommandDispatcher(String robotName, RealtimeROS2Node realtimeROS2Node, String rosHostIP) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, HandDesiredConfigurationMessage.class, (ROS2Topic)ROS2Tools.getControllerInputTopic((String)robotName), (NewMessageListener)this.handDesiredConfigurationMessageSubscriber);
        String rosURI = "http://" + rosHostIP + ":11311";
        this.rosHandCommunicator = new ROSiRobotCommunicator(rosURI);
        try {
            NodeConfiguration nodeConfiguration = RosTools.createNodeConfiguration((URI)new URI(rosURI));
            NodeMainExecutor nodeMainExecutor = DefaultNodeMainExecutor.newDefault();
            nodeMainExecutor.execute((NodeMain)this.rosHandCommunicator, nodeConfiguration);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            if (!this.handDesiredConfigurationMessageSubscriber.isNewDesiredConfigurationAvailable()) {
                continue;
            }
            HandDesiredConfigurationMessage ihmcMessage = this.handDesiredConfigurationMessageSubscriber.pollMessage();
            this.rosHandCommunicator.sendHandCommand(ihmcMessage);
        }
    }
}

