/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.geometry.SpiralBasedAlgorithm;

public class SphereVoxelShape {
    private final Quaternion[][] rotations;
    private final Point3D[] pointsOnSphere;
    private final Point3D sphereOrigin = new Point3D();
    private final int numberOfRays;
    private final int numberOfRotationsAroundRay;
    private final SphereVoxelType type;
    private ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();

    public SphereVoxelShape(double voxelSize, int numberOfRays, int numberOfRotationsAroundRay, SphereVoxelType type) {
        this.type = type;
        this.numberOfRays = numberOfRays;
        this.numberOfRotationsAroundRay = numberOfRotationsAroundRay;
        this.pointsOnSphere = SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)this.sphereOrigin, (double)voxelSize, (int)numberOfRays);
        this.rotations = SpiralBasedAlgorithm.generateOrientations((int)numberOfRays, (int)numberOfRotationsAroundRay);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public int getNumberOfRays() {
        return this.numberOfRays;
    }

    public int getNumberOfRotationsAroundRay() {
        return this.numberOfRotationsAroundRay;
    }

    public void getRay(Vector3D rayToPack, int rayIndex) {
        MathTools.checkIntervalContains((long)rayIndex, (long)0L, (long)(this.numberOfRays - 1));
        rayToPack.sub((Tuple3DReadOnly)this.sphereOrigin, (Tuple3DReadOnly)this.pointsOnSphere[rayIndex]);
        rayToPack.normalize();
    }

    public void getOrientation(FrameQuaternion orientation, int rayIndex, int rotationAroundRayIndex) {
        MathTools.checkIntervalContains((long)rayIndex, (long)0L, (long)(this.numberOfRays - 1));
        MathTools.checkIntervalContains((long)rotationAroundRayIndex, (long)0L, (long)(this.numberOfRotationsAroundRay - 1));
        orientation.setIncludingFrame(this.referenceFrame, (QuaternionReadOnly)this.rotations[rayIndex][rotationAroundRayIndex]);
    }

    public void getPose(FramePose3DBasics pose, int rayIndex, int rotationAroundRayIndex) {
        MathTools.checkIntervalContains((long)rayIndex, (long)0L, (long)(this.numberOfRays - 1));
        MathTools.checkIntervalContains((long)rotationAroundRayIndex, (long)0L, (long)(this.numberOfRotationsAroundRay - 1));
        if (this.type == SphereVoxelType.graspAroundSphere) {
            pose.setIncludingFrame(this.referenceFrame, (Tuple3DReadOnly)this.pointsOnSphere[rayIndex], (Orientation3DReadOnly)this.rotations[rayIndex][rotationAroundRayIndex]);
        } else {
            pose.setToZero(this.referenceFrame);
            pose.getOrientation().set((QuaternionReadOnly)this.rotations[rayIndex][rotationAroundRayIndex]);
        }
    }

    public Point3D[] getPointsOnSphere() {
        return this.pointsOnSphere;
    }

    public static enum SphereVoxelType {
        graspOrigin,
        graspAroundSphere;

    }
}

