/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.footstep;

import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityData;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityLatticePoint;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.footstepPlanning.graphSearch.FootstepPlannerEnvironmentHandler;
import us.ihmc.footstepPlanning.graphSearch.footstepSnapping.FootstepSnapAndWiggler;
import us.ihmc.footstepPlanning.graphSearch.footstepSnapping.FootstepSnapData;
import us.ihmc.footstepPlanning.graphSearch.footstepSnapping.FootstepSnappingTools;
import us.ihmc.footstepPlanning.graphSearch.graph.DiscreteFootstep;
import us.ihmc.footstepPlanning.graphSearch.graph.visualization.BipedalFootstepPlannerNodeRejectionReason;
import us.ihmc.footstepPlanning.graphSearch.parameters.DefaultFootstepPlannerParameters;
import us.ihmc.footstepPlanning.graphSearch.parameters.FootstepPlannerParametersReadOnly;
import us.ihmc.footstepPlanning.graphSearch.stepChecking.FootstepPoseHeuristicChecker;
import us.ihmc.footstepPlanning.tools.PlannerTools;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.yoVariables.registry.YoRegistry;

public class StepReachabilityVisualizer {
    private static final Mode mode = Mode.CHECKER_COMPARISON;
    private final double reachabilityThreshold = 2.2;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SideDependentList<ConvexPolygon2D> footPolygons = PlannerTools.createDefaultFootPolygons();
    private final DefaultFootstepPlannerParameters parameters = new DefaultFootstepPlannerParameters();
    private final FootstepPlannerEnvironmentHandler environmentHandler = new FootstepPlannerEnvironmentHandler(this.footPolygons);
    private final FootstepSnapAndWiggler snapper = new FootstepSnapAndWiggler(this.footPolygons, (FootstepPlannerParametersReadOnly)this.parameters, this.environmentHandler);
    private final FootstepPoseHeuristicChecker checker = new FootstepPoseHeuristicChecker((FootstepPlannerParametersReadOnly)this.parameters, this.snapper, this.registry);
    private final StepReachabilityData stepReachabilityData;

    public StepReachabilityVisualizer(StepReachabilityData stepReachabilityData) {
        this.stepReachabilityData = stepReachabilityData;
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters(true, 16000);
        SimulationConstructionSet scs = new SimulationConstructionSet(parameters);
        Graphics3DObject coordinate = new Graphics3DObject();
        coordinate.addCoordinateSystem(0.5);
        scs.addStaticLinkGraphics(coordinate);
        scs.setGroundVisible(false);
        scs.setCameraFix(0.0, 0.0, 1.0);
        scs.setCameraPosition(8.0, 0.0, 3.0);
        scs.startOnAThread();
        for (StepReachabilityLatticePoint latticePoint : stepReachabilityData.getLegReachabilityMap().keySet()) {
            Graphics3DObject validStep = new Graphics3DObject();
            validStep.translate((double)latticePoint.getXIndex(), (double)latticePoint.getYIndex(), (double)latticePoint.getZIndex());
            validStep.rotate(Math.toRadians(90.0), (Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0));
            validStep.rotate((double)latticePoint.getYawIndex() * stepReachabilityData.getGridSizeYaw() / (double)stepReachabilityData.getYawDivisions(), (Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0));
            BipedalFootstepPlannerNodeRejectionReason rejectionReason = this.checkStepHeuristicValidity(latticePoint);
            switch (mode) {
                case REACHABILITY_GRADIENT: {
                    double reachabilityValue = (Double)stepReachabilityData.getLegReachabilityMap().get(latticePoint);
                    if (reachabilityValue > 40.0) {
                        reachabilityValue = 40.0;
                    }
                    AppearanceDefinition appearance = YoAppearance.RGBColor((double)(reachabilityValue / 40.0), (double)((40.0 - reachabilityValue) / 40.0), (double)0.0);
                    validStep.addArrow(0.4, appearance, appearance);
                    scs.addStaticLinkGraphics(validStep);
                    break;
                }
                case REACHABILITY_MAP: {
                    double reachabilityValue = (Double)stepReachabilityData.getLegReachabilityMap().get(latticePoint);
                    AppearanceDefinition appearance = reachabilityValue <= 2.2 ? YoAppearance.Green() : YoAppearance.Red();
                    validStep.addArrow(0.4, appearance, appearance);
                    scs.addStaticLinkGraphics(validStep);
                    break;
                }
                case HEURISTIC_REJECTION_REASON: {
                    AppearanceDefinition appearance;
                    if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_NOT_WIDE_ENOUGH) {
                        appearance = YoAppearance.Pink();
                    } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_TOO_FAR) {
                        appearance = YoAppearance.Blue();
                    } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_YAWS_TOO_MUCH) {
                        appearance = YoAppearance.Red();
                    } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_TOO_WIDE) {
                        appearance = YoAppearance.Purple();
                    } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_TOO_HIGH_OR_LOW) {
                        appearance = YoAppearance.YellowGreen();
                    } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_NOT_LONG_ENOUGH) {
                        appearance = YoAppearance.HotPink();
                    } else {
                        appearance = YoAppearance.White();
                        LogTools.info((Object)rejectionReason);
                    }
                    validStep.addArrow(0.4, appearance, appearance);
                    scs.addStaticLinkGraphics(validStep);
                    break;
                }
                case CHECKER_COMPARISON: {
                    AppearanceDefinition appearance = null;
                    boolean addArrow = false;
                    if ((Double)stepReachabilityData.getLegReachabilityMap().get(latticePoint) < 2.2) {
                        addArrow = true;
                        if (rejectionReason == null) {
                            appearance = YoAppearance.Green();
                        } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_NOT_WIDE_ENOUGH) {
                            appearance = YoAppearance.Pink();
                        } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_TOO_FAR) {
                            appearance = YoAppearance.Blue();
                        } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_YAWS_TOO_MUCH) {
                            appearance = YoAppearance.Red();
                        } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_TOO_WIDE) {
                            appearance = YoAppearance.Purple();
                        } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_TOO_HIGH_OR_LOW) {
                            appearance = YoAppearance.YellowGreen();
                        } else if (rejectionReason == BipedalFootstepPlannerNodeRejectionReason.STEP_NOT_LONG_ENOUGH) {
                            appearance = YoAppearance.White();
                        } else {
                            appearance = YoAppearance.HotPink();
                            LogTools.info((Object)rejectionReason);
                        }
                    } else if (rejectionReason == null) {
                        addArrow = true;
                        appearance = YoAppearance.Black();
                    }
                    if (!addArrow) break;
                    validStep.addArrow(0.4, appearance, appearance);
                    scs.addStaticLinkGraphics(validStep);
                    break;
                }
            }
        }
    }

    private BipedalFootstepPlannerNodeRejectionReason checkStepHeuristicValidity(StepReachabilityLatticePoint latticePoint) {
        double stepX = (double)latticePoint.getXIndex() * this.stepReachabilityData.getXyzSpacing();
        double stepY = (double)latticePoint.getYIndex() * this.stepReachabilityData.getXyzSpacing();
        double stepZ = (double)latticePoint.getZIndex() * this.stepReachabilityData.getXyzSpacing();
        double stepYaw = (double)latticePoint.getYawIndex() * (this.stepReachabilityData.getGridSizeYaw() / (double)this.stepReachabilityData.getYawDivisions());
        DiscreteFootstep candidateStep = new DiscreteFootstep(stepX, stepY, stepYaw, RobotSide.LEFT);
        DiscreteFootstep stanceStep = new DiscreteFootstep(0, 0, 0, RobotSide.RIGHT);
        FootstepSnapData candidateSnapData = new FootstepSnapData();
        Pose3D snappedCandidateStep = new Pose3D();
        snappedCandidateStep.getPosition().set(stepX, stepY, stepZ);
        snappedCandidateStep.getOrientation().setToYawOrientation(stepYaw);
        candidateSnapData.getSnapTransform().set(FootstepSnappingTools.computeSnapTransform((DiscreteFootstep)candidateStep, (Pose3DReadOnly)snappedCandidateStep));
        FootstepSnapData stanceSnapData = new FootstepSnapData();
        stanceSnapData.getSnapTransform().set(new RigidBodyTransform());
        this.snapper.addSnapData(candidateStep, candidateSnapData);
        BipedalFootstepPlannerNodeRejectionReason rejectionReason = this.checker.snapAndCheckValidity(candidateStep, stanceStep, null);
        return rejectionReason;
    }

    private static enum Mode {
        REACHABILITY_GRADIENT,
        REACHABILITY_MAP,
        HEURISTIC_REJECTION_REASON,
        CHECKER_COMPARISON;

    }
}

