/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.example;

import java.util.EnumMap;
import us.ihmc.avatar.reachabilityMap.example.RobotParameters;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;

public class RobotArmDefinition
extends RobotDefinition {
    private static final RobotParameters.RobotArmJointParameters[] allJointNames = RobotParameters.RobotArmJointParameters.values();
    private final EnumMap<RobotParameters.RobotArmJointParameters, RevoluteJointDefinition> robotArmRevoluteJoints = new EnumMap(RobotParameters.RobotArmJointParameters.class);
    private final EnumMap<RobotParameters.RobotArmLinkParameters, RigidBodyDefinition> robotArmRigidBodies = new EnumMap(RobotParameters.RobotArmLinkParameters.class);
    private final RigidBodyTransform transformFromControlFrameToEndEffectorBodyFixedFrame = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.08));

    public RobotArmDefinition() {
        super("RobotArm");
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            RevoluteJointDefinition revoluteJoint = new RevoluteJointDefinition(armJoint.getJointName(false), (Tuple3DReadOnly)armJoint.getJointOffset(), (Vector3DReadOnly)armJoint.getJointAxis());
            revoluteJoint.setPositionLimits(armJoint.getJointLowerLimit(), armJoint.getJointUpperLimit());
            this.robotArmRevoluteJoints.put(armJoint, revoluteJoint);
            RobotParameters.RobotArmLinkParameters armLink = armJoint.getAttachedLink();
            RigidBodyDefinition rigidBody = new RigidBodyDefinition(armLink.getLinkName());
            rigidBody.getVisualDefinitions().addAll(armLink.getRigidBodyVisuals());
            revoluteJoint.setSuccessor(rigidBody);
            this.robotArmRigidBodies.put(armLink, rigidBody);
        }
        RigidBodyDefinition rootBody = new RigidBodyDefinition("rootBody");
        this.setRootBodyDefinition(rootBody);
        RobotParameters.RobotArmJointParameters rootJoint = RobotParameters.RobotArmJointParameters.getRootJoint();
        rootBody.addChildJoint((JointDefinition)this.robotArmRevoluteJoints.get((Object)rootJoint));
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            if (armJoint.getChildJoint() == null) continue;
            this.robotArmRevoluteJoints.get((Object)armJoint).getSuccessor().addChildJoint((JointDefinition)this.robotArmRevoluteJoints.get((Object)armJoint.getChildJoint()));
        }
        RigidBodyDefinition endEffector = this.robotArmRigidBodies.get((Object)RobotParameters.RobotArmLinkParameters.getEndEffector());
        endEffector.getParentJoint().addKinematicPointDefinition(new KinematicPointDefinition("controlFrame", (RigidBodyTransformReadOnly)this.transformFromControlFrameToEndEffectorBodyFixedFrame));
    }
}

