/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes.SphereVoxelShape;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class Voxel3DGrid
implements ReferenceFrameHolder {
    public static final int MAX_GRID_SIZE_VOXELS = (int)Math.pow(2.147483647E9, 0.3333333333333333);
    private final BoundingBox3D boundingBox;
    private final SphereVoxelShape sphereVoxelShape;
    private final double voxelSize;
    private final double gridSizeMeters;
    private final int gridSizeVoxels;
    private final int numberOfVoxels;
    private final Voxel3DData[] voxels;
    private final PoseReferenceFrame referenceFrame;

    public static Voxel3DGrid newVoxel3DGrid(int gridSizeInNumberOfVoxels, double voxelSize, int numberOfRays, int numberOfRotationsAroundRay) {
        SphereVoxelShape sphereVoxelShape = new SphereVoxelShape(voxelSize, numberOfRays, numberOfRotationsAroundRay, SphereVoxelShape.SphereVoxelType.graspOrigin);
        return new Voxel3DGrid(sphereVoxelShape, gridSizeInNumberOfVoxels, voxelSize);
    }

    public Voxel3DGrid(SphereVoxelShape sphereVoxelShape, int gridSizeInNumberOfVoxels, double voxelSize) {
        if (gridSizeInNumberOfVoxels > MAX_GRID_SIZE_VOXELS) {
            throw new IllegalArgumentException("Grid size is too big: " + gridSizeInNumberOfVoxels + " [max=" + MAX_GRID_SIZE_VOXELS + "]");
        }
        this.sphereVoxelShape = sphereVoxelShape;
        this.voxelSize = voxelSize;
        this.gridSizeVoxels = gridSizeInNumberOfVoxels;
        this.numberOfVoxels = this.gridSizeVoxels * this.gridSizeVoxels * this.gridSizeVoxels;
        this.gridSizeMeters = voxelSize * (double)gridSizeInNumberOfVoxels;
        double halfSize = this.gridSizeMeters / 2.0;
        this.boundingBox = new BoundingBox3D(-halfSize, -halfSize, -halfSize, halfSize, halfSize, halfSize);
        this.voxels = new Voxel3DData[this.numberOfVoxels];
        this.referenceFrame = new PoseReferenceFrame("voxel3DGridFrame", ReferenceFrame.getWorldFrame());
        sphereVoxelShape.setReferenceFrame((ReferenceFrame)this.referenceFrame);
    }

    public Voxel3DData getVoxel(FrameTuple3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return this.getVoxel((Tuple3DReadOnly)query);
    }

    public Voxel3DData getVoxel(Tuple3DReadOnly query) {
        return this.getVoxel(query.getX(), query.getY(), query.getZ());
    }

    public Voxel3DData getVoxel(double x, double y, double z) {
        if (!this.boundingBox.isInsideInclusive(x, y, z)) {
            throw new IllegalArgumentException("The given point is outside the grid");
        }
        return this.getVoxel(this.toIndex(x), this.toIndex(y), this.toIndex(z));
    }

    public Voxel3DData getVoxel(int xIndex, int yIndex, int zIndex) {
        return this.voxels[Voxel3DKey.toArrayIndex(xIndex, yIndex, zIndex, this.gridSizeVoxels)];
    }

    public Voxel3DData getVoxel(int index) {
        return this.voxels[index];
    }

    public Voxel3DData getOrCreateVoxel(int index) {
        Voxel3DData voxel = this.voxels[index];
        if (voxel == null) {
            this.voxels[index] = voxel = new Voxel3DData(new Voxel3DKey(index, this.gridSizeVoxels));
        }
        return voxel;
    }

    public Voxel3DData getOrCreateVoxel(int xIndex, int yIndex, int zIndex) {
        int index = Voxel3DKey.toArrayIndex(xIndex, yIndex, zIndex, this.gridSizeVoxels);
        Voxel3DData voxel = this.voxels[index];
        if (voxel == null) {
            this.voxels[index] = voxel = new Voxel3DData(new Voxel3DKey(xIndex, yIndex, zIndex, this.gridSizeVoxels));
        }
        return voxel;
    }

    public void destroy(Voxel3DData voxel) {
        this.voxels[voxel.getKey().getIndex()] = null;
    }

    public FramePoint3DReadOnly getVoxelPosition(int index) {
        return new Voxel3DData(new Voxel3DKey(index, this.gridSizeVoxels)).getPosition();
    }

    private double toCoordinate(int index) {
        return ((double)index + 0.5) * this.voxelSize - 0.5 * this.gridSizeMeters;
    }

    private int toIndex(double coordinate) {
        return (int)(coordinate / this.voxelSize + (double)(this.gridSizeVoxels / 2) - 1.0);
    }

    public void setGridPose(RigidBodyTransformReadOnly pose) {
        this.referenceFrame.setPoseAndUpdate(pose);
    }

    public void setGridPose(Pose3DReadOnly pose) {
        this.referenceFrame.setPoseAndUpdate(pose);
    }

    public PoseReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public SphereVoxelShape getSphereVoxelShape() {
        return this.sphereVoxelShape;
    }

    public double getVoxelSize() {
        return this.voxelSize;
    }

    public double getGridSizeMeters() {
        return this.gridSizeMeters;
    }

    public int getGridSizeVoxels() {
        return this.gridSizeVoxels;
    }

    public int getNumberOfVoxels() {
        return this.numberOfVoxels;
    }

    public FramePoint3D getMinPoint() {
        return new FramePoint3D((ReferenceFrame)this.referenceFrame, (Tuple3DReadOnly)this.boundingBox.getMinPoint());
    }

    public FramePoint3D getMaxPoint() {
        return new FramePoint3D((ReferenceFrame)this.referenceFrame, (Tuple3DReadOnly)this.boundingBox.getMaxPoint());
    }

    public class Voxel3DData {
        private final Voxel3DKey key;
        private final FramePoint3DReadOnly position;
        private VoxelExtraData positionExtraData;
        private VoxelExtraData[] rayExtraData;
        private VoxelExtraData[] poseExtraData;

        public Voxel3DData(Voxel3DKey key) {
            this.key = key;
            this.position = new FramePoint3D((ReferenceFrame)Voxel3DGrid.this.getReferenceFrame(), Voxel3DGrid.this.toCoordinate(key.x), Voxel3DGrid.this.toCoordinate(key.y), Voxel3DGrid.this.toCoordinate(key.z));
        }

        public void registerReachablePosition(Point3DReadOnly desiredPosition, float[] jointPositions, float[] jointTorques) {
            if (!(jointPositions != null && jointPositions.length != 0 || jointTorques != null && jointTorques.length != 0)) {
                return;
            }
            this.positionExtraData = new VoxelExtraData();
            this.positionExtraData.setDesiredPosition(desiredPosition);
            this.positionExtraData.jointPositions = jointPositions;
            this.positionExtraData.jointTorques = jointTorques;
        }

        public void registerReachablePosition(Point3DReadOnly desiredPosition, OneDoFJointReadOnly[] joints) {
            this.positionExtraData = new VoxelExtraData();
            this.positionExtraData.setDesiredPosition(desiredPosition);
            this.positionExtraData.setJointPositions(joints);
            this.positionExtraData.setJointTorques(joints);
        }

        public void registerReachableRay(int rayIndex, Pose3DReadOnly desiredPose, float[] jointPositions, float[] jointTorques) {
            if (!(desiredPose != null || jointPositions != null && jointPositions.length != 0 || jointTorques != null && jointTorques.length != 0)) {
                return;
            }
            if (this.rayExtraData == null) {
                this.rayExtraData = new VoxelExtraData[this.getNumberOfRays()];
            }
            VoxelExtraData jointData = new VoxelExtraData();
            jointData.setDesiredPose(desiredPose);
            jointData.jointPositions = jointPositions;
            jointData.jointTorques = jointTorques;
            this.rayExtraData[rayIndex] = jointData;
        }

        public void registerReachableRay(int rayIndex, Pose3DReadOnly desiredPose, OneDoFJointReadOnly[] joints) {
            if (this.rayExtraData == null) {
                this.rayExtraData = new VoxelExtraData[this.getNumberOfRays()];
            }
            VoxelExtraData extraData = new VoxelExtraData();
            extraData.setDesiredPose(desiredPose);
            extraData.setJointPositions(joints);
            extraData.setJointTorques(joints);
            this.rayExtraData[rayIndex] = extraData;
        }

        public void registerReachablePose(int rayIndex, int rotationAroundRayIndex, Pose3DReadOnly desiredPose, float[] jointPositions, float[] jointTorques) {
            if (!(desiredPose != null || jointPositions != null && jointPositions.length != 0 || jointTorques != null && jointTorques.length != 0)) {
                return;
            }
            if (this.poseExtraData == null) {
                this.poseExtraData = new VoxelExtraData[this.getNumberOfRays() * this.getNumberOfRotationsAroundRay()];
            }
            VoxelExtraData extraData = new VoxelExtraData();
            extraData.setDesiredPose(desiredPose);
            extraData.jointPositions = jointPositions;
            extraData.jointTorques = jointTorques;
            this.poseExtraData[rayIndex * this.getNumberOfRotationsAroundRay() + rotationAroundRayIndex] = extraData;
        }

        public void registerReachablePose(int rayIndex, int rotationAroundRayIndex, Pose3DReadOnly desiredPose, OneDoFJointReadOnly[] joints) {
            if (this.poseExtraData == null) {
                this.poseExtraData = new VoxelExtraData[this.getNumberOfRays() * this.getNumberOfRotationsAroundRay()];
            }
            VoxelExtraData extraData = new VoxelExtraData();
            extraData.setDesiredPose(desiredPose);
            extraData.setJointPositions(joints);
            extraData.setJointTorques(joints);
            this.poseExtraData[rayIndex * this.getNumberOfRotationsAroundRay() + rotationAroundRayIndex] = extraData;
        }

        public double getR() {
            return (double)this.getNumberOfReachableRays() / (double)this.getNumberOfRays();
        }

        public int getNumberOfReachableRays() {
            if (this.rayExtraData == null) {
                return 0;
            }
            int n = 0;
            int numberOfRays = this.getNumberOfRays();
            for (int rayIndex = 0; rayIndex < numberOfRays; ++rayIndex) {
                if (!this.isRayReachable(rayIndex)) continue;
                ++n;
            }
            return n;
        }

        public double getR2() {
            return (double)this.getNumberOfReachablePoses() / (double)this.getNumberOfRays() / (double)this.getNumberOfRotationsAroundRay();
        }

        public int getNumberOfReachablePoses() {
            if (this.poseExtraData == null) {
                return 0;
            }
            int n = 0;
            for (int rayIndex = 0; rayIndex < this.getNumberOfRays(); ++rayIndex) {
                n += this.getNumberOfReachableRotationsAroundRay(rayIndex);
            }
            return n;
        }

        public int getNumberOfReachableRotationsAroundRay(int rayIndex) {
            if (this.poseExtraData == null) {
                return 0;
            }
            int n = 0;
            for (int rotationIndex = 0; rotationIndex < this.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                if (!this.isPoseReachable(rayIndex, rotationIndex)) continue;
                ++n;
            }
            return n;
        }

        public double computeD06() {
            int nCommOrientations = 0;
            for (int rayIndex = 0; rayIndex < this.getNumberOfRays(); ++rayIndex) {
                for (int rotationIndex = 0; rotationIndex < this.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                    nCommOrientations += this.compute6NeighborCommonOrientation(rayIndex, rotationIndex);
                }
            }
            return (double)nCommOrientations / (6.0 * (double)this.getNumberOfReachablePoses());
        }

        public double computeD018() {
            int nCommOrientations = 0;
            for (int rayIndex = 0; rayIndex < this.getNumberOfRays(); ++rayIndex) {
                for (int rotationIndex = 0; rotationIndex < this.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                    nCommOrientations += this.compute18NeighborCommonOrientation(rayIndex, rotationIndex);
                }
            }
            return (double)nCommOrientations / (18.0 * (double)this.getNumberOfReachablePoses());
        }

        public double computeD026() {
            int nCommOrientations = 0;
            for (int rayIndex = 0; rayIndex < this.getNumberOfRays(); ++rayIndex) {
                for (int rotationIndex = 0; rotationIndex < this.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                    nCommOrientations += this.compute26NeighborCommonOrientation(rayIndex, rotationIndex);
                }
            }
            return (double)nCommOrientations / (26.0 * (double)this.getNumberOfReachablePoses());
        }

        public int compute6NeighborCommonOrientation(int rayIndex, int rotationIndex) {
            int n = 0;
            n += this.isNeightPoseReachable(1, 0, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(-1, 0, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(0, 1, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(0, -1, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(0, 0, 1, rayIndex, rotationIndex) ? 1 : 0;
            return n += this.isNeightPoseReachable(0, 0, -1, rayIndex, rotationIndex) ? 1 : 0;
        }

        public int compute18NeighborCommonOrientation(int rayIndex, int rotationIndex) {
            int n = this.compute6NeighborCommonOrientation(rayIndex, rotationIndex);
            n += this.isNeightPoseReachable(1, 1, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(1, -1, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(-1, 1, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(-1, -1, 0, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(0, 1, 1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(0, 1, -1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(0, -1, 1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(0, -1, -1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(1, 0, 1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(-1, 0, 1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(1, 0, -1, rayIndex, rotationIndex) ? 1 : 0;
            return n += this.isNeightPoseReachable(-1, 0, -1, rayIndex, rotationIndex) ? 1 : 0;
        }

        public int compute26NeighborCommonOrientation(int rayIndex, int rotationIndex) {
            int n = this.compute18NeighborCommonOrientation(rayIndex, rotationIndex);
            n += this.isNeightPoseReachable(1, 1, 1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(1, 1, -1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(1, -1, 1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(1, -1, -1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(-1, 1, 1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(-1, 1, -1, rayIndex, rotationIndex) ? 1 : 0;
            n += this.isNeightPoseReachable(-1, -1, 1, rayIndex, rotationIndex) ? 1 : 0;
            return n += this.isNeightPoseReachable(-1, -1, -1, rayIndex, rotationIndex) ? 1 : 0;
        }

        public boolean isNeightPoseReachable(int xShift, int yShift, int zShift, int rayIndex, int rotationIndex) {
            Voxel3DData neighbor = this.getNeighbor(1, 0, 0);
            return neighbor != null && neighbor.isPoseReachable(rayIndex, rotationIndex);
        }

        public Voxel3DData getNeighbor(int xShift, int yShift, int zShift) {
            return Voxel3DGrid.this.getVoxel(this.key.getX() + xShift, this.key.getY() + yShift, this.key.getZ() + zShift);
        }

        public double getSize() {
            return Voxel3DGrid.this.voxelSize;
        }

        public Voxel3DKey getKey() {
            return this.key;
        }

        public FramePoint3DReadOnly getPosition() {
            return this.position;
        }

        public SphereVoxelShape getSphereVoxelShape() {
            return Voxel3DGrid.this.sphereVoxelShape;
        }

        public int getNumberOfRays() {
            return Voxel3DGrid.this.sphereVoxelShape.getNumberOfRays();
        }

        public int getNumberOfRotationsAroundRay() {
            return Voxel3DGrid.this.sphereVoxelShape.getNumberOfRotationsAroundRay();
        }

        public boolean atLeastOneReachableRay() {
            if (this.rayExtraData == null) {
                return false;
            }
            for (VoxelExtraData jointData : this.rayExtraData) {
                if (jointData == null) continue;
                return true;
            }
            return false;
        }

        public boolean isRayReachable(int rayIndex) {
            return this.rayExtraData == null ? false : this.rayExtraData[rayIndex] != null;
        }

        public boolean atLeastOneReachablePose() {
            if (this.poseExtraData == null) {
                return false;
            }
            for (VoxelExtraData jointData : this.poseExtraData) {
                if (jointData == null) continue;
                return true;
            }
            return false;
        }

        public boolean isPoseReachable(int rayIndex, int rotationIndex) {
            return this.getPoseExtraData(rayIndex, rotationIndex) != null;
        }

        public VoxelExtraData getPositionExtraData() {
            return this.positionExtraData;
        }

        public VoxelExtraData getRayExtraData(int rayIndex) {
            if (this.rayExtraData == null) {
                return null;
            }
            return this.rayExtraData[rayIndex];
        }

        public VoxelExtraData getPoseExtraData(int rayIndex, int rotationIndex) {
            if (this.poseExtraData == null) {
                return null;
            }
            return this.poseExtraData[rayIndex * this.getNumberOfRotationsAroundRay() + rotationIndex];
        }
    }

    public static class Voxel3DKey {
        private int x;
        private int y;
        private int z;
        private int index;

        public Voxel3DKey(int x, int y, int z, int gridSizeVoxels) {
            if (x >= gridSizeVoxels) {
                throw new ArrayIndexOutOfBoundsException(x);
            }
            if (y >= gridSizeVoxels) {
                throw new ArrayIndexOutOfBoundsException(y);
            }
            if (z >= gridSizeVoxels) {
                throw new ArrayIndexOutOfBoundsException(z);
            }
            this.x = x;
            this.y = y;
            this.z = z;
            this.index = Voxel3DKey.toArrayIndex(x, y, z, gridSizeVoxels);
        }

        public Voxel3DKey(int index, int gridSizeVoxels) {
            this.index = index;
            this.x = Voxel3DKey.toXindex(index, gridSizeVoxels);
            this.y = Voxel3DKey.toYindex(index, gridSizeVoxels);
            this.z = Voxel3DKey.toZindex(index, gridSizeVoxels);
            if (this.x >= gridSizeVoxels) {
                throw new ArrayIndexOutOfBoundsException(this.x);
            }
            if (this.y >= gridSizeVoxels) {
                throw new ArrayIndexOutOfBoundsException(this.y);
            }
            if (this.z >= gridSizeVoxels) {
                throw new ArrayIndexOutOfBoundsException(this.z);
            }
        }

        public static int toArrayIndex(int x, int y, int z, int gridSizeVoxels) {
            return (x * gridSizeVoxels + y) * gridSizeVoxels + z;
        }

        public static int toXindex(int arrayIndex, int gridSizeVoxels) {
            return arrayIndex / gridSizeVoxels / gridSizeVoxels;
        }

        public static int toYindex(int arrayIndex, int gridSizeVoxels) {
            return arrayIndex / gridSizeVoxels % gridSizeVoxels;
        }

        public static int toZindex(int arrayIndex, int gridSizeVoxels) {
            return arrayIndex % gridSizeVoxels;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object object) {
            if (object instanceof Voxel3DKey) {
                Voxel3DKey other = (Voxel3DKey)object;
                return this.x == other.x && this.y == other.y && this.z == other.z;
            }
            return false;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return EuclidCoreIOTools.getStringOf((String)"(", (String)")", (String)", ", (int[])new int[]{this.x, this.y, this.z});
        }
    }

    public static class VoxelExtraData {
        private Point3D desiredPosition;
        private Quaternion desiredOrientation;
        private float[] jointPositions;
        private float[] jointTorques;

        public void setDesiredPosition(Point3DReadOnly desiredPosition) {
            this.desiredPosition = new Point3D((Tuple3DReadOnly)desiredPosition);
            this.desiredOrientation = null;
        }

        public void setDesiredPose(Pose3DReadOnly desiredPose) {
            this.desiredPosition = new Point3D((Tuple3DReadOnly)desiredPose.getPosition());
            this.desiredOrientation = new Quaternion(desiredPose.getOrientation());
        }

        public void setJointPositions(OneDoFJointReadOnly[] joints) {
            if (this.jointPositions == null) {
                this.jointPositions = new float[joints.length];
            }
            for (int i = 0; i < joints.length; ++i) {
                this.jointPositions[i] = (float)joints[i].getQ();
            }
        }

        public void setJointTorques(OneDoFJointReadOnly[] joints) {
            if (this.jointTorques == null) {
                this.jointTorques = new float[joints.length];
            }
            for (int i = 0; i < joints.length; ++i) {
                this.jointTorques[i] = (float)joints[i].getTau();
            }
        }

        public Point3D getDesiredPosition() {
            return this.desiredPosition;
        }

        public Quaternion getDesiredOrientation() {
            return this.desiredOrientation;
        }

        public float[] getJointPositions() {
            return this.jointPositions;
        }

        public float[] getJointTorques() {
            return this.jointTorques;
        }
    }
}

