/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapRobotInformation;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapSolver;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes.SphereVoxelShape;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.conversion.YoGraphicConversionTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinitionFactory;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class ReachabilitySphereMapCalculator
implements Controller {
    private static final boolean VISUALIZE_ALL_SOLVERS = false;
    private final ControllerOutput controllerOutput;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private Voxel3DGrid voxel3DGrid;
    private Consumer<Voxel3DGrid.Voxel3DData> voxelUnreachableListener = null;
    private Consumer<Voxel3DGrid.Voxel3DData> voxelCompletedListener = null;
    private final FramePose3D[] solverInputs;
    private final FrameVector3D[] translationFromVoxelOrigin;
    private final ReachabilityMapSolver[] solvers;
    private final boolean[] solverResults;
    private final Voxel3DGrid.Voxel3DData[] solverVoxels;
    private final YoFramePose3D gridFramePose = new YoFramePose3D("gridFramePose", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePose3D evaluatedPose = new YoFramePose3D("evaluatedPose", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoBoolean isDone = new YoBoolean("isDone", this.registry);
    private final YoBoolean evaluateRReachability = new YoBoolean("evaluateRReachability", this.registry);
    private final YoBoolean evaluateR2Reachability = new YoBoolean("evaluateR2Reachability", this.registry);
    private final List<YoGraphicGroupDefinition> solverYoGraphicGroupDefinitions = new ArrayList<YoGraphicGroupDefinition>();
    private final YoInteger currentVoxelIndex = new YoInteger("currentVoxelIndex", this.registry);

    public ReachabilitySphereMapCalculator(ReachabilityMapRobotInformation robotInformation, ControllerOutput controllerOutput, int numberOfThreads) {
        this.controllerOutput = controllerOutput;
        this.solvers = new ReachabilityMapSolver[numberOfThreads];
        this.solverResults = new boolean[numberOfThreads];
        this.solverVoxels = new Voxel3DGrid.Voxel3DData[numberOfThreads];
        this.solverInputs = new FramePose3D[numberOfThreads];
        this.translationFromVoxelOrigin = new FrameVector3D[numberOfThreads];
        RobotDefinition robotDefinition = robotInformation.getRobotDefinition();
        ReferenceFrame robotRootFrame = Robot.createRobotRootFrame((RobotDefinition)robotDefinition, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        RigidBodyBasics rootBody = robotDefinition.newInstance(robotRootFrame);
        RigidBodyBasics base = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)robotInformation.getBaseName());
        RigidBodyBasics endEffector = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)robotInformation.getEndEffectorName());
        OneDoFJointBasics[] armJoints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)base, (RigidBodyBasics)endEffector);
        OneDoFJointBasics firstJoint = armJoints[0];
        for (int i = 0; i < numberOfThreads; ++i) {
            Object cloneSuffix;
            OneDoFJointBasics[] solverJoints;
            YoRegistry solverRegistry = new YoRegistry("solverRegistry" + i);
            this.registry.addChild(solverRegistry);
            if (i == 0) {
                solverJoints = armJoints;
                cloneSuffix = "";
            } else {
                RigidBodyBasics originalRootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)firstJoint.getPredecessor());
                cloneSuffix = "-solver" + i;
                RigidBodyBasics solverRootBody = MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)originalRootBody, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (String)cloneSuffix);
                solverJoints = (OneDoFJointBasics[])Arrays.stream(armJoints).map(arg_0 -> ReachabilitySphereMapCalculator.lambda$new$0(solverRootBody, (String)cloneSuffix, arg_0)).toArray(OneDoFJointBasics[]::new);
            }
            YoGraphicsListRegistry solverGraphicsRegistry = new YoGraphicsListRegistry();
            this.solvers[i] = new ReachabilityMapSolver((String)cloneSuffix, solverJoints, solverGraphicsRegistry, solverRegistry);
            if (i == 0) {
                YoGraphicGroupDefinition solverYoGraphicGroup = new YoGraphicGroupDefinition("solver" + i);
                solverYoGraphicGroup.setChildren(YoGraphicConversionTools.toYoGraphicDefinitions((YoGraphicsListRegistry)solverGraphicsRegistry));
                this.solverYoGraphicGroupDefinitions.add(solverYoGraphicGroup);
            }
            this.solverInputs[i] = new FramePose3D();
            this.translationFromVoxelOrigin[i] = new FrameVector3D();
        }
        for (ReachabilityMapSolver solver : this.solvers) {
            solver.setControlFramePoseInParentJoint(robotInformation.getControlFramePoseInParentJoint());
            solver.setRayAxis(robotInformation.getOrthogonalToPalm());
        }
        this.gridFramePose.attachVariableChangedListener(v -> {
            if (this.voxel3DGrid != null) {
                this.voxel3DGrid.setGridPose((Pose3DReadOnly)this.gridFramePose);
            }
        });
        FramePose3D gridFramePose = new FramePose3D(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)firstJoint.getFrameBeforeJoint().getTransformToRoot());
        this.setGridFramePose((FramePose3DReadOnly)gridFramePose);
    }

    public void setRobotCollisionModel(RobotDefinition robotDefinition) {
        for (ReachabilityMapSolver solver : this.solvers) {
            solver.setCollisionModel(robotDefinition);
        }
    }

    public void setVoxel3DGrid(Voxel3DGrid voxel3DGrid) {
        this.voxel3DGrid = voxel3DGrid;
        voxel3DGrid.setGridPose((Pose3DReadOnly)this.gridFramePose);
    }

    public void setEvaluateRReachability(boolean enable) {
        this.evaluateRReachability.set(enable);
    }

    public void setEvaluateR2Reachability(boolean enable) {
        this.evaluateR2Reachability.set(enable);
    }

    public void setVoxelUnreachableListener(Consumer<Voxel3DGrid.Voxel3DData> voxelUnreachableListener) {
        this.voxelUnreachableListener = voxelUnreachableListener;
    }

    public void setVoxelCompletedListener(Consumer<Voxel3DGrid.Voxel3DData> voxelCompletedListener) {
        this.voxelCompletedListener = voxelCompletedListener;
    }

    public YoGraphicDefinition getYoGraphicVisuals() {
        YoGraphicGroupDefinition group = new YoGraphicGroupDefinition("ReachabilityCalculatorVisuals");
        ArrayList<Object> yoGraphics = new ArrayList<Object>();
        yoGraphics.add(YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D((String)"gridFramePose", (YoFramePose3D)this.gridFramePose, (double)0.5, (PaintDefinition)ColorDefinitions.Blue()));
        yoGraphics.add(YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D((String)"evaluatedPose", (YoFramePose3D)this.evaluatedPose, (double)0.15, (PaintDefinition)ColorDefinitions.HotPink()));
        yoGraphics.add(YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D((String)"controlFrame", (FramePose3DReadOnly)this.solvers[0].getControlFramePoseInEndEffector(), (double)0.05, (PaintDefinition)ColorDefinitions.parse((String)"#A1887F")));
        yoGraphics.addAll(this.solverYoGraphicGroupDefinitions);
        group.setChildren(yoGraphics);
        return group;
    }

    public OneDoFJointBasics[] getRobotArmJoints() {
        return this.solvers[0].getRobotArmJoints();
    }

    public FramePose3DReadOnly getControlFramePose() {
        return this.solvers[0].getControlFramePoseInEndEffector();
    }

    public void enableJointTorqueAnalysis(boolean considerJointTorqueLimits) {
        for (ReachabilityMapSolver solver : this.solvers) {
            solver.enableJointTorqueAnalysis(considerJointTorqueLimits);
        }
    }

    public void setGridFramePose(FramePose3DReadOnly pose) {
        this.gridFramePose.setMatchingFrame(pose);
    }

    public void doControl() {
        if (this.isDone.getValue()) {
            return;
        }
        Arrays.fill(this.solverResults, false);
        IntStream.range(0, this.solvers.length).parallel().forEach(solverIndex -> {
            boolean success;
            Voxel3DGrid.Voxel3DData voxel;
            int voxelIndex = this.currentVoxelIndex.getValue() + solverIndex;
            if (voxelIndex >= this.voxel3DGrid.getNumberOfVoxels()) {
                this.solverVoxels[solverIndex] = null;
                return;
            }
            this.solverVoxels[solverIndex] = voxel = this.voxel3DGrid.getOrCreateVoxel(voxelIndex);
            if (solverIndex == 0) {
                this.evaluatedPose.getPosition().setMatchingFrame((FrameTuple3DReadOnly)voxel.getPosition());
                this.evaluatedPose.getOrientation().setToZero();
            }
            FramePose3D solverInput = this.solverInputs[solverIndex];
            solverInput.setReferenceFrame(ReferenceFrame.getWorldFrame());
            solverInput.getPosition().setMatchingFrame((FrameTuple3DReadOnly)voxel.getPosition());
            this.solverResults[solverIndex] = success = this.solvers[solverIndex].solveFor((FramePoint3DReadOnly)solverInput.getPosition());
            if (success) {
                voxel.registerReachablePosition((Point3DReadOnly)solverInput.getPosition(), (OneDoFJointReadOnly[])this.solvers[solverIndex].getRobotArmJoints());
                if (solverIndex == 0) {
                    ReachabilitySphereMapCalculator.writeSolverSolution(this.solvers[solverIndex], this.controllerOutput);
                }
                this.computeVoxel(voxel, solverIndex);
            }
        });
        for (int solverIndex2 = 0; solverIndex2 < this.solverResults.length; ++solverIndex2) {
            boolean solverResult = this.solverResults[solverIndex2];
            if (solverResult) {
                if (this.voxelCompletedListener != null) {
                    this.voxelCompletedListener.accept(this.solverVoxels[solverIndex2]);
                }
            } else if (this.solverVoxels[solverIndex2] != null) {
                if (this.voxelUnreachableListener != null) {
                    this.voxelUnreachableListener.accept(this.solverVoxels[solverIndex2]);
                }
                this.voxel3DGrid.destroy(this.solverVoxels[solverIndex2]);
            }
            this.solverVoxels[solverIndex2] = null;
        }
        this.currentVoxelIndex.add(this.solvers.length);
        if (this.currentVoxelIndex.getValue() >= this.voxel3DGrid.getNumberOfVoxels()) {
            this.isDone.set(true);
        }
    }

    private void computeVoxel(Voxel3DGrid.Voxel3DData voxel, int solverIndex) {
        FramePose3D solverInput = this.solverInputs[solverIndex];
        ReachabilityMapSolver solver = this.solvers[solverIndex];
        SphereVoxelShape sphereVoxelShape = this.voxel3DGrid.getSphereVoxelShape();
        for (int rayIndex = 0; rayIndex < sphereVoxelShape.getNumberOfRays(); ++rayIndex) {
            if (this.evaluateRReachability.getValue()) {
                sphereVoxelShape.getPose((FramePose3DBasics)solverInput, rayIndex, 0);
                solverInput.getPosition().add((FrameTuple3DReadOnly)voxel.getPosition());
                solverInput.changeFrame(ReferenceFrame.getWorldFrame());
                if (!solver.solveForRay((FramePose3DReadOnly)solverInput)) continue;
                voxel.registerReachableRay(rayIndex, (Pose3DReadOnly)solverInput, (OneDoFJointReadOnly[])solver.getRobotArmJoints());
                if (solverIndex == 0) {
                    ReachabilitySphereMapCalculator.writeSolverSolution(solver, this.controllerOutput);
                }
            }
            if (!this.evaluateR2Reachability.getValue()) continue;
            for (int rotationAroundRayIndex = 0; rotationAroundRayIndex < sphereVoxelShape.getNumberOfRotationsAroundRay(); ++rotationAroundRayIndex) {
                sphereVoxelShape.getPose((FramePose3DBasics)solverInput, rayIndex, rotationAroundRayIndex);
                solverInput.getPosition().add((FrameTuple3DReadOnly)voxel.getPosition());
                solverInput.changeFrame(ReferenceFrame.getWorldFrame());
                if (solverIndex == 0) {
                    this.evaluatedPose.set((FramePose3DReadOnly)solverInput);
                }
                if (!solver.solveForPose((FramePose3DReadOnly)solverInput)) continue;
                voxel.registerReachablePose(rayIndex, rotationAroundRayIndex, (Pose3DReadOnly)solverInput, (OneDoFJointReadOnly[])solver.getRobotArmJoints());
                if (solverIndex != 0) continue;
                ReachabilitySphereMapCalculator.writeSolverSolution(solver, this.controllerOutput);
            }
        }
    }

    public static void writeSolverSolution(ReachabilityMapSolver solver, ControllerOutput controllerOutput) {
        for (OneDoFJointBasics joint : solver.getRobotArmJoints()) {
            controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)joint).setConfiguration((JointReadOnly)joint);
            controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)joint).setEffort((JointReadOnly)joint);
        }
    }

    public void buildReachabilitySpace() {
        while (!this.isDone()) {
            this.doControl();
        }
    }

    public double getGridSizeInMeters() {
        return this.voxel3DGrid.getGridSizeMeters();
    }

    public boolean isDone() {
        return this.isDone.getValue();
    }

    public Voxel3DGrid getVoxel3DGrid() {
        return this.voxel3DGrid;
    }

    public YoFramePose3D getGridFramePose() {
        return this.gridFramePose;
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    private static /* synthetic */ JointBasics lambda$new$0(RigidBodyBasics solverRootBody, String cloneSuffix, OneDoFJointBasics originalJoint) {
        return MultiBodySystemTools.findJoint((RigidBodyBasics)solverRootBody, (String)(originalJoint.getName() + cloneSuffix));
    }
}

