/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapFileReader;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapRobotInformation;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapSpreadsheetExporter;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;

public class ReachabilityMapSpreadsheetImporter
implements ReachabilityMapFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Voxel3DGrid read(File fileToLoad, ReachabilityMapRobotInformation robotInformation) {
        HSSFWorkbook workbook;
        NPOIFSFileSystem fileSystem;
        try {
            fileSystem = new NPOIFSFileSystem(fileToLoad);
            workbook = new HSSFWorkbook(fileSystem.getRoot(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            HSSFSheet descriptionSheet = workbook.getSheet("Description");
            ReachabilityMapSpreadsheetImporter.checkRobotMatchesData(robotInformation, descriptionSheet);
            ReachabilityMapSpreadsheetImporter.loadControlFramePose(robotInformation, descriptionSheet);
            Voxel3DGrid reachabilityMap = ReachabilityMapSpreadsheetImporter.createGrid(descriptionSheet);
            ReachabilityMapSpreadsheetImporter.loadReachabilityMapData(robotInformation.getEvaluatedJoints().size(), reachabilityMap, workbook);
            Voxel3DGrid voxel3DGrid = reachabilityMap;
            return voxel3DGrid;
        }
        catch (Exception e) {
            e.printStackTrace();
            Voxel3DGrid voxel3DGrid = null;
            return voxel3DGrid;
        }
        finally {
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadControlFramePose(ReachabilityMapRobotInformation robotInformation, HSSFSheet descriptionSheet) {
        HSSFRow row = descriptionSheet.getRow(14);
        int cellIndex = 1;
        double x = row.getCell(cellIndex++).getNumericCellValue();
        double y = row.getCell(cellIndex++).getNumericCellValue();
        double z = row.getCell(cellIndex++).getNumericCellValue();
        double yaw = row.getCell(cellIndex++).getNumericCellValue();
        double pitch = row.getCell(cellIndex++).getNumericCellValue();
        double roll = row.getCell(cellIndex++).getNumericCellValue();
        robotInformation.setControlFramePoseInParentJoint((Pose3DReadOnly)new Pose3D(x, y, z, yaw, pitch, roll));
    }

    private static void checkRobotMatchesData(ReachabilityMapRobotInformation robotInformation, HSSFSheet descriptionSheet) {
        String robotNameInWorkbook = descriptionSheet.getRow(0).getCell(1).getStringCellValue();
        if (!robotInformation.getRobotDefinition().getName().equals(robotNameInWorkbook)) {
            throw new RuntimeException("Trying to load the data for another robot: Loading data for " + robotInformation.getRobotDefinition().getName() + ", workbook contains data for " + robotNameInWorkbook);
        }
        ArrayList<String> jointNames = new ArrayList<String>();
        int currentIndexValue = 1;
        HSSFRow currentRow = descriptionSheet.getRow(8);
        HSSFCell currentCell = currentRow.getCell(currentIndexValue);
        while (currentCell != null) {
            jointNames.add(currentCell.getStringCellValue());
            currentCell = currentRow.getCell(++currentIndexValue);
        }
        boolean jointsMatch = true;
        List<OneDoFJointDefinition> evaluatedJoints = robotInformation.getEvaluatedJoints();
        if (jointNames.size() != evaluatedJoints.size()) {
            jointsMatch = false;
        } else {
            for (int i = 0; i < evaluatedJoints.size(); ++i) {
                if (((String)jointNames.get(i)).equals(evaluatedJoints.get(i).getName())) continue;
                jointsMatch = false;
                break;
            }
        }
        if (!jointsMatch) {
            throw new RuntimeException("Could not find all the joints, expected:\n " + jointNames + "\nwas:\n[" + EuclidCoreIOTools.getCollectionString((String)", ", evaluatedJoints, j -> j.getName()) + "]");
        }
    }

    private static Voxel3DGrid createGrid(HSSFSheet descriptionSheet) {
        HSSFRow poseRow = descriptionSheet.getRow(7);
        int poseCellIndex = 1;
        double x = poseRow.getCell(poseCellIndex++).getNumericCellValue();
        double y = poseRow.getCell(poseCellIndex++).getNumericCellValue();
        double z = poseRow.getCell(poseCellIndex++).getNumericCellValue();
        double yaw = poseRow.getCell(poseCellIndex++).getNumericCellValue();
        double pitch = poseRow.getCell(poseCellIndex++).getNumericCellValue();
        double roll = poseRow.getCell(poseCellIndex++).getNumericCellValue();
        int numberOfVoxelsPerDimension = (int)descriptionSheet.getRow(2).getCell(1).getNumericCellValue();
        double voxelSize = descriptionSheet.getRow(3).getCell(2).getNumericCellValue();
        int numberOfRaysPerVoxel = (int)descriptionSheet.getRow(4).getCell(2).getNumericCellValue();
        int numberOfRotationsPerRay = (int)descriptionSheet.getRow(5).getCell(2).getNumericCellValue();
        Voxel3DGrid grid = Voxel3DGrid.newVoxel3DGrid(numberOfVoxelsPerDimension, voxelSize, numberOfRaysPerVoxel, numberOfRotationsPerRay);
        grid.setGridPose((Pose3DReadOnly)new Pose3D(x, y, z, yaw, pitch, roll));
        return grid;
    }

    private static void loadReachabilityMapData(int numberOfJoints, Voxel3DGrid reachabilityMap, HSSFWorkbook workbook) {
        ReachabilityMapSpreadsheetImporter.loadPositionData(numberOfJoints, reachabilityMap, workbook);
        ReachabilityMapSpreadsheetImporter.loadRayData(numberOfJoints, reachabilityMap, workbook);
        ReachabilityMapSpreadsheetImporter.loadPoseData(numberOfJoints, reachabilityMap, workbook);
    }

    private static void loadPositionData(int numberOfJoints, Voxel3DGrid reachabilityMap, HSSFWorkbook workbook) {
        int currentDataSheetNameIndex = 1;
        HSSFSheet currentDataSheet = workbook.getSheet(ReachabilityMapSpreadsheetExporter.getPositionDataSheetName(currentDataSheetNameIndex++));
        while (currentDataSheet != null) {
            int currentRowIndex = 1;
            HSSFRow currentRow = currentDataSheet.getRow(currentRowIndex++);
            int cellIndex = 0;
            while (currentRow != null) {
                cellIndex = 0;
                int xIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int yIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int zIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                Point3D desiredPosition = new Point3D();
                desiredPosition.setX(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredPosition.setY(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredPosition.setZ(currentRow.getCell(cellIndex++).getNumericCellValue());
                float[] jointPositions = new float[numberOfJoints];
                for (int i = 0; i < numberOfJoints; ++i) {
                    jointPositions[i] = (float)currentRow.getCell(cellIndex++).getNumericCellValue();
                }
                float[] jointTorques = new float[numberOfJoints];
                for (int i = 0; i < numberOfJoints; ++i) {
                    jointTorques[i] = (float)currentRow.getCell(cellIndex++).getNumericCellValue();
                }
                Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getOrCreateVoxel(xIndex, yIndex, zIndex);
                voxel.registerReachablePosition((Point3DReadOnly)desiredPosition, jointPositions, jointTorques);
                currentRow = currentDataSheet.getRow(currentRowIndex++);
            }
            currentDataSheet = workbook.getSheet(ReachabilityMapSpreadsheetExporter.getPositionDataSheetName(currentDataSheetNameIndex++));
        }
    }

    private static void loadRayData(int numberOfJoints, Voxel3DGrid reachabilityMap, HSSFWorkbook workbook) {
        int currentDataSheetNameIndex = 1;
        HSSFSheet currentDataSheet = workbook.getSheet(ReachabilityMapSpreadsheetExporter.getRayDataSheetName(currentDataSheetNameIndex++));
        while (currentDataSheet != null) {
            int currentRowIndex = 1;
            HSSFRow currentRow = currentDataSheet.getRow(currentRowIndex++);
            int cellIndex = 0;
            while (currentRow != null) {
                cellIndex = 0;
                int xIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int yIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int zIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int rayIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                Point3D desiredPosition = new Point3D();
                desiredPosition.setX(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredPosition.setY(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredPosition.setZ(currentRow.getCell(cellIndex++).getNumericCellValue());
                YawPitchRoll desiredOrientation = new YawPitchRoll();
                desiredOrientation.setYaw(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredOrientation.setPitch(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredOrientation.setRoll(currentRow.getCell(cellIndex++).getNumericCellValue());
                float[] jointPositions = new float[numberOfJoints];
                for (int i = 0; i < numberOfJoints; ++i) {
                    jointPositions[i] = (float)currentRow.getCell(cellIndex++).getNumericCellValue();
                }
                float[] jointTorques = new float[numberOfJoints];
                for (int i = 0; i < numberOfJoints; ++i) {
                    jointTorques[i] = (float)currentRow.getCell(cellIndex++).getNumericCellValue();
                }
                Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getOrCreateVoxel(xIndex, yIndex, zIndex);
                voxel.registerReachableRay(rayIndex, (Pose3DReadOnly)new Pose3D((Tuple3DReadOnly)desiredPosition, (Orientation3DReadOnly)desiredOrientation), jointPositions, jointTorques);
                currentRow = currentDataSheet.getRow(currentRowIndex++);
            }
            currentDataSheet = workbook.getSheet(ReachabilityMapSpreadsheetExporter.getRayDataSheetName(currentDataSheetNameIndex++));
        }
    }

    private static void loadPoseData(int numberOfJoints, Voxel3DGrid reachabilityMap, HSSFWorkbook workbook) {
        int currentDataSheetNameIndex = 1;
        HSSFSheet currentDataSheet = workbook.getSheet(ReachabilityMapSpreadsheetExporter.getPoseDataSheetName(currentDataSheetNameIndex++));
        while (currentDataSheet != null) {
            int currentRowIndex = 1;
            HSSFRow currentRow = currentDataSheet.getRow(currentRowIndex++);
            int cellIndex = 0;
            while (currentRow != null) {
                cellIndex = 0;
                int xIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int yIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int zIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int rayIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                int rotationIndex = (int)currentRow.getCell(cellIndex++).getNumericCellValue();
                Point3D desiredPosition = new Point3D();
                desiredPosition.setX(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredPosition.setY(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredPosition.setZ(currentRow.getCell(cellIndex++).getNumericCellValue());
                YawPitchRoll desiredOrientation = new YawPitchRoll();
                desiredOrientation.setYaw(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredOrientation.setPitch(currentRow.getCell(cellIndex++).getNumericCellValue());
                desiredOrientation.setRoll(currentRow.getCell(cellIndex++).getNumericCellValue());
                float[] jointPositions = new float[numberOfJoints];
                for (int i = 0; i < numberOfJoints; ++i) {
                    jointPositions[i] = (float)currentRow.getCell(cellIndex++).getNumericCellValue();
                }
                float[] jointTorques = new float[numberOfJoints];
                for (int i = 0; i < numberOfJoints; ++i) {
                    jointTorques[i] = (float)currentRow.getCell(cellIndex++).getNumericCellValue();
                }
                Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getOrCreateVoxel(xIndex, yIndex, zIndex);
                voxel.registerReachablePose(rayIndex, rotationIndex, (Pose3DReadOnly)new Pose3D((Tuple3DReadOnly)desiredPosition, (Orientation3DReadOnly)desiredOrientation), jointPositions, jointTorques);
                currentRow = currentDataSheet.getRow(currentRowIndex++);
            }
            currentDataSheet = workbook.getSheet(ReachabilityMapSpreadsheetExporter.getPoseDataSheetName(currentDataSheetNameIndex++));
        }
    }

    @Override
    public String getFileType() {
        return "Spreadsheet";
    }

    @Override
    public String getFileExtension() {
        return ".xls";
    }
}

