/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.posePlayback.DRCRobotMidiSliderBoardPositionManipulation;
import us.ihmc.avatar.posePlayback.PlaybackPose;
import us.ihmc.avatar.posePlayback.PlaybackPoseInterpolator;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequence;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequenceReader;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequenceWriter;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJointHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class VisualizePoseWorkspace {
    private final FullHumanoidRobotModel fullRobotModelForSlider;
    private PlaybackPoseSequence posePlaybackRobotPoseSequence;
    private final PlaybackPoseInterpolator interpolator;
    private final YoRegistry registry = new YoRegistry("PlaybackPoseSCSBridge");
    private final double controlDT;
    private YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();

    public VisualizePoseWorkspace(DRCRobotModel robotModel) throws IOException {
        this.controlDT = robotModel.getControllerDT();
        HumanoidJointNameMap jointMap = robotModel.getJointMap();
        HumanoidFloatingRootJointRobot sdfRobot = robotModel.createHumanoidFloatingRootJointRobot(false);
        this.interpolator = new PlaybackPoseInterpolator(this.registry);
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)sdfRobot);
        scs.addYoRegistry(this.registry);
        scs.addYoGraphicsListRegistry(this.yoGraphicsListRegistry);
        this.fullRobotModelForSlider = robotModel.createFullRobotModel();
        DRCRobotMidiSliderBoardPositionManipulation sliderBoard = new DRCRobotMidiSliderBoardPositionManipulation(scs, (FloatingRootJointRobot)sdfRobot, this.fullRobotModelForSlider, this.yoGraphicsListRegistry);
        this.posePlaybackRobotPoseSequence = new PlaybackPoseSequence((FullRobotModel)this.fullRobotModelForSlider);
        CaptureSnapshotListener captureSnapshotListener = new CaptureSnapshotListener(sdfRobot, scs);
        sliderBoard.addCaptureSnapshotListener(captureSnapshotListener);
        SaveSequenceListener saveSequenceListener = new SaveSequenceListener();
        sliderBoard.addSaveSequenceRequestedListener(saveSequenceListener);
        LoadSequenceListener loadSequenceListener = new LoadSequenceListener((FullRobotModel)this.fullRobotModelForSlider, (FloatingRootJointRobot)sdfRobot, scs);
        sliderBoard.addLoadSequenceRequestedListener(loadSequenceListener);
        scs.startOnAThread();
    }

    private class CaptureSnapshotListener
    implements YoVariableChangedListener {
        private final HumanoidFloatingRootJointRobot sdfRobot;
        private final SimulationConstructionSet scs;
        private PlaybackPose previousPose;

        public CaptureSnapshotListener(HumanoidFloatingRootJointRobot sdfRobot, SimulationConstructionSet scs) {
            this.sdfRobot = sdfRobot;
            this.scs = scs;
        }

        public void changed(YoVariable yoVariable) {
            PlaybackPose pose = new PlaybackPose((FullRobotModel)VisualizePoseWorkspace.this.fullRobotModelForSlider, (OneDegreeOfFreedomJointHolder)this.sdfRobot);
            if (this.previousPose != null && pose.epsilonEquals(this.previousPose, 0.001, 1.0)) {
                return;
            }
            System.out.println("Adding pose to sequence list: " + pose);
            VisualizePoseWorkspace.this.posePlaybackRobotPoseSequence.addPose(pose);
            double dt = 0.01;
            double morphTime = 1.0;
            for (double time = 0.0; time < morphTime; time += dt) {
                this.scs.setTime(time);
                this.scs.tickAndUpdate();
            }
            this.previousPose = pose;
        }
    }

    private class SaveSequenceListener
    implements YoVariableChangedListener {
        private SaveSequenceListener() {
        }

        public void changed(YoVariable yoVariable) {
            System.out.println("saving file");
            PlaybackPoseSequenceWriter.promptWriteToFile(VisualizePoseWorkspace.this.posePlaybackRobotPoseSequence);
        }
    }

    private class LoadSequenceListener
    implements YoVariableChangedListener {
        private final SimulationConstructionSet scs;

        public LoadSequenceListener(FullRobotModel fullRobotModel, FloatingRootJointRobot sdfRobot, SimulationConstructionSet scs) {
            this.scs = scs;
        }

        public void changed(YoVariable yoVariable) {
            double startTime;
            System.out.println("Load Sequence Listener");
            JFileChooser chooser = new JFileChooser(new File("PoseSequences"));
            int approveOption = chooser.showOpenDialog(null);
            if (approveOption != 0) {
                System.err.println("Can not load selected file :" + chooser.getName());
                return;
            }
            File selectedFile = chooser.getSelectedFile();
            PlaybackPoseSequence sequence = new PlaybackPoseSequence((FullRobotModel)VisualizePoseWorkspace.this.fullRobotModelForSlider);
            PlaybackPoseSequenceReader.appendFromFile(sequence, selectedFile);
            double time = startTime = 0.0;
            double dt = VisualizePoseWorkspace.this.controlDT;
            VisualizePoseWorkspace.this.interpolator.startSequencePlayback(sequence, startTime);
            while (!VisualizePoseWorkspace.this.interpolator.isDone()) {
                this.scs.setTime(time += dt);
                this.scs.tickAndUpdate();
            }
        }
    }
}

