/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJointHolder;

public class PlaybackPose {
    private final LinkedHashMap<OneDoFJointBasics, Double> playbackPoseMap;
    private double playBackDelayBeforePose = 1.0;
    private double playBackDuration = 1.0;

    public PlaybackPose(FullRobotModel fullRobotModel, OneDegreeOfFreedomJointHolder oneDegreeOfFreedomJointHolder) {
        OneDoFJointBasics[] oneDoFJoints;
        this.playbackPoseMap = new LinkedHashMap();
        for (OneDoFJointBasics oneDoFJoint : oneDoFJoints = fullRobotModel.getOneDoFJoints()) {
            String jointName = oneDoFJoint.getName();
            OneDegreeOfFreedomJoint oneDegreeOfFreedomJoint = oneDegreeOfFreedomJointHolder.getOneDegreeOfFreedomJoint(jointName);
            double jointAngle = oneDegreeOfFreedomJoint.getQYoVariable().getDoubleValue();
            this.playbackPoseMap.put(oneDoFJoint, jointAngle);
        }
    }

    public PlaybackPose(FullRobotModel fullRobotModel, OneDegreeOfFreedomJointHolder oneDegreeOfFreedomJointHolder, double playBackDelayBeforePose, double playbackDuration) {
        this(fullRobotModel, oneDegreeOfFreedomJointHolder);
        this.playBackDelayBeforePose = playBackDelayBeforePose;
        this.playBackDuration = playbackDuration;
    }

    public PlaybackPose(LinkedHashMap<OneDoFJointBasics, Double> playbackPoseMap) {
        if (playbackPoseMap == null) {
            throw new RuntimeException("playbackPoseMap == null");
        }
        this.playbackPoseMap = playbackPoseMap;
    }

    public PlaybackPose(OneDoFJointBasics[] oneDoFJoints, double[] jointAngles, double delay, double duration) {
        int length = oneDoFJoints.length;
        if (jointAngles.length != length) {
            throw new RuntimeException("jointAngles.length != length");
        }
        this.playbackPoseMap = new LinkedHashMap();
        for (int i = 0; i < oneDoFJoints.length; ++i) {
            OneDoFJointBasics oneDoFJoint = oneDoFJoints[i];
            this.playbackPoseMap.put(oneDoFJoint, jointAngles[i]);
        }
        this.playBackDelayBeforePose = delay;
        this.playBackDuration = duration;
    }

    public PlaybackPose(OneDoFJointBasics[] joints, double playBackDelayBeforePose, double playbackDuration) {
        this.playbackPoseMap = new LinkedHashMap();
        for (OneDoFJointBasics oneDoFJoint : joints) {
            this.playbackPoseMap.put(oneDoFJoint, oneDoFJoint.getQ());
        }
        this.playBackDelayBeforePose = playBackDelayBeforePose;
        this.playBackDuration = playbackDuration;
    }

    public PlaybackPose(LinkedHashMap<OneDoFJointBasics, Double> playbackPoseMap, double playBackDelayBeforePose, double playbackDuration) {
        if (playbackPoseMap == null) {
            throw new RuntimeException("playbackPoseMap == null");
        }
        this.playbackPoseMap = playbackPoseMap;
        this.playBackDelayBeforePose = playBackDelayBeforePose;
        this.playBackDuration = playbackDuration;
    }

    public void setRobotAtPose(OneDegreeOfFreedomJointHolder oneDegreeOfFreedomJointHolder) {
        Set<OneDoFJointBasics> oneDoFJoints = this.playbackPoseMap.keySet();
        for (OneDoFJointBasics oneDoFJoint : oneDoFJoints) {
            String jointName = oneDoFJoint.getName();
            OneDegreeOfFreedomJoint oneDegreeOfFreedomJoint = oneDegreeOfFreedomJointHolder.getOneDegreeOfFreedomJoint(jointName);
            Double value = this.playbackPoseMap.get(oneDoFJoint);
            oneDegreeOfFreedomJoint.getQYoVariable().set(value.doubleValue());
        }
    }

    public static PlaybackPose morph(PlaybackPose pose1, PlaybackPose pose2, double morphPercentage) {
        if (morphPercentage < 0.0) {
            morphPercentage = 0.0;
        }
        if (morphPercentage > 1.0) {
            morphPercentage = 1.0;
        }
        Set<OneDoFJointBasics> oneDoFJoints = pose1.playbackPoseMap.keySet();
        LinkedHashMap<OneDoFJointBasics, Double> playbackPoseMap = new LinkedHashMap<OneDoFJointBasics, Double>();
        for (OneDoFJointBasics oneDoFJoint : oneDoFJoints) {
            double angleOne = pose1.getJointAngle(oneDoFJoint);
            double angleTwo = pose2.getJointAngle(oneDoFJoint);
            double morphedAngle = (1.0 - morphPercentage) * angleOne + morphPercentage * angleTwo;
            playbackPoseMap.put(oneDoFJoint, morphedAngle);
        }
        return new PlaybackPose(playbackPoseMap);
    }

    public Double getJointAngle(OneDoFJointBasics oneDoFJoint) {
        if (!this.playbackPoseMap.containsKey(oneDoFJoint)) {
            return null;
        }
        return this.playbackPoseMap.get(oneDoFJoint);
    }

    public double getPlayBackDelayBeforePose() {
        return this.playBackDelayBeforePose;
    }

    public double getPlayBackDuration() {
        return this.playBackDuration;
    }

    public void setPlaybackDelayBeforePose(double playbackTransitionDelayBeforePose) {
        this.playBackDelayBeforePose = playbackTransitionDelayBeforePose;
    }

    public void setPlayBackDuration(double playBackDuration) {
        this.playBackDuration = playBackDuration;
    }

    public String toString() {
        Object ret = "{";
        Set<OneDoFJointBasics> oneDoFJoints = this.playbackPoseMap.keySet();
        boolean firstOne = true;
        for (OneDoFJointBasics oneDoFJoint : oneDoFJoints) {
            if (!firstOne) {
                ret = (String)ret + ", ";
            }
            ret = (String)ret + this.getJointAngle(oneDoFJoint);
            firstOne = false;
        }
        ret = (String)ret + "}";
        return ret;
    }

    public boolean epsilonEquals(PlaybackPose pose, double jointEpsilon, double timeEpsilon) {
        if (this.playbackPoseMap.size() != pose.playbackPoseMap.size()) {
            return false;
        }
        if (Math.abs(this.playBackDelayBeforePose - pose.getPlayBackDelayBeforePose()) > timeEpsilon) {
            return false;
        }
        if (Math.abs(this.playBackDuration - pose.getPlayBackDuration()) > timeEpsilon) {
            return false;
        }
        for (OneDoFJointBasics oneDoFJoint : this.playbackPoseMap.keySet()) {
            Double value = pose.playbackPoseMap.get(oneDoFJoint);
            if (value == null) {
                return false;
            }
            Double valueTwo = this.playbackPoseMap.get(oneDoFJoint);
            if (!(Math.abs(valueTwo - value) > jointEpsilon)) continue;
            return false;
        }
        return true;
    }

    public PlaybackPose copy() {
        LinkedHashMap<OneDoFJointBasics, Double> playbackPoseMapCopy = new LinkedHashMap<OneDoFJointBasics, Double>();
        Set<OneDoFJointBasics> oneDoFJoints = this.playbackPoseMap.keySet();
        for (OneDoFJointBasics oneDoFJoint : oneDoFJoints) {
            playbackPoseMapCopy.put(oneDoFJoint, this.playbackPoseMap.get(oneDoFJoint));
        }
        return new PlaybackPose(playbackPoseMapCopy, this.playBackDelayBeforePose, this.playBackDuration);
    }

    public double[] getJointAngles() {
        Set<OneDoFJointBasics> oneDoFJoints = this.playbackPoseMap.keySet();
        int size = oneDoFJoints.size();
        int index = 0;
        double[] ret = new double[size];
        for (OneDoFJointBasics oneDoFJoint : oneDoFJoints) {
            ret[index] = this.playbackPoseMap.get(oneDoFJoint);
            ++index;
        }
        return ret;
    }

    public void getOneDoFJoints(ArrayList<OneDoFJointBasics> oneDoFJointsToPack) {
        oneDoFJointsToPack.addAll(this.playbackPoseMap.keySet());
    }

    public void getJointAngles(ArrayList<OneDoFJointBasics> oneDoFJoints, double[] jointAnglesToPack) {
        for (int i = 0; i < oneDoFJoints.size(); ++i) {
            jointAnglesToPack[i] = this.playbackPoseMap.get(oneDoFJoints.get(i));
        }
    }
}

