/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.polaris;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.robotics.geometry.RotationalInertiaCalculator;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;

public class PolarisRobot
extends Robot {
    private static final String polarisModelFile = "models/polarisModel.obj";
    private static final String wheelModelFile = "models/steeringWheel.obj";
    private static final String checkerBoardModelFile = "models/GFE/ihmc/calibration_cube.dae";
    private final FloatingJoint floatingJoint;
    private final Link polarisLink;
    private final Graphics3DObject polarisLinkGraphics;
    private static final RigidBodyTransform wheelToCarTransform = new RigidBodyTransform();
    private static final RigidBodyTransform carToWheelTransform = new RigidBodyTransform();
    private static final double wheelToCarX = 0.45207;
    private static final double wheelToCarY = 0.37051;
    private static final double wheelToCarZ = 1.15204;
    private static final double steeringWheelPitchInDegrees = -34.0;
    private static final Vector3D checkerBoardToWheelTranslation = new Vector3D(-0.0992, 0.3762, 0.6109);
    private static final RotationMatrix checkerBoardToWheelRotation = new RotationMatrix();
    private static final RigidBodyTransform checkerBoardToWheel;
    private static final RigidBodyTransform wheelToCheckerBoard;

    public PolarisRobot(String name, RigidBodyTransform rootJointTransform) {
        super(name);
        this.polarisLink = new Link(name + "Link");
        this.polarisLinkGraphics = new Graphics3DObject();
        this.polarisLinkGraphics.addModelFile(polarisModelFile);
        this.polarisLink.setLinkGraphics(this.polarisLinkGraphics);
        this.polarisLink.setMass(1.0);
        this.polarisLink.setComOffset((Vector3DReadOnly)new Vector3D());
        Matrix3D inertia = RotationalInertiaCalculator.getRotationalInertiaMatrixOfSolidCylinder((double)1.0, (double)1.0, (double)1.0, (Axis3D)Axis3D.Z);
        this.polarisLink.setMomentOfInertia((Matrix3DReadOnly)inertia);
        this.floatingJoint = new FloatingJoint(name + "Base", name, (Tuple3DReadOnly)new Vector3D(), (Robot)this);
        this.floatingJoint.setRotationAndTranslation((RigidBodyTransformReadOnly)rootJointTransform);
        this.floatingJoint.setLink(this.polarisLink);
        this.floatingJoint.setDynamic(false);
        Link wheelLink = new Link(name + "Wheel");
        Graphics3DObject wheelGraphics = new Graphics3DObject();
        wheelGraphics.addModelFile(wheelModelFile);
        wheelLink.setLinkGraphics(wheelGraphics);
        wheelLink.setMass(1.0);
        wheelLink.setComOffset((Vector3DReadOnly)new Vector3D());
        wheelLink.setMomentOfInertia((Matrix3DReadOnly)inertia);
        FloatingJoint wheelJoint = new FloatingJoint(name + "WheelJoint", "wheelJoint", (Tuple3DReadOnly)new Vector3D(), (Robot)this);
        wheelJoint.setRotationAndTranslation((RigidBodyTransformReadOnly)wheelToCarTransform);
        wheelJoint.setLink(wheelLink);
        wheelJoint.setDynamic(false);
        this.floatingJoint.addJoint((Joint)wheelJoint);
        Link checkerBoardLink = new Link(name + "CheckerBoardLink");
        Graphics3DObject checkerBoardGraphics = new Graphics3DObject();
        checkerBoardGraphics.scale((Vector3DReadOnly)new Vector3D(2.68, 2.68, 0.1));
        checkerBoardGraphics.addModelFile(checkerBoardModelFile);
        checkerBoardLink.setLinkGraphics(checkerBoardGraphics);
        FloatingJoint checkerBoardJoint = new FloatingJoint(name + "CheckerBoardJoint", "checkerboardJoint", (Tuple3DReadOnly)new Vector3D(), (Robot)this);
        checkerBoardJoint.setRotationAndTranslation((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0), -1.5707963267948966), (Tuple3DReadOnly)new Vector3D(1.1, -0.5, 1.3)));
        checkerBoardJoint.setLink(checkerBoardLink);
        checkerBoardJoint.setDynamic(false);
        this.floatingJoint.addJoint((Joint)checkerBoardJoint);
        this.addRootJoint((Joint)this.floatingJoint);
    }

    public void attachFaceCube() {
        Link faceLink = new Link("FaceLink");
        Graphics3DObject faceGraphics = new Graphics3DObject();
        faceGraphics.scale((Vector3DReadOnly)new Vector3D(3.0, 3.0, 0.1));
        faceGraphics.addModelFile("models/GFE/ihmc/face_cube.dae");
        faceLink.setLinkGraphics(faceGraphics);
        FloatingJoint faceJoint = new FloatingJoint("FaceJoint", "faceJoint", (Tuple3DReadOnly)new Vector3D(), (Robot)this);
        faceJoint.setRotationAndTranslation((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0), -1.5707963267948966), (Tuple3DReadOnly)new Vector3D(1.1, 0.0, 1.3)));
        faceJoint.setLink(faceLink);
        faceJoint.setDynamic(false);
        this.floatingJoint.addJoint((Joint)faceJoint);
    }

    public static RigidBodyTransform getCarToWheelTransform() {
        return wheelToCarTransform;
    }

    public static RigidBodyTransform getWheelToCarTransform() {
        return carToWheelTransform;
    }

    public static RigidBodyTransform getCheckerBoardToWheelTransform() {
        return checkerBoardToWheel;
    }

    public static RigidBodyTransform getWheelToCheckerBoardTransform() {
        return wheelToCheckerBoard;
    }

    static {
        checkerBoardToWheelRotation.setAndNormalize(0.7693, -0.0024, 0.6389, -0.0024, 1.0, 0.0066, -0.6389, -0.0066, 0.7693);
        checkerBoardToWheel = new RigidBodyTransform((Orientation3DReadOnly)checkerBoardToWheelRotation, (Tuple3DReadOnly)checkerBoardToWheelTranslation);
        wheelToCheckerBoard = new RigidBodyTransform();
        wheelToCarTransform.getTranslation().set(0.45207, 0.37051, 1.15204);
        RotationMatrix rotation = new RotationMatrix();
        rotation.setToPitchOrientation(Math.toRadians(-34.0));
        wheelToCarTransform.getRotation().set((RotationMatrixReadOnly)rotation);
        carToWheelTransform.set(wheelToCarTransform);
        carToWheelTransform.invert();
        wheelToCheckerBoard.set(checkerBoardToWheel);
        wheelToCheckerBoard.invert();
    }
}

