/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.polaris;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.polaris.PolarisRobot;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTexture;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.SelectableObjectListener;
import us.ihmc.simulationConstructionSetTools.util.ground.CombinedTerrainObject3D;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.util.ground.RotatableBoxTerrainObject;
import us.ihmc.simulationconstructionset.util.ground.RotatableCinderBlockTerrainObject;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class CarEgressEnvironment
implements CommonAvatarEnvironmentInterface {
    private final double edgeOfStepX = -0.8;
    private final double edgeOfStepY = 0.5;
    private static final Point3D stepDimensions = new Point3D(1.0, 0.3, 0.2);
    private static final Point3D carDimensions = new Point3D(1.0, 0.6, 0.4);
    private static final Vector3D polarisPosition = new Vector3D(-0.4, 1.5, 0.0);
    private final CombinedTerrainObject3D terrain = new CombinedTerrainObject3D("drcCarEgressTerrain");
    private final List<Robot> robots = new ArrayList<Robot>();

    public CarEgressEnvironment() {
        RigidBodyTransform locationStep = new RigidBodyTransform();
        locationStep.getTranslation().set((Tuple3DReadOnly)new Vector3D(-0.8 + 0.5 * stepDimensions.getX(), 0.5 + 0.5 * stepDimensions.getY(), stepDimensions.getZ() / 2.0));
        Box3D stepBox = new Box3D((RigidBodyTransformReadOnly)locationStep, stepDimensions.getX(), stepDimensions.getY(), stepDimensions.getZ());
        this.terrain.addTerrainObject((TerrainObject3D)new RotatableCinderBlockTerrainObject(stepBox, YoAppearance.DarkGray()));
        RigidBodyTransform locationCar = new RigidBodyTransform();
        locationCar.getTranslation().set((Tuple3DReadOnly)new Vector3D(-0.8 + 0.5 * stepDimensions.getX(), 0.5 + stepDimensions.getY() + 0.5 * carDimensions.getY(), carDimensions.getZ() / 2.0));
        Box3D carBox = new Box3D((RigidBodyTransformReadOnly)locationCar, carDimensions.getX(), carDimensions.getY(), carDimensions.getZ());
        this.terrain.addTerrainObject((TerrainObject3D)new RotatableCinderBlockTerrainObject(carBox, YoAppearance.DarkGray()));
        this.terrain.addTerrainObject((TerrainObject3D)CarEgressEnvironment.setUpGround("ground"));
        RigidBodyTransform polarisTransform = new RigidBodyTransform();
        polarisTransform.getTranslation().set((Tuple3DReadOnly)polarisPosition);
        this.robots.add(new PolarisRobot("polaris", polarisTransform));
    }

    public TerrainObject3D getTerrainObject3D() {
        return this.terrain;
    }

    public List<? extends Robot> getEnvironmentRobots() {
        return this.robots;
    }

    public void createAndSetContactControllerToARobot() {
    }

    public void addContactPoints(List<? extends ExternalForcePoint> externalForcePoints) {
    }

    public void addSelectableListenerToSelectables(SelectableObjectListener selectedListener) {
    }

    private static CombinedTerrainObject3D setUpGround(String name) {
        CombinedTerrainObject3D combinedTerrainObject = new CombinedTerrainObject3D(name);
        YoAppearanceTexture texture = new YoAppearanceTexture("Textures/brick.png");
        RigidBodyTransform location = new RigidBodyTransform();
        location.getTranslation().set((Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.5));
        RotatableBoxTerrainObject newBox = new RotatableBoxTerrainObject(new Box3D((RigidBodyTransformReadOnly)location, 10.0, 10.0, 1.0), (AppearanceDefinition)texture);
        combinedTerrainObject.addTerrainObject((TerrainObject3D)newBox);
        return combinedTerrainObject;
    }
}

