/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.perception;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ros2.ROS2Helper;
import us.ihmc.perception.BytedecoImage;
import us.ihmc.perception.opencl.OpenCLManager;
import us.ihmc.perception.opencv.OpenCVTools;
import us.ihmc.perception.rapidRegions.RapidPlanarRegionsExtractor;
import us.ihmc.perception.tools.PerceptionMessageTools;
import us.ihmc.robotics.geometry.FramePlanarRegionsList;
import us.ihmc.ros2.ROS2Topic;

public class RapidRegionsAsyncPublisher {
    private final ROS2Helper ros2Helper;
    private final ROS2SyncedRobotModel syncedRobot;
    private final RapidPlanarRegionsExtractor extractor;
    private final Mat depthImageMeters32FC1;
    private final Supplier<Boolean> enabled;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory((String)this.getClass().getSimpleName()));
    private final BytedecoImage bytedecoDepthImage;

    public RapidRegionsAsyncPublisher(ROS2Helper ros2Helper, ROS2SyncedRobotModel syncedRobot, RapidPlanarRegionsExtractor extractor, int imageHeight, int imageWidth, Mat depthImageMeters32FC1, OpenCLManager openCLManager, Supplier<Boolean> enabled) {
        this.ros2Helper = ros2Helper;
        this.syncedRobot = syncedRobot;
        this.extractor = extractor;
        this.depthImageMeters32FC1 = depthImageMeters32FC1;
        this.enabled = enabled;
        this.bytedecoDepthImage = new BytedecoImage(imageWidth, imageHeight, opencv_core.CV_16UC1);
        this.bytedecoDepthImage.createOpenCLImage(openCLManager, 1);
    }

    public void update() {
        boolean enabled = this.enabled.get();
        this.extractor.setEnabled(enabled);
        this.executorService.submit(() -> {
            OpenCVTools.convertFloatToShort((Mat)this.depthImageMeters32FC1, (Mat)this.bytedecoDepthImage.getBytedecoOpenCVMat(), (double)1000.0, (double)0.0);
            FramePlanarRegionsList frameRegions = new FramePlanarRegionsList();
            this.extractor.updateRobotConfigurationData(this.syncedRobot.getLatestRobotConfigurationData());
            this.extractor.update(this.bytedecoDepthImage, this.syncedRobot.getReferenceFrames().getSteppingCameraFrame(), frameRegions);
            PerceptionMessageTools.publishFramePlanarRegionsList((FramePlanarRegionsList)frameRegions, (ROS2Topic)PerceptionAPI.PERSPECTIVE_RAPID_REGIONS, (ROS2Helper)this.ros2Helper);
            this.extractor.setProcessing(false);
        });
    }

    public void destroy() {
        this.executorService.shutdownNow();
    }
}

