/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.WholeBodyTrajectoryToolboxAPI;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;

public class WholeBodyTrajectoryToolboxCommandConverter
implements CommandConversionInterface {
    private final Map<Integer, RigidBodyBasics> rigidBodyHashMap = new HashMap<Integer, RigidBodyBasics>();
    private final ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver;

    public WholeBodyTrajectoryToolboxCommandConverter(FullHumanoidRobotModel fullRobotModel) {
        this.referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver((FullRobotModel)fullRobotModel, (ReferenceFrames)new HumanoidReferenceFrames(fullRobotModel));
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)fullRobotModel.getElevator());
        for (RigidBodyBasics rigidBody : rootBody.subtreeIterable()) {
            this.rigidBodyHashMap.put(rigidBody.hashCode(), rigidBody);
        }
    }

    public WholeBodyTrajectoryToolboxCommandConverter(RigidBodyBasics rootBody) {
        ArrayList<MovingReferenceFrame> referenceFrames = new ArrayList<MovingReferenceFrame>();
        for (JointBasics joint : rootBody.childrenSubtreeIterable()) {
            referenceFrames.add(joint.getFrameAfterJoint());
            referenceFrames.add(joint.getFrameBeforeJoint());
        }
        for (RigidBodyBasics rigidBody : rootBody.subtreeIterable()) {
            referenceFrames.add(rigidBody.getBodyFixedFrame());
        }
        this.referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver(referenceFrames);
        for (RigidBodyBasics rigidBody : rootBody.subtreeIterable()) {
            this.rigidBodyHashMap.put(rigidBody.hashCode(), rigidBody);
        }
    }

    public RigidBodyBasics getRigidBody(int hashCode) {
        return this.rigidBodyHashMap.get(hashCode);
    }

    public <C extends Command<?, M>, M extends Settable<M>> boolean isConvertible(C command, M message) {
        return command instanceof WholeBodyTrajectoryToolboxAPI;
    }

    public <C extends Command<?, M>, M extends Settable<M>> void process(C command, M message) {
        WholeBodyTrajectoryToolboxAPI wholeBodyTrajectoryCommand = (WholeBodyTrajectoryToolboxAPI)command;
        wholeBodyTrajectoryCommand.set(message, this.rigidBodyHashMap, this.referenceFrameHashCodeResolver);
    }
}

