/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.walkingPreview;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.ejml.data.DMatrix;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import toolbox_msgs.msg.dds.WalkingControllerPreviewOutputMessage;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.walkingPreview.FootstepListPreviewTask;
import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingPreviewResetTask;
import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingPreviewTask;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModule;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisHeightControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerAPIDefinition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WalkingHighLevelHumanoidController;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.SettableFootSwitch;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataListCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.FrameMessageCommandConverter;
import us.ihmc.humanoidRobotics.communication.walkingPreviewToolboxAPI.WalkingControllerPreviewInputCommand;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.humanoidRobotics.model.CenterOfMassStateProvider;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.taskExecutor.StateExecutor;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class WalkingControllerPreviewToolboxController
extends ToolboxController {
    private final double gravityZ = 9.81;
    private final YoDouble previewTime;
    private final double integrationDT;
    private final FloatingJointBasics rootJoint;
    private final OneDoFJointBasics[] allOneDoFJointsExcludingHands;
    private final FullHumanoidRobotModel fullRobotModel;
    private final CenterOfMassStateProvider centerOfMassStateProvider;
    private final CommonHumanoidReferenceFrames referenceFrames;
    private final SideDependentList<SettableFootSwitch> footSwitches = new SideDependentList();
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WholeBodyControllerCore controllerCore;
    private final LinearMomentumRateControlModule linearMomentumRateControlModule;
    private final HighLevelControlManagerFactory managerFactory;
    private final WalkingHighLevelHumanoidController walkingController;
    private final CommandInputManager toolboxInputManager;
    private final AtomicReference<RobotConfigurationData> latestRobotConfigurationDataReference = new AtomicReference<Object>(null);
    private final CommandInputManager walkingInputManager = new CommandInputManager("walking_preview_internal", ControllerAPIDefinition.getControllerSupportedCommands());
    private final StatusMessageOutputManager walkingOutputManager = new StatusMessageOutputManager(ControllerAPIDefinition.getControllerSupportedStatusMessages());
    private final StateExecutor taskExecutor = new StateExecutor();
    private final YoBoolean isInitialized = new YoBoolean("isInitialized", this.registry);
    private final YoBoolean isDone = new YoBoolean("isDone", this.registry);
    private final YoBoolean hasControllerFailed = new YoBoolean("hasControllerFailed", this.registry);
    private final List<KinematicsToolboxOutputStatus> previewFrames = new ArrayList<KinematicsToolboxOutputStatus>();
    private final MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator();
    private final List<Updatable> updatables = new ArrayList<Updatable>();

    public WalkingControllerPreviewToolboxController(DRCRobotModel robotModel, double integrationDT, CommandInputManager toolboxInputManager, StatusMessageOutputManager statusOutputManager, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.integrationDT = integrationDT;
        this.toolboxInputManager = toolboxInputManager;
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.centerOfMassStateProvider = CenterOfMassStateProvider.createJacobianBasedStateCalculator((RigidBodyReadOnly)this.fullRobotModel.getElevator(), (ReferenceFrame)ReferenceFrame.getWorldFrame());
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel, this.centerOfMassStateProvider, null);
        this.previewTime = new YoDouble("timeInPreview", this.registry);
        ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver((FullRobotModel)this.fullRobotModel, (ReferenceFrames)this.referenceFrames);
        FrameMessageCommandConverter commandConversionHelper = new FrameMessageCommandConverter(referenceFrameHashCodeResolver);
        this.walkingInputManager.registerConversionHelper((CommandConversionInterface)commandConversionHelper);
        WalkingControllerParameters walkingControllerParameters = robotModel.getWalkingControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = robotModel.getCoPTrajectoryParameters();
        YoRegistry drcControllerThread = new YoRegistry("DRCControllerThread");
        YoRegistry drcMomentumBasedController = new YoRegistry("DRCMomentumBasedController");
        YoRegistry humanoidHighLevelControllerManager = new YoRegistry("HumanoidHighLevelControllerManager");
        YoRegistry managerParentRegistry = new YoRegistry("HighLevelHumanoidControllerFactory");
        YoRegistry walkingParentRegistry = new YoRegistry("WalkingControllerState");
        this.registry.addChild(drcControllerThread);
        drcControllerThread.addChild(drcMomentumBasedController);
        drcMomentumBasedController.addChild(humanoidHighLevelControllerManager);
        humanoidHighLevelControllerManager.addChild(walkingParentRegistry);
        humanoidHighLevelControllerManager.addChild(managerParentRegistry);
        this.controllerToolbox = this.createHighLevelControllerToolbox(robotModel, yoGraphicsListRegistry);
        this.controllerToolbox.attachControllerFailureListener(fallingDirection -> this.hasControllerFailed.set(true));
        humanoidHighLevelControllerManager.addChild(this.controllerToolbox.getYoVariableRegistry());
        this.setupWalkingMessageHandler(walkingControllerParameters, copTrajectoryParameters, yoGraphicsListRegistry);
        this.rootJoint = this.fullRobotModel.getRootJoint();
        this.allOneDoFJointsExcludingHands = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel);
        this.managerFactory = new HighLevelControlManagerFactory(managerParentRegistry);
        this.managerFactory.setHighLevelHumanoidControllerToolbox(this.controllerToolbox);
        this.managerFactory.setCopTrajectoryParameters(copTrajectoryParameters);
        this.managerFactory.setWalkingControllerParameters(walkingControllerParameters);
        this.walkingController = new WalkingHighLevelHumanoidController(this.walkingInputManager, this.walkingOutputManager, this.managerFactory, walkingControllerParameters, this.controllerToolbox);
        walkingParentRegistry.addChild(this.walkingController.getYoVariableRegistry());
        WholeBodyControlCoreToolbox controlCoreToolbox = this.createControllerCoretoolbox(walkingControllerParameters, yoGraphicsListRegistry);
        FeedbackControllerTemplate feedbackControlTemplate = this.managerFactory.createFeedbackControlTemplate();
        JointDesiredOutputList jointDesiredOutputList = new JointDesiredOutputList((OneDoFJointReadOnly[])this.controllerToolbox.getControlledOneDoFJoints());
        this.controllerCore = new WholeBodyControllerCore(controlCoreToolbox, feedbackControlTemplate, jointDesiredOutputList, walkingParentRegistry);
        this.walkingController.setControllerCoreOutput(this.controllerCore.getOutputForHighLevelController());
        double controlDT = this.controllerToolbox.getControlDT();
        RigidBodyBasics elevator = this.fullRobotModel.getElevator();
        SideDependentList contactableFeet = this.controllerToolbox.getContactableFeet();
        this.linearMomentumRateControlModule = new LinearMomentumRateControlModule(this.centerOfMassStateProvider, this.referenceFrames, contactableFeet, elevator, walkingControllerParameters, 9.81, controlDT, walkingParentRegistry, yoGraphicsListRegistry);
        ParameterLoaderHelper.loadParameters((Object)this, (WholeBodyControllerParameters)robotModel, (YoRegistry)drcControllerThread);
        YoVariable defaultHeight = this.registry.findVariable(PelvisHeightControlState.class.getSimpleName(), PelvisHeightControlState.class.getSimpleName() + "DefaultHeight");
        if (Double.isNaN(defaultHeight.getValueAsDouble())) {
            throw new RuntimeException("Need to load a default height.");
        }
    }

    private HighLevelHumanoidControllerToolbox createHighLevelControllerToolbox(DRCRobotModel robotModel, YoGraphicsListRegistry yoGraphicsListRegistry) {
        double omega0 = robotModel.getWalkingControllerParameters().getOmega0();
        ContactableBodiesFactory<RobotSide> contactableBodiesFactory = this.createContactableBodiesFactory(robotModel);
        SideDependentList feet = new SideDependentList(contactableBodiesFactory.createFootContactableFeet());
        List additionalContacts = contactableBodiesFactory.createAdditionalContactPoints();
        contactableBodiesFactory.disposeFactory();
        ArrayList allContactableBodies = new ArrayList(additionalContacts);
        allContactableBodies.addAll(feet.values());
        double robotMass = TotalMassCalculator.computeSubTreeMass((RigidBodyReadOnly)this.fullRobotModel.getElevator());
        for (RobotSide robotSide : RobotSide.values) {
            SettableFootSwitch footSwitch = new SettableFootSwitch((ContactablePlaneBody)feet.get((Enum)robotSide), robotMass, 2, this.registry);
            footSwitch.setFootContactState(true);
            this.footSwitches.put((Enum)robotSide, (Object)footSwitch);
        }
        JointBasics[] jointsToIgnore = AvatarControllerThread.createListOfJointsToIgnore(this.fullRobotModel, robotModel, robotModel.getSensorInformation());
        return new HighLevelHumanoidControllerToolbox(this.fullRobotModel, this.centerOfMassStateProvider, this.referenceFrames, this.footSwitches, null, this.previewTime, 9.81, omega0, feet, this.integrationDT, Collections.emptyList(), allContactableBodies, yoGraphicsListRegistry, jointsToIgnore);
    }

    private void setupWalkingMessageHandler(WalkingControllerParameters walkingControllerParameters, CoPTrajectoryParameters copTrajectoryParameters, YoGraphicsListRegistry yoGraphicsListRegistry) {
        double defaultTransferTime = walkingControllerParameters.getDefaultTransferTime();
        double defaultSwingTime = walkingControllerParameters.getDefaultSwingTime();
        double defaultInitialTransferTime = walkingControllerParameters.getDefaultInitialTransferTime();
        double defaultFinalTransferTime = walkingControllerParameters.getDefaultFinalTransferTime();
        WalkingMessageHandler walkingMessageHandler = new WalkingMessageHandler(defaultTransferTime, defaultSwingTime, defaultInitialTransferTime, defaultFinalTransferTime, this.controllerToolbox.getContactableFeet(), this.walkingOutputManager, this.previewTime, yoGraphicsListRegistry, this.controllerToolbox.getYoVariableRegistry());
        this.controllerToolbox.setWalkingMessageHandler(walkingMessageHandler);
    }

    private WholeBodyControlCoreToolbox createControllerCoretoolbox(WalkingControllerParameters walkingControllerParameters, YoGraphicsListRegistry yoGraphicsListRegistry) {
        JointBasics[] controlledJoints = this.controllerToolbox.getControlledJoints();
        MomentumOptimizationSettings momentumOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters = walkingControllerParameters.getJointPrivilegedConfigurationParameters();
        FeedbackControllerSettings feedbackControllerSettings = walkingControllerParameters.getFeedbackControllerSettings();
        WholeBodyControlCoreToolbox controlCoreToolbox = new WholeBodyControlCoreToolbox(this.integrationDT, 9.81, this.fullRobotModel.getRootJoint(), controlledJoints, this.controllerToolbox.getCenterOfMassFrame(), (ControllerCoreOptimizationSettings)momentumOptimizationSettings, yoGraphicsListRegistry, this.registry);
        controlCoreToolbox.setJointPrivilegedConfigurationParameters(jointPrivilegedConfigurationParameters);
        controlCoreToolbox.setFeedbackControllerSettings(feedbackControllerSettings);
        controlCoreToolbox.setupForInverseDynamicsSolver(this.controllerToolbox.getContactablePlaneBodies());
        return controlCoreToolbox;
    }

    private ContactableBodiesFactory<RobotSide> createContactableBodiesFactory(DRCRobotModel robotModel) {
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
        ArrayList additionaContactNames = contactPointParameters.getAdditionalContactNames();
        ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionaContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
        }
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)this.fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)this.referenceFrames);
        return contactableBodiesFactory;
    }

    @Override
    public boolean initialize() {
        this.isDone.set(false);
        this.isInitialized.set(false);
        this.hasControllerFailed.set(false);
        return this.latestRobotConfigurationDataReference.get() != null;
    }

    private void initializeInternal() {
        LogTools.info((String)"Initializing");
        this.isDone.set(false);
        this.previewTime.set(0.0);
        this.previewFrames.clear();
        RobotConfigurationData robotConfigurationData = this.latestRobotConfigurationDataReference.get();
        KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(robotConfigurationData, this.rootJoint, FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel));
        for (JointBasics joint : this.fullRobotModel.getElevator().childrenSubtreeIterable()) {
            joint.setJointTwistToZero();
            joint.setJointAccelerationToZero();
        }
        this.referenceFrames.updateFrames();
        this.controllerCore.initialize();
        this.controllerToolbox.update();
        this.walkingController.initialize();
        this.taskExecutor.clear();
        this.taskExecutor.submit((State)new WalkingPreviewResetTask(this.walkingController, (SideDependentList<YoPlaneContactState>)this.controllerToolbox.getFootContactStates()));
        this.isInitialized.set(true);
    }

    @Override
    public void updateInternal() {
        if (this.isDone()) {
            for (JointBasics joint : this.fullRobotModel.getElevator().childrenSubtreeIterable()) {
                joint.setJointAccelerationToZero();
                joint.setJointTwistToZero();
            }
            return;
        }
        if (this.toolboxInputManager.isNewCommandAvailable(WalkingControllerPreviewInputCommand.class)) {
            this.initializeInternal();
            WalkingControllerPreviewInputCommand command = (WalkingControllerPreviewInputCommand)this.toolboxInputManager.pollNewestCommand(WalkingControllerPreviewInputCommand.class);
            FootstepDataListCommand foostepCommand = command.getFoostepCommand();
            this.taskExecutor.submit((State)new FootstepListPreviewTask((FloatingJointReadOnly)this.fullRobotModel.getRootJoint(), foostepCommand, this.walkingInputManager, this.walkingOutputManager, (SideDependentList<YoPlaneContactState>)this.controllerToolbox.getFootContactStates(), this.managerFactory.getOrCreateBalanceManager(), this.footSwitches));
        } else {
            this.previewTime.add(this.integrationDT);
            this.fullRobotModel.updateFrames();
            this.referenceFrames.updateFrames();
            this.controllerToolbox.update();
        }
        if (!this.isInitialized.getValue()) {
            return;
        }
        this.taskExecutor.doControl();
        this.walkingController.doAction();
        this.linearMomentumRateControlModule.setInputFromWalkingStateMachine(this.walkingController.getLinearMomentumRateControlModuleInput());
        if (!this.linearMomentumRateControlModule.computeControllerCoreCommands()) {
            this.controllerToolbox.reportControllerFailureToListeners(new FrameVector2D());
        }
        this.walkingController.setLinearMomentumRateControlModuleOutput(this.linearMomentumRateControlModule.getOutputForWalkingStateMachine());
        ControllerCoreCommand controllerCoreCommand = this.walkingController.getControllerCoreCommand();
        controllerCoreCommand.addInverseDynamicsCommand((InverseDynamicsCommand)this.linearMomentumRateControlModule.getMomentumRateCommand());
        if (!this.taskExecutor.isDone()) {
            controllerCoreCommand.addInverseDynamicsCommand(((WalkingPreviewTask)this.taskExecutor.getCurrentTask()).getOutput());
        }
        this.controllerCore.compute((ControllerCoreCommandInterface)controllerCoreCommand);
        this.linearMomentumRateControlModule.setInputFromControllerCore(this.controllerCore.getControllerCoreOutput());
        this.linearMomentumRateControlModule.computeAchievedCMP();
        this.rootJoint.setJointAcceleration(0, (DMatrix)this.controllerCore.getOutputForRootJoint().getDesiredAcceleration());
        JointDesiredOutputListReadOnly jointDesiredOutputList = this.controllerCore.getOutputForLowLevelController();
        for (OneDoFJointBasics joint : this.controllerToolbox.getControlledOneDoFJoints()) {
            JointDesiredOutputReadOnly jointDesiredOutput = jointDesiredOutputList.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            joint.setQdd(jointDesiredOutput.getDesiredAcceleration());
        }
        this.integrator.setIntegrationDT(this.integrationDT);
        this.integrator.doubleIntegrateFromAcceleration(Arrays.asList(this.controllerToolbox.getControlledJoints()));
        if (!(this.taskExecutor.getCurrentTask() instanceof WalkingPreviewResetTask)) {
            this.previewFrames.add(MessageTools.createKinematicsToolboxOutputStatus((FloatingJointBasics)this.rootJoint, (OneDoFJointBasics[])this.allOneDoFJointsExcludingHands));
        }
        this.isDone.set(this.taskExecutor.isDone() || this.hasControllerFailed.getValue());
        if (this.isDone()) {
            LogTools.info((String)("Preview is done, packing and sending result, number of frames: " + this.previewFrames.size()));
            if (this.hasControllerFailed.getValue()) {
                LogTools.info((String)"Controller has failed.");
            }
            WalkingControllerPreviewOutputMessage output = MessageTools.createWalkingControllerPreviewOutputMessage((double)this.integrationDT, this.previewFrames);
            this.reportMessage(output);
            this.taskExecutor.clear();
        }
        this.updatables.forEach(updatable -> updatable.update(this.previewTime.getValue()));
    }

    public void addUpdatable(Updatable updatable) {
        this.updatables.add(updatable);
    }

    @Override
    public boolean isDone() {
        return this.isDone.getValue();
    }

    public boolean isWalkingControllerResetDone() {
        return this.isInitialized.getValue() && !(this.taskExecutor.getCurrentTask() instanceof WalkingPreviewResetTask);
    }

    public void updateRobotConfigurationData(RobotConfigurationData newConfigurationData) {
        this.latestRobotConfigurationDataReference.set(newConfigurationData);
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public double getIntegrationDT() {
        return this.integrationDT;
    }
}

