/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.supportingPlanarRegionPublisher;

import controller_msgs.msg.dds.BipedalSupportPlanarRegionParametersMessage;
import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.supportingPlanarRegionPublisher.BipedalSupportPlanarRegionCalculator;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.tools.thread.CloseableAndDisposable;

public class BipedalSupportPlanarRegionPublisher
implements CloseableAndDisposable {
    public static final double defaultScaleFactor = 2.0;
    private final boolean manageROS2Node;
    private final RealtimeROS2Node ros2Node;
    private final IHMCRealtimeROS2Publisher<PlanarRegionsListMessage> regionPublisher;
    private final AtomicReference<CapturabilityBasedStatus> latestCapturabilityBasedStatusMessage = new AtomicReference<Object>(null);
    private final AtomicReference<RobotConfigurationData> latestRobotConfigurationData = new AtomicReference<Object>(null);
    private final AtomicReference<BipedalSupportPlanarRegionParametersMessage> latestParametersMessage = new AtomicReference<Object>(null);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory((String)this.getClass().getSimpleName()));
    private ScheduledFuture<?> task;
    private final BipedalSupportPlanarRegionCalculator bipedalSupportPlanarRegionCalculator;

    public BipedalSupportPlanarRegionPublisher(DRCRobotModel robotModel, RealtimeROS2Node realtimeROS2Node) {
        this(robotModel, realtimeROS2Node, null);
    }

    public BipedalSupportPlanarRegionPublisher(DRCRobotModel robotModel, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(robotModel, null, pubSubImplementation);
    }

    private BipedalSupportPlanarRegionPublisher(DRCRobotModel robotModel, RealtimeROS2Node realtimeROS2Node, DomainFactory.PubSubImplementation pubSubImplementation) {
        String robotName = robotModel.getSimpleRobotName();
        this.bipedalSupportPlanarRegionCalculator = new BipedalSupportPlanarRegionCalculator(robotModel);
        boolean bl = this.manageROS2Node = realtimeROS2Node == null;
        if (realtimeROS2Node == null) {
            realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)pubSubImplementation, (String)"supporting_planar_region_publisher");
        }
        this.ros2Node = realtimeROS2Node;
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)robotName), subscriber -> this.latestCapturabilityBasedStatusMessage.set((CapturabilityBasedStatus)subscriber.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, RobotConfigurationData.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)robotName), subscriber -> this.latestRobotConfigurationData.set((RobotConfigurationData)subscriber.takeNextData()));
        this.regionPublisher = ROS2Tools.createPublisher((RealtimeROS2Node)this.ros2Node, (ROS2Topic)PerceptionAPI.BIPEDAL_SUPPORT_REGIONS);
        ROS2Tools.createCallbackSubscription((RealtimeROS2Node)this.ros2Node, BipedalSupportPlanarRegionParametersMessage.class, BipedalSupportPlanarRegionPublisher.getTopic(robotName), s -> this.latestParametersMessage.set((BipedalSupportPlanarRegionParametersMessage)s.takeNextData()));
        BipedalSupportPlanarRegionParametersMessage defaultParameters = new BipedalSupportPlanarRegionParametersMessage();
        defaultParameters.setEnable(true);
        defaultParameters.setSupportRegionScaleFactor(2.0);
        this.latestParametersMessage.set(defaultParameters);
        this.bipedalSupportPlanarRegionCalculator.initializeEmptyRegions();
    }

    public void start() {
        if (this.manageROS2Node) {
            this.ros2Node.spin();
        }
        this.task = this.executorService.scheduleWithFixedDelay(this::run, 0L, 1L, TimeUnit.SECONDS);
    }

    private void run() {
        BipedalSupportPlanarRegionParametersMessage parameters = this.latestParametersMessage.get();
        if (!parameters.getEnable() || parameters.getSupportRegionScaleFactor() <= 0.0) {
            this.bipedalSupportPlanarRegionCalculator.initializeEmptyRegions();
            this.publishRegions();
            return;
        }
        CapturabilityBasedStatus capturabilityBasedStatus = this.latestCapturabilityBasedStatusMessage.get();
        if (capturabilityBasedStatus == null) {
            return;
        }
        RobotConfigurationData robotConfigurationData = this.latestRobotConfigurationData.get();
        if (robotConfigurationData == null) {
            return;
        }
        this.bipedalSupportPlanarRegionCalculator.calculateSupportRegions(parameters.getSupportRegionScaleFactor(), capturabilityBasedStatus, robotConfigurationData);
        this.publishRegions();
    }

    private void publishRegions() {
        this.regionPublisher.publish((Object)PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)this.bipedalSupportPlanarRegionCalculator.getSupportRegionsAsList()));
    }

    public void stop() {
        this.task.cancel(false);
    }

    public void destroy() {
        this.stop();
        this.executorService.shutdownNow();
        if (this.manageROS2Node) {
            this.ros2Node.destroy();
        }
    }

    public void closeAndDispose() {
        this.destroy();
    }

    public static ROS2Topic<BipedalSupportPlanarRegionParametersMessage> getTopic(String robotName) {
        return PerceptionAPI.getBipedalSupportRegionParametersTopic((String)robotName);
    }
}

