/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher;

import us.ihmc.communication.packets.ScanPointFilter;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class RangeScanPointFilter
implements ScanPointFilter {
    private double minRangeSquared = Double.NaN;
    private double maxRangeSquared = Double.NaN;
    private Point3DReadOnly sensorPosition;

    public void setMinRange(double minRange) {
        this.minRangeSquared = minRange <= 0.0 || Double.isNaN(minRange) ? Double.NaN : minRange * minRange;
    }

    public void setMaxRange(double maxRange) {
        this.maxRangeSquared = maxRange <= 0.0 || Double.isNaN(maxRange) ? Double.NaN : maxRange * maxRange;
    }

    public void setSensorPosition(Point3DReadOnly sensorPosition) {
        this.sensorPosition = sensorPosition;
    }

    public boolean test(int index, Point3DReadOnly point) {
        if (Double.isNaN(this.minRangeSquared) && Double.isNaN(this.maxRangeSquared)) {
            return true;
        }
        double distanceSquared = this.sensorPosition.distanceSquared(point);
        return distanceSquared >= this.minRangeSquared && distanceSquared <= this.maxRangeSquared;
    }
}

