/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.stepConstraintToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.StepConstraintMessage;
import java.util.ArrayList;
import java.util.List;
import perception_msgs.msg.dds.PlanarRegionMessage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.avatar.networkProcessor.stepConstraintToolboxModule.StepConstraintToolboxController;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerAPIDefinition;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.util.JVMStatisticsGenerator;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class StepConstraintToolboxModule
extends ToolboxModule {
    private static final int DEFAULT_UPDATE_PERIOD_MILLISECONDS = 10;
    protected final StepConstraintToolboxController controller;
    private IHMCROS2Publisher<StepConstraintMessage> constraintRegionPublisher;

    public StepConstraintToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, DomainFactory.PubSubImplementation pubSubImplementation, double gravityZ) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 10, pubSubImplementation);
        this.setTimeWithoutInputsBeforeGoingToSleep(Double.POSITIVE_INFINITY);
        this.controller = new StepConstraintToolboxController(this.statusOutputManager, this.constraintRegionPublisher, robotModel.getWalkingControllerParameters(), this.fullRobotModel, gravityZ, this.registry, this.yoGraphicsListRegistry);
        this.startYoVariableServer();
        if (this.yoVariableServer != null) {
            JVMStatisticsGenerator jvmStatisticsGenerator = new JVMStatisticsGenerator((RobotVisualizer)this.yoVariableServer);
            jvmStatisticsGenerator.start();
        }
    }

    @Override
    public void registerExtraPuSubs(ROS2NodeInterface ros2Node) {
        ROS2Topic controllerPubGenerator = ControllerAPIDefinition.getOutputTopic((String)this.robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.controller != null) {
                this.controller.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
        RobotConfigurationData robotConfigurationData = new RobotConfigurationData();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.controller != null) {
                s.takeNextData((Object)robotConfigurationData, null);
                this.controller.updateRobotConfigurationData(robotConfigurationData);
            }
        });
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.controller != null) {
                s.takeNextData((Object)capturabilityBasedStatus, null);
                this.controller.updateCapturabilityBasedStatus(capturabilityBasedStatus);
            }
        });
        FootstepStatusMessage statusMessage = new FootstepStatusMessage();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, FootstepStatusMessage.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.controller != null) {
                s.takeNextData((Object)statusMessage, null);
                this.controller.updateFootstepStatus(statusMessage);
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.outputTopic, s -> this.updatePlanarRegion((PlanarRegionsListMessage)s.takeNextData()));
        this.constraintRegionPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, StepConstraintMessage.class, (ROS2Topic)ControllerAPIDefinition.getInputTopic((String)this.robotName));
    }

    public void setSwitchPlanarRegionConstraintsAutomatically(boolean switchAutomatically) {
        this.controller.setSwitchPlanarRegionConstraintsAutomatically(switchAutomatically);
    }

    public void updatePlanarRegion(PlanarRegionsListMessage planarRegionsListMessage) {
        if (this.controller != null) {
            this.controller.updatePlanarRegions(planarRegionsListMessage);
        }
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return new ArrayList();
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return StepConstraintToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(PlanarRegionsListMessage.class);
        status.add(PlanarRegionMessage.class);
        return status;
    }

    public ROS2Topic getOutputTopic() {
        return StepConstraintToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic getOutputTopic(String robotName) {
        return ROS2Tools.STEP_CONSTRAINT_TOOLBOX.withRobot(robotName).withOutput();
    }

    public ROS2Topic getInputTopic() {
        return StepConstraintToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic getInputTopic(String robotName) {
        return ROS2Tools.STEP_CONSTRAINT_TOOLBOX.withRobot(robotName).withInput();
    }
}

