/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.quadTreeHeightMap;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import perception_msgs.msg.dds.HeightQuadTreeMessage;
import perception_msgs.msg.dds.LidarScanMessage;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.avatar.networkProcessor.quadTreeHeightMap.HeightQuadTreeToolboxController;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.toolbox.heightQuadTree.command.HeightQuadTreeToolboxRequestCommand;
import us.ihmc.humanoidRobotics.communication.toolbox.heightQuadTree.command.LidarScanCommand;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class HeightQuadTreeToolboxModule
extends ToolboxModule {
    private final HeightQuadTreeToolboxController controller;

    public HeightQuadTreeToolboxModule(String robotName, FullHumanoidRobotModel desiredFullRobotModel, LogModelProvider modelProvider, DomainFactory.PubSubImplementation pubSubImplementation) {
        super(robotName, desiredFullRobotModel, modelProvider, false, 50, pubSubImplementation);
        this.controller = new HeightQuadTreeToolboxController(this.fullRobotModel, this.commandInputManager, this.statusOutputManager, this.registry);
        this.setTimeWithoutInputsBeforeGoingToSleep(3.0);
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public void registerExtraPuSubs(ROS2NodeInterface ros2Node) {
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)this.robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.controller != null) {
                this.controller.receivedPacket((RobotConfigurationData)s.takeNextData());
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.controller != null) {
                this.controller.receivedPacket((CapturabilityBasedStatus)s.takeNextData());
            }
        });
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(HeightQuadTreeToolboxRequestCommand.class);
        commands.add(LidarScanCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return Collections.singletonList(HeightQuadTreeMessage.class);
    }

    @Override
    public Set<Class<? extends Command<?, ?>>> silentCommands() {
        return Collections.singleton(LidarScanCommand.class);
    }

    @Override
    public Set<Class<? extends Settable<?>>> filterExceptions() {
        return Collections.singleton(LidarScanMessage.class);
    }

    public ROS2Topic getOutputTopic() {
        return HeightQuadTreeToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic getOutputTopic(String robotName) {
        return PerceptionAPI.HEIGHT_QUADTREE_TOOLBOX.withRobot(robotName).withOutput();
    }

    public ROS2Topic getInputTopic() {
        return HeightQuadTreeToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic getInputTopic(String robotName) {
        return PerceptionAPI.HEIGHT_QUADTREE_TOOLBOX.withRobot(robotName).withInput();
    }
}

