/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.quadTreeHeightMap;

import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.Vector2D32;

public class HeightQuadTreeNode {
    private float height;
    private Point2D32 center = new Point2D32();
    private Vector2D32 size = new Vector2D32();
    private HeightQuadTreeNode[] children;

    public boolean hasChildrenArray() {
        return this.children != null;
    }

    public int getNumberOfChildren() {
        if (this.children == null) {
            return 0;
        }
        int numberOfChildren = 0;
        for (int childIndex = 0; childIndex < 4; ++childIndex) {
            numberOfChildren += this.children[childIndex] == null ? 0 : 1;
        }
        return numberOfChildren;
    }

    public HeightQuadTreeNode getChild(int childIndex) {
        return this.children == null ? null : this.children[childIndex];
    }

    public void assignChildrenArray() {
        this.children = new HeightQuadTreeNode[4];
    }

    public void setChild(int childIndex, HeightQuadTreeNode child) {
        this.children[childIndex] = child;
    }

    public float getHeight() {
        return this.height;
    }

    public Point2D32 getCenter() {
        return this.center;
    }

    public float getCenterX() {
        return this.center.getX32();
    }

    public float getCenterY() {
        return this.center.getY32();
    }

    public Vector2D32 getSize() {
        return this.size;
    }

    public float getSizeX() {
        return this.size.getX32();
    }

    public float getSizeY() {
        return this.size.getY32();
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setCenterX(float centerX) {
        this.center.setX(centerX);
    }

    public void setCenterY(float centerY) {
        this.center.setY(centerY);
    }

    public void setSizeX(float sizeX) {
        this.size.setX(sizeX);
    }

    public void setSizeY(float sizeY) {
        this.size.setY(sizeY);
    }
}

