/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.objectDetectorToolBox;

import perception_msgs.msg.dds.DetectedFiducialPacket;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidBehaviors.communication.ConcurrentListeningQueue;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ObjectDetectorToolboxController
extends ToolboxController {
    private final ConcurrentListeningQueue<DetectedFiducialPacket> fiducialPacketQueue = new ConcurrentListeningQueue(20);

    public ObjectDetectorToolboxController(FullHumanoidRobotModel fullRobotModel, StatusMessageOutputManager statusOutputManager, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
    }

    @Override
    public boolean initialize() {
        return true;
    }

    public void receivedPacket(DetectedFiducialPacket packet) {
        if (packet != null) {
            this.fiducialPacketQueue.put((Object)packet);
        }
    }

    @Override
    public void updateInternal() {
        while (this.fiducialPacketQueue.isNewPacketAvailable()) {
            DetectedFiducialPacket newPacket = (DetectedFiducialPacket)this.fiducialPacketQueue.poll();
            if (newPacket == null) continue;
            this.decodeFiducial(newPacket);
        }
    }

    private void decodeFiducial(DetectedFiducialPacket fiducial) {
        if (fiducial.fiducial_id_ == 50L) {
            this.decodePushDoorFiducial(fiducial);
        } else if (fiducial.fiducial_id_ == 150L) {
            this.decodePullDoorFiducial(fiducial);
        } else {
            LogTools.debug((String)("fiducial " + fiducial.fiducial_id_ + " detected, but not implemented in ObejctDetetorToolboxController"));
        }
    }

    private void decodePushDoorFiducial(DetectedFiducialPacket fiducial) {
        Pose3D tmpFP = fiducial.fiducial_transform_to_world_;
        tmpFP.appendPitchRotation(Math.toRadians(90.0));
        tmpFP.appendYawRotation(0.0);
        tmpFP.appendRollRotation(Math.toRadians(-90.0));
        tmpFP.appendPitchRotation(-tmpFP.getPitch());
        FramePose3D doorFrame = new FramePose3D((Pose3DReadOnly)tmpFP);
        doorFrame.appendTranslation(0.025875, 0.68183125, -1.1414125);
        Pose3D pose = new Pose3D((Tuple3DReadOnly)doorFrame.getPosition(), (Orientation3DReadOnly)doorFrame.getOrientation());
        pose.appendYawRotation(Math.toRadians(-90.0));
        this.reportMessage(HumanoidMessageTools.createDoorLocationPacket((Pose3D)pose, (byte)2));
    }

    private void decodePullDoorFiducial(DetectedFiducialPacket fiducial) {
        Pose3D tmpFP = fiducial.fiducial_transform_to_world_;
        tmpFP.appendPitchRotation(Math.toRadians(90.0));
        tmpFP.appendYawRotation(0.0);
        tmpFP.appendRollRotation(Math.toRadians(-90.0));
        tmpFP.appendPitchRotation(-tmpFP.getPitch());
        FramePose3D doorFrame = new FramePose3D((Pose3DReadOnly)tmpFP);
        doorFrame.appendTranslation(0.025875, -0.68183125, -1.1414125);
        Pose3D pose = new Pose3D((Tuple3DReadOnly)doorFrame.getPosition(), (Orientation3DReadOnly)doorFrame.getOrientation());
        pose.appendYawRotation(Math.toRadians(90.0));
        this.reportMessage(HumanoidMessageTools.createDoorLocationPacket((Pose3D)pose, (byte)3));
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

