/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules.uiConnector;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.avatar.networkProcessor.modules.uiConnector.PacketsForwardedToTheUi;
import us.ihmc.communication.net.AtomicSettableTimestampProvider;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.communication.packetCommunicator.FilteredPacketSendingForwarder;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;

public class UiConnectionModule
implements PacketConsumer<RobotConfigurationData> {
    private final AtomicSettableTimestampProvider timestampProvider = new AtomicSettableTimestampProvider();
    private final FilteredPacketSendingForwarder packetForwarderFromUiModuleToUserInterface;
    private final FilteredPacketSendingForwarder packetForwarderFromUserInterfaceToUiModule;
    private final Class<?>[] packetsAllowedToGotoUserInterface = PacketsForwardedToTheUi.PACKETS_ALLOWED_TO_BE_SENT_TO_THE_USER_INTERFACE;
    private final HashMap<Class<?>, Long> packetsAllowedToGotoUserInterfaceWithIntervals = PacketsForwardedToTheUi.PACKETS_ALLOWED_TO_BE_SENT_TO_THE_USER_INTERFACE_WITH_MINIMAL_INTERVALS;
    private final NetClassList NETCLASSLIST = new IHMCCommunicationKryoNetClassList();
    private final PacketCommunicator uiPacketServer = PacketCommunicator.createTCPPacketCommunicatorServer((NetworkPorts)NetworkPorts.NETWORK_PROCESSOR_TO_UI_TCP_PORT, (NetClassList)this.NETCLASSLIST);
    private final PacketCommunicator uiModuleCommunicator = PacketCommunicator.createIntraprocessPacketCommunicator((NetworkPorts)NetworkPorts.UI_MODULE, (NetClassList)this.NETCLASSLIST);

    public UiConnectionModule() {
        this.packetForwarderFromUserInterfaceToUiModule = new FilteredPacketSendingForwarder(this.uiPacketServer, this.uiModuleCommunicator, this.timestampProvider);
        this.packetForwarderFromUiModuleToUserInterface = new FilteredPacketSendingForwarder(this.uiModuleCommunicator, this.uiPacketServer, this.timestampProvider);
        this.uiModuleCommunicator.attachListener(RobotConfigurationData.class, (PacketConsumer)this);
        this.setPacketForwardingFilters();
        this.connect();
    }

    private void setPacketForwardingFilters() {
        this.packetForwarderFromUserInterfaceToUiModule.enableUnfilteredForwarding();
        this.packetForwarderFromUiModuleToUserInterface.enableInclusiveForwarding((Class[])this.packetsAllowedToGotoUserInterface);
        for (Map.Entry<Class<?>, Long> entry : this.packetsAllowedToGotoUserInterfaceWithIntervals.entrySet()) {
            this.packetForwarderFromUiModuleToUserInterface.enableInclusiveForwardingWithMinimumRobotTimeIntervals(entry.getKey(), entry.getValue().longValue());
        }
    }

    public void connect() {
        try {
            this.uiPacketServer.connect();
            this.uiModuleCommunicator.connect();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isConnected() {
        return this.uiPacketServer.isConnected();
    }

    public void close() {
        this.uiPacketServer.disconnect();
        this.uiModuleCommunicator.disconnect();
    }

    public void receivedPacket(RobotConfigurationData packet) {
        this.timestampProvider.set(packet.getMonotonicTime());
    }
}

