/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules;

import controller_msgs.msg.dds.LocalizationPacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.ros.internal.message.Message;
import org.ros.message.MessageFactory;
import org.ros.node.NodeConfiguration;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.ros.IHMCPacketToMsgPublisher;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.ros.RosRobotConfigurationDataPublisher;
import us.ihmc.avatar.ros.RosSCSCameraPublisher;
import us.ihmc.avatar.ros.RosSCSLidarPublisher;
import us.ihmc.avatar.ros.RosTfPublisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.ros.generators.RosMessagePacket;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.log.LogTools;
import us.ihmc.perception.ros1.IHMCETHRosLocalizationUpdateSubscriber;
import us.ihmc.perception.ros1.RosLocalizationServiceClient;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.robotics.partNames.JointNameMap;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotRosVisionSensorInformation;
import us.ihmc.sensorProcessing.parameters.AvatarRobotVisionSensorInformation;
import us.ihmc.sensorProcessing.parameters.HumanoidForceSensorInformation;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosNodeInterface;
import us.ihmc.utilities.ros.msgToPacket.converter.GenericROSTranslationTools;

public class RosModule
implements CloseableAndDisposable {
    private static final boolean CREATE_ROS_ECHO_PUBLISHER = false;
    private static final String ROS_NODE_NAME = "networkProcessor/rosModule";
    private final boolean manageROS2Node;
    private final RealtimeROS2Node ros2Node;
    private final RosMainNode rosMainNode;
    private final RobotROSClockCalculator rosClockCalculator;
    private final AvatarRobotRosVisionSensorInformation sensorInformation;
    private final String robotName;
    private RosRobotConfigurationDataPublisher robotConfigurationPublisher;

    public RosModule(DRCRobotModel robotModel, URI rosCoreURI, ObjectCommunicator simulatedSensorCommunicator, RealtimeROS2Node realtimeROS2Node) {
        this((FullRobotModelFactory)robotModel, robotModel.getROSClockCalculator(), (AvatarRobotRosVisionSensorInformation)robotModel.getSensorInformation(), (HumanoidForceSensorInformation)robotModel.getSensorInformation(), (JointNameMap<?>)robotModel.getJointMap(), rosCoreURI, simulatedSensorCommunicator, (ROS2Topic<?>)ROS2Tools.getControllerOutputTopic((String)robotModel.getRobotDefinition().getName()).withTypeName(RobotConfigurationData.class), realtimeROS2Node);
    }

    public RosModule(DRCRobotModel robotModel, URI rosCoreURI, ObjectCommunicator simulatedSensorCommunicator, DomainFactory.PubSubImplementation pubSubImplementation) {
        this((FullRobotModelFactory)robotModel, robotModel.getROSClockCalculator(), (AvatarRobotRosVisionSensorInformation)robotModel.getSensorInformation(), (HumanoidForceSensorInformation)robotModel.getSensorInformation(), (JointNameMap<?>)robotModel.getJointMap(), rosCoreURI, simulatedSensorCommunicator, (ROS2Topic<?>)ROS2Tools.getControllerOutputTopic((String)robotModel.getRobotDefinition().getName()).withTypeName(RobotConfigurationData.class), pubSubImplementation);
    }

    public RosModule(FullRobotModelFactory robotModelFactory, RobotROSClockCalculator rosClockCalculator, AvatarRobotRosVisionSensorInformation sensorInformation, HumanoidForceSensorInformation forceSensorInformation, JointNameMap<?> jointMap, URI rosCoreURI, ObjectCommunicator simulatedSensorCommunicator, ROS2Topic<?> robotConfigurationDataTopicName, RealtimeROS2Node realtimeROS2Node) {
        this(robotModelFactory, rosClockCalculator, sensorInformation, forceSensorInformation, jointMap, rosCoreURI, simulatedSensorCommunicator, robotConfigurationDataTopicName, realtimeROS2Node, null);
    }

    public RosModule(FullRobotModelFactory robotModelFactory, RobotROSClockCalculator rosClockCalculator, AvatarRobotRosVisionSensorInformation sensorInformation, HumanoidForceSensorInformation forceSensorInformation, JointNameMap<?> jointMap, URI rosCoreURI, ObjectCommunicator simulatedSensorCommunicator, ROS2Topic<?> robotConfigurationDataTopicName, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(robotModelFactory, rosClockCalculator, sensorInformation, forceSensorInformation, jointMap, rosCoreURI, simulatedSensorCommunicator, robotConfigurationDataTopicName, null, pubSubImplementation);
    }

    private RosModule(FullRobotModelFactory robotModelFactory, RobotROSClockCalculator rosClockCalculator, AvatarRobotRosVisionSensorInformation sensorInformation, HumanoidForceSensorInformation forceSensorInformation, JointNameMap<?> jointMap, URI rosCoreURI, ObjectCommunicator simulatedSensorCommunicator, ROS2Topic<?> robotConfigurationDataTopicName, RealtimeROS2Node realtimeROS2Node, DomainFactory.PubSubImplementation pubSubImplementation) {
        LogTools.info((String)"Starting ROS Module");
        String simpleRobotName = robotModelFactory.getRobotDefinition().getName();
        boolean bl = this.manageROS2Node = realtimeROS2Node == null;
        if (realtimeROS2Node == null) {
            realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)pubSubImplementation, (String)"ihmc_ros_node");
        }
        this.ros2Node = realtimeROS2Node;
        this.rosMainNode = new RosMainNode(rosCoreURI, ROS_NODE_NAME, true);
        this.robotName = simpleRobotName.toLowerCase();
        String rosTopicPrefix = "/ihmc_ros/" + this.robotName;
        this.rosClockCalculator = rosClockCalculator;
        this.rosClockCalculator.subscribeToROS1Topics((RosNodeInterface)this.rosMainNode);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, RobotConfigurationData.class, robotConfigurationDataTopicName, s -> this.rosClockCalculator.receivedRobotConfigurationData((RobotConfigurationData)s.takeNextData()));
        this.sensorInformation = sensorInformation;
        RosTfPublisher tfPublisher = new RosTfPublisher(this.rosMainNode, null);
        this.robotConfigurationPublisher = new RosRobotConfigurationDataPublisher(robotModelFactory, this.ros2Node, robotConfigurationDataTopicName, this.rosMainNode, rosClockCalculator, this.sensorInformation, forceSensorInformation, jointMap, rosTopicPrefix, tfPublisher);
        if (simulatedSensorCommunicator != null) {
            this.publishSimulatedCameraAndLidar(robotModelFactory.createFullRobotModel(), (AvatarRobotVisionSensorInformation)sensorInformation, simulatedSensorCommunicator);
            AvatarRobotLidarParameters[] lidarParameters = sensorInformation.getLidarParameters();
            if (lidarParameters.length > 0) {
                AvatarRobotLidarParameters primaryLidar = lidarParameters[0];
                this.robotConfigurationPublisher.setAdditionalJointStatePublishing(primaryLidar.getLidarSpindleJointTopic(), primaryLidar.getLidarSpindleJointName());
            }
        }
        if (sensorInformation.setupROSLocationService()) {
            this.setupRosLocalization();
        }
        System.out.flush();
        if (this.manageROS2Node) {
            this.ros2Node.spin();
        }
        this.rosMainNode.execute();
        LogTools.info((String)"Finished starting ROS Module");
    }

    private void publishSimulatedCameraAndLidar(FullRobotModel fullRobotModel, AvatarRobotVisionSensorInformation sensorInformation, ObjectCommunicator localObjectCommunicator) {
        if (sensorInformation.getCameraParameters().length > 0) {
            new RosSCSCameraPublisher(localObjectCommunicator, this.rosMainNode, this.rosClockCalculator, sensorInformation.getCameraParameters());
        }
        if (sensorInformation.getLidarParameters().length > 0) {
            new RosSCSLidarPublisher(localObjectCommunicator, this.rosMainNode, this.rosClockCalculator, fullRobotModel, sensorInformation.getLidarParameters());
        }
    }

    private void setupRosLocalization() {
        new IHMCETHRosLocalizationUpdateSubscriber(this.robotName, this.rosMainNode, this.ros2Node, this.rosClockCalculator::computeRobotMonotonicTime);
        RosLocalizationServiceClient rosLocalizationServiceClient = new RosLocalizationServiceClient(this.rosMainNode);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, LocalizationPacket.class, (ROS2Topic)ROS2Tools.IHMC_ROOT, s -> rosLocalizationServiceClient.receivedPacket((LocalizationPacket)s.takeNextData()));
    }

    private void setupROSEchoPublisher(RosMainNode rosMainNode, String namespace) {
        PacketCommunicator uiPacketCommunicator = PacketCommunicator.createIntraprocessPacketCommunicator((NetworkPorts)NetworkPorts.UI_MODULE, (NetClassList)new IHMCCommunicationKryoNetClassList());
        try {
            uiPacketCommunicator.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NodeConfiguration nodeConfiguration = NodeConfiguration.newPrivate();
        MessageFactory messageFactory = nodeConfiguration.getTopicMessageFactory();
        Set inputTypes = GenericROSTranslationTools.getCoreInputTopics();
        for (Class inputType : inputTypes) {
            RosMessagePacket rosAnnotation = inputType.getAnnotation(RosMessagePacket.class);
            String rosMessageClassNameFromIHMCMessage = GenericROSTranslationTools.getRosMessageClassNameFromIHMCMessage((String)inputType.getSimpleName());
            Message message = (Message)messageFactory.newFromType(rosAnnotation.rosPackage() + "/" + rosMessageClassNameFromIHMCMessage);
            IHMCPacketToMsgPublisher publisher = IHMCPacketToMsgPublisher.createIHMCPacketToMsgPublisher(message, false, uiPacketCommunicator, inputType);
            String topic = rosAnnotation.topic();
            topic = topic.replaceFirst("control", "output");
            rosMainNode.attachPublisher(namespace + topic, publisher);
        }
    }

    public void closeAndDispose() {
        this.robotConfigurationPublisher.closeAndDispose();
        this.rosMainNode.shutdown();
        if (this.manageROS2Node) {
            this.ros2Node.destroy();
        }
    }
}

