/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import java.util.Arrays;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.robotics.math.QuaternionCalculus;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoKinematicsToolboxOutputStatus {
    private final YoRegistry registry;
    private int numberOfJoints;
    private final YoEnum<Status> currentToolboxState;
    private final YoInteger jointNameHash;
    private final YoDouble[] desiredJointAngles;
    private final YoDouble[] desiredJointVelocities;
    private final YoFramePose3D desiredRootJointPose;
    private final YoFixedFrameSpatialVector desiredRootJointVelocity;
    private final KinematicsToolboxOutputStatus interpolationStatus = new KinematicsToolboxOutputStatus();
    private final Vector4D quaternionDot = new Vector4D();
    private final QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
    private final KinematicsToolboxOutputStatus status = new KinematicsToolboxOutputStatus();

    public YoKinematicsToolboxOutputStatus(String namePrefix, FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.currentToolboxState = new YoEnum(namePrefix + "CurrentToolboxState", this.registry, Status.class, true);
        this.jointNameHash = new YoInteger(namePrefix + "JointNameHash", this.registry);
        this.jointNameHash.set(Arrays.hashCode(oneDoFJoints));
        this.numberOfJoints = oneDoFJoints.length;
        this.desiredJointAngles = new YoDouble[this.numberOfJoints];
        this.desiredJointVelocities = new YoDouble[this.numberOfJoints];
        for (int i = 0; i < this.numberOfJoints; ++i) {
            String jointName = oneDoFJoints[i].getName();
            this.desiredJointAngles[i] = new YoDouble("q_d_" + namePrefix + "_" + jointName, this.registry);
            this.desiredJointVelocities[i] = new YoDouble("qd_d_" + namePrefix + "_" + jointName, this.registry);
        }
        this.desiredRootJointPose = new YoFramePose3D(namePrefix + "Desired" + rootJoint.getName(), ReferenceFrame.getWorldFrame(), this.registry);
        this.desiredRootJointVelocity = new YoFixedFrameSpatialVector(namePrefix + "DesiredVelocity" + rootJoint.getName(), ReferenceFrame.getWorldFrame(), this.registry);
    }

    public void setToNaN() {
        this.currentToolboxState.set(null);
        for (YoDouble desiredJointAngle : this.desiredJointAngles) {
            desiredJointAngle.setToNaN();
        }
        for (YoDouble desiredJointVelocity : this.desiredJointVelocities) {
            desiredJointVelocity.setToNaN();
        }
        this.desiredRootJointPose.setToNaN();
        this.desiredRootJointVelocity.setToNaN();
    }

    public void set(KinematicsToolboxOutputStatus status) {
        if (status.getJointNameHash() != this.jointNameHash.getValue()) {
            throw new IllegalArgumentException("Incompatible status");
        }
        this.currentToolboxState.set((Enum)Status.fromByte(status.getCurrentToolboxState()));
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.desiredJointAngles[i].set((double)status.getDesiredJointAngles().get(i));
            this.desiredJointVelocities[i].set((double)status.getDesiredJointVelocities().get(i));
        }
        this.desiredRootJointPose.set((Tuple3DReadOnly)status.getDesiredRootPosition(), (Orientation3DReadOnly)status.getDesiredRootOrientation());
        this.desiredRootJointVelocity.set((Vector3DReadOnly)status.getDesiredRootAngularVelocity(), (Vector3DReadOnly)status.getDesiredRootLinearVelocity());
    }

    public void set(YoKinematicsToolboxOutputStatus other) {
        this.jointNameHash.set(other.jointNameHash.getValue());
        this.currentToolboxState.set((Enum)((Status)other.currentToolboxState.getEnumValue()));
        this.numberOfJoints = other.numberOfJoints;
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.desiredJointAngles[i].set(other.desiredJointAngles[i].getValue());
            this.desiredJointVelocities[i].set(other.desiredJointVelocities[i].getValue());
        }
        this.desiredRootJointPose.set((FramePose3DReadOnly)other.desiredRootJointPose);
        this.desiredRootJointVelocity.set((SpatialVectorReadOnly)other.desiredRootJointVelocity);
    }

    public void interpolate(KinematicsToolboxOutputStatus end, double alpha) {
        this.interpolate(this.getStatus(), end, alpha);
    }

    public void interpolate(KinematicsToolboxOutputStatus start, KinematicsToolboxOutputStatus end, double alpha) {
        MessageTools.interpolateMessages((KinematicsToolboxOutputStatus)start, (KinematicsToolboxOutputStatus)end, (double)alpha, (KinematicsToolboxOutputStatus)this.interpolationStatus);
        this.set(this.interpolationStatus);
    }

    public void interpolate(KinematicsToolboxOutputStatus start, KinematicsToolboxOutputStatus end, double alpha, double alphaDot) {
        MessageTools.interpolate((KinematicsToolboxOutputStatus)start, (KinematicsToolboxOutputStatus)end, (double)alpha, (double)alphaDot, (KinematicsToolboxOutputStatus)this.interpolationStatus);
        this.set(this.interpolationStatus);
    }

    public void scaleVelocities(double scaleFactor) {
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.desiredJointVelocities[i].set(this.desiredJointVelocities[i].getValue() * scaleFactor);
        }
        this.desiredRootJointVelocity.scale(scaleFactor);
    }

    public void setDesiredVelocitiesByFiniteDifference(KinematicsToolboxOutputStatus previous, KinematicsToolboxOutputStatus current, double duration) {
        if (previous.getJointNameHash() != current.getJointNameHash()) {
            throw new RuntimeException("Output status are not compatible.");
        }
        for (int i = 0; i < this.numberOfJoints; ++i) {
            double qd = (double)(current.getDesiredJointAngles().get(i) - previous.getDesiredJointAngles().get(i)) / duration;
            this.desiredJointVelocities[i].set(qd);
        }
        this.desiredRootJointVelocity.getLinearPart().sub((Tuple3DReadOnly)current.getDesiredRootPosition(), (Tuple3DReadOnly)current.getDesiredRootPosition());
        this.desiredRootJointVelocity.getLinearPart().scale(1.0 / duration);
        this.desiredRootJointPose.getOrientation().inverseTransform((FixedFrameTuple3DBasics)this.desiredRootJointVelocity.getLinearPart());
        this.quaternionDot.sub((Tuple4DReadOnly)current.getDesiredRootOrientation(), (Tuple4DReadOnly)previous.getDesiredRootOrientation());
        this.quaternionDot.scale(1.0 / duration);
        this.quaternionCalculus.computeAngularVelocityInBodyFixedFrame((QuaternionReadOnly)this.desiredRootJointPose.getOrientation(), (Vector4DReadOnly)this.quaternionDot, (Vector3DBasics)this.desiredRootJointVelocity.getAngularPart());
    }

    public KinematicsToolboxOutputStatus getStatus() {
        this.status.setJointNameHash(this.jointNameHash.getValue());
        this.status.setCurrentToolboxState(Status.toByte((Status)this.currentToolboxState.getEnumValue()));
        this.status.getDesiredJointAngles().reset();
        this.status.getDesiredJointVelocities().reset();
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.status.getDesiredJointAngles().add((float)this.desiredJointAngles[i].getValue());
            this.status.getDesiredJointVelocities().add((float)this.desiredJointVelocities[i].getValue());
        }
        this.status.getDesiredRootPosition().set((Tuple3DReadOnly)this.desiredRootJointPose.getPosition());
        this.status.getDesiredRootOrientation().set((QuaternionReadOnly)this.desiredRootJointPose.getOrientation());
        this.status.getDesiredRootLinearVelocity().set((Tuple3DReadOnly)this.desiredRootJointVelocity.getLinearPart());
        this.status.getDesiredRootAngularVelocity().set((Tuple3DReadOnly)this.desiredRootJointVelocity.getAngularPart());
        return this.status;
    }

    public static enum Status {
        NO_STATUS,
        INITIALIZE_SUCCESSFUL,
        INITIALIZE_FAILURE_MISSING_RCD,
        RUNNING;

        public static final Status[] values;

        public static Status fromByte(byte enumAsByte) {
            if (enumAsByte == -1) {
                return null;
            }
            return values[enumAsByte];
        }

        public static byte toByte(Status status) {
            if (status == null) {
                return -1;
            }
            return (byte)status.ordinal();
        }

        static {
            values = Status.values();
        }
    }
}

