/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import toolbox_msgs.msg.dds.KinematicsStreamingToolboxConfigurationMessage;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.tools.UnitConversions;

public class KinematicsStreamingToolboxParameters {
    private double centerOfMassSafeMargin;
    private double centerOfMassHoldWeight;
    private double publishingSolutionPeriod;
    private double defaultArmMessageWeight;
    private double defaultNeckMessageWeight;
    private final Vector3D defaultPelvisMessageLinearWeight = new Vector3D();
    private final Vector3D defaultPelvisMessageAngularWeight = new Vector3D();
    private final Vector3D defaultChestMessageAngularWeight = new Vector3D();
    private double defaultPelvisMessageLockWeight;
    private double defaultChestMessageLockWeight;
    private double defaultLinearWeight;
    private double defaultAngularWeight;
    private double defaultLinearRateLimit;
    private double defaultAngularRateLimit;
    private double outputJointVelocityScale;
    private boolean minimizeAngularMomentum;
    private boolean minimizeLinearMomentum;
    private double angularMomentumWeight;
    private double linearMomentumWeight;
    private double defaultStreamingBlendingDuration;
    private double inputPoseLPFBreakFrequency;
    private double inputWeightDecayDuration;
    private double inputVelocityDecayDuration;
    private boolean useStreamingPublisher;
    private double publishingPeriod;
    private final KinematicsStreamingToolboxConfigurationMessage defaultConfiguration = new KinematicsStreamingToolboxConfigurationMessage();

    public static KinematicsStreamingToolboxParameters defaultParameters() {
        KinematicsStreamingToolboxParameters parameters = new KinematicsStreamingToolboxParameters();
        parameters.setDefault();
        return parameters;
    }

    public void setDefault() {
        this.centerOfMassSafeMargin = 0.05;
        this.centerOfMassHoldWeight = 0.001;
        this.publishingSolutionPeriod = UnitConversions.hertzToSeconds((double)60.0);
        this.defaultArmMessageWeight = 10.0;
        this.defaultNeckMessageWeight = 10.0;
        this.defaultPelvisMessageLinearWeight.set(2.5, 2.5, 2.5);
        this.defaultPelvisMessageAngularWeight.set(1.0, 1.0, 1.0);
        this.defaultChestMessageAngularWeight.set(0.75, 0.75, 0.75);
        this.defaultPelvisMessageLockWeight = 1000.0;
        this.defaultChestMessageLockWeight = 1000.0;
        this.defaultLinearWeight = 20.0;
        this.defaultAngularWeight = 1.0;
        this.defaultLinearRateLimit = 1.5;
        this.defaultAngularRateLimit = 10.0;
        this.outputJointVelocityScale = 0.75;
        this.minimizeAngularMomentum = true;
        this.minimizeLinearMomentum = false;
        this.angularMomentumWeight = 0.125;
        this.linearMomentumWeight = 0.0;
        this.defaultStreamingBlendingDuration = 2.0;
        this.inputPoseLPFBreakFrequency = 4.0;
        this.inputWeightDecayDuration = 3.0;
        this.inputVelocityDecayDuration = 0.5;
        this.useStreamingPublisher = true;
        this.publishingPeriod = 0.03;
        this.defaultConfiguration.setLockPelvis(false);
        this.defaultConfiguration.setLockChest(false);
        this.defaultConfiguration.setEnableLeftArmJointspace(true);
        this.defaultConfiguration.setEnableRightArmJointspace(true);
        this.defaultConfiguration.setEnableNeckJointspace(true);
        this.defaultConfiguration.setEnableLeftHandTaskspace(true);
        this.defaultConfiguration.setEnableRightHandTaskspace(true);
        this.defaultConfiguration.setEnableChestTaskspace(true);
        this.defaultConfiguration.setEnablePelvisTaskspace(true);
        this.defaultConfiguration.setLeftHandTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
        this.defaultConfiguration.setRightHandTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
        this.defaultConfiguration.setChestTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
        this.defaultConfiguration.setPelvisTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
    }

    public double getCenterOfMassSafeMargin() {
        return this.centerOfMassSafeMargin;
    }

    public double getCenterOfMassHoldWeight() {
        return this.centerOfMassHoldWeight;
    }

    public double getPublishingSolutionPeriod() {
        return this.publishingSolutionPeriod;
    }

    public double getDefaultArmMessageWeight() {
        return this.defaultArmMessageWeight;
    }

    public double getDefaultNeckMessageWeight() {
        return this.defaultNeckMessageWeight;
    }

    public Vector3D getDefaultPelvisMessageLinearWeight() {
        return this.defaultPelvisMessageLinearWeight;
    }

    public Vector3D getDefaultPelvisMessageAngularWeight() {
        return this.defaultPelvisMessageAngularWeight;
    }

    public Vector3D getDefaultChestMessageAngularWeight() {
        return this.defaultChestMessageAngularWeight;
    }

    public double getDefaultPelvisMessageLockWeight() {
        return this.defaultPelvisMessageLockWeight;
    }

    public double getDefaultChestMessageLockWeight() {
        return this.defaultChestMessageLockWeight;
    }

    public double getDefaultLinearWeight() {
        return this.defaultLinearWeight;
    }

    public double getDefaultAngularWeight() {
        return this.defaultAngularWeight;
    }

    public double getDefaultLinearRateLimit() {
        return this.defaultLinearRateLimit;
    }

    public double getDefaultAngularRateLimit() {
        return this.defaultAngularRateLimit;
    }

    public double getOutputJointVelocityScale() {
        return this.outputJointVelocityScale;
    }

    public boolean isMinimizeAngularMomentum() {
        return this.minimizeAngularMomentum;
    }

    public boolean isMinimizeLinearMomentum() {
        return this.minimizeLinearMomentum;
    }

    public double getAngularMomentumWeight() {
        return this.angularMomentumWeight;
    }

    public double getLinearMomentumWeight() {
        return this.linearMomentumWeight;
    }

    public double getDefaultStreamingBlendingDuration() {
        return this.defaultStreamingBlendingDuration;
    }

    public double getInputPoseLPFBreakFrequency() {
        return this.inputPoseLPFBreakFrequency;
    }

    public double getInputWeightDecayDuration() {
        return this.inputWeightDecayDuration;
    }

    public double getInputVelocityDecayDuration() {
        return this.inputVelocityDecayDuration;
    }

    public boolean getUseStreamingPublisher() {
        return this.useStreamingPublisher;
    }

    public KinematicsStreamingToolboxConfigurationMessage getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setCenterOfMassSafeMargin(double centerOfMassSafeMargin) {
        this.centerOfMassSafeMargin = centerOfMassSafeMargin;
    }

    public void setCenterOfMassHoldWeight(double centerOfMassHoldWeight) {
        this.centerOfMassHoldWeight = centerOfMassHoldWeight;
    }

    public void setPublishingSolutionPeriod(double publishingSolutionPeriod) {
        this.publishingSolutionPeriod = publishingSolutionPeriod;
    }

    public void setDefaultArmMessageWeight(double defaultArmMessageWeight) {
        this.defaultArmMessageWeight = defaultArmMessageWeight;
    }

    public void setDefaultNeckMessageWeight(double defaultNeckMessageWeight) {
        this.defaultNeckMessageWeight = defaultNeckMessageWeight;
    }

    public void setDefaultPelvisMessageLinearWeight(double xWeight, double yWeight, double zWeight) {
        this.defaultPelvisMessageLinearWeight.set(xWeight, yWeight, zWeight);
    }

    public void setDefaultPelvisMessageAngularWeight(double xWeight, double yWeight, double zWeight) {
        this.defaultPelvisMessageAngularWeight.set(xWeight, yWeight, zWeight);
    }

    public void setDefaultChestMessageAngularWeight(double xWeight, double yWeight, double zWeight) {
        this.defaultChestMessageAngularWeight.set(xWeight, yWeight, zWeight);
    }

    public void setDefaultPelvisMessageLockWeight(double defaultPelvisMessageLockWeight) {
        this.defaultPelvisMessageLockWeight = defaultPelvisMessageLockWeight;
    }

    public void setDefaultChestMessageLockWeight(double defaultChestMessageLockWeight) {
        this.defaultChestMessageLockWeight = defaultChestMessageLockWeight;
    }

    public void setDefaultLinearWeight(double defaultLinearWeight) {
        this.defaultLinearWeight = defaultLinearWeight;
    }

    public void setDefaultAngularWeight(double defaultAngularWeight) {
        this.defaultAngularWeight = defaultAngularWeight;
    }

    public void setDefaultLinearRateLimit(double defaultLinearRateLimit) {
        this.defaultLinearRateLimit = defaultLinearRateLimit;
    }

    public void setDefaultAngularRateLimit(double defaultAngularRateLimit) {
        this.defaultAngularRateLimit = defaultAngularRateLimit;
    }

    public void setOutputJointVelocityScale(double outputJointVelocityScale) {
        this.outputJointVelocityScale = outputJointVelocityScale;
    }

    public void setMinimizeAngularMomentum(boolean minimizeAngularMomentum) {
        this.minimizeAngularMomentum = minimizeAngularMomentum;
    }

    public void setMinimizeLinearMomentum(boolean minimizeLinearMomentum) {
        this.minimizeLinearMomentum = minimizeLinearMomentum;
    }

    public void setAngularMomentumWeight(double angularMomentumWeight) {
        this.angularMomentumWeight = angularMomentumWeight;
    }

    public void setLinearMomentumWeight(double linearMomentumWeight) {
        this.linearMomentumWeight = linearMomentumWeight;
    }

    public void setDefaultStreamingBlendingDuration(double defaultStreamingBlendingDuration) {
        this.defaultStreamingBlendingDuration = defaultStreamingBlendingDuration;
    }

    public void setInputPoseLPFBreakFrequency(double inputPoseLPFBreakFrequency) {
        this.inputPoseLPFBreakFrequency = inputPoseLPFBreakFrequency;
    }

    public void setInputWeightDecayDuration(double inputWeightDecayDuration) {
        this.inputWeightDecayDuration = inputWeightDecayDuration;
    }

    public void setInputVelocityDecayDuration(double inputVelocityDecayDuration) {
        this.inputVelocityDecayDuration = inputVelocityDecayDuration;
    }

    public void setUseStreamingPublisher(boolean useStreamingPublisher) {
        this.useStreamingPublisher = useStreamingPublisher;
    }

    public void setPublishingPeriod(double publishingPeriod) {
        this.publishingPeriod = publishingPeriod;
    }

    public double getPublishingPeriod() {
        return this.publishingPeriod;
    }
}

