/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInputMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import toolbox_msgs.msg.dds.ToolboxStateMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KinematicsStreamingToolboxController;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WholeBodySetpointParameters;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.util.JVMStatisticsGenerator;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class KinematicsStreamingToolboxModule
extends ToolboxModule {
    private static final int DEFAULT_UPDATE_PERIOD_MILLISECONDS = 5;
    protected final KinematicsStreamingToolboxController controller;
    private IHMCROS2Publisher<WholeBodyTrajectoryMessage> trajectoryMessagePublisher;
    private IHMCROS2Publisher<WholeBodyStreamingMessage> streamingMessagePublisher;

    public KinematicsStreamingToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(robotModel, KinematicsStreamingToolboxParameters.defaultParameters(), startYoVariableServer, pubSubImplementation);
    }

    public KinematicsStreamingToolboxModule(DRCRobotModel robotModel, KinematicsStreamingToolboxParameters parameters, boolean startYoVariableServer, DomainFactory.PubSubImplementation pubSubImplementation) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 5, pubSubImplementation);
        this.setTimeWithoutInputsBeforeGoingToSleep(3.0);
        this.controller = new KinematicsStreamingToolboxController(this.commandInputManager, this.statusOutputManager, parameters, this.fullRobotModel, (FullHumanoidRobotModelFactory)robotModel, robotModel.getControllerDT(), Conversions.millisecondsToSeconds((double)this.updatePeriodMilliseconds), this.yoGraphicsListRegistry, this.registry);
        this.controller.setCollisionModel(robotModel.getHumanoidRobotKinematicsCollisionModel());
        Map<String, Double> initialConfiguration = KinematicsStreamingToolboxModule.fromStandPrep(robotModel);
        if (initialConfiguration != null) {
            this.controller.setInitialRobotConfigurationNamedMap(initialConfiguration);
        }
        this.controller.setTrajectoryMessagePublisher(arg_0 -> this.trajectoryMessagePublisher.publish(arg_0));
        this.controller.setStreamingMessagePublisher(arg_0 -> this.streamingMessagePublisher.publish(arg_0));
        this.startYoVariableServer();
        if (this.yoVariableServer != null) {
            JVMStatisticsGenerator jvmStatisticsGenerator = new JVMStatisticsGenerator((RobotVisualizer)this.yoVariableServer);
            jvmStatisticsGenerator.start();
        }
    }

    private static Map<String, Double> fromStandPrep(DRCRobotModel robotModel) {
        WholeBodySetpointParameters standPrepParameters = robotModel.getHighLevelControllerParameters().getStandPrepParameters();
        if (standPrepParameters == null) {
            return null;
        }
        HashMap<String, Double> initialConfigurationMap = new HashMap<String, Double>();
        FullHumanoidRobotModel fullRobotModel = robotModel.createFullRobotModel();
        for (OneDoFJointBasics joint : fullRobotModel.getOneDoFJoints()) {
            String jointName = joint.getName();
            initialConfigurationMap.put(jointName, standPrepParameters.getSetpoint(jointName));
        }
        return initialConfigurationMap;
    }

    @Override
    public void registerExtraPuSubs(ROS2NodeInterface ros2Node) {
        ROS2Topic controllerInputTopic = ROS2Tools.getControllerInputTopic((String)this.robotName);
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)this.robotName);
        this.trajectoryMessagePublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, WholeBodyTrajectoryMessage.class, (ROS2Topic)controllerInputTopic);
        this.streamingMessagePublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, WholeBodyStreamingMessage.class, (ROS2Topic)controllerInputTopic);
        RobotConfigurationData robotConfigurationData = new RobotConfigurationData();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.controller != null) {
                s.takeNextData((Object)robotConfigurationData, null);
                this.controller.updateRobotConfigurationData(robotConfigurationData);
            }
        });
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.controller != null) {
                s.takeNextData((Object)capturabilityBasedStatus, null);
                this.controller.updateCapturabilityBasedStatus(capturabilityBasedStatus);
            }
        });
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return KinematicsStreamingToolboxModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(KinematicsStreamingToolboxInputCommand.class);
        commands.add(KinematicsStreamingToolboxConfigurationCommand.class);
        commands.add(KinematicsToolboxConfigurationCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return KinematicsStreamingToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(KinematicsToolboxOutputStatus.class);
        status.add(ControllerCrashNotificationPacket.class);
        return status;
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return KinematicsStreamingToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ROS2Tools.KINEMATICS_STREAMING_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return KinematicsStreamingToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ROS2Tools.KINEMATICS_STREAMING_TOOLBOX.withRobot(robotName).withInput();
    }

    public static ROS2Topic<ToolboxStateMessage> getInputStateTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getInputTopic(robotName).withTypeName(ToolboxStateMessage.class);
    }

    public static ROS2Topic<KinematicsStreamingToolboxInputMessage> getInputCommandTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getInputTopic(robotName).withTypeName(KinematicsStreamingToolboxInputMessage.class);
    }

    public static ROS2Topic<KinematicsStreamingToolboxConfigurationMessage> getInputStreamingConfigurationTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getInputTopic(robotName).withTypeName(KinematicsStreamingToolboxConfigurationMessage.class);
    }

    public static ROS2Topic<KinematicsToolboxConfigurationMessage> getInputToolboxConfigurationTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getInputTopic(robotName).withTypeName(KinematicsToolboxConfigurationMessage.class);
    }

    public static ROS2Topic<KinematicsToolboxOutputStatus> getOutputStatusTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getOutputTopic(robotName).withTypeName(KinematicsToolboxOutputStatus.class);
    }

    public static ROS2Topic<ControllerCrashNotificationPacket> getOutputCrashNotificationTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getOutputTopic(robotName).withTypeName(ControllerCrashNotificationPacket.class);
    }
}

