/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import com.google.common.base.CaseFormat;
import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.CapturabilityBasedStatusPubSubType;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.RobotConfigurationDataPubSubType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInputMessage;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInputMessagePubSubType;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessagePubSubType;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatusPubSubType;
import toolbox_msgs.msg.dds.ToolboxStateMessage;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KinematicsStreamingToolboxModule;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.Packet;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.tools.thread.CloseableAndDisposable;

public class KinematicsStreamingToolboxMessageLogger
implements CloseableAndDisposable {
    private static final long recordPeriodMillis = 5L;
    private static final double maximumRecordTimeSeconds = 300.0;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final String logDirectory = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "logs" + File.separator;
    private final String robotName;
    static final String timestampName = "Timestamp";
    static final String robotConfigurationDataName = RobotConfigurationData.class.getSimpleName();
    static final String capturabilityBasedStatusName = CapturabilityBasedStatus.class.getSimpleName();
    static final String kinematicsToolboxConfigurationMessageName = KinematicsToolboxConfigurationMessage.class.getSimpleName();
    static final String kinematicsStreamingToolboxInputMessageName = KinematicsStreamingToolboxInputMessage.class.getSimpleName();
    static final String kinematicsToolboxOutputStatusName = KinematicsToolboxOutputStatus.class.getSimpleName();
    private final RealtimeROS2Node ros2Node;
    private final AtomicReference<RobotConfigurationData> robotConfigurationData = new AtomicReference();
    private final AtomicReference<CapturabilityBasedStatus> capturabilityBasedStatus = new AtomicReference();
    private final AtomicReference<KinematicsToolboxConfigurationMessage> kinematicsToolboxConfigurationMessage = new AtomicReference();
    private final AtomicReference<KinematicsStreamingToolboxInputMessage> kinematicsStreamingToolboxInputMessage = new AtomicReference();
    private final AtomicReference<KinematicsToolboxOutputStatus> kinematicsToolboxOutputStatus = new AtomicReference();
    private final AtomicBoolean firstMessage = new AtomicBoolean();
    private final AtomicBoolean stopRequested = new AtomicBoolean();
    private final JSONSerializer<RobotConfigurationData> robotConfigurationDataSerializer = new JSONSerializer((TopicDataType)new RobotConfigurationDataPubSubType());
    private final JSONSerializer<CapturabilityBasedStatus> capturabilityBasedStatusSerializer = new JSONSerializer((TopicDataType)new CapturabilityBasedStatusPubSubType());
    private final JSONSerializer<KinematicsToolboxConfigurationMessage> kinematicsToolboxConfigurationMessageSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxConfigurationMessagePubSubType());
    private final JSONSerializer<KinematicsStreamingToolboxInputMessage> kinematicsStreamingToolboxInputMessageSerializer = new JSONSerializer((TopicDataType)new KinematicsStreamingToolboxInputMessagePubSubType());
    private final JSONSerializer<KinematicsToolboxOutputStatus> kinematicsToolboxOutputStatusSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxOutputStatusPubSubType());
    private final ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
    private long startTimeMillis;
    private FileOutputStream outputStream = null;
    private PrintStream printStream = null;
    private Runnable loggerRunnable = null;
    private ScheduledFuture<?> loggerTaskScheduled = null;

    public KinematicsStreamingToolboxMessageLogger(String robotName, DomainFactory.PubSubImplementation pubSubImplementation) {
        this.robotName = robotName;
        this.ros2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)pubSubImplementation, (String)("ihmc_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "KinematicsStreamingToolboxMessageLogger")));
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> this.robotConfigurationData.set((RobotConfigurationData)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerOutputTopic, s -> this.capturabilityBasedStatus.set((CapturabilityBasedStatus)s.takeNextData()));
        ROS2Topic<?> toolboxInputTopic = KinematicsStreamingToolboxModule.getInputTopic(robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, ToolboxStateMessage.class, toolboxInputTopic, s -> this.processToolboxStateMessage((ToolboxStateMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, KinematicsToolboxConfigurationMessage.class, toolboxInputTopic, s -> this.kinematicsToolboxConfigurationMessage.set((KinematicsToolboxConfigurationMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, KinematicsStreamingToolboxInputMessage.class, toolboxInputTopic, s -> this.kinematicsStreamingToolboxInputMessage.set((KinematicsStreamingToolboxInputMessage)s.takeNextData()));
        ROS2Topic<?> toolboxOutputTopic = KinematicsStreamingToolboxModule.getOutputTopic(robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, KinematicsToolboxOutputStatus.class, toolboxOutputTopic, s -> this.kinematicsToolboxOutputStatus.set((KinematicsToolboxOutputStatus)s.takeNextData()));
        this.ros2Node.spin();
    }

    private void processToolboxStateMessage(ToolboxStateMessage message) {
        boolean sleepRequested;
        boolean loggingRequested = message.getRequestLogging();
        boolean bl = sleepRequested = message.getRequestedToolboxState() == 2;
        if (!sleepRequested && loggingRequested) {
            this.startLogging();
        } else {
            this.stopLogging();
        }
    }

    public void startLogging() {
        LogTools.info((String)"Starting logger...");
        if (this.loggerRunnable != null) {
            return;
        }
        String fileName = logDirectory + dateFormat.format(new Date()) + "_" + this.robotName + "KinematicsStreamingToolbox.json";
        try {
            this.outputStream = new FileOutputStream(fileName);
            this.printStream = new PrintStream(this.outputStream);
            this.loggerRunnable = this::logMessageFrame;
            this.startTimeMillis = System.currentTimeMillis();
            this.firstMessage.set(true);
            this.stopRequested.set(false);
            this.printStream.println("[");
            this.loggerTaskScheduled = this.executorService.scheduleAtFixedRate(this.loggerRunnable, 0L, 5L, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            this.loggerRunnable = null;
            this.executorService.shutdownNow();
            e.printStackTrace();
        }
    }

    public void stopLogging() {
        if (this.loggerRunnable == null) {
            return;
        }
        this.stopRequested.set(true);
    }

    private void logMessageFrame() {
        if (!this.containsNewMessage()) {
            return;
        }
        if (this.stopRequested.get() || (double)(System.currentTimeMillis() - this.startTimeMillis) > Conversions.secondsToMilliseconds((double)300.0)) {
            this.closeLog();
        }
        if (!this.firstMessage.get()) {
            this.printStream.println("},");
        }
        this.printStream.println("{");
        this.printStream.print("\"Timestamp\" : " + System.nanoTime());
        try {
            KinematicsStreamingToolboxMessageLogger.writeIfPresent(this.robotConfigurationData, robotConfigurationDataName, this.robotConfigurationDataSerializer, this.printStream);
            KinematicsStreamingToolboxMessageLogger.writeIfPresent(this.capturabilityBasedStatus, capturabilityBasedStatusName, this.capturabilityBasedStatusSerializer, this.printStream);
            KinematicsStreamingToolboxMessageLogger.writeIfPresent(this.kinematicsToolboxConfigurationMessage, kinematicsToolboxConfigurationMessageName, this.kinematicsToolboxConfigurationMessageSerializer, this.printStream);
            KinematicsStreamingToolboxMessageLogger.writeIfPresent(this.kinematicsStreamingToolboxInputMessage, kinematicsStreamingToolboxInputMessageName, this.kinematicsStreamingToolboxInputMessageSerializer, this.printStream);
            KinematicsStreamingToolboxMessageLogger.writeIfPresent(this.kinematicsToolboxOutputStatus, kinematicsToolboxOutputStatusName, this.kinematicsToolboxOutputStatusSerializer, this.printStream);
        }
        catch (IOException e) {
            LogTools.error((String)"Error logging messages. Shutting down logging process");
            this.shutdown();
            return;
        }
        if (this.firstMessage.get()) {
            this.firstMessage.set(false);
        }
    }

    private boolean containsNewMessage() {
        return this.robotConfigurationData.get() != null || this.capturabilityBasedStatus.get() != null || this.kinematicsToolboxConfigurationMessage.get() != null || this.kinematicsStreamingToolboxInputMessage.get() != null;
    }

    private void closeLog() {
        LogTools.info((String)"Closing log...");
        this.printStream.println("}");
        this.printStream.println("]");
        this.printStream.flush();
        this.printStream.close();
        this.shutdown();
    }

    private void shutdown() {
        if (this.loggerTaskScheduled != null) {
            this.loggerTaskScheduled.cancel(true);
            this.loggerTaskScheduled = null;
        }
        this.loggerRunnable = null;
        this.printStream = null;
        this.outputStream = null;
    }

    private static <T extends Packet> void writeIfPresent(AtomicReference<T> messageReference, String messageName, JSONSerializer<T> serializer, PrintStream printStream) throws IOException {
        Packet message = messageReference.getAndSet(null);
        if (message == null) {
            return;
        }
        printStream.println(",");
        printStream.println("\"" + messageName + "\" : ");
        printStream.write(serializer.serializeToBytes((Object)message));
    }

    public void closeAndDispose() {
        this.shutdown();
        this.ros2Node.destroy();
        this.executorService.shutdownNow();
    }

    public static void main(String[] args) {
        String robotName = "Valkyrie";
        new KinematicsStreamingToolboxMessageLogger(robotName, DomainFactory.PubSubImplementation.FAST_RTPS);
    }
}

