/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import ihmc_common_msgs.msg.dds.WeightMatrix3DMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxOneDoFJointMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KinematicsStreamingToolboxController;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.YoKinematicsToolboxOutputStatus;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxMessageFactory;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.controllers.pidGains.YoPIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePose3D;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameQuaternion;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class KSTStreamingState
implements State {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final KSTTools tools;
    private final double toolboxControllerPeriod;
    private final YoBoolean useStreamingPublisher = new YoBoolean("useStreamingPublisher", this.registry);
    private KinematicsStreamingToolboxController.WholeBodyTrajectoryMessagePublisher trajectoryMessagePublisher = m -> {};
    private KinematicsStreamingToolboxController.WholeBodyStreamingMessagePublisher streamingMessagePublisher = null;
    private final YoDouble timeOfLastMessageSentToController = new YoDouble("timeOfLastMessageSentToController", this.registry);
    private final YoDouble publishingPeriod = new YoDouble("publishingPeriod", this.registry);
    private final KinematicsToolboxConfigurationMessage configurationMessage = new KinematicsToolboxConfigurationMessage();
    private final FullHumanoidRobotModel desiredFullRobotModel;
    private final CommandInputManager ikCommandInputManager;
    private final List<KinematicsToolboxOneDoFJointMessage> defaultNeckJointMessages;
    private final KinematicsToolboxRigidBodyMessage defaultPelvisMessage = new KinematicsToolboxRigidBodyMessage();
    private final KinematicsToolboxRigidBodyMessage defaultChestMessage = new KinematicsToolboxRigidBodyMessage();
    private final SideDependentList<List<KinematicsToolboxOneDoFJointMessage>> defaultArmJointMessages = new SideDependentList();
    private final RigidBodyBasics head;
    private final OneDoFJointBasics[] neckJoints;
    private final RigidBodyBasics pelvis;
    private final RigidBodyBasics chest;
    private final SideDependentList<RigidBodyBasics> hands = new SideDependentList();
    private final SideDependentList<OneDoFJointBasics[]> armJoints = new SideDependentList();
    private final YoDouble lockPoseFilterBreakFrequency = new YoDouble("lockPoseFilterBreakFrequncy", this.registry);
    private final YoBoolean lockPelvis = new YoBoolean("lockPelvis", this.registry);
    private final YoBoolean lockChest = new YoBoolean("lockChest", this.registry);
    private final YoFramePose3D lockPelvisPose = new YoFramePose3D("lockPelvisPose", worldFrame, this.registry);
    private final AlphaFilteredYoFramePose3D lockPelvisPoseFiltered;
    private final YoFramePose3D lockChestPose = new YoFramePose3D("lockChestPose", worldFrame, this.registry);
    private final AlphaFilteredYoFramePose3D lockChestPoseFiltered;
    private final YoDouble defaultArmMessageWeight = new YoDouble("defaultArmMessageWeight", this.registry);
    private final YoDouble defaultNeckMessageWeight = new YoDouble("defaultNeckMessageWeight", this.registry);
    private final YoVector3D defaultPelvisMessageLinearWeight = new YoVector3D("defaultPelvisMessageLinearWeight", this.registry);
    private final YoVector3D defaultPelvisMessageAngularWeight = new YoVector3D("defaultPelvisMessageAngularWeight", this.registry);
    private final YoVector3D defaultChestMessageAngularWeight = new YoVector3D("defaultChestMessageAngularWeight", this.registry);
    private final YoDouble defaultPelvisMessageLockWeight = new YoDouble("defaultPelvisMessageLockWeight", this.registry);
    private final YoDouble defaultChestMessageLockWeight = new YoDouble("defaultChestMessageLockWeight", this.registry);
    private final YoDouble inputWeightDecayFactor;
    private final YoInteger numberOfDecayingInputs = new YoInteger("numberOfDecayingInputs", this.registry);
    private final Map<RigidBodyBasics, YoDouble> rigidBodyControlStartTimeMap = new HashMap<RigidBodyBasics, YoDouble>();
    private final YoDouble[] rigidBodyControlStartTimeArray;
    private final RecyclingArrayList<KinematicsToolboxRigidBodyCommand> decayingInputs = new RecyclingArrayList(KinematicsToolboxRigidBodyCommand::new);
    private final YoBoolean isStreaming = new YoBoolean("isStreaming", this.registry);
    private final YoBoolean wasStreaming = new YoBoolean("wasStreaming", this.registry);
    private final YoDouble linearRateLimit = new YoDouble("linearRateLimit", this.registry);
    private final YoDouble angularRateLimit = new YoDouble("angularRateLimit", this.registry);
    private final YoDouble defaultLinearRateLimit = new YoDouble("defaultLinearRateLimit", this.registry);
    private final YoDouble defaultAngularRateLimit = new YoDouble("defaultAngularRateLimit", this.registry);
    private final YoDouble defaultLinearWeight = new YoDouble("defaultLinearWeight", this.registry);
    private final YoDouble defaultAngularWeight = new YoDouble("defaultAngularWeight", this.registry);
    private final YoDouble streamingStartTime = new YoDouble("streamingStartTime", this.registry);
    private final YoDouble streamingBlendingDuration = new YoDouble("streamingBlendingDuration", this.registry);
    private final YoDouble solutionFilterBreakFrequency = new YoDouble("solutionFilterBreakFrequency", this.registry);
    private final YoKinematicsToolboxOutputStatus ikRobotState;
    private final YoKinematicsToolboxOutputStatus initialRobotState;
    private final YoKinematicsToolboxOutputStatus blendedRobotState;
    private final YoKinematicsToolboxOutputStatus filteredRobotState;
    private final YoKinematicsToolboxOutputStatus outputRobotState;
    private final YoDouble outputJointVelocityScale = new YoDouble("outputJointVelocityScale", this.registry);
    private final YoDouble timeOfLastInput = new YoDouble("timeOfLastInput", this.registry);
    private final YoDouble timeSinceLastInput = new YoDouble("timeSinceLastInput", this.registry);
    private final YoDouble rawInputFrequency = new YoDouble("rawInputFrequency", this.registry);
    private final AlphaFilteredYoVariable inputFrequency;
    private final YoDouble inputsFilterBreakFrequency = new YoDouble("inputsFilterBreakFrequency", this.registry);
    private final HumanoidKinematicsToolboxController ikController;
    private final YoPIDSE3Gains ikSolverSpatialGains;
    private final YoPIDGains ikSolverJointGains;
    private final Map<RigidBodyBasics, YoFramePoint3D> rawInputPositionMap = new HashMap<RigidBodyBasics, YoFramePoint3D>();
    private final Map<RigidBodyBasics, YoFrameQuaternion> rawInputOrientationMap = new HashMap<RigidBodyBasics, YoFrameQuaternion>();
    private final Map<RigidBodyBasics, YoFramePoint3D> rawExtrapolatedInputPositionMap = new HashMap<RigidBodyBasics, YoFramePoint3D>();
    private final Map<RigidBodyBasics, YoFrameQuaternion> rawExtrapolatedInputOrientationMap = new HashMap<RigidBodyBasics, YoFrameQuaternion>();
    private final Map<RigidBodyBasics, AlphaFilteredYoFramePoint> filteredExtrapolatedInputPositionMap = new HashMap<RigidBodyBasics, AlphaFilteredYoFramePoint>();
    private final Map<RigidBodyBasics, AlphaFilteredYoFrameQuaternion> filteredExtrapolatedInputOrientationMap = new HashMap<RigidBodyBasics, AlphaFilteredYoFrameQuaternion>();
    private final YoFixedFrameSpatialVector[] rawInputSpatialVelocityArray;
    private final Map<RigidBodyBasics, YoFixedFrameSpatialVector> rawInputSpatialVelocityMap = new HashMap<RigidBodyBasics, YoFixedFrameSpatialVector>();
    private final YoFixedFrameSpatialVector[] decayingInputSpatialVelocityArray;
    private final Map<RigidBodyBasics, YoFixedFrameSpatialVector> decayingInputSpatialVelocityMap = new HashMap<RigidBodyBasics, YoFixedFrameSpatialVector>();
    private final YoDouble inputVelocityDecayFactor = new YoDouble("inputVelocityDecayFactor", this.registry);
    private final YoDouble inputVelocityDecayDuration = new YoDouble("inputVelocityDecayDuration", this.registry);
    private boolean resetFilter = false;
    private final KinematicsStreamingToolboxInputCommand rawInputs = new KinematicsStreamingToolboxInputCommand();
    private final KinematicsStreamingToolboxInputCommand filteredInputs = new KinematicsStreamingToolboxInputCommand();
    private final List<RigidBodyBasics> uncontrolledRigidBodies = new ArrayList<RigidBodyBasics>();

    public KSTStreamingState(KSTTools tools) {
        KinematicsStreamingToolboxParameters parameters = tools.getParameters();
        this.useStreamingPublisher.set(parameters.getUseStreamingPublisher());
        this.tools = tools;
        this.toolboxControllerPeriod = tools.getToolboxControllerPeriod();
        this.ikController = tools.getIKController();
        this.ikSolverSpatialGains = this.ikController.getDefaultSpatialGains();
        this.ikSolverJointGains = this.ikController.getDefaultJointGains();
        this.ikController.getCenterOfMassSafeMargin().set(parameters.getCenterOfMassSafeMargin());
        this.ikController.setPublishingSolutionPeriod(parameters.getPublishingSolutionPeriod());
        this.ikController.getMomentumWeight().set(parameters.getCenterOfMassHoldWeight());
        this.ikController.minimizeMomentum(parameters.isMinimizeAngularMomentum(), parameters.isMinimizeLinearMomentum());
        this.ikController.setMomentumWeight(parameters.getAngularMomentumWeight(), parameters.getLinearMomentumWeight());
        this.desiredFullRobotModel = tools.getDesiredFullRobotModel();
        this.ikCommandInputManager = tools.getIKCommandInputManager();
        tools.getRegistry().addChild(this.registry);
        this.head = this.desiredFullRobotModel.getHead();
        this.pelvis = this.desiredFullRobotModel.getPelvis();
        this.chest = this.desiredFullRobotModel.getChest();
        this.neckJoints = this.head == null ? new OneDoFJointBasics[0] : MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)this.chest, (RigidBodyBasics)this.head);
        this.defaultNeckJointMessages = Stream.of(this.neckJoints).map(joint -> KinematicsToolboxMessageFactory.newOneDoFJointMessage((OneDoFJointReadOnly)joint, (double)10.0, (double)0.0)).collect(Collectors.toList());
        this.defaultPelvisMessage.setEndEffectorHashCode(this.pelvis.hashCode());
        this.defaultPelvisMessage.getDesiredOrientationInWorld().setToZero();
        this.defaultChestMessage.setEndEffectorHashCode(this.chest.hashCode());
        this.defaultChestMessage.getDesiredOrientationInWorld().setToZero();
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics hand = this.desiredFullRobotModel.getHand(robotSide);
            OneDoFJointBasics[] joints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)this.chest, (RigidBodyBasics)hand);
            this.hands.put((Enum)robotSide, (Object)hand);
            this.armJoints.put((Enum)robotSide, (Object)joints);
            this.defaultArmJointMessages.put((Enum)robotSide, Stream.of(joints).map(joint -> KinematicsToolboxMessageFactory.newOneDoFJointMessage((OneDoFJointReadOnly)joint, (double)10.0, (double)0.0)).collect(Collectors.toList()));
        }
        this.defaultArmMessageWeight.set(parameters.getDefaultArmMessageWeight());
        this.defaultNeckMessageWeight.set(parameters.getDefaultNeckMessageWeight());
        this.defaultPelvisMessageLinearWeight.set((Tuple3DReadOnly)parameters.getDefaultPelvisMessageLinearWeight());
        this.defaultPelvisMessageAngularWeight.set((Tuple3DReadOnly)parameters.getDefaultPelvisMessageAngularWeight());
        this.defaultChestMessageAngularWeight.set((Tuple3DReadOnly)parameters.getDefaultChestMessageAngularWeight());
        this.defaultPelvisMessageLockWeight.set(parameters.getDefaultPelvisMessageLockWeight());
        this.defaultChestMessageLockWeight.set(parameters.getDefaultChestMessageLockWeight());
        this.defaultLinearWeight.set(parameters.getDefaultLinearWeight());
        this.defaultAngularWeight.set(parameters.getDefaultAngularWeight());
        this.publishingPeriod.set(parameters.getPublishingPeriod());
        this.defaultLinearRateLimit.set(parameters.getDefaultLinearRateLimit());
        this.defaultAngularRateLimit.set(parameters.getDefaultAngularRateLimit());
        this.outputJointVelocityScale.set(parameters.getOutputJointVelocityScale());
        this.streamingBlendingDuration.set(parameters.getDefaultStreamingBlendingDuration());
        this.solutionFilterBreakFrequency.set(Double.POSITIVE_INFINITY);
        FloatingJointBasics rootJoint = this.desiredFullRobotModel.getRootJoint();
        OneDoFJointBasics[] oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.desiredFullRobotModel);
        this.ikRobotState = new YoKinematicsToolboxOutputStatus("IK", rootJoint, oneDoFJoints, this.registry);
        this.initialRobotState = new YoKinematicsToolboxOutputStatus("Initial", rootJoint, oneDoFJoints, this.registry);
        this.blendedRobotState = new YoKinematicsToolboxOutputStatus("Blended", rootJoint, oneDoFJoints, this.registry);
        this.filteredRobotState = new YoKinematicsToolboxOutputStatus("Filtered", rootJoint, oneDoFJoints, this.registry);
        this.outputRobotState = new YoKinematicsToolboxOutputStatus("FD", rootJoint, oneDoFJoints, this.registry);
        DoubleProvider alpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.lockPoseFilterBreakFrequency.getValue(), (double)this.toolboxControllerPeriod);
        this.lockPoseFilterBreakFrequency.set(0.25);
        this.lockPelvisPoseFiltered = new AlphaFilteredYoFramePose3D("lockPelvisPoseFiltered", "", (FramePose3DReadOnly)this.lockPelvisPose, alpha, this.registry);
        this.lockChestPoseFiltered = new AlphaFilteredYoFramePose3D("lockChestPoseFiltered", "", (FramePose3DReadOnly)this.lockChestPose, alpha, this.registry);
        YoDouble inputFrequencyAlpha = new YoDouble("inputFrequencyFilter", this.registry);
        inputFrequencyAlpha.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)2.0, (double)this.toolboxControllerPeriod));
        this.inputFrequency = new AlphaFilteredYoVariable("inputFrequency", this.registry, (DoubleProvider)inputFrequencyAlpha, this.rawInputFrequency);
        this.inputWeightDecayFactor = new YoDouble("inputDecayFactor", this.registry);
        this.inputWeightDecayFactor.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)(1.0 / parameters.getInputWeightDecayDuration()), (double)this.toolboxControllerPeriod));
        List<? extends RigidBodyBasics> controllableRigidBodies = tools.getIKController().getControllableRigidBodies();
        DoubleProvider inputsAlphaProvider = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.inputsFilterBreakFrequency.getValue(), (double)this.toolboxControllerPeriod);
        this.inputsFilterBreakFrequency.set(parameters.getInputPoseLPFBreakFrequency());
        this.inputVelocityDecayDuration.set(parameters.getInputVelocityDecayDuration());
        for (RigidBodyBasics rigidBodyBasics : controllableRigidBodies) {
            String string = rigidBodyBasics.getName() + "Input";
            YoFramePoint3D rawInputPosition = new YoFramePoint3D(string + "RawPosition", worldFrame, this.registry);
            YoFrameQuaternion rawInputOrientation = new YoFrameQuaternion(string + "RawOrientation", worldFrame, this.registry);
            YoFramePoint3D rawExtrapolatedInputPosition = new YoFramePoint3D(string + "RawExtrapolatedPosition", worldFrame, this.registry);
            YoFrameQuaternion rawExtrapolatedInputOrientation = new YoFrameQuaternion(string + "RawExtrapolatedOrientation", worldFrame, this.registry);
            AlphaFilteredYoFramePoint filteredExtrapolatedInputPosition = new AlphaFilteredYoFramePoint(string + "FilteredExtrapolatedPosition", "", this.registry, inputsAlphaProvider, (FrameTuple3DReadOnly)rawExtrapolatedInputPosition);
            AlphaFilteredYoFrameQuaternion filteredExtrapolatedInputOrientation = new AlphaFilteredYoFrameQuaternion(string + "FilteredExtrapolatedOrientation", "", rawExtrapolatedInputOrientation, inputsAlphaProvider, this.registry);
            YoFixedFrameSpatialVector rawInputSpatialVelocity = new YoFixedFrameSpatialVector(string + "RawVelocity", worldFrame, this.registry);
            YoFixedFrameSpatialVector decayingInputSpatialVelocity = new YoFixedFrameSpatialVector(string + "DecayingVelocity", worldFrame, this.registry);
            this.rawInputPositionMap.put(rigidBodyBasics, rawInputPosition);
            this.rawInputOrientationMap.put(rigidBodyBasics, rawInputOrientation);
            this.rawExtrapolatedInputPositionMap.put(rigidBodyBasics, rawExtrapolatedInputPosition);
            this.rawExtrapolatedInputOrientationMap.put(rigidBodyBasics, rawExtrapolatedInputOrientation);
            this.filteredExtrapolatedInputPositionMap.put(rigidBodyBasics, filteredExtrapolatedInputPosition);
            this.filteredExtrapolatedInputOrientationMap.put(rigidBodyBasics, filteredExtrapolatedInputOrientation);
            this.rawInputSpatialVelocityMap.put(rigidBodyBasics, rawInputSpatialVelocity);
            this.decayingInputSpatialVelocityMap.put(rigidBodyBasics, decayingInputSpatialVelocity);
            YoDouble rigidBodyControlStartTime = new YoDouble(rigidBodyBasics.getName() + "ControlStartTime", this.registry);
            this.rigidBodyControlStartTimeMap.put(rigidBodyBasics, rigidBodyControlStartTime);
        }
        this.rawInputSpatialVelocityArray = new YoFixedFrameSpatialVector[controllableRigidBodies.size()];
        this.decayingInputSpatialVelocityArray = new YoFixedFrameSpatialVector[controllableRigidBodies.size()];
        this.rigidBodyControlStartTimeArray = new YoDouble[controllableRigidBodies.size()];
        int index = 0;
        for (RigidBodyBasics rigidBodyBasics : controllableRigidBodies) {
            this.rawInputSpatialVelocityArray[index] = this.rawInputSpatialVelocityMap.get(rigidBodyBasics);
            this.decayingInputSpatialVelocityArray[index] = this.decayingInputSpatialVelocityMap.get(rigidBodyBasics);
            this.rigidBodyControlStartTimeArray[index] = this.rigidBodyControlStartTimeMap.get(rigidBodyBasics);
            ++index;
        }
    }

    public void setTrajectoryMessagerPublisher(KinematicsStreamingToolboxController.WholeBodyTrajectoryMessagePublisher outputPublisher) {
        this.trajectoryMessagePublisher = outputPublisher;
    }

    public void setStreamingMessagePublisher(KinematicsStreamingToolboxController.WholeBodyStreamingMessagePublisher streamingMessagePublisher) {
        this.streamingMessagePublisher = streamingMessagePublisher;
    }

    public void onEntry() {
        this.isStreaming.set(false);
        this.wasStreaming.set(false);
        this.timeOfLastMessageSentToController.set(Double.NEGATIVE_INFINITY);
        this.ikSolverSpatialGains.setPositionProportionalGains(50.0);
        this.ikSolverSpatialGains.setOrientationProportionalGains(50.0);
        this.ikSolverSpatialGains.setPositionMaxFeedbackAndFeedbackRate(this.linearRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverSpatialGains.setOrientationMaxFeedbackAndFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverJointGains.setKp(50.0);
        this.ikSolverJointGains.setMaximumFeedbackAndMaximumFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.configurationMessage.setJointVelocityWeight(1.0);
        this.configurationMessage.setEnableJointVelocityLimits(true);
        this.ikCommandInputManager.submitMessage((Settable)this.configurationMessage);
        FullHumanoidRobotModel controllerFullRobotModel = this.tools.getCurrentFullRobotModel();
        for (OneDoFJointBasics oneDoFJointBasics : this.neckJoints) {
            oneDoFJointBasics.setQ(controllerFullRobotModel.getOneDoFJointByName(oneDoFJointBasics.getName()).getQ());
        }
        for (OneDoFJointBasics oneDoFJointBasics : RobotSide.values) {
            for (OneDoFJointBasics armJoint : (OneDoFJointBasics[])this.armJoints.get((Enum)oneDoFJointBasics)) {
                armJoint.setQ(controllerFullRobotModel.getOneDoFJointByName(armJoint.getName()).getQ());
            }
        }
        for (int i = 0; i < this.neckJoints.length; ++i) {
            this.defaultNeckJointMessages.get(i).setDesiredPosition(controllerFullRobotModel.getOneDoFJointByName(this.neckJoints[i].getName()).getQ());
            this.defaultNeckJointMessages.get(i).setWeight(this.defaultNeckMessageWeight.getValue());
        }
        this.lockPelvis.set(this.tools.getConfigurationCommand().isLockPelvis());
        if (this.lockPelvis.getValue()) {
            this.lockPelvisPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getPelvis().getBodyFixedFrame());
            this.lockPelvisPoseFiltered.update();
            this.defaultPelvisMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockPelvisPoseFiltered.getPosition());
            this.defaultPelvisMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockPelvisPoseFiltered.getOrientation());
            this.defaultPelvisMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            this.defaultPelvisMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((double)this.defaultPelvisMessageLockWeight.getValue(), (WeightMatrix3DMessage)this.defaultPelvisMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((double)this.defaultPelvisMessageLockWeight.getValue(), (WeightMatrix3DMessage)this.defaultPelvisMessage.getAngularWeightMatrix());
        } else {
            this.lockPelvisPoseFiltered.reset();
            this.lockPelvisPose.setFromReferenceFrame((ReferenceFrame)this.pelvis.getBodyFixedFrame());
            this.defaultPelvisMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockPelvisPose.getPosition());
            this.defaultPelvisMessage.getDesiredOrientationInWorld().setToYawOrientation(this.lockPelvisPose.getYaw());
            this.defaultPelvisMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)false, (boolean)false, (boolean)true, (ReferenceFrame)worldFrame));
            this.defaultPelvisMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((Tuple3DReadOnly)this.defaultPelvisMessageLinearWeight, (WeightMatrix3DMessage)this.defaultPelvisMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((Tuple3DReadOnly)this.defaultPelvisMessageAngularWeight, (WeightMatrix3DMessage)this.defaultPelvisMessage.getAngularWeightMatrix());
        }
        this.lockChest.set(this.tools.getConfigurationCommand().isLockChest());
        if (this.lockChest.getValue()) {
            this.lockChestPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getChest().getBodyFixedFrame());
            this.lockChestPoseFiltered.update();
            this.defaultChestMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockChestPoseFiltered.getPosition());
            this.defaultChestMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockChestPoseFiltered.getOrientation());
            this.defaultChestMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            this.defaultChestMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((double)this.defaultChestMessageLockWeight.getValue(), (WeightMatrix3DMessage)this.defaultChestMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((double)this.defaultChestMessageLockWeight.getValue(), (WeightMatrix3DMessage)this.defaultChestMessage.getAngularWeightMatrix());
        } else {
            this.lockChestPoseFiltered.reset();
            this.lockChestPose.setFromReferenceFrame((ReferenceFrame)this.chest.getBodyFixedFrame());
            this.defaultChestMessage.getDesiredPositionInWorld().setToZero();
            this.defaultChestMessage.getDesiredOrientationInWorld().setToYawOrientation(this.lockChestPose.getYaw());
            this.defaultChestMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)false, (boolean)false, (boolean)false, (ReferenceFrame)worldFrame));
            this.defaultChestMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((double)0.0, (WeightMatrix3DMessage)this.defaultChestMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((Tuple3DReadOnly)this.defaultChestMessageAngularWeight, (WeightMatrix3DMessage)this.defaultChestMessage.getAngularWeightMatrix());
        }
        for (RobotSide robotSide : RobotSide.values) {
            OneDoFJointBasics[] joints = (OneDoFJointBasics[])this.armJoints.get((Enum)robotSide);
            List defaultMessages = (List)this.defaultArmJointMessages.get((Enum)robotSide);
            for (int i = 0; i < joints.length; ++i) {
                ((KinematicsToolboxOneDoFJointMessage)defaultMessages.get(i)).setDesiredPosition(controllerFullRobotModel.getOneDoFJointByName(joints[i].getName()).getQ());
                ((KinematicsToolboxOneDoFJointMessage)defaultMessages.get(i)).setWeight(this.defaultArmMessageWeight.getValue());
            }
        }
        this.resetFilter = true;
        this.streamingStartTime.set(Double.NaN);
        this.ikRobotState.setToNaN();
        this.initialRobotState.setToNaN();
        this.blendedRobotState.setToNaN();
        this.filteredRobotState.setToNaN();
        this.outputRobotState.setToNaN();
        this.timeOfLastInput.set(Double.NaN);
        this.timeSinceLastInput.set(Double.NaN);
        this.inputFrequency.reset();
        for (YoFramePoint3D rawInputPosition : this.rawInputPositionMap.values()) {
            rawInputPosition.setToNaN();
        }
        for (YoFramePoint3D rawExtrapolatedInputPosition : this.rawExtrapolatedInputPositionMap.values()) {
            rawExtrapolatedInputPosition.setToNaN();
        }
        for (AlphaFilteredYoFramePoint filteredExtrapolatedInputPosition : this.filteredExtrapolatedInputPositionMap.values()) {
            filteredExtrapolatedInputPosition.setToNaN();
            filteredExtrapolatedInputPosition.reset();
        }
        for (YoFrameQuaternion rawInputOrientation : this.rawInputOrientationMap.values()) {
            rawInputOrientation.setToNaN();
        }
        for (YoFrameQuaternion rawExtrapolatedInputOrientation : this.rawExtrapolatedInputOrientationMap.values()) {
            rawExtrapolatedInputOrientation.setToNaN();
        }
        for (AlphaFilteredYoFrameQuaternion filteredExtrapolatedInputOrientation : this.filteredExtrapolatedInputOrientationMap.values()) {
            filteredExtrapolatedInputOrientation.setToNaN();
            filteredExtrapolatedInputOrientation.reset();
        }
        for (YoDouble yoDouble : this.rigidBodyControlStartTimeArray) {
            yoDouble.setToNaN();
        }
        this.resetEstimatedInputVelocities();
        System.gc();
    }

    private void resetEstimatedInputVelocities() {
        for (YoFixedFrameSpatialVector rawInputSpatialVelocity : this.rawInputSpatialVelocityArray) {
            rawInputSpatialVelocity.setToZero();
        }
        for (YoFixedFrameSpatialVector decayingInputSpatialVelocity : this.decayingInputSpatialVelocityArray) {
            decayingInputSpatialVelocity.setToZero();
        }
    }

    public void doAction(double timeInState) {
        this.tools.pollInputCommand();
        FullHumanoidRobotModel controllerFullRobotModel = this.tools.getCurrentFullRobotModel();
        if (this.lockPelvis.getValue() && !this.tools.getConfigurationCommand().isPelvisTaskspaceEnabled()) {
            this.lockPelvisPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getPelvis().getBodyFixedFrame());
            this.lockPelvisPoseFiltered.update();
            this.defaultPelvisMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockPelvisPoseFiltered.getPosition());
            this.defaultPelvisMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockPelvisPoseFiltered.getOrientation());
        } else {
            this.lockPelvisPoseFiltered.reset();
        }
        if (this.lockChest.getValue() && !this.tools.getConfigurationCommand().isChestTaskspaceEnabled()) {
            this.lockChestPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getChest().getBodyFixedFrame());
            this.lockChestPoseFiltered.update();
            this.defaultChestMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockChestPoseFiltered.getPosition());
            this.defaultChestMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockChestPoseFiltered.getOrientation());
        } else {
            this.lockChestPoseFiltered.reset();
        }
        this.estimateInputsVelocity();
        KinematicsStreamingToolboxInputCommand latestInput = this.tools.getLatestInput();
        if (latestInput != null) {
            YoFramePoint3D rawInputPosition;
            RigidBodyBasics endEffector;
            int i;
            this.uncontrolledRigidBodies.clear();
            List<? extends RigidBodyBasics> controllableRigidBodies = this.tools.getIKController().getControllableRigidBodies();
            for (i = 0; i < controllableRigidBodies.size(); ++i) {
                this.uncontrolledRigidBodies.add(controllableRigidBodies.get(i));
            }
            for (i = 0; i < latestInput.getNumberOfInputs(); ++i) {
                double controlDuration;
                KinematicsToolboxRigidBodyCommand rigidBodyInput = latestInput.getInput(i);
                this.setDefaultWeightIfNeeded(rigidBodyInput.getSelectionMatrix(), rigidBodyInput.getWeightMatrix());
                YoDouble startTime = this.rigidBodyControlStartTimeMap.get(rigidBodyInput.getEndEffector());
                if (startTime.isNaN()) {
                    startTime.set(timeInState);
                }
                if ((controlDuration = timeInState - startTime.getValue()) < this.streamingBlendingDuration.getValue()) {
                    double blendingFactor = MathTools.clamp((double)(controlDuration / this.streamingBlendingDuration.getValue()), (double)0.0, (double)1.0);
                    rigidBodyInput.getWeightMatrix().scale(blendingFactor);
                }
                this.uncontrolledRigidBodies.remove(rigidBodyInput.getEndEffector());
            }
            for (i = 0; i < this.uncontrolledRigidBodies.size(); ++i) {
                this.rigidBodyControlStartTimeMap.get(this.uncontrolledRigidBodies.get(i)).setToNaN();
            }
            if (!latestInput.getStreamToController() && latestInput.getNumberOfInputs() == 0 && this.tools.hasPreviousInput()) {
                latestInput.addInputs(this.tools.getPreviousInput().getInputs());
                this.filteredInputs.set(latestInput);
            }
            if (this.tools.hasNewInputCommand()) {
                for (i = 0; i < latestInput.getNumberOfInputs(); ++i) {
                    KinematicsToolboxRigidBodyCommand input = latestInput.getInput(i);
                    endEffector = input.getEndEffector();
                    FramePose3D desiredPose = input.getDesiredPose();
                    rawInputPosition = this.rawInputPositionMap.get(endEffector);
                    if (rawInputPosition == null) continue;
                    YoFrameQuaternion rawInputOrientation = this.rawInputOrientationMap.get(endEffector);
                    rawInputPosition.set((FrameTuple3DReadOnly)desiredPose.getPosition());
                    rawInputOrientation.set((FrameQuaternionReadOnly)desiredPose.getOrientation());
                }
                this.rawInputs.set(latestInput);
            } else {
                this.extrapolateInputPositions(this.rawInputs, this.toolboxControllerPeriod);
            }
            this.filteredInputs.set(this.rawInputs);
            for (i = 0; i < this.filteredInputs.getNumberOfInputs(); ++i) {
                KinematicsToolboxRigidBodyCommand filteredInput = this.filteredInputs.getInput(i);
                endEffector = filteredInput.getEndEffector();
                FramePose3D desiredPose = filteredInput.getDesiredPose();
                if (this.lockPelvis.getValue() && endEffector == this.pelvis || this.lockChest.getValue() && endEffector == this.chest || (rawInputPosition = this.rawExtrapolatedInputPositionMap.get(endEffector)) == null) continue;
                AlphaFilteredYoFramePoint filteredInputPosition = this.filteredExtrapolatedInputPositionMap.get(endEffector);
                YoFrameQuaternion rawInputOrientation = this.rawExtrapolatedInputOrientationMap.get(endEffector);
                AlphaFilteredYoFrameQuaternion filteredInputOrientation = this.filteredExtrapolatedInputOrientationMap.get(endEffector);
                rawInputPosition.set((FrameTuple3DReadOnly)desiredPose.getPosition());
                rawInputOrientation.set((FrameQuaternionReadOnly)desiredPose.getOrientation());
                filteredInputPosition.update();
                filteredInputOrientation.update();
                desiredPose.getPosition().set((FrameTuple3DReadOnly)filteredInputPosition);
                desiredPose.getOrientation().set((FrameQuaternionReadOnly)filteredInputOrientation);
                this.ikCommandInputManager.submitCommand((Command)filteredInput);
            }
            if (!latestInput.hasInputFor(this.head)) {
                this.ikCommandInputManager.submitMessages(this.defaultNeckJointMessages);
            }
            if (!latestInput.hasInputFor(this.pelvis) || this.lockPelvis.getValue()) {
                this.ikCommandInputManager.submitMessage((Settable)this.defaultPelvisMessage);
            }
            if (!latestInput.hasInputFor(this.chest) || this.lockChest.getValue()) {
                this.ikCommandInputManager.submitMessage((Settable)this.defaultChestMessage);
            }
            RobotSide[] robotSideArray = RobotSide.values;
            int filteredInput = robotSideArray.length;
            for (int endEffector2 = 0; endEffector2 < filteredInput; ++endEffector2) {
                RobotSide robotSide = robotSideArray[endEffector2];
                if (latestInput.hasInputFor((RigidBodyBasics)this.hands.get((Enum)robotSide))) continue;
                this.ikCommandInputManager.submitMessages((List)this.defaultArmJointMessages.get((Enum)robotSide));
            }
            this.isStreaming.set(latestInput.getStreamToController());
            if (latestInput.getStreamInitialBlendDuration() > 0.0) {
                this.streamingBlendingDuration.set(latestInput.getStreamInitialBlendDuration());
            } else {
                this.streamingBlendingDuration.set(this.tools.getParameters().getDefaultStreamingBlendingDuration());
            }
            if (latestInput.getAngularRateLimitation() > 0.0) {
                this.angularRateLimit.set(latestInput.getAngularRateLimitation());
            } else {
                this.angularRateLimit.set(this.defaultAngularRateLimit.getValue());
            }
            if (latestInput.getLinearRateLimitation() > 0.0) {
                this.linearRateLimit.set(latestInput.getLinearRateLimitation());
            } else {
                this.linearRateLimit.set(this.defaultLinearRateLimit.getValue());
            }
            if (this.tools.hasPreviousInput()) {
                this.handleInputsDecay(latestInput, this.tools.getPreviousInput());
                this.ikCommandInputManager.submitCommands(this.decayingInputs);
            }
        }
        if (this.tools.hasNewInputCommand()) {
            if (Double.isFinite(this.timeSinceLastInput.getValue()) && this.timeSinceLastInput.getValue() > 0.0) {
                this.rawInputFrequency.set(1.0 / this.timeSinceLastInput.getValue());
                this.inputFrequency.update();
            }
            this.timeOfLastInput.set(timeInState);
        }
        if (Double.isFinite(this.timeOfLastInput.getValue())) {
            this.timeSinceLastInput.set(timeInState - this.timeOfLastInput.getValue());
        }
        this.ikSolverSpatialGains.setPositionMaxFeedbackAndFeedbackRate(this.linearRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverSpatialGains.setOrientationMaxFeedbackAndFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverJointGains.setMaximumFeedbackAndMaximumFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.tools.getIKController().updateInternal();
        this.ikRobotState.set(this.tools.getIKController().getSolution());
        if (latestInput != null) {
            if (latestInput.hasInputFor(this.head)) {
                for (int i = 0; i < this.neckJoints.length; ++i) {
                    this.defaultNeckJointMessages.get(i).setDesiredPosition(this.neckJoints[i].getQ());
                }
            }
            for (RobotSide robotSide : RobotSide.values) {
                if (!latestInput.hasInputFor((RigidBodyBasics)this.hands.get((Enum)robotSide))) continue;
                OneDoFJointBasics[] joints = (OneDoFJointBasics[])this.armJoints.get((Enum)robotSide);
                List messages = (List)this.defaultArmJointMessages.get((Enum)robotSide);
                for (int i = 0; i < joints.length; ++i) {
                    ((KinematicsToolboxOneDoFJointMessage)messages.get(i)).setDesiredPosition(joints[i].getQ());
                }
            }
        }
        if (this.resetFilter) {
            this.filteredRobotState.set(this.ikRobotState);
            this.resetFilter = false;
        } else {
            double alphaFilter = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.solutionFilterBreakFrequency.getValue(), (double)this.tools.getToolboxControllerPeriod());
            this.filteredRobotState.interpolate(this.ikRobotState.getStatus(), this.filteredRobotState.getStatus(), alphaFilter);
        }
        if (this.isStreaming.getValue()) {
            if (!this.wasStreaming.getValue()) {
                this.tools.getCurrentState(this.initialRobotState);
                this.streamingStartTime.set(timeInState);
            }
            double timeInBlending = timeInState - this.streamingStartTime.getValue();
            double timeSinceLastPublished = timeInState - this.timeOfLastMessageSentToController.getValue();
            if (timeSinceLastPublished >= this.publishingPeriod.getValue()) {
                this.outputRobotState.set(this.filteredRobotState);
                this.outputRobotState.scaleVelocities(this.outputJointVelocityScale.getValue());
                if (timeInBlending < this.streamingBlendingDuration.getValue()) {
                    double alpha = MathTools.clamp((double)(timeInBlending / this.streamingBlendingDuration.getValue()), (double)0.0, (double)1.0);
                    double alphaDot = 1.0 / this.streamingBlendingDuration.getValue();
                    this.blendedRobotState.interpolate(this.initialRobotState.getStatus(), this.outputRobotState.getStatus(), alpha, alphaDot);
                    if (this.streamingMessagePublisher == null || !this.useStreamingPublisher.getValue()) {
                        this.trajectoryMessagePublisher.publish(this.tools.setupTrajectoryMessage(this.blendedRobotState.getStatus()));
                    } else {
                        this.streamingMessagePublisher.publish(this.tools.setupStreamingMessage(this.blendedRobotState.getStatus()));
                    }
                } else if (this.streamingMessagePublisher == null || !this.useStreamingPublisher.getValue()) {
                    this.trajectoryMessagePublisher.publish(this.tools.setupTrajectoryMessage(this.outputRobotState.getStatus()));
                } else {
                    this.streamingMessagePublisher.publish(this.tools.setupStreamingMessage(this.outputRobotState.getStatus()));
                }
                this.timeOfLastMessageSentToController.set(timeInState);
            }
        } else {
            if (this.wasStreaming.getValue()) {
                this.outputRobotState.set(this.filteredRobotState);
                this.outputRobotState.scaleVelocities(this.outputJointVelocityScale.getValue());
                this.trajectoryMessagePublisher.publish(this.tools.setupFinalizeTrajectoryMessage(this.outputRobotState.getStatus()));
            }
            this.timeOfLastMessageSentToController.set(Double.NEGATIVE_INFINITY);
        }
        this.wasStreaming.set(this.isStreaming.getValue());
    }

    private void estimateInputsVelocity() {
        double previousInputReceivedTime;
        if (!this.tools.hasPreviousInput()) {
            this.resetEstimatedInputVelocities();
            return;
        }
        if (!this.tools.hasNewInputCommand()) {
            this.decayEstimatedInputVelocity();
            return;
        }
        KinematicsStreamingToolboxInputCommand latestInput = this.tools.getLatestInput();
        KinematicsStreamingToolboxInputCommand previousInput = this.tools.getPreviousInput();
        if (latestInput.getNumberOfInputs() != previousInput.getNumberOfInputs()) {
            this.resetEstimatedInputVelocities();
            return;
        }
        double latestInputReceivedTime = Conversions.nanosecondsToSeconds((long)latestInput.getTimestamp());
        double timeInterval = latestInputReceivedTime - (previousInputReceivedTime = Conversions.nanosecondsToSeconds((long)previousInput.getTimestamp()));
        if (timeInterval <= 0.0) {
            LogTools.warn((String)("Got a negative or zero time interval between 2 inputs: " + timeInterval));
            this.decayEstimatedInputVelocity();
            return;
        }
        for (int i = 0; i < latestInput.getNumberOfInputs(); ++i) {
            RigidBodyBasics endEffector = latestInput.getInput(i).getEndEffector();
            YoFixedFrameSpatialVector rawSpatialVelocity = this.rawInputSpatialVelocityMap.get(endEffector);
            if (rawSpatialVelocity == null) continue;
            FramePose3D previousInputPose = previousInput.getInput(i).getDesiredPose();
            FixedFramePoint3DBasics previousInputPosition = previousInputPose.getPosition();
            FixedFrameQuaternionBasics previousInputOrientation = previousInputPose.getOrientation();
            FramePose3D latestInputPose = latestInput.getInput(i).getDesiredPose();
            FixedFramePoint3DBasics latestInputPosition = latestInputPose.getPosition();
            FixedFrameQuaternionBasics latestInputOrientation = latestInputPose.getOrientation();
            YoFrameVector3D rawLinearVelocity = rawSpatialVelocity.getLinearPart();
            YoFrameVector3D rawAngularVelocity = rawSpatialVelocity.getAngularPart();
            KSTTools.computeLinearVelocity(timeInterval, (FramePoint3DReadOnly)previousInputPosition, (FramePoint3DReadOnly)latestInputPosition, (FixedFrameVector3DBasics)rawLinearVelocity);
            KSTTools.computeAngularVelocity(timeInterval, (FrameQuaternionReadOnly)previousInputOrientation, (FrameQuaternionReadOnly)latestInputOrientation, (FixedFrameVector3DBasics)rawAngularVelocity);
            this.decayingInputSpatialVelocityMap.get(endEffector).set((SpatialVectorReadOnly)rawSpatialVelocity);
            this.inputVelocityDecayFactor.set(0.0);
        }
    }

    private void decayEstimatedInputVelocity() {
        double alpha = Math.min(1.0, this.inputVelocityDecayFactor.getValue() + this.toolboxControllerPeriod / this.inputVelocityDecayDuration.getValue());
        this.inputVelocityDecayFactor.set(alpha);
        for (int i = 0; i < this.decayingInputSpatialVelocityArray.length; ++i) {
            YoFixedFrameSpatialVector rawVelocity = this.rawInputSpatialVelocityArray[i];
            YoFixedFrameSpatialVector decayingVelocity = this.decayingInputSpatialVelocityArray[i];
            decayingVelocity.getLinearPart().interpolate((FrameTuple3DReadOnly)rawVelocity.getLinearPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
            decayingVelocity.getAngularPart().interpolate((FrameTuple3DReadOnly)rawVelocity.getAngularPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
        }
    }

    private void extrapolateInputPositions(KinematicsStreamingToolboxInputCommand inputs, double integrationDT) {
        for (int i = 0; i < inputs.getNumberOfInputs(); ++i) {
            KinematicsToolboxRigidBodyCommand input = inputs.getInput(i);
            YoFixedFrameSpatialVector inputVelocity = this.decayingInputSpatialVelocityMap.get(input.getEndEffector());
            FramePose3D desiredPose = input.getDesiredPose();
            KSTTools.integrateLinearVelocity(integrationDT, (FramePoint3DReadOnly)desiredPose.getPosition(), (FrameVector3DReadOnly)inputVelocity.getLinearPart(), desiredPose.getPosition());
            KSTTools.integrateAngularVelocity(integrationDT, (FrameQuaternionReadOnly)desiredPose.getOrientation(), (FrameVector3DReadOnly)inputVelocity.getLinearPart(), desiredPose.getOrientation());
        }
    }

    private void handleInputsDecay(KinematicsStreamingToolboxInputCommand latestInputs, KinematicsStreamingToolboxInputCommand previousInputs) {
        KinematicsToolboxRigidBodyCommand decayingInput;
        int i;
        for (i = this.decayingInputs.size() - 1; i >= 0; --i) {
            decayingInput = (KinematicsToolboxRigidBodyCommand)this.decayingInputs.get(i);
            if (!latestInputs.hasInputFor(decayingInput.getEndEffector())) continue;
            this.decayingInputs.remove(i);
        }
        for (i = 0; i < previousInputs.getNumberOfInputs(); ++i) {
            KinematicsToolboxRigidBodyCommand previousInput = previousInputs.getInput(i);
            if (latestInputs.hasInputFor(previousInput.getEndEffector())) continue;
            boolean addInputToDecay = true;
            for (int j = 0; j < this.decayingInputs.size(); ++j) {
                if (previousInput.getEndEffector() != ((KinematicsToolboxRigidBodyCommand)this.decayingInputs.get(j)).getEndEffector()) continue;
                addInputToDecay = false;
                break;
            }
            if (!addInputToDecay) continue;
            ((KinematicsToolboxRigidBodyCommand)this.decayingInputs.add()).set(previousInput);
        }
        for (i = this.decayingInputs.size() - 1; i >= 0; --i) {
            decayingInput = (KinematicsToolboxRigidBodyCommand)this.decayingInputs.get(i);
            decayingInput.getWeightMatrix().scale(this.inputWeightDecayFactor.getValue());
            if (!(KSTStreamingState.findMaximumWeightValue(decayingInput.getWeightMatrix()) < 0.1)) continue;
            this.decayingInputs.remove(i);
        }
        this.numberOfDecayingInputs.set(this.decayingInputs.size());
    }

    private static double findMaximumWeightValue(WeightMatrix6D weightMatrix) {
        return Math.max(KSTStreamingState.findMaximumWeightValue(weightMatrix.getAngularPart()), KSTStreamingState.findMaximumWeightValue(weightMatrix.getLinearPart()));
    }

    private static double findMaximumWeightValue(WeightMatrix3D weightMatrix) {
        return EuclidCoreTools.max((double)weightMatrix.getX(), (double)weightMatrix.getY(), (double)weightMatrix.getZ());
    }

    private void setDefaultWeightIfNeeded(SelectionMatrix6D selectionMatrix, WeightMatrix6D weightMatrix) {
        KSTStreamingState.setDefaultWeightIfNeeded(selectionMatrix.getLinearPart(), weightMatrix.getLinearPart(), this.defaultLinearWeight.getValue());
        KSTStreamingState.setDefaultWeightIfNeeded(selectionMatrix.getAngularPart(), weightMatrix.getAngularPart(), this.defaultAngularWeight.getValue());
    }

    private static void setDefaultWeightIfNeeded(SelectionMatrix3D selectionMatrix, WeightMatrix3D weightMatrix, double defaultWeight) {
        if (selectionMatrix.isXSelected() && (Double.isNaN(weightMatrix.getX()) || weightMatrix.getX() <= 0.0)) {
            weightMatrix.setXAxisWeight(defaultWeight);
        }
        if (selectionMatrix.isYSelected() && (Double.isNaN(weightMatrix.getY()) || weightMatrix.getY() <= 0.0)) {
            weightMatrix.setYAxisWeight(defaultWeight);
        }
        if (selectionMatrix.isZSelected() && (Double.isNaN(weightMatrix.getZ()) || weightMatrix.getZ() <= 0.0)) {
            weightMatrix.setZAxisWeight(defaultWeight);
        }
    }

    public void onExit(double timeInState) {
        this.tools.flushInputCommands();
    }
}

