/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.MultiContactBalanceStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.ArrayList;
import java.util.List;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.HumanoidKinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxInputCollectionCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxOneDoFJointCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxPrivilegedConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxSupportRegionCommand;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;

public class KinematicsToolboxModule
extends ToolboxModule {
    private static final boolean DEFAULT_SETUP_INITIAL_CONFIGURATION = true;
    private final HumanoidKinematicsToolboxController kinematicsToolBoxController;

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, RealtimeROS2Node realtimeROS2Node) {
        this(robotModel, startYoVariableServer, 1, true, realtimeROS2Node, null);
    }

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(robotModel, startYoVariableServer, 1, pubSubImplementation);
    }

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, int updatePeriodMilliseconds, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(robotModel, startYoVariableServer, updatePeriodMilliseconds, true, pubSubImplementation);
    }

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, int updatePeriodMilliseconds, boolean setupInitialConfiguration, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(robotModel, startYoVariableServer, updatePeriodMilliseconds, setupInitialConfiguration, null, pubSubImplementation);
    }

    private KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, int updatePeriodMilliseconds, boolean setupInitialConfiguration, RealtimeROS2Node realtimeROS2Node, DomainFactory.PubSubImplementation pubSubImplementation) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, updatePeriodMilliseconds, (ROS2NodeInterface)realtimeROS2Node, pubSubImplementation);
        this.kinematicsToolBoxController = new HumanoidKinematicsToolboxController(this.commandInputManager, this.statusOutputManager, this.fullRobotModel, (FullHumanoidRobotModelFactory)robotModel, 0.001, this.yoGraphicsListRegistry, this.registry);
        if (setupInitialConfiguration) {
            this.kinematicsToolBoxController.setInitialRobotConfiguration(robotModel);
        }
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(this.fullRobotModel, (ReferenceFrames)this.kinematicsToolBoxController.getDesiredReferenceFrames()));
        this.startYoVariableServer();
    }

    @Override
    public void registerExtraPuSubs(ROS2NodeInterface ros2Node) {
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)this.robotName);
        RobotConfigurationData robotConfigurationData = new RobotConfigurationData();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.kinematicsToolBoxController != null) {
                s.takeNextData((Object)robotConfigurationData, null);
                this.kinematicsToolBoxController.updateRobotConfigurationData(robotConfigurationData);
            }
        });
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.kinematicsToolBoxController != null) {
                s.takeNextData((Object)capturabilityBasedStatus, null);
                this.kinematicsToolBoxController.updateCapturabilityBasedStatus(capturabilityBasedStatus);
            }
        });
        MultiContactBalanceStatus multiContactBalanceStatus = new MultiContactBalanceStatus();
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, MultiContactBalanceStatus.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.kinematicsToolBoxController != null) {
                s.takeNextData((Object)multiContactBalanceStatus, null);
                this.kinematicsToolBoxController.updateMultiContactBalanceStatus(multiContactBalanceStatus);
            }
        });
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return KinematicsToolboxModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(KinematicsToolboxCenterOfMassCommand.class);
        commands.add(KinematicsToolboxRigidBodyCommand.class);
        commands.add(KinematicsToolboxOneDoFJointCommand.class);
        commands.add(KinematicsToolboxConfigurationCommand.class);
        commands.add(KinematicsToolboxSupportRegionCommand.class);
        commands.add(KinematicsToolboxPrivilegedConfigurationCommand.class);
        commands.add(KinematicsToolboxInputCollectionCommand.class);
        commands.add(HumanoidKinematicsToolboxConfigurationCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return KinematicsToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(KinematicsToolboxOutputStatus.class);
        return status;
    }

    @Override
    public KinematicsToolboxController getToolboxController() {
        return this.kinematicsToolBoxController;
    }

    public CommandInputManager getCommandInputManager() {
        return this.commandInputManager;
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return KinematicsToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ROS2Tools.KINEMATICS_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return KinematicsToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ROS2Tools.KINEMATICS_TOOLBOX.withRobot(robotName).withInput();
    }
}

