/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointspaceVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class KinematicsSolutionQualityCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final PoseReferenceFrame controlFrame = new PoseReferenceFrame("controlFrame", worldFrame);
    private final DMatrixRMaj selectionMatrix = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj weightMatrix = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj error = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj errorWeighted = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj errorSubspace = new DMatrixRMaj(6, 1);

    public double calculateSolutionQuality(FeedbackControllerDataHolderReadOnly feedbackControllerDataHolder, double totalRobotMass, double scale) {
        double error = 0.0;
        InverseKinematicsCommandList ikOutput = feedbackControllerDataHolder.getLastFeedbackControllerInverseKinematicsOutput();
        block5: for (int i = 0; i < ikOutput.getNumberOfCommands(); ++i) {
            InverseKinematicsCommand command = ikOutput.getCommand(i);
            switch (command.getCommandType()) {
                case MOMENTUM: {
                    error += this.calculateCommandQuality((MomentumCommand)command, totalRobotMass);
                    continue block5;
                }
                case TASKSPACE: {
                    error += this.calculateCommandQuality((SpatialVelocityCommand)command);
                    continue block5;
                }
                case JOINTSPACE: {
                    error += this.calculateCommandQuality((JointspaceVelocityCommand)command);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("The following command is not handled: " + command.getClass());
                }
            }
        }
        return error * scale;
    }

    private double calculateCommandQuality(MomentumCommand command, double totalRobotMass) {
        command.getSelectionMatrix(worldFrame, this.selectionMatrix);
        command.getWeightMatrix(this.weightMatrix);
        return this.computeQualityFromError(command.getMomentum(), this.weightMatrix, this.selectionMatrix) / totalRobotMass;
    }

    private double calculateCommandQuality(SpatialVelocityCommand command) {
        RigidBodyBasics endEffector = command.getEndEffector();
        this.controlFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)endEffector.getBodyFixedFrame().getTransformToRoot());
        command.getDesiredAngularVelocity().get(0, (DMatrix)this.error);
        command.getDesiredLinearVelocity().get(3, (DMatrix)this.error);
        command.getSelectionMatrix((ReferenceFrame)this.controlFrame, this.selectionMatrix);
        command.getWeightMatrix((ReferenceFrame)this.controlFrame, this.weightMatrix);
        return this.computeQualityFromError(this.error, this.weightMatrix, this.selectionMatrix);
    }

    private double calculateCommandQuality(JointspaceVelocityCommand command) {
        if (command.getNumberOfJoints() != 1) {
            throw new IllegalStateException("Unexpected number of joints");
        }
        return Math.abs(command.getDesiredVelocity(0).get(0)) * command.getWeight(0);
    }

    private double computeQualityFromError(DMatrixRMaj error, DMatrixRMaj weightMatrix, DMatrixRMaj selectionMatrix) {
        this.errorWeighted.reshape(error.getNumRows(), 1);
        CommonOps_DDRM.mult((DMatrix1Row)weightMatrix, (DMatrix1Row)error, (DMatrix1Row)this.errorWeighted);
        this.errorSubspace.reshape(selectionMatrix.getNumRows(), 1);
        CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.errorWeighted, (DMatrix1Row)this.errorSubspace);
        return NormOps_DDRM.normP2((DMatrixRMaj)this.errorSubspace);
    }
}

