/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.physics.CollisionResult;

public class KinematicsCollisionFrame
extends ReferenceFrame {
    private final RigidBodyTransform transformToParent = new RigidBodyTransform();
    private final FramePoint3D collisionPoint0 = new FramePoint3D();
    private final FramePoint3D collisionPoint1 = new FramePoint3D();
    private final FrameVector3D collisionNormal0 = new FrameVector3D();
    private final FrameVector3D collisionNormal1 = new FrameVector3D();
    private final FrameVector3D collisionAxis = new FrameVector3D();
    private final FramePoint3D origin = new FramePoint3D();
    private final FrameVector3D zAxis = new FrameVector3D();

    public KinematicsCollisionFrame(String name, ReferenceFrame parentFrame) {
        super(name, parentFrame);
    }

    public void update(CollisionResult collision, boolean centerFrameAtA) {
        EuclidFrameShape3DCollisionResult collisionData = collision.getCollisionData();
        if (centerFrameAtA) {
            this.collisionPoint0.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getPointOnA());
            this.collisionPoint1.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getPointOnB());
            this.collisionNormal0.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getNormalOnA());
            this.collisionNormal1.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getNormalOnB());
        } else {
            this.collisionPoint0.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getPointOnB());
            this.collisionPoint1.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getPointOnA());
            this.collisionNormal0.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getNormalOnB());
            this.collisionNormal1.setIncludingFrame((FrameTuple3DReadOnly)collisionData.getNormalOnA());
        }
        this.collisionAxis.setToZero(this.getParent());
        if (!this.collisionNormal0.containsNaN()) {
            this.collisionNormal0.changeFrame(this.getParent());
            this.collisionAxis.set(this.collisionNormal0);
        } else if (!this.collisionNormal1.containsNaN()) {
            this.collisionNormal1.changeFrame(this.getParent());
            this.collisionAxis.set(this.collisionNormal1);
            this.collisionAxis.negate();
        } else {
            this.collisionPoint0.changeFrame(this.getParent());
            this.collisionPoint1.changeFrame(this.getParent());
            this.collisionAxis.sub((FrameTuple3DReadOnly)this.collisionPoint1, (FrameTuple3DReadOnly)this.collisionPoint0);
            if (collisionData.areShapesColliding()) {
                this.collisionAxis.negate();
            }
        }
        this.update((FramePoint3DReadOnly)this.collisionPoint0, (FrameVector3DReadOnly)this.collisionAxis);
    }

    public void update(FramePoint3DReadOnly origin, FrameVector3DReadOnly zAxis) {
        this.origin.setIncludingFrame((FrameTuple3DReadOnly)origin);
        this.zAxis.setIncludingFrame((FrameTuple3DReadOnly)zAxis);
        this.origin.changeFrame(this.getParent());
        this.zAxis.changeFrame(this.getParent());
        this.transformToParent.getTranslation().set((Tuple3DReadOnly)this.origin);
        EuclidCoreMissingTools.rotationMatrix3DFromZUpToVector3D((Vector3DReadOnly)this.zAxis, (CommonMatrix3DBasics)this.transformToParent.getRotation());
        this.update();
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        transformToParent.set(this.transformToParent);
    }
}

