/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessor;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataPublisher;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataPublisherFactory;
import us.ihmc.sensorProcessing.sensorProcessors.OneDoFJointStateReadOnly;
import us.ihmc.sensorProcessing.sensorProcessors.SensorOutputMapReadOnly;
import us.ihmc.sensorProcessing.simulatedSensors.SDFPerfectSimulatedSensorReader;
import us.ihmc.sensorProcessing.stateEstimation.IMUSensorReadOnly;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.util.PeriodicNonRealtimeThreadScheduler;

public class KinematicToolboxDiagnosticEnvironment {
    private final String threadName = "NonRealtimeScheduler";
    private final RealtimeROS2Node realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.INTRAPROCESS, (String)"ihmc_fake_controller");
    private long timestamp = 0L;

    public KinematicToolboxDiagnosticEnvironment(DRCRobotModel drcRobotModel) {
        FullHumanoidRobotModel humanoidFullRobotModel = drcRobotModel.createFullRobotModel();
        HumanoidFloatingRootJointRobot humanoidFloatingRobotModel = drcRobotModel.createHumanoidFloatingRootJointRobot(false);
        RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup = drcRobotModel.getDefaultRobotInitialSetup(0.0, 0.0);
        robotInitialSetup.initializeRobot(humanoidFloatingRobotModel);
        SDFPerfectSimulatedSensorReader sdfPerfectReader = new SDFPerfectSimulatedSensorReader((FloatingRootJointRobot)humanoidFloatingRobotModel, (FullRobotModel)humanoidFullRobotModel, null);
        sdfPerfectReader.read();
        ForceSensorDefinition[] forceSensorDefinitionArray = humanoidFullRobotModel.getForceSensorDefinitions();
        List<ForceSensorDefinition> forceSensorDefinitionList = Arrays.asList(forceSensorDefinitionArray);
        SensorOutputMapReadOnly sensorOutputMapReadOnly = this.initializeSensorOutputMapReadOnly();
        RobotConfigurationDataPublisherFactory factory = new RobotConfigurationDataPublisherFactory();
        factory.setDefinitionsToPublish(humanoidFullRobotModel);
        factory.setSensorSource((FullRobotModel)humanoidFullRobotModel, (ForceSensorDataHolderReadOnly)new ForceSensorDataHolder(forceSensorDefinitionList), sensorOutputMapReadOnly);
        factory.setROS2Info(this.realtimeROS2Node, ROS2Tools.getControllerOutputTopic((String)drcRobotModel.getSimpleRobotName()));
        final RobotConfigurationDataPublisher robotConfigurationDataPublisher = factory.createRobotConfigurationDataPublisher();
        PeriodicNonRealtimeThreadScheduler scheduler2 = new PeriodicNonRealtimeThreadScheduler("NonRealtimeScheduler");
        scheduler2.schedule(new Runnable(){

            @Override
            public void run() {
                robotConfigurationDataPublisher.write();
            }
        }, 1L, TimeUnit.MILLISECONDS);
        HumanoidNetworkProcessor networkProcessor = new HumanoidNetworkProcessor(drcRobotModel, DomainFactory.PubSubImplementation.INTRAPROCESS);
        networkProcessor.setupKinematicsToolboxModule(true);
        networkProcessor.start();
    }

    private SensorOutputMapReadOnly initializeSensorOutputMapReadOnly() {
        return new SensorOutputMapReadOnly(){

            public long getWallTime() {
                KinematicToolboxDiagnosticEnvironment.this.timestamp += Conversions.millisecondsToNanoseconds((long)1L);
                return KinematicToolboxDiagnosticEnvironment.this.timestamp;
            }

            public long getMonotonicTime() {
                return KinematicToolboxDiagnosticEnvironment.this.timestamp;
            }

            public long getSyncTimestamp() {
                return KinematicToolboxDiagnosticEnvironment.this.timestamp;
            }

            public OneDoFJointStateReadOnly getOneDoFJointOutput(OneDoFJointBasics oneDoFJoint) {
                return null;
            }

            public List<? extends OneDoFJointStateReadOnly> getOneDoFJointOutputs() {
                return null;
            }

            public List<? extends IMUSensorReadOnly> getIMUOutputs() {
                return null;
            }

            public ForceSensorDataHolderReadOnly getForceSensorOutputs() {
                return null;
            }
        };
    }
}

