/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.MultiContactBalanceStatus;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.MultiContactActuationBasedSupportRegionSolver;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.WholeBodyContactDescription;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.HumanoidKinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class HumanoidKinematicsToolboxController
extends KinematicsToolboxController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FullHumanoidRobotModel desiredFullRobotModel;
    private final CommonHumanoidReferenceFrames desiredReferenceFrames;
    private final FullHumanoidRobotModel currentFullRobotModel;
    private final CommonHumanoidReferenceFrames currentReferenceFrames;
    private final OneDoFJointBasics[] currentOneDoFJoints;
    private final TIntObjectHashMap<RigidBodyBasics> rigidBodyHashCodeMap = new TIntObjectHashMap();
    private final TIntObjectHashMap<OneDoFJointBasics> jointHashCodeMap = new TIntObjectHashMap();
    private final Map<RigidBodyBasics, RigidBodyBasics> endEffectorToPrimaryBaseMap = new HashMap<RigidBodyBasics, RigidBodyBasics>();
    private final Map<RigidBodyBasics, GeometricJacobian> rootJacobians = new HashMap<RigidBodyBasics, GeometricJacobian>();
    private final YoBoolean enableAutoSupportPolygon = new YoBoolean("enableAutoSupportPolygon", this.registry);
    private final SideDependentList<YoBoolean> isFootInSupport = new SideDependentList();
    private final SideDependentList<YoFramePose3D> initialFootPoses = new SideDependentList();
    private final RecyclingArrayList<ContactingRigidBody> contactingRigidBodies = new RecyclingArrayList(ContactingRigidBody::new);
    private final YoFramePoint3D initialCenterOfMassPosition = new YoFramePoint3D("initialCenterOfMass", worldFrame, this.registry);
    private final YoBoolean enableMultiContactSupportRegionSolver = new YoBoolean("enableMultiContactSupportRegionSolver", this.registry);
    private final MultiContactActuationBasedSupportRegionSolver supportRegionSolver = new MultiContactActuationBasedSupportRegionSolver(20, this.registry);
    private final WholeBodyContactDescription supportRegionSolverInput;
    private final YoBoolean holdSupportRigidBodies = new YoBoolean("holdSupportRigidBodies", this.registry);
    private final YoBoolean holdCenterOfMassXYPosition = new YoBoolean("holdCenterOfMassXYPosition", this.registry);
    private final FramePoint3D centerOfMassPositionToHold = new FramePoint3D();
    private final YoDouble supportRigidBodyWeight = new YoDouble("supportRigidBodyWeight", this.registry);
    private final YoDouble momentumWeight = new YoDouble("momentumWeight", this.registry);
    private final HashMap<String, YoDouble> jointLimitReductionFactors = new HashMap();
    private final ConcurrentCopier<CapturabilityBasedStatus> concurrentCapturabilityBasedStatusCopier = new ConcurrentCopier(CapturabilityBasedStatus::new);
    private boolean hasCapturabilityBasedStatus = false;
    private final CapturabilityBasedStatus capturabilityBasedStatusInternal = new CapturabilityBasedStatus();
    private final YoBoolean enableJointLimitReduction = new YoBoolean("enableJointLimitReduction", this.registry);
    private final ConcurrentCopier<MultiContactBalanceStatus> concurrentMultiContactBalanceStatusCopier = new ConcurrentCopier(MultiContactBalanceStatus::new);
    private boolean hasMultiContactBalanceStatus = false;
    private final MultiContactBalanceStatus multiContactBalanceStatusInternal = new MultiContactBalanceStatus();
    private final ExecutionTimer executionTimer = new ExecutionTimer("ikTotal", this.registry);
    private final RecyclingArrayList<FramePoint3D> activeContactPointPositions = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<PoseReferenceFrame> contactFrames = new RecyclingArrayList(20, SupplierBuilder.indexedSupplier(i -> new PoseReferenceFrame("contactFrame" + i, ReferenceFrame.getWorldFrame())));
    private final FramePose3D tmpContactPose = new FramePose3D();

    public HumanoidKinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, FullHumanoidRobotModelFactory fullRobotModelFactory, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(commandInputManager, statusOutputManager, desiredFullRobotModel, HumanoidKinematicsToolboxController.createListOfControllableRigidBodies(desiredFullRobotModel), fullRobotModelFactory, updateDT, yoGraphicsListRegistry, parentRegistry);
    }

    public HumanoidKinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, Collection<? extends RigidBodyBasics> controllableRigidBodyies, FullHumanoidRobotModelFactory fullRobotModelFactory, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(commandInputManager, statusOutputManager, desiredFullRobotModel.getRootJoint(), FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)desiredFullRobotModel), controllableRigidBodyies, updateDT, yoGraphicsListRegistry, parentRegistry);
        this.desiredFullRobotModel = desiredFullRobotModel;
        this.desiredReferenceFrames = new HumanoidReferenceFrames(desiredFullRobotModel);
        this.currentFullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.currentOneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.currentFullRobotModel);
        this.currentReferenceFrames = new HumanoidReferenceFrames(this.currentFullRobotModel);
        desiredFullRobotModel.getElevator().subtreeStream().forEach(rigidBody -> this.rigidBodyHashCodeMap.put(rigidBody.hashCode(), rigidBody));
        desiredFullRobotModel.getRootBody().subtreeStream().forEach(rigidBody -> this.rootJacobians.put((RigidBodyBasics)rigidBody, new GeometricJacobian(desiredFullRobotModel.getElevator(), rigidBody, ReferenceFrame.getWorldFrame())));
        Arrays.stream(this.currentOneDoFJoints).forEach(joint -> this.jointHashCodeMap.put(joint.hashCode(), joint));
        this.supportRigidBodyWeight.set(200.0);
        this.momentumWeight.set(0.001);
        for (RobotSide robotSide : RobotSide.values) {
            if (desiredFullRobotModel.getHand(robotSide) != null) {
                this.setupVisualization(desiredFullRobotModel.getHand(robotSide));
            }
            this.setupVisualization(desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        for (RobotSide robotSide : RobotSide.values) {
            String side = robotSide.getCamelCaseNameForMiddleOfExpression();
            String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            this.isFootInSupport.put((Enum)robotSide, (Object)new YoBoolean("is" + side + "FootInSupport", this.registry));
            this.initialFootPoses.put((Enum)robotSide, (Object)new YoFramePose3D(sidePrefix + "FootInitial", worldFrame, this.registry));
        }
        for (RobotSide robotSide : RobotSide.values) {
            this.endEffectorToPrimaryBaseMap.put(desiredFullRobotModel.getChest(), desiredFullRobotModel.getHand(robotSide));
            this.endEffectorToPrimaryBaseMap.put(desiredFullRobotModel.getPelvis(), desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        this.supportRegionSolverInput = new WholeBodyContactDescription(this.getDesiredOneDoFJoints());
        this.populateDefaultJointLimitReductionFactors();
    }

    private void populateDefaultJointLimitReductionFactors() {
        for (int i = 0; i < this.currentOneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.currentOneDoFJoints[i];
            YoDouble limitReductionFactor = new YoDouble(joint.getName() + "LimitReductionFactor", this.registry);
            this.jointLimitReductionFactors.put(joint.getName(), limitReductionFactor);
        }
        double defaultHipJointReduction = 0.05;
        for (RobotSide robotSide : RobotSide.values) {
            this.setJointLimitReductionFactor(this.currentFullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_PITCH).getName(), defaultHipJointReduction);
            this.setJointLimitReductionFactor(this.currentFullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_ROLL).getName(), defaultHipJointReduction);
            this.setJointLimitReductionFactor(this.currentFullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_YAW).getName(), defaultHipJointReduction);
        }
    }

    private void setJointLimitReductionFactor(String jointName, double jointLimitReductionFactor) {
        if (this.jointLimitReductionFactors.containsKey(jointName)) {
            this.jointLimitReductionFactors.get(jointName).set(jointLimitReductionFactor);
        }
    }

    private static Collection<RigidBodyBasics> createListOfControllableRigidBodies(FullHumanoidRobotModel desiredFullRobotModel) {
        ArrayList<RigidBodyBasics> listOfControllableRigidBodies = new ArrayList<RigidBodyBasics>();
        listOfControllableRigidBodies.add(desiredFullRobotModel.getHead());
        listOfControllableRigidBodies.add(desiredFullRobotModel.getChest());
        listOfControllableRigidBodies.add(desiredFullRobotModel.getPelvis());
        for (RobotSide robotSide : RobotSide.values) {
            listOfControllableRigidBodies.add(desiredFullRobotModel.getHand(robotSide));
            listOfControllableRigidBodies.add(desiredFullRobotModel.getForearm(robotSide));
            listOfControllableRigidBodies.add(desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        listOfControllableRigidBodies.removeIf(Objects::isNull);
        return listOfControllableRigidBodies;
    }

    public void setInitialRobotConfiguration(DRCRobotModel robotModel) {
        HashMap<OneDoFJointBasics, Double> privilegedConfiguration = new HashMap<OneDoFJointBasics, Double>();
        RobotInitialSetup<HumanoidFloatingRootJointRobot> defaultRobotInitialSetup = robotModel.getDefaultRobotInitialSetup(0.0, 0.0);
        FullHumanoidRobotModel robot = robotModel.createFullRobotModel();
        defaultRobotInitialSetup.initializeFullRobotModel(robot);
        for (OneDoFJointBasics joint : this.getDesiredOneDoFJoints()) {
            double q_priv = robot.getOneDoFJointByName(joint.getName()).getQ();
            privilegedConfiguration.put(joint, q_priv);
        }
        this.setInitialRobotConfiguration(privilegedConfiguration);
    }

    public void setCollisionModel(RobotCollisionModel collisionModel) {
        if (collisionModel != null) {
            this.registerRobotCollidables(collisionModel.getRobotCollidables(this.getDesiredFullRobotModel().getElevator()));
        }
    }

    @Override
    public boolean initialize() {
        KinematicsToolboxOutputStatus status = new KinematicsToolboxOutputStatus();
        status.setJointNameHash(-1);
        status.setSolutionQuality(Double.NaN);
        if (!super.initializeInternal()) {
            status.setCurrentToolboxState((byte)2);
            this.reportMessage(status);
            return false;
        }
        CapturabilityBasedStatus capturabilityBasedStatus = (CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForReading();
        boolean bl = this.hasCapturabilityBasedStatus = capturabilityBasedStatus != null;
        if (this.hasCapturabilityBasedStatus) {
            this.capturabilityBasedStatusInternal.set(capturabilityBasedStatus);
        }
        this.contactingRigidBodies.clear();
        if (this.hasCapturabilityBasedStatus) {
            this.processCapturabilityBasedStatus(capturabilityBasedStatus);
        } else {
            for (RobotSide robotSide : RobotSide.values) {
                ((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).set(true);
            }
        }
        if (this.initialRobotConfigurationMap != null) {
            MovingReferenceFrame desiredFrame;
            MovingReferenceFrame currentFrame;
            if (this.hasMultiContactBalanceStatus) {
                throw new UnsupportedOperationException("Initial robot configuration is not supported with multi-contact context.");
            }
            KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(this.robotConfigurationDataInternal, this.currentFullRobotModel.getRootJoint(), this.currentOneDoFJoints);
            this.currentReferenceFrames.updateFrames();
            this.rootJoint.getJointPose().setToZero();
            this.desiredReferenceFrames.updateFrames();
            if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.LEFT)).getValue()) {
                if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
                    currentFrame = this.currentReferenceFrames.getMidFootZUpGroundFrame();
                    desiredFrame = this.desiredReferenceFrames.getMidFootZUpGroundFrame();
                } else {
                    currentFrame = this.currentReferenceFrames.getSoleZUpFrame((Enum)RobotSide.LEFT);
                    desiredFrame = this.desiredReferenceFrames.getSoleZUpFrame((Enum)RobotSide.LEFT);
                }
            } else if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
                currentFrame = this.currentReferenceFrames.getSoleZUpFrame((Enum)RobotSide.RIGHT);
                desiredFrame = this.desiredReferenceFrames.getSoleZUpFrame((Enum)RobotSide.RIGHT);
            } else {
                throw new IllegalArgumentException("We have a flying robot here, such scenario is not handled.");
            }
            RigidBodyTransform rootJointTransform = currentFrame.getTransformToDesiredFrame((ReferenceFrame)desiredFrame);
            RigidBodyTransform rotationRelocation = desiredFrame.getTransformToDesiredFrame((ReferenceFrame)this.rootJoint.getFrameAfterJoint());
            rootJointTransform.multiplyInvertOther((RigidBodyTransformReadOnly)rotationRelocation);
            rootJointTransform.preMultiply((RigidBodyTransformReadOnly)rotationRelocation);
            this.rootJoint.getJointPose().set((RigidBodyTransformReadOnly)rootJointTransform);
            this.updateTools();
            this.desiredReferenceFrames.updateFrames();
        }
        this.updateCoMPositionAndFootPoses();
        this.holdSupportRigidBodies.set(true);
        this.enableAutoSupportPolygon.set(true);
        this.holdCenterOfMassXYPosition.set(true);
        this.enableJointLimitReduction.set(true);
        status.setCurrentToolboxState((byte)1);
        this.reportMessage(status);
        return true;
    }

    @Override
    public void updateInternal() {
        MultiContactBalanceStatus multiContactBalanceStatus;
        this.executionTimer.startMeasurement();
        if (this.commandInputManager.isNewCommandAvailable(HumanoidKinematicsToolboxConfigurationCommand.class)) {
            HumanoidKinematicsToolboxConfigurationCommand command = (HumanoidKinematicsToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(HumanoidKinematicsToolboxConfigurationCommand.class);
            this.holdCenterOfMassXYPosition.set(command.holdCurrentCenterOfMassXYPosition());
            this.holdSupportRigidBodies.set(command.holdSupportRigidBodies());
            this.enableMultiContactSupportRegionSolver.set(command.enableMultiContactSupportRegionSolver());
            this.enableJointLimitReduction.set(command.enableJointLimitReduction());
            if (command.hasCustomJointRestrictionLimits()) {
                int i;
                for (i = 0; i < this.currentOneDoFJoints.length; ++i) {
                    this.jointLimitReductionFactors.get(this.currentOneDoFJoints[i].getName()).set(0.0);
                }
                for (i = 0; i < command.getNumberOfCustomJointRestrictionLimits(); ++i) {
                    OneDoFJointBasics joint = (OneDoFJointBasics)this.jointHashCodeMap.get(command.getJointLimitReductionHashCode(i));
                    if (joint == null) continue;
                    double jointLimitReductionFactor = command.getJointRestrictionLimitFactor(i);
                    this.jointLimitReductionFactors.get(joint.getName()).set(jointLimitReductionFactor);
                }
            }
        }
        boolean bl = this.hasMultiContactBalanceStatus = (multiContactBalanceStatus = (MultiContactBalanceStatus)this.concurrentMultiContactBalanceStatusCopier.getCopyForReading()) != null;
        if (this.hasMultiContactBalanceStatus) {
            this.multiContactBalanceStatusInternal.set(multiContactBalanceStatus);
            this.processMultiContactBalanceStatus(this.multiContactBalanceStatusInternal);
        }
        super.updateInternal();
        this.executionTimer.stopMeasurement();
    }

    private void updateCoMPositionAndFootPoses() {
        this.updateTools();
        this.initialCenterOfMassPosition.setFromReferenceFrame(this.centerOfMassFrame);
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = this.desiredFullRobotModel.getFoot((Enum)robotSide);
            ((YoFramePose3D)this.initialFootPoses.get((Enum)robotSide)).setFromReferenceFrame((ReferenceFrame)foot.getBodyFixedFrame());
        }
    }

    private void addHoldSupportFootCommands(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.holdSupportRigidBodies.getBooleanValue()) {
            return;
        }
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot;
            if (!((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).getBooleanValue() || this.isUserControllingRigidBody(foot = this.desiredFullRobotModel.getFoot((Enum)robotSide))) continue;
            SpatialFeedbackControlCommand feedbackControlCommand = bufferToPack.addSpatialFeedbackControlCommand();
            feedbackControlCommand.set(this.rootBody, foot);
            feedbackControlCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(foot));
            feedbackControlCommand.resetControlFrame();
            feedbackControlCommand.resetControlBaseFrame();
            feedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.getDefaultSpatialGains());
            feedbackControlCommand.setSelectionMatrixToIdentity();
            feedbackControlCommand.setWeightForSolver(this.supportRigidBodyWeight.getValue());
            feedbackControlCommand.setInverseKinematics((FramePose3DReadOnly)this.initialFootPoses.get((Enum)robotSide), KinematicsToolboxHelper.zeroVector6D);
        }
    }

    private void addHoldSupportRigidBodyCommands(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.holdSupportRigidBodies.getBooleanValue()) {
            return;
        }
        if (this.contactingRigidBodies.isEmpty()) {
            return;
        }
        HashSet<RigidBodyBasics> controlledBodies = new HashSet<RigidBodyBasics>();
        for (int i = 0; i < this.contactingRigidBodies.size(); ++i) {
            ContactingRigidBody contactingRigidBody = (ContactingRigidBody)this.contactingRigidBodies.get(i);
            if (this.isUserControllingRigidBody(contactingRigidBody.rigidBody) || !controlledBodies.add(contactingRigidBody.rigidBody)) continue;
            SpatialFeedbackControlCommand feedbackControlCommand = bufferToPack.addSpatialFeedbackControlCommand();
            feedbackControlCommand.set(this.rootBody, contactingRigidBody.rigidBody);
            feedbackControlCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(contactingRigidBody.rigidBody));
            feedbackControlCommand.setControlFrameFixedInEndEffector((FramePoint3DReadOnly)contactingRigidBody.contactPointInBodyFixedFrame);
            feedbackControlCommand.resetControlBaseFrame();
            feedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.getDefaultSpatialGains());
            feedbackControlCommand.getSpatialAccelerationCommand().setSelectionMatrixForLinearControl();
            feedbackControlCommand.setWeightForSolver(this.supportRigidBodyWeight.getValue());
            feedbackControlCommand.setInverseKinematics((FramePoint3DReadOnly)contactingRigidBody.initialPosition, KinematicsToolboxHelper.zeroVector3D);
        }
    }

    private void addHoldCenterOfMassXYCommand(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.holdCenterOfMassXYPosition.getBooleanValue()) {
            return;
        }
        if (this.isUserControllingCenterOfMass()) {
            this.holdCenterOfMassXYPosition.set(false);
            return;
        }
        this.centerOfMassPositionToHold.setIncludingFrame((FrameTuple3DReadOnly)this.initialCenterOfMassPosition);
        CenterOfMassFeedbackControlCommand feedbackControlCommand = bufferToPack.addCenterOfMassFeedbackControlCommand();
        feedbackControlCommand.setGains((PID3DGains)this.getDefaultSpatialGains().getPositionGains());
        feedbackControlCommand.setWeightForSolver(this.momentumWeight.getDoubleValue());
        feedbackControlCommand.setSelectionMatrixForLinearXYControl();
        feedbackControlCommand.setInverseKinematics((FramePoint3DReadOnly)this.centerOfMassPositionToHold, KinematicsToolboxHelper.zeroVector3D);
    }

    private void addJointLimitReductionCommand(InverseKinematicsCommandBuffer bufferToPack) {
        if (!this.enableJointLimitReduction.getValue()) {
            return;
        }
        JointLimitReductionCommand jointLimitReductionCommand = bufferToPack.addJointLimitReductionCommand();
        jointLimitReductionCommand.clear();
        for (int i = 0; i < this.desiredOneDoFJoints.length; ++i) {
            double reductionFactor = this.jointLimitReductionFactors.get(this.desiredOneDoFJoints[i].getName()).getValue();
            if (reductionFactor <= 0.0 || reductionFactor > 1.0) continue;
            jointLimitReductionCommand.addReductionFactor(this.desiredOneDoFJoints[i], reductionFactor);
        }
    }

    private void processCapturabilityBasedStatus(CapturabilityBasedStatus capturabilityBasedStatus) {
        for (RobotSide robotside : RobotSide.values) {
            ((YoBoolean)this.isFootInSupport.get((Enum)robotside)).set(HumanoidMessageTools.unpackIsSupportFoot((CapturabilityBasedStatus)capturabilityBasedStatus, (RobotSide)robotside));
        }
        if (!this.isUserProvidingSupportPolygon()) {
            int i;
            IDLSequence.Object leftFootSupportPolygon2d = capturabilityBasedStatus.getLeftFootSupportPolygon3d();
            IDLSequence.Object rightFootSupportPolygon2d = capturabilityBasedStatus.getRightFootSupportPolygon3d();
            for (i = 0; i < leftFootSupportPolygon2d.size(); ++i) {
                ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame(worldFrame, (Tuple3DReadOnly)leftFootSupportPolygon2d.get(i));
            }
            for (i = 0; i < rightFootSupportPolygon2d.size(); ++i) {
                ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame(worldFrame, (Tuple3DReadOnly)rightFootSupportPolygon2d.get(i));
            }
            this.updateSupportPolygonConstraint((List<? extends FramePoint3DReadOnly>)this.activeContactPointPositions);
        }
    }

    private void processMultiContactBalanceStatus(MultiContactBalanceStatus multiContactBalanceStatus) {
        for (RobotSide robotside : RobotSide.values) {
            ((YoBoolean)this.isFootInSupport.get((Enum)robotside)).set(false);
        }
        this.contactingRigidBodies.clear();
        IDLSequence.Object supportPolygon = multiContactBalanceStatus.getContactPointsInWorld();
        IDLSequence.Integer supportRigidBodyIds = multiContactBalanceStatus.getSupportRigidBodyIds();
        if (multiContactBalanceStatus.getContactPointsInWorld().size() < 3) {
            this.shrunkSupportPolygon.clear();
            this.shrunkSupportPolygonVertices.clear();
            return;
        }
        for (int i = 0; i < supportPolygon.size(); ++i) {
            ContactingRigidBody contactingRigidBody = (ContactingRigidBody)this.contactingRigidBodies.add();
            contactingRigidBody.initialize((RigidBodyBasics)this.rigidBodyHashCodeMap.get(supportRigidBodyIds.get(i)), worldFrame, (Point3DReadOnly)supportPolygon.get(i));
        }
        if (this.solveForMultiContactSupportRegion(multiContactBalanceStatus)) {
            this.activeContactPointPositions.clear();
            this.getSolution().getSupportRegion().clear();
            ConvexPolygon2DReadOnly supportRegion = this.supportRegionSolver.getSupportRegion();
            for (int i = 0; i < supportRegion.getNumberOfVertices(); ++i) {
                ((Point3D)this.getSolution().getSupportRegion().add()).set((Tuple2DReadOnly)supportRegion.getVertex(i));
                ((FramePoint3D)this.activeContactPointPositions.add()).set((Tuple2DReadOnly)supportRegion.getVertex(i));
            }
            this.updateSupportPolygonConstraint((List<? extends FramePoint3DReadOnly>)this.activeContactPointPositions);
        }
    }

    private boolean solveForMultiContactSupportRegion(MultiContactBalanceStatus multiContactBalanceStatus) {
        boolean hasSurfaceNormalData;
        if (this.isUserProvidingSupportPolygon()) {
            return false;
        }
        if (!this.enableMultiContactSupportRegionSolver.getValue()) {
            return false;
        }
        boolean bl = hasSurfaceNormalData = multiContactBalanceStatus.getSurfaceNormalsInWorld().size() == multiContactBalanceStatus.getContactPointsInWorld().size();
        if (!hasSurfaceNormalData) {
            return false;
        }
        this.supportRegionSolverInput.clear();
        this.contactFrames.clear();
        for (int i = 0; i < multiContactBalanceStatus.getSupportRigidBodyIds().size(); ++i) {
            this.tmpContactPose.getPosition().set((Tuple3DReadOnly)multiContactBalanceStatus.getContactPointsInWorld().get(i));
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)((Vector3DReadOnly)multiContactBalanceStatus.getSurfaceNormalsInWorld().get(i)), (Orientation3DBasics)this.tmpContactPose.getOrientation());
            PoseReferenceFrame contactFrame = (PoseReferenceFrame)this.contactFrames.add();
            contactFrame.setPoseAndUpdate((FramePose3DReadOnly)this.tmpContactPose);
            RigidBodyBasics contactingBody = (RigidBodyBasics)this.rigidBodyHashCodeMap.get(multiContactBalanceStatus.getSupportRigidBodyIds().get(i));
            this.supportRegionSolverInput.addContactPoint((ReferenceFrame)contactFrame, contactingBody, this.rootJacobians.get(contactingBody));
        }
        this.supportRegionSolver.startTimer();
        this.supportRegionSolverInput.update();
        this.supportRegionSolver.initialize(this.supportRegionSolverInput);
        boolean success = this.supportRegionSolver.solve();
        this.supportRegionSolver.stopTimer();
        return success;
    }

    @Override
    protected void robotConfigurationReinitialized() {
        this.updateCoMPositionAndFootPoses();
    }

    public void updateFootSupportState(boolean isLeftFootInSupport, boolean isRightFootInSupport) {
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        if (isLeftFootInSupport) {
            capturabilityBasedStatus.getLeftFootSupportPolygon3d().add();
        }
        if (isRightFootInSupport) {
            capturabilityBasedStatus.getRightFootSupportPolygon3d().add();
        }
        this.updateCapturabilityBasedStatus(capturabilityBasedStatus);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        ((CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForWriting()).set(newStatus);
        this.concurrentCapturabilityBasedStatusCopier.commit();
    }

    public void updateMultiContactBalanceStatus(MultiContactBalanceStatus newStatus) {
        ((MultiContactBalanceStatus)this.concurrentMultiContactBalanceStatusCopier.getCopyForWriting()).set(newStatus);
        this.concurrentMultiContactBalanceStatusCopier.commit();
    }

    @Override
    protected RigidBodyBasics getEndEffectorPrimaryBase(RigidBodyBasics endEffector) {
        return this.endEffectorToPrimaryBaseMap.get(endEffector);
    }

    @Override
    protected void getAdditionalFeedbackControlCommands(FeedbackControlCommandBuffer bufferToPack) {
        this.addHoldSupportFootCommands(bufferToPack);
        this.addHoldSupportRigidBodyCommands(bufferToPack);
        this.addHoldCenterOfMassXYCommand(bufferToPack);
    }

    @Override
    protected void getAdditionalInverseKinematicsCommands(InverseKinematicsCommandBuffer bufferToPack) {
        this.addJointLimitReductionCommand(bufferToPack);
    }

    public YoDouble getMomentumWeight() {
        return this.momentumWeight;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.desiredFullRobotModel;
    }

    public CommonHumanoidReferenceFrames getDesiredReferenceFrames() {
        return this.desiredReferenceFrames;
    }

    public FullHumanoidRobotModel getCurrentFullRobotModel() {
        return this.currentFullRobotModel;
    }

    public CommonHumanoidReferenceFrames getCurrentReferenceFrames() {
        return this.currentReferenceFrames;
    }

    private static class ContactingRigidBody {
        private RigidBodyBasics rigidBody;
        private final FramePoint3D contactPointInBodyFixedFrame = new FramePoint3D();
        private final FramePoint3D initialPosition = new FramePoint3D();

        public void initialize(RigidBodyBasics rigidBody, ReferenceFrame positionFrame, Point3DReadOnly position) {
            this.rigidBody = rigidBody;
            this.initialPosition.setIncludingFrame(positionFrame, (Tuple3DReadOnly)position);
            this.contactPointInBodyFixedFrame.setIncludingFrame((FrameTuple3DReadOnly)this.initialPosition);
            this.contactPointInBodyFixedFrame.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
        }
    }
}

