/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.RobotConfigurationData;
import gnu.trove.list.array.TFloatArrayList;
import toolbox_msgs.msg.dds.KinematicsToolboxCenterOfMassMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion32;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class HumanoidKinematicsSolver {
    private static final int DEFAULT_MAX_NUMBER_OF_ITERATIONS = 200;
    private static final double DEFAULT_QUALITY_THRESHOLD = 0.005;
    private static final double DEFAULT_STABILITY_THRESHOLD = 2.0E-5;
    private static final double DEFAULT_MIN_PROGRESSION = 0.005;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final HumanoidKinematicsToolboxController controller;
    private final CommandInputManager commandInputManager = new CommandInputManager(this.name, KinematicsToolboxModule.supportedCommands());
    private final YoDouble solutionQualityThreshold = new YoDouble("solutionQualityThreshold", this.registry);
    private final YoDouble solutionStabilityThreshold = new YoDouble("solutionStabilityThreshold", this.registry);
    private final YoDouble solutionMinimumProgression = new YoDouble("solutionProgressionThreshold", this.registry);
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.registry);
    private final YoInteger maximumNumberOfIterations = new YoInteger("maximumNumberOfIterations", this.registry);
    private final YoBoolean hasConverged = new YoBoolean("hasConverged", this.registry);
    private final YoDouble computationTime = new YoDouble("computationTime", this.registry);
    private final YoDouble solutionQuality = new YoDouble("solutionQuality", this.registry);

    public HumanoidKinematicsSolver(FullHumanoidRobotModelFactory fullRobotModelFactory, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        StatusMessageOutputManager statusOutputManager = new StatusMessageOutputManager(KinematicsToolboxModule.supportedStatus());
        FullHumanoidRobotModel desiredFullRobotModel = fullRobotModelFactory.createFullRobotModel();
        double updateDT = 0.001;
        this.controller = new HumanoidKinematicsToolboxController(this.commandInputManager, statusOutputManager, desiredFullRobotModel, fullRobotModelFactory, updateDT, yoGraphicsListRegistry, this.registry);
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(desiredFullRobotModel, (ReferenceFrames)this.controller.getDesiredReferenceFrames()));
        this.maximumNumberOfIterations.set(200);
        this.solutionQualityThreshold.set(0.005);
        this.solutionStabilityThreshold.set(2.0E-5);
        this.solutionMinimumProgression.set(0.005);
        parentRegistry.addChild(this.registry);
    }

    public void setInitialConfiguration(KinematicsToolboxOutputStatus kinematicsToolboxOutputStatus) {
        RobotConfigurationData configurationData = new RobotConfigurationData();
        configurationData.setJointNameHash(kinematicsToolboxOutputStatus.getJointNameHash());
        MessageTools.copyData((TFloatArrayList)kinematicsToolboxOutputStatus.getDesiredJointAngles(), (TFloatArrayList)configurationData.getJointAngles());
        configurationData.getRootPosition().set((Tuple3DReadOnly)new Vector3D32((Tuple3DReadOnly)kinematicsToolboxOutputStatus.getDesiredRootPosition()));
        configurationData.getRootOrientation().set((QuaternionReadOnly)new Quaternion32((Orientation3DReadOnly)kinematicsToolboxOutputStatus.getDesiredRootOrientation()));
        this.setInitialConfiguration(configurationData);
    }

    public void setInitialConfiguration(RobotConfigurationData robotConfigurationData) {
        this.controller.updateRobotConfigurationData(robotConfigurationData);
    }

    public void submit(Iterable<KinematicsToolboxRigidBodyMessage> rigidBodyMessages) {
        rigidBodyMessages.forEach(this::submit);
    }

    public void submit(KinematicsToolboxRigidBodyMessage rigidBodyMessage) {
        this.commandInputManager.submitMessage((Settable)rigidBodyMessage);
    }

    public void submit(KinematicsToolboxCenterOfMassMessage centerOfMassMessage) {
        this.commandInputManager.submitMessage((Settable)centerOfMassMessage);
    }

    public void initialize() {
        this.controller.updateFootSupportState(true, true);
        boolean initialized = this.controller.initialize();
        if (!initialized) {
            throw new RuntimeException("Could not initialize the " + KinematicsToolboxController.class.getSimpleName());
        }
    }

    public boolean solve() {
        int iteration;
        long startTime = System.nanoTime();
        boolean isSolutionGood = false;
        boolean isSolverStuck = false;
        this.solutionQuality.set(Double.NaN);
        double solutionQualityLast = Double.NaN;
        double solutionQualityBeforeLast = Double.NaN;
        for (iteration = 0; !isSolutionGood && iteration < this.maximumNumberOfIterations.getIntegerValue(); ++iteration) {
            this.controller.updateInternal();
            KinematicsToolboxOutputStatus solution = this.controller.getSolution();
            this.solutionQuality.set(solution.getSolutionQuality());
            if (!Double.isNaN(solutionQualityLast)) {
                double deltaSolutionQualityLast = Math.abs(this.solutionQuality.getDoubleValue() - solutionQualityLast);
                double deltaSolutionQualityBeforeLast = Math.abs(this.solutionQuality.getDoubleValue() - solutionQualityBeforeLast);
                boolean isSolutionStable = deltaSolutionQualityLast < this.solutionStabilityThreshold.getDoubleValue();
                boolean isSolutionQualityHigh = this.solutionQuality.getDoubleValue() < this.solutionQualityThreshold.getDoubleValue();
                boolean bl = isSolutionGood = isSolutionStable && isSolutionQualityHigh;
                if (!isSolutionQualityHigh) {
                    boolean stuckLast = deltaSolutionQualityLast / this.solutionQuality.getDoubleValue() < this.solutionMinimumProgression.getDoubleValue();
                    boolean stuckBeforeLast = deltaSolutionQualityBeforeLast / this.solutionQuality.getDoubleValue() < this.solutionMinimumProgression.getDoubleValue();
                    isSolverStuck = stuckLast || stuckBeforeLast;
                } else {
                    isSolverStuck = false;
                }
            }
            solutionQualityBeforeLast = solutionQualityLast;
            solutionQualityLast = this.solutionQuality.getDoubleValue();
            if (!isSolverStuck) continue;
            break;
        }
        this.numberOfIterations.set(iteration);
        this.hasConverged.set(isSolutionGood);
        long endTime = System.nanoTime();
        this.computationTime.set(Conversions.nanosecondsToSeconds((long)(endTime - startTime)));
        return isSolutionGood;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.controller.getDesiredFullRobotModel();
    }

    public KinematicsToolboxOutputStatus getSolution() {
        return this.controller.getSolution();
    }
}

