/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import toolbox_msgs.msg.dds.KinematicsPlanningToolboxOutputStatus;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.KinematicsPlanningToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.KinematicsPlanningToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.kinematicsPlanningToolboxAPI.KinematicsPlanningToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsPlanningToolboxAPI.KinematicsPlanningToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsPlanningToolboxAPI.KinematicsPlanningToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class KinematicsPlanningToolboxModule
extends ToolboxModule {
    private final KinematicsPlanningToolboxController kinematicsPlanningToolboxController;

    public KinematicsPlanningToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, DomainFactory.PubSubImplementation pubSubImplementation) throws IOException {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 1, pubSubImplementation);
        this.kinematicsPlanningToolboxController = new KinematicsPlanningToolboxController(robotModel, this.fullRobotModel, this.commandInputManager, this.statusOutputManager, this.yoGraphicsListRegistry, this.registry);
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsPlanningToolboxCommandConverter(this.fullRobotModel, this.kinematicsPlanningToolboxController.getDesiredReferenceFrames()));
        this.startYoVariableServer();
    }

    @Override
    public void registerExtraPuSubs(ROS2NodeInterface ros2Node) {
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)this.robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.kinematicsPlanningToolboxController != null) {
                this.kinematicsPlanningToolboxController.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.kinematicsPlanningToolboxController != null) {
                this.kinematicsPlanningToolboxController.updateCapturabilityBasedStatus((CapturabilityBasedStatus)s.takeNextData());
            }
        });
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.kinematicsPlanningToolboxController;
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(KinematicsPlanningToolboxOutputStatus.class);
        status.add(KinematicsToolboxOutputStatus.class);
        return status;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return KinematicsPlanningToolboxModule.supportedCommands();
    }

    static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(KinematicsToolboxConfigurationCommand.class);
        commands.add(KinematicsPlanningToolboxCenterOfMassCommand.class);
        commands.add(KinematicsPlanningToolboxRigidBodyCommand.class);
        commands.add(KinematicsPlanningToolboxInputCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return KinematicsPlanningToolboxModule.supportedStatus();
    }

    public ROS2Topic getOutputTopic() {
        return KinematicsPlanningToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic getOutputTopic(String robotName) {
        return ROS2Tools.KINEMATICS_PLANNING_TOOLBOX.withRobot(robotName).withOutput();
    }

    public ROS2Topic getInputTopic() {
        return KinematicsPlanningToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic getInputTopic(String robotName) {
        return ROS2Tools.KINEMATICS_PLANNING_TOOLBOX.withRobot(robotName).withInput();
    }
}

