/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.externalForceEstimationToolboxModule;

import controller_msgs.msg.dds.JointDesiredOutputMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.RobotDesiredConfigurationData;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToIntFunction;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import toolbox_msgs.msg.dds.ExternalForceEstimationOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactablePlaneBodyTools;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.RectangularContactableBody;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ContactParticleFilter;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ForceEstimatorDynamicMatrixUpdater;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.PredefinedContactExternalForceSolver;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.DynamicsMatrixCalculator;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.externalForceEstimationToolboxAPI.ExternalForceEstimationToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ExternalForceEstimationToolboxController
extends ToolboxController {
    private final YoBoolean waitingForRobotConfigurationData;
    private final YoBoolean waitingForRobotControllerData;
    private final YoBoolean contactParticleFilterHasInitialized;
    private final YoBoolean estimateContactPosition;
    private final YoBoolean isDone;
    private final AtomicReference<RobotConfigurationData> robotConfigurationData;
    private final AtomicReference<RobotDesiredConfigurationData> robotDesiredConfigurationData;
    private final HumanoidReferenceFrames referenceFrames;
    private final FullHumanoidRobotModel fullRobotModel;
    private final FloatingJointBasics rootJoint;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final TIntObjectHashMap<RigidBodyBasics> rigidBodyHashMap;
    private final HashMap<String, OneDoFJointBasics> jointNameMap;
    private final ToIntFunction<String> jointNameToMatrixIndexFunction;
    private final YoBoolean calculateRootJointWrench;
    private final int degreesOfFreedom;
    private final DynamicsMatrixCalculator dynamicsMatrixCalculator;
    private final DMatrixRMaj controllerDesiredQdd;
    private final DMatrixRMaj controllerDesiredTau;
    private final DMatrixRMaj massMatrix;
    private final DMatrixRMaj coriolisGravityMatrix;
    private final CommandInputManager commandInputManager;
    private final ExternalForceEstimationOutputStatus outputStatus;
    private PredefinedContactExternalForceSolver predefinedContactForceSolver;
    private ContactParticleFilter contactParticleFilter;
    private final YoBoolean enableJointNoiseModel;
    private final YoDouble rootJointNoise;
    private final YoDouble jointNoiseMultiplier;

    public ExternalForceEstimationToolboxController(DRCRobotModel robotModel, FullHumanoidRobotModel fullRobotModel, CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, YoGraphicsListRegistry graphicsListRegistry, int updateRateMillis, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.waitingForRobotConfigurationData = new YoBoolean("waitingForRobotConfigurationData", this.registry);
        this.waitingForRobotControllerData = new YoBoolean("waitingForRobotControllerData", this.registry);
        this.contactParticleFilterHasInitialized = new YoBoolean("contactParticleFilterHasInitialized", this.registry);
        this.estimateContactPosition = new YoBoolean("estimateContactPosition", this.registry);
        this.isDone = new YoBoolean("isDone", this.registry);
        this.robotConfigurationData = new AtomicReference();
        this.robotDesiredConfigurationData = new AtomicReference();
        this.rigidBodyHashMap = new TIntObjectHashMap();
        this.jointNameMap = new HashMap();
        this.calculateRootJointWrench = new YoBoolean("calculateRootJointWrench", this.registry);
        this.outputStatus = new ExternalForceEstimationOutputStatus();
        this.enableJointNoiseModel = new YoBoolean("enableJointNoiseModel", this.registry);
        this.rootJointNoise = new YoDouble("rootJointNoise", this.registry);
        this.jointNoiseMultiplier = new YoDouble("jointNoiseMultiplier", this.registry);
        this.commandInputManager = commandInputManager;
        this.fullRobotModel = fullRobotModel;
        this.referenceFrames = new HumanoidReferenceFrames(fullRobotModel);
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        this.rootJoint = fullRobotModel.getRootJoint();
        MultiBodySystemTools.getRootBody((RigidBodyBasics)fullRobotModel.getElevator()).subtreeIterable().forEach(rigidBody -> this.rigidBodyHashMap.put(rigidBody.hashCode(), rigidBody));
        double updateDT = Conversions.millisecondsToSeconds((double)updateRateMillis);
        JointBasics[] joints = HighLevelHumanoidControllerToolbox.computeJointsToOptimizeFor((FullHumanoidRobotModel)fullRobotModel, (JointBasics[])new JointBasics[0]);
        WholeBodyControlCoreToolbox controlCoreToolbox = new WholeBodyControlCoreToolbox(robotModel.getControllerDT(), 9.81, fullRobotModel.getRootJoint(), joints, this.referenceFrames.getCenterOfMassFrame(), (ControllerCoreOptimizationSettings)robotModel.getWalkingControllerParameters().getMomentumOptimizationSettings(), graphicsListRegistry, parentRegistry);
        ArrayList<RectangularContactableBody> contactablePlaneBodies = new ArrayList<RectangularContactableBody>();
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics footBody = fullRobotModel.getFoot((Enum)robotSide);
            MovingReferenceFrame soleFrame = fullRobotModel.getSoleFrame((Enum)robotSide);
            contactablePlaneBodies.add(ContactablePlaneBodyTools.createTypicalContactablePlaneBodyForTests((RigidBodyBasics)footBody, (ReferenceFrame)soleFrame));
        }
        controlCoreToolbox.setupForInverseDynamicsSolver(contactablePlaneBodies);
        this.dynamicsMatrixCalculator = new DynamicsMatrixCalculator(controlCoreToolbox);
        this.degreesOfFreedom = Arrays.stream(joints).mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        this.controllerDesiredQdd = new DMatrixRMaj(this.degreesOfFreedom, 1);
        this.controllerDesiredTau = new DMatrixRMaj(this.degreesOfFreedom, 1);
        this.massMatrix = new DMatrixRMaj(this.degreesOfFreedom, this.degreesOfFreedom);
        this.coriolisGravityMatrix = new DMatrixRMaj(this.degreesOfFreedom, 1);
        ForceEstimatorDynamicMatrixUpdater dynamicMatrixUpdater = (massMatrix, coriolisGravityMatrix, tau) -> {
            massMatrix.set((DMatrixD1)this.massMatrix);
            coriolisGravityMatrix.set((DMatrixD1)this.coriolisGravityMatrix);
            tau.set((DMatrixD1)this.controllerDesiredTau);
        };
        RobotCollisionModel collisionModel = robotModel.getHumanoidRobotKinematicsCollisionModel();
        List collidables = collisionModel.getRobotCollidables(fullRobotModel.getRootBody());
        this.predefinedContactForceSolver = new PredefinedContactExternalForceSolver(joints, updateDT, dynamicMatrixUpdater, graphicsListRegistry, this.registry);
        this.contactParticleFilter = new ContactParticleFilter(joints, updateDT, dynamicMatrixUpdater, collidables, graphicsListRegistry, this.registry);
        String jointName = "torsoRoll";
        Point3D offset = new Point3D(0.137, 0.05, 0.329);
        this.contactParticleFilter.setActualContactingBodyForDebugging(jointName, (Tuple3DReadOnly)offset);
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            this.jointNameMap.put(this.oneDoFJoints[i].getName(), this.oneDoFJoints[i]);
        }
        this.jointNameToMatrixIndexFunction = j -> {
            OneDoFJointBasics joint = this.jointNameMap.get(j);
            return this.dynamicsMatrixCalculator.getMassMatrixCalculator().getInput().getJointMatrixIndexProvider().getJointDoFIndices((JointReadOnly)joint)[0];
        };
        this.enableJointNoiseModel.set(false);
        this.rootJointNoise.set(20.0);
        this.jointNoiseMultiplier.set(0.03);
    }

    @Override
    public boolean initialize() {
        this.waitingForRobotConfigurationData.set(true);
        this.waitingForRobotControllerData.set(true);
        this.isDone.set(false);
        if (this.commandInputManager.isNewCommandAvailable(ExternalForceEstimationToolboxConfigurationCommand.class)) {
            ExternalForceEstimationToolboxConfigurationCommand configurationCommand = (ExternalForceEstimationToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(ExternalForceEstimationToolboxConfigurationCommand.class);
            this.estimateContactPosition.set(configurationCommand.getEstimateContactLocation());
            if (!this.estimateContactPosition.getBooleanValue()) {
                this.predefinedContactForceSolver.clearContactPoints();
                int numberOfContactPoints = configurationCommand.getNumberOfContactPoints();
                for (int i = 0; i < numberOfContactPoints; ++i) {
                    RigidBodyBasics rigidBody = (RigidBodyBasics)this.rigidBodyHashMap.get(configurationCommand.getRigidBodyHashCodes().get(i));
                    Point3D contactPoint = (Point3D)configurationCommand.getContactPointPositions().get(i);
                    this.predefinedContactForceSolver.addContactPoint(rigidBody, (Tuple3DReadOnly)contactPoint, true);
                }
                this.calculateRootJointWrench.set(configurationCommand.getCalculateRootJointWrench());
                if (this.calculateRootJointWrench.getValue()) {
                    this.predefinedContactForceSolver.addContactPoint(this.fullRobotModel.getRootBody(), (Tuple3DReadOnly)new Vector3D(), false);
                }
                this.predefinedContactForceSolver.setEstimatorGain(configurationCommand.getEstimatorGain());
                this.predefinedContactForceSolver.setSolverAlpha(configurationCommand.getSolverAlpha());
            }
            this.commandInputManager.clearCommands(ExternalForceEstimationToolboxConfigurationCommand.class);
        }
        this.predefinedContactForceSolver.initialize();
        this.contactParticleFilterHasInitialized.set(false);
        return true;
    }

    @Override
    public void updateInternal() {
        RobotDesiredConfigurationData desiredConfigurationData;
        RobotConfigurationData robotConfigurationData = this.robotConfigurationData.getAndSet(null);
        if (robotConfigurationData != null) {
            ExternalForceEstimationToolboxController.updateRobotState(robotConfigurationData, this.rootJoint, this.oneDoFJoints);
            this.referenceFrames.updateFrames();
            this.waitingForRobotConfigurationData.set(false);
        }
        if ((desiredConfigurationData = (RobotDesiredConfigurationData)this.robotDesiredConfigurationData.getAndSet(null)) != null) {
            ExternalForceEstimationToolboxController.updateRobotDesiredState(desiredConfigurationData, this.controllerDesiredQdd, this.jointNameToMatrixIndexFunction);
            this.waitingForRobotControllerData.set(false);
        }
        if (this.waitingForRobotControllerData.getBooleanValue() || this.waitingForRobotConfigurationData.getBooleanValue()) {
            return;
        }
        if (this.estimateContactPosition.getBooleanValue() && !this.contactParticleFilterHasInitialized.getBooleanValue()) {
            this.contactParticleFilter.initializeJointspaceEstimator();
            this.contactParticleFilter.initializeParticleFilter();
            this.contactParticleFilterHasInitialized.set(true);
        }
        this.dynamicsMatrixCalculator.compute();
        this.dynamicsMatrixCalculator.getMassMatrix(this.massMatrix);
        this.dynamicsMatrixCalculator.getCoriolisMatrix(this.coriolisGravityMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.massMatrix, (DMatrix1Row)this.controllerDesiredQdd, (DMatrix1Row)this.controllerDesiredTau);
        CommonOps_DDRM.addEquals((DMatrixD1)this.controllerDesiredTau, (DMatrixD1)this.coriolisGravityMatrix);
        if (this.estimateContactPosition.getBooleanValue()) {
            RigidBodyBasics estimatedContactingBody;
            this.setModelledJointNoise();
            this.contactParticleFilter.computeJointspaceDisturbance();
            this.contactParticleFilter.computeParticleFilterEstimation();
            if (this.contactParticleFilter.hasConverged()) {
                this.isDone.set(true);
            }
            if ((estimatedContactingBody = this.contactParticleFilter.getEstimatedContactingBody()) == null) {
                this.outputStatus.setRigidBodyHashCode(-1);
                this.outputStatus.getContactPoint().setToNaN();
            } else {
                this.outputStatus.setRigidBodyHashCode(estimatedContactingBody.hashCode());
                this.contactParticleFilter.getEstimatedContactPosition().changeFrame((ReferenceFrame)estimatedContactingBody.getParentJoint().getFrameAfterJoint());
                this.outputStatus.getContactPoint().set((Tuple3DReadOnly)this.contactParticleFilter.getEstimatedContactPosition());
            }
        } else {
            this.predefinedContactForceSolver.doControl();
            this.outputStatus.getEstimatedExternalForces().clear();
            YoFixedFrameSpatialVector[] estimatedExternalWrenches = this.predefinedContactForceSolver.getEstimatedExternalWrenches();
            int numberOfContactPoints = this.predefinedContactForceSolver.getNumberOfContactPoints() - (this.calculateRootJointWrench.getValue() ? 1 : 0);
            for (int i = 0; i < numberOfContactPoints; ++i) {
                ((Vector3D)this.outputStatus.getEstimatedExternalForces().add()).set((Tuple3DReadOnly)estimatedExternalWrenches[i].getLinearPart());
            }
            if (this.calculateRootJointWrench.getValue()) {
                int lastIndex = this.predefinedContactForceSolver.getNumberOfContactPoints() - 1;
                this.outputStatus.getEstimatedRootJointWrench().getTorque().set((Tuple3DReadOnly)this.predefinedContactForceSolver.getEstimatedExternalWrenches()[lastIndex].getAngularPart());
                this.outputStatus.getEstimatedRootJointWrench().getForce().set((Tuple3DReadOnly)this.predefinedContactForceSolver.getEstimatedExternalWrenches()[lastIndex].getLinearPart());
            } else {
                this.outputStatus.getEstimatedRootJointWrench().getTorque().setToNaN();
                this.outputStatus.getEstimatedRootJointWrench().getForce().setToNaN();
            }
        }
        this.outputStatus.setSequenceId(this.outputStatus.getSequenceId() + 1L);
        this.statusOutputManager.reportStatusMessage((Object)this.outputStatus);
    }

    public void setModelledJointNoise() {
        if (this.enableJointNoiseModel.getBooleanValue()) {
            int i;
            for (i = 0; i < 6; ++i) {
                this.contactParticleFilter.setDoFVariance(i, this.rootJointNoise.getValue());
            }
            for (i = 0; i < this.oneDoFJoints.length; ++i) {
                String name = this.oneDoFJoints[i].getName();
                double modeledNoise = this.jointNoiseMultiplier.getValue() * Math.abs(this.oneDoFJoints[i].getEffortLimitUpper());
                this.contactParticleFilter.setDoFVariance(this.jointNameToMatrixIndexFunction.applyAsInt(name), modeledNoise);
            }
        } else {
            for (int i = 0; i < this.degreesOfFreedom; ++i) {
                this.contactParticleFilter.setDoFVariance(i, 1.0);
            }
        }
    }

    public void updateRobotConfigurationData(RobotConfigurationData robotConfigurationData) {
        this.robotConfigurationData.set(robotConfigurationData);
    }

    public void updateRobotDesiredConfigurationData(RobotDesiredConfigurationData robotDesiredConfigurationData) {
        this.robotDesiredConfigurationData.set(robotDesiredConfigurationData);
    }

    @Override
    public boolean isDone() {
        return this.isDone.getValue();
    }

    public FloatingJointBasics getRootJoint() {
        return this.rootJoint;
    }

    public OneDoFJointBasics[] getOneDoFJoints() {
        return this.oneDoFJoints;
    }

    private static void updateRobotState(RobotConfigurationData robotConfigurationData, FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints) {
        IDLSequence.Float newJointAngles = robotConfigurationData.getJointAngles();
        IDLSequence.Float newJointVelocities = robotConfigurationData.getJointVelocities();
        if (newJointAngles.size() != oneDoFJoints.length) {
            throw new RuntimeException("Received RobotConfigurationData packet with " + newJointAngles.size() + "joints, expected " + oneDoFJoints.length);
        }
        for (int i = 0; i < newJointAngles.size(); ++i) {
            oneDoFJoints[i].setQ((double)newJointAngles.get(i));
            oneDoFJoints[i].setQd((double)newJointVelocities.get(i));
        }
        rootJoint.setJointConfiguration((Orientation3DReadOnly)robotConfigurationData.getRootOrientation(), (Tuple3DReadOnly)robotConfigurationData.getRootPosition());
        rootJoint.setJointLinearVelocity((Vector3DReadOnly)robotConfigurationData.getPelvisLinearVelocity());
        rootJoint.setJointAngularVelocity((Vector3DReadOnly)robotConfigurationData.getPelvisAngularVelocity());
        rootJoint.getPredecessor().updateFramesRecursively();
    }

    private static void updateRobotDesiredState(RobotDesiredConfigurationData desiredConfigurationData, DMatrixRMaj controllerDesiredQdd, ToIntFunction<String> jointNameToMatrixIndex) {
        CommonOps_DDRM.fill((DMatrixD1)controllerDesiredQdd, (double)0.0);
        desiredConfigurationData.getDesiredRootJointAngularAcceleration().get(0, (DMatrix)controllerDesiredQdd);
        desiredConfigurationData.getDesiredRootJointLinearAcceleration().get(3, (DMatrix)controllerDesiredQdd);
        IDLSequence.Object jointDesiredOutputList = desiredConfigurationData.getJointDesiredOutputList();
        for (int i = 0; i < jointDesiredOutputList.size(); ++i) {
            String jointName = ((JointDesiredOutputMessage)jointDesiredOutputList.get(i)).getJointName().toString();
            int matrixIndex = jointNameToMatrixIndex.applyAsInt(jointName);
            controllerDesiredQdd.set(matrixIndex, 0, ((JointDesiredOutputMessage)jointDesiredOutputList.get(i)).getDesiredAcceleration());
        }
    }
}

