/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.directionalControlToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.DirectionalControlConfigurationMessage;
import controller_msgs.msg.dds.DirectionalControlInputMessage;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingControllerFailureStatusMessage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.avatar.joystickBasedJavaFXController.JoystickStepParametersProperty;
import us.ihmc.avatar.joystickBasedJavaFXController.UserProfileManager;
import us.ihmc.avatar.networkProcessor.directionalControlToolboxModule.RobotModelUpdater;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.ContinuousStepGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.footstepPlanning.graphSearch.collision.BoundingBoxCollisionDetector;
import us.ihmc.footstepPlanning.polygonSnapping.PlanarRegionsListPolygonSnapper;
import us.ihmc.footstepPlanning.simplePlanners.SnapAndWiggleSingleStep;
import us.ihmc.footstepPlanning.simplePlanners.SnapAndWiggleSingleStepParameters;
import us.ihmc.humanoidRobotics.communication.directionalControlToolboxAPI.DirectionalControlConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.directionalControlToolboxAPI.DirectionalControlInputCommand;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class DirectionalControlController
extends ToolboxController {
    private final int MAIN_TASK_RATE_MS = 500;
    private final DoubleProperty turningVelocityProperty = new SimpleDoubleProperty((Object)this, "turningVelocityProperty", 0.0);
    private final DoubleProperty forwardVelocityProperty = new SimpleDoubleProperty((Object)this, "forwardVelocityProperty", 0.0);
    private final DoubleProperty lateralVelocityProperty = new SimpleDoubleProperty((Object)this, "lateralVelocityProperty", 0.0);
    private final AtomicReference<PlanarRegionsListMessage> planarRegionsListMessage = new AtomicReference<Object>(null);
    private final AtomicReference<FootstepDataListMessage> footstepsToSendReference = new AtomicReference<Object>(null);
    private final AtomicReference<PlanarRegionsList> planarRegionsList = new AtomicReference<Object>(null);
    private final AtomicReference<DirectionalControlInputCommand> controlInputCommand = new AtomicReference<Object>(null);
    private final AtomicReference<DirectionalControlConfigurationCommand> controlConfigurationCommand = new AtomicReference<Object>(null);
    private final AtomicBoolean isWalking = new AtomicBoolean(false);
    private final AtomicBoolean hasSuccessfullyStoppedWalking = new AtomicBoolean(false);
    private final AtomicBoolean ignorePlanarRegions = new AtomicBoolean(true);
    private JoystickStepParametersProperty.JoystickStepParameters controlParameters;
    private UserProfileManager<JoystickStepParametersProperty.JoystickStepParameters> userProfileManager;
    private AtomicReference<JoystickStepParametersProperty.JoystickStepParameters> stepParametersReference;
    private final SteppingParameters steppingParameters;
    private final SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons;
    private final DoubleProvider stepTime;
    private final BoundingBoxCollisionDetector collisionDetector;
    private final RobotModelUpdater robotUpdater;
    private Consumer<FootstepDataListMessage> footstepPublisher = m -> {};
    private Consumer<FootstepDataListMessage> footstepVisualizationPublisher = m -> {};
    private Consumer<PauseWalkingMessage> pauseWalkingPublisher = m -> {};
    private final ContinuousStepGenerator continuousStepGenerator = new ContinuousStepGenerator();
    private final SnapAndWiggleSingleStep snapAndWiggleSingleStep;
    private final SnapAndWiggleSingleStepParameters snapAndWiggleParameters = new SnapAndWiggleSingleStepParameters();
    private final ConvexPolygon2D footPolygonToWiggle = new ConvexPolygon2D();
    private final ConvexPolygon2D footPolygon = new ConvexPolygon2D();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final PlanarRegion tempRegion = new PlanarRegion();
    private final SideDependentList<FramePose3D> lastSupportFootPoses = new SideDependentList(null, null);
    private final ConcurrentLinkedQueue<Runnable> queuedTasksToProcess = new ConcurrentLinkedQueue();
    private final AtomicBoolean isLeftFootInSupport = new AtomicBoolean(false);
    private final AtomicBoolean isRightFootInSupport = new AtomicBoolean(false);
    private final SideDependentList<AtomicBoolean> isFootInSupport = new SideDependentList((Object)this.isLeftFootInSupport, (Object)this.isRightFootInSupport);
    private final BooleanProvider isInDoubleSupport = () -> this.isLeftFootInSupport.get() && this.isRightFootInSupport.get();
    private boolean supportFootPosesInitialized = false;
    private FootstepDataListMessage lastPublishedFootstepPlan = null;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(4);

    public DirectionalControlController(FullHumanoidRobotModel robotModel, WalkingControllerParameters walkingControllerParameters, StatusMessageOutputManager statusOutputManager, YoRegistry registry) {
        super(statusOutputManager, registry);
        this.footPolygons = this.getFootPolygons(walkingControllerParameters);
        this.robotUpdater = new RobotModelUpdater(robotModel);
        this.steppingParameters = walkingControllerParameters.getSteppingParameters();
        this.stepTime = () -> this.getSwingDuration() + this.getTransferDuration();
        this.controlParameters = new JoystickStepParametersProperty.JoystickStepParameters(walkingControllerParameters);
        this.userProfileManager = new UserProfileManager<JoystickStepParametersProperty.JoystickStepParameters>(null, this.controlParameters, JoystickStepParametersProperty.JoystickStepParameters::parseFromPropertyMap, JoystickStepParametersProperty.JoystickStepParameters::exportToPropertyMap);
        this.controlParameters = this.userProfileManager.loadProfile("default");
        this.stepParametersReference = new AtomicReference<JoystickStepParametersProperty.JoystickStepParameters>(this.controlParameters);
        this.snapAndWiggleParameters.setFootLength(walkingControllerParameters.getSteppingParameters().getFootLength());
        this.snapAndWiggleSingleStep = new SnapAndWiggleSingleStep(this.snapAndWiggleParameters);
        this.continuousStepGenerator.setNumberOfFootstepsToPlan(10);
        this.continuousStepGenerator.setDesiredTurningVelocityProvider(() -> this.turningVelocityProperty.get());
        this.continuousStepGenerator.setDesiredVelocityProvider(() -> new Vector2D(this.forwardVelocityProperty.get(), this.lateralVelocityProperty.get()));
        this.continuousStepGenerator.configureWith(walkingControllerParameters);
        this.continuousStepGenerator.addFootstepAdjustment(this::adjustFootstep);
        this.continuousStepGenerator.setFootstepMessenger(this::prepareFootsteps);
        this.continuousStepGenerator.setFootPoseProvider(robotSide -> new FramePose3D((ReferenceFrame)this.getSoleFrame(robotSide)));
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isStepSnappable);
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isSafeDistanceFromObstacle);
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isSafeStepHeight);
        double collisionBoxDepth = 0.65;
        double collisionBoxWidth = 1.15;
        double collisionBoxHeight = 1.0;
        this.collisionDetector = new BoundingBoxCollisionDetector();
        this.collisionDetector.setBoxDimensions(collisionBoxDepth, collisionBoxWidth, collisionBoxHeight);
        this.setupLowBandwidthTasks();
        LogTools.info((String)("Ignoring REA planes is " + this.ignorePlanarRegions.toString()));
    }

    public void setFootstepPublisher(Consumer<FootstepDataListMessage> footstepPublisher) {
        this.footstepPublisher = footstepPublisher;
    }

    public void setFootstepVisualizationPublisher(Consumer<FootstepDataListMessage> footstepVisualizationPublisher) {
        this.footstepVisualizationPublisher = footstepVisualizationPublisher;
    }

    public void setPauseWalkingPublisher(Consumer<PauseWalkingMessage> pauseWalkingPublisher) {
        this.pauseWalkingPublisher = pauseWalkingPublisher;
    }

    public void updateRobotConfigurationData(RobotConfigurationData message) {
        this.robotUpdater.updateConfiguration(message);
        RobotMotionStatus newStatus = RobotMotionStatus.fromByte((byte)message.getRobotMotionStatus());
        if (this.hasSuccessfullyStoppedWalking.get() || this.isWalking.get()) {
            return;
        }
        if (newStatus == null) {
            return;
        }
        if (newStatus == RobotMotionStatus.STANDING) {
            this.hasSuccessfullyStoppedWalking.set(true);
        }
    }

    public void updateFootstepStatusMessage(FootstepStatusMessage message) {
        this.queuedTasksToProcess.add(() -> {
            this.continuousStepGenerator.consumeFootstepStatus(message);
            if (message.getFootstepStatus() == FootstepStatus.COMPLETED.toByte()) {
                this.lastSupportFootPoses.put((Enum)RobotSide.fromByte((byte)message.getRobotSide()), (Object)new FramePose3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)message.getActualFootPositionInWorld(), (Orientation3DReadOnly)message.getActualFootOrientationInWorld()));
            }
        });
    }

    public void updatePlanarRegionsListMessage(PlanarRegionsListMessage message) {
        this.planarRegionsListMessage.set(message);
    }

    public void updateWalkingControllerFailureStatusMessage(WalkingControllerFailureStatusMessage message) {
        this.stopWalking();
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus message) {
        this.queuedTasksToProcess.add(() -> {
            this.isLeftFootInSupport.set(!message.getLeftFootSupportPolygon3d().isEmpty());
            this.isRightFootInSupport.set(!message.getRightFootSupportPolygon3d().isEmpty());
        });
    }

    public void updateConfiguration(DirectionalControlConfigurationCommand command) {
        this.controlConfigurationCommand.set(command);
        LogTools.info((String)("Config is now " + this.controlConfigurationCommand.toString()));
    }

    public void updateConfiguration(DirectionalControlConfigurationMessage message) {
        DirectionalControlConfigurationCommand command = new DirectionalControlConfigurationCommand();
        command.setFromMessage(message);
        this.updateConfiguration(command);
    }

    public void updateInputs(DirectionalControlInputCommand command) {
        this.controlInputCommand.set(command);
    }

    public void updateInputs(DirectionalControlInputMessage message) {
        DirectionalControlInputCommand command = new DirectionalControlInputCommand();
        command.setFromMessage(message);
        this.updateInputs(command);
    }

    private void setupLowBandwidthTasks() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    DirectionalControlController.this.publishFootsteps();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        final ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(task, 0L, 500L, TimeUnit.MILLISECONDS);
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    LogTools.error((String)("Caught exception in main task: " + e));
                    future.cancel(true);
                }
            }
        });
    }

    private SideDependentList<ConvexPolygon2D> getFootPolygons(WalkingControllerParameters walkingControllerParameters) {
        SteppingParameters steppingParameters = walkingControllerParameters.getSteppingParameters();
        double footLength = steppingParameters.getFootLength();
        double footWidth = steppingParameters.getFootWidth();
        ConvexPolygon2D footPolygon = new ConvexPolygon2D();
        footPolygon.addVertex(footLength / 2.0, footWidth / 2.0);
        footPolygon.addVertex(footLength / 2.0, -footWidth / 2.0);
        footPolygon.addVertex(-footLength / 2.0, -footWidth / 2.0);
        footPolygon.addVertex(-footLength / 2.0, footWidth / 2.0);
        footPolygon.update();
        SideDependentList footPolygons = new SideDependentList((Object)footPolygon, (Object)footPolygon);
        return footPolygons;
    }

    private FullHumanoidRobotModel getFullRobotModel() {
        return this.robotUpdater.getRobot();
    }

    private MovingReferenceFrame getSoleFrame(RobotSide robotSide) {
        return this.getFullRobotModel().getSoleFrame((Enum)robotSide);
    }

    public double getSwingDuration() {
        return this.stepParametersReference.get().getSwingDuration();
    }

    public double getTransferDuration() {
        return this.stepParametersReference.get().getTransferDuration();
    }

    private boolean adjustFootstep(FramePose3DReadOnly stancePose, FramePose2DReadOnly footstepPose, RobotSide footSide, FootstepDataMessage adjustedFootstep) {
        FramePose3D adjustedBasedOnStanceFoot = new FramePose3D();
        adjustedBasedOnStanceFoot.getPosition().set((FrameTuple2DReadOnly)footstepPose.getPosition());
        adjustedBasedOnStanceFoot.setZ(this.continuousStepGenerator.getCurrentSupportFootPose().getZ());
        adjustedBasedOnStanceFoot.getOrientation().set(footstepPose.getOrientation());
        if (!this.ignorePlanarRegions.get() && this.planarRegionsList.get() != null && this.planarRegionsList.get().getNumberOfPlanarRegions() > 0) {
            FramePose3D wiggledPose = new FramePose3D((FramePose3DReadOnly)adjustedBasedOnStanceFoot);
            this.footPolygonToWiggle.set((Vertex2DSupplier)this.footPolygons.get((Enum)footSide));
            try {
                this.snapAndWiggleSingleStep.snapAndWiggle(wiggledPose, (ConvexPolygon2DReadOnly)this.footPolygonToWiggle, this.forwardVelocityProperty.get() > 0.0);
                if (wiggledPose.containsNaN()) {
                    adjustedFootstep.getLocation().set((Tuple3DReadOnly)adjustedBasedOnStanceFoot.getPosition());
                    adjustedFootstep.getOrientation().set((QuaternionReadOnly)adjustedBasedOnStanceFoot.getOrientation());
                    return true;
                }
            }
            catch (SnapAndWiggleSingleStep.SnappingFailedException snappingFailedException) {
                // empty catch block
            }
            adjustedFootstep.getLocation().set((Tuple3DReadOnly)wiggledPose.getPosition());
            adjustedFootstep.getOrientation().set((QuaternionReadOnly)wiggledPose.getOrientation());
            return true;
        }
        adjustedFootstep.getLocation().set((Tuple3DReadOnly)adjustedBasedOnStanceFoot.getPosition());
        adjustedFootstep.getOrientation().set((QuaternionReadOnly)adjustedBasedOnStanceFoot.getOrientation());
        return true;
    }

    private void updateForwardVelocity(double alpha) {
        double minMaxVelocity = this.stepParametersReference.get().getMaxStepLength() / this.stepTime.getValue();
        this.forwardVelocityProperty.set(minMaxVelocity * MathTools.clamp((double)alpha, (double)1.0));
    }

    private void updateLateralVelocity(double alpha) {
        double minMaxVelocity = this.stepParametersReference.get().getMaxStepWidth() / this.stepTime.getValue();
        this.lateralVelocityProperty.set(minMaxVelocity * MathTools.clamp((double)alpha, (double)1.0));
    }

    private void updateTurningVelocity(double alpha) {
        double minMaxVelocity = (this.stepParametersReference.get().getTurnMaxAngleOutward() - this.stepParametersReference.get().getTurnMaxAngleInward()) / this.stepTime.getValue();
        if (this.forwardVelocityProperty.get() < -1.0E-10) {
            alpha = -alpha;
        }
        this.turningVelocityProperty.set(minMaxVelocity * MathTools.clamp((double)alpha, (double)1.0));
    }

    public void startWalking() {
        this.isWalking.set(true);
        this.continuousStepGenerator.startWalking();
        this.hasSuccessfullyStoppedWalking.set(false);
    }

    public void stopWalking() {
        this.isWalking.set(false);
        this.footstepsToSendReference.set(null);
        this.continuousStepGenerator.stopWalking();
        this.sendPauseMessage();
        this.lastPublishedFootstepPlan = null;
    }

    private boolean isNotYetWalking() {
        return this.lastPublishedFootstepPlan == null;
    }

    private void sendPauseMessage() {
        PauseWalkingMessage pauseWalkingMessage = new PauseWalkingMessage();
        pauseWalkingMessage.setPause(true);
        this.pauseWalkingPublisher.accept(pauseWalkingMessage);
    }

    private void prepareFootsteps(FootstepDataListMessage footstepDataListMessage) {
        for (int i = 0; i < footstepDataListMessage.getFootstepDataList().size(); ++i) {
            FootstepDataMessage footstepDataMessage = (FootstepDataMessage)footstepDataListMessage.getFootstepDataList().get(i);
            footstepDataMessage.setSwingHeight(this.stepParametersReference.get().getSwingHeight());
        }
        this.footstepsToSendReference.set(new FootstepDataListMessage(footstepDataListMessage));
        this.footstepVisualizationPublisher.accept(footstepDataListMessage);
    }

    private void publishFootsteps() {
        FootstepDataListMessage footstepsToSend = this.footstepsToSendReference.getAndSet(null);
        if (footstepsToSend != null && this.isWalking.get()) {
            long millis = System.currentTimeMillis();
            LogTools.info((String)String.format("%d.%d: Publishing Footsteps", millis / 1000L, millis % 1000L));
            this.footstepPublisher.accept(footstepsToSend);
            this.lastPublishedFootstepPlan = footstepsToSend;
        }
        if (!this.isWalking.get() && !this.hasSuccessfullyStoppedWalking.get()) {
            this.sendPauseMessage();
        }
    }

    private boolean isSafeStepHeight(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        double heightChange = touchdownPose.getZ() - stancePose.getZ();
        return heightChange < this.steppingParameters.getMaxStepUp() && heightChange > -this.steppingParameters.getMaxStepDown();
    }

    private boolean isSafeDistanceFromObstacle(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (this.planarRegionsList.get() == null) {
            return true;
        }
        double halfStanceWidth = 0.5 * this.steppingParameters.getInPlaceWidth();
        double heightOffset = this.steppingParameters.getMaxStepUp();
        double soleYaw = touchdownPose.getYaw();
        double lateralOffset = swingSide.negateIfLeftSide(halfStanceWidth);
        double offsetX = -lateralOffset * Math.sin(soleYaw);
        double offsetY = lateralOffset * Math.cos(soleYaw);
        this.collisionDetector.setBoxPose(touchdownPose.getX() + offsetX, touchdownPose.getY() + offsetY, touchdownPose.getZ() + heightOffset, soleYaw);
        return !this.collisionDetector.checkForCollision().isCollisionDetected();
    }

    private boolean isStepSnappable(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (this.planarRegionsList.get() == null) {
            return true;
        }
        this.tempTransform.getTranslation().set(touchdownPose.getPosition().getX(), touchdownPose.getPosition().getY(), 0.0);
        this.tempTransform.getRotation().setToYawOrientation(touchdownPose.getYaw());
        this.footPolygon.set((Vertex2DSupplier)this.footPolygons.get((Enum)swingSide));
        this.footPolygon.applyTransform((Transform)this.tempTransform, false);
        PlanarRegionsList planarRegionsList = this.planarRegionsList.get();
        return PlanarRegionsListPolygonSnapper.snapPolygonToPlanarRegionsList((ConvexPolygon2DReadOnly)this.footPolygon, (PlanarRegionsList)planarRegionsList, (double)Double.POSITIVE_INFINITY, (PlanarRegion)this.tempRegion) != null;
    }

    protected void updateDirectionalInputs() {
        DirectionalControlInputCommand inputMessage = this.controlInputCommand.getAndSet(null);
        if (inputMessage != null) {
            this.updateForwardVelocity(inputMessage.getForward());
            this.updateLateralVelocity(-inputMessage.getRight());
            this.updateTurningVelocity(-inputMessage.getClockwise());
        }
    }

    protected void updateStateInputs() {
        DirectionalControlConfigurationCommand controlMessage = this.controlConfigurationCommand.getAndSet(null);
        if (controlMessage != null) {
            String profile = controlMessage.getProfileName();
            if (profile.length() > 0) {
                try {
                    this.controlParameters = this.userProfileManager.loadProfile(profile);
                    this.stepParametersReference = new AtomicReference<JoystickStepParametersProperty.JoystickStepParameters>(this.controlParameters);
                    LogTools.info((String)("Switched profile to " + profile));
                }
                catch (RuntimeException e) {
                    System.out.printf("Unable to load profile %s: %s\n", profile, e);
                }
            }
            if (this.isWalking.get() && !controlMessage.getEnableWalking()) {
                this.stopWalking();
            } else if (!this.isWalking.get() && controlMessage.getEnableWalking()) {
                this.startWalking();
            }
        }
    }

    protected void handleIncomingMessages() {
        this.updateDirectionalInputs();
        this.updateStateInputs();
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
        PauseWalkingMessage pauseWalkingMessage = new PauseWalkingMessage();
        pauseWalkingMessage.setPause(true);
        this.pauseWalkingPublisher.accept(pauseWalkingMessage);
    }

    @Override
    public boolean initialize() {
        return true;
    }

    @Override
    public void updateInternal() throws Exception {
        try {
            while (!this.queuedTasksToProcess.isEmpty()) {
                this.queuedTasksToProcess.poll().run();
            }
            if (!this.supportFootPosesInitialized) {
                if (this.isLeftFootInSupport.get() && this.isRightFootInSupport.get()) {
                    for (RobotSide robotSide : RobotSide.values) {
                        this.lastSupportFootPoses.put((Enum)robotSide, (Object)new FramePose3D((ReferenceFrame)this.getSoleFrame(robotSide)));
                    }
                    this.supportFootPosesInitialized = true;
                } else {
                    for (RobotSide robotSide : RobotSide.values) {
                        if (((AtomicBoolean)this.isFootInSupport.get((Enum)robotSide)).get()) continue;
                        LogTools.warn((String)(robotSide.getPascalCaseName() + " foot is not in support, cannot initialize foot poses."));
                    }
                }
            }
            if (!this.supportFootPosesInitialized) {
                return;
            }
            for (RobotSide robotSide : RobotSide.values) {
                MovingReferenceFrame soleFrame;
                double currentHeight;
                if (!((AtomicBoolean)this.isFootInSupport.get((Enum)robotSide)).get() || !((currentHeight = (soleFrame = this.getSoleFrame(robotSide)).getTransformToWorldFrame().getTranslationZ()) < ((FramePose3D)this.lastSupportFootPoses.get((Enum)robotSide)).getZ())) continue;
                this.lastSupportFootPoses.put((Enum)robotSide, (Object)new FramePose3D((ReferenceFrame)soleFrame));
            }
            this.handleIncomingMessages();
            PlanarRegionsListMessage latestMessage = this.planarRegionsListMessage.getAndSet(null);
            if (latestMessage != null) {
                PlanarRegionsList planarRegionsList = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)latestMessage);
                this.snapAndWiggleSingleStep.setPlanarRegions(planarRegionsList);
                this.collisionDetector.setPlanarRegionsList(new PlanarRegionsList(planarRegionsList.getPlanarRegionsAsList().stream().filter(region -> region.getConvexHull().getArea() >= this.snapAndWiggleParameters.getMinPlanarRegionArea()).collect(Collectors.toList())));
                this.planarRegionsList.set(planarRegionsList);
            }
            JoystickStepParametersProperty.JoystickStepParameters stepParameters = this.stepParametersReference.get();
            this.continuousStepGenerator.setFootstepTiming(stepParameters.getSwingDuration(), stepParameters.getTransferDuration());
            this.continuousStepGenerator.update(Double.NaN);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LogTools.error((String)"Caught exception, stopping timer.");
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void notifyToolboxStateChange(ToolboxState newState) {
        if (newState == ToolboxState.SLEEP) {
            this.stopWalking();
        }
        LogTools.info((String)("Directional controller state is now " + newState.toString()));
    }
}

