/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import controller_msgs.msg.dds.ChestTrajectoryMessage;
import controller_msgs.msg.dds.FootTrajectoryMessage;
import controller_msgs.msg.dds.PelvisTrajectoryMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import ihmc_common_msgs.msg.dds.FrameInformation;
import ihmc_common_msgs.msg.dds.SE3TrajectoryMessage;
import ihmc_common_msgs.msg.dds.SE3TrajectoryPointMessage;
import ihmc_common_msgs.msg.dds.SO3TrajectoryMessage;
import ihmc_common_msgs.msg.dds.SO3TrajectoryPointMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.math.trajectories.generators.TrajectoryPointOptimizer;
import us.ihmc.robotics.partNames.RigidBodyName;
import us.ihmc.robotics.robotSide.RobotSide;

public class WholeBodyScriptPostProcessor {
    private final RigidBodyBasics rootBody;
    private final FloatingJointBasics rootJoint;
    private final int jointNameHash;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final FullHumanoidRobotModel fullRobotModel;
    private final HumanoidReferenceFrames referenceFrames;
    private final TrajectoryPointOptimizer trajectoryPointOptimizer;
    private double durationPerKeyframe = 1.0;
    private double trajectoryInitialDelay = 0.5;

    public WholeBodyScriptPostProcessor(FullHumanoidRobotModelFactory fullRobotModelFactory) {
        this.fullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.rootBody = this.fullRobotModel.getElevator();
        this.rootJoint = this.fullRobotModel.getRootJoint();
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel);
        this.jointNameHash = Arrays.hashCode(this.oneDoFJoints);
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        this.trajectoryPointOptimizer = new TrajectoryPointOptimizer(this.oneDoFJoints.length);
        for (int jointIndex = 0; jointIndex < this.oneDoFJoints.length; ++jointIndex) {
            System.out.println(this.oneDoFJoints[jointIndex].getName());
        }
    }

    public WholeBodyTrajectoryMessage generateWholeBodyMessage(List<KinematicsToolboxSnapshotDescription> rawScript, RigidBodyName[] rigidBodiesToControl, double[] trajectoryTiming) {
        int i;
        this.checkJointNameHash(rawScript);
        List<KinematicsToolboxOutputStatus> desiredRobotConfigurations = rawScript.stream().map(item -> item.getIkSolution()).collect(Collectors.toList());
        KinematicsToolboxOutputStatus startDesiredConfiguration = (KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(0);
        KinematicsToolboxOutputStatus targetDesiredConfiguration = (KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(desiredRobotConfigurations.size() - 1);
        int numberOfJoints = startDesiredConfiguration.getDesiredJointAngles().size();
        TDoubleArrayList startPosition = WholeBodyScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)startDesiredConfiguration.getDesiredJointAngles());
        TDoubleArrayList startVelocity = WholeBodyScriptPostProcessor.zeros(numberOfJoints);
        TDoubleArrayList targetPosition = WholeBodyScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)targetDesiredConfiguration.getDesiredJointAngles());
        TDoubleArrayList targetVelocity = WholeBodyScriptPostProcessor.zeros(numberOfJoints);
        ArrayList<TDoubleArrayList> waypoints = new ArrayList<TDoubleArrayList>();
        for (i = 0; i < desiredRobotConfigurations.size(); ++i) {
            waypoints.add(WholeBodyScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)((KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(i)).getDesiredJointAngles()));
        }
        this.trajectoryPointOptimizer.setEndPoints(startPosition, startVelocity, targetPosition, targetVelocity);
        this.trajectoryPointOptimizer.setWaypoints(waypoints);
        this.trajectoryPointOptimizer.compute(0);
        if (trajectoryTiming == null) {
            for (i = 0; i < 100 && !this.trajectoryPointOptimizer.doFullTimeUpdate(); ++i) {
                LogTools.info((String)("Iteration: " + i));
            }
        }
        double trajectoryDuration = (double)desiredRobotConfigurations.size() * this.durationPerKeyframe;
        WholeBodyTrajectoryMessage message = this.createWholebodyCommands(this.fullRobotModel, this.referenceFrames, rigidBodiesToControl, desiredRobotConfigurations, waypoints, trajectoryTiming, trajectoryDuration, this.trajectoryInitialDelay);
        return message;
    }

    public WholeBodyTrajectoryMessage createWholebodyCommands(FullHumanoidRobotModel fullRobotModel, HumanoidReferenceFrames humanoidReferenceFrames, RigidBodyName[] rigidBodiesToControl, List<KinematicsToolboxOutputStatus> desiredRobotConfigurations, List<TDoubleArrayList> waypoints, double[] trajectoryTiming, double trajectoryDuration, double startOffset) {
        RigidBodyBasics pelvis = fullRobotModel.getPelvis();
        RigidBodyBasics chest = fullRobotModel.getChest();
        RigidBodyBasics rightFoot = fullRobotModel.getFoot((Enum)RobotSide.RIGHT);
        RigidBodyBasics leftFoot = fullRobotModel.getFoot((Enum)RobotSide.LEFT);
        FramePose3D rightFootPose = new FramePose3D();
        FramePose3D pelvisPose = new FramePose3D();
        FrameQuaternion chestOrientation = new FrameQuaternion();
        Twist twist = new Twist();
        PelvisTrajectoryMessage pelvisTrajectoryMessage = new PelvisTrajectoryMessage();
        ChestTrajectoryMessage chestTrajectoryMessage = new ChestTrajectoryMessage();
        FootTrajectoryMessage rightFootTrajectoryMessage = new FootTrajectoryMessage();
        rightFootTrajectoryMessage.setRobotSide(RobotSide.RIGHT.toByte());
        SE3TrajectoryMessage pelvisTrajectory = pelvisTrajectoryMessage.getSe3Trajectory();
        SO3TrajectoryMessage chestOrientationTrajectory = chestTrajectoryMessage.getSo3Trajectory();
        SE3TrajectoryMessage rightFootTrajectory = rightFootTrajectoryMessage.getSe3Trajectory();
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        MovingReferenceFrame pelvisZUpFrame = humanoidReferenceFrames.getPelvisZUpFrame();
        MovingReferenceFrame leftFootFrame = humanoidReferenceFrames.getFootFrame(RobotSide.LEFT);
        ReferenceFrame pelvisTrajectoryReferenceFrame = worldFrame;
        ReferenceFrame footTrajectoryReferenceFrame = worldFrame;
        ReferenceFrame chestTrajectoryReferenceFrame = worldFrame;
        FrameInformation pelvisFrameInformation = pelvisTrajectory.getFrameInformation();
        pelvisFrameInformation.setDataReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)pelvisTrajectoryReferenceFrame));
        pelvisFrameInformation.setTrajectoryReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)pelvisTrajectoryReferenceFrame));
        FrameInformation chestTrajectoryFrameInformation = chestOrientationTrajectory.getFrameInformation();
        chestTrajectoryFrameInformation.setDataReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)chestTrajectoryReferenceFrame));
        chestTrajectoryFrameInformation.setTrajectoryReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)chestTrajectoryReferenceFrame));
        FrameInformation rightFootTrajectoryFrameInformation = rightFootTrajectory.getFrameInformation();
        rightFootTrajectoryFrameInformation.setDataReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)footTrajectoryReferenceFrame));
        rightFootTrajectoryFrameInformation.setTrajectoryReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)footTrajectoryReferenceFrame));
        for (int configurationIndex = 0; configurationIndex < desiredRobotConfigurations.size(); ++configurationIndex) {
            double waypointTime = this.trajectoryPointOptimizer.getWaypointTime(configurationIndex) * trajectoryDuration + startOffset;
            if (trajectoryTiming != null) {
                waypointTime = trajectoryTiming[configurationIndex] + startOffset;
            }
            System.out.println("waypointTime: " + waypointTime);
            KinematicsToolboxOutputStatus robotConfiguration = desiredRobotConfigurations.get(configurationIndex);
            Point3D desiredRootPosition = robotConfiguration.getDesiredRootPosition();
            Quaternion desiredRootOrientation = robotConfiguration.getDesiredRootOrientation();
            Vector3D desiredRootLinearVelocity = robotConfiguration.getDesiredRootLinearVelocity();
            Vector3D desiredRootAngularVelocity = robotConfiguration.getDesiredRootAngularVelocity();
            this.rootJoint.setJointPosition((Tuple3DReadOnly)desiredRootPosition);
            this.rootJoint.setJointOrientation((Orientation3DReadOnly)desiredRootOrientation);
            this.rootJoint.setJointLinearVelocity((Vector3DReadOnly)desiredRootLinearVelocity);
            this.rootJoint.setJointAngularVelocity((Vector3DReadOnly)desiredRootAngularVelocity);
            TDoubleArrayList jointAngles = waypoints.get(configurationIndex);
            TDoubleArrayList velocities = new TDoubleArrayList(this.oneDoFJoints.length);
            this.trajectoryPointOptimizer.getWaypointVelocity(velocities, configurationIndex);
            for (int jointIndex = 0; jointIndex < this.oneDoFJoints.length; ++jointIndex) {
                this.oneDoFJoints[jointIndex].setQ(jointAngles.get(jointIndex));
                this.oneDoFJoints[jointIndex].setQd(velocities.get(jointIndex));
            }
            fullRobotModel.updateFrames();
            rightFootPose.setToZero((ReferenceFrame)rightFoot.getBodyFixedFrame());
            rightFootPose.changeFrame(worldFrame);
            rightFoot.getBodyFixedFrame().getTwistRelativeToOther(worldFrame, (TwistBasics)twist);
            SE3TrajectoryPointMessage footTrajectoryPoint = (SE3TrajectoryPointMessage)rightFootTrajectory.getTaskspaceTrajectoryPoints().add();
            footTrajectoryPoint.setTime(waypointTime);
            footTrajectoryPoint.getPosition().set((Tuple3DReadOnly)rightFootPose.getPosition());
            footTrajectoryPoint.getOrientation().set((QuaternionReadOnly)rightFootPose.getOrientation());
            footTrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)twist.getLinearPart());
            footTrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)twist.getAngularPart());
            chestOrientation.setToZero((ReferenceFrame)chest.getBodyFixedFrame());
            chestOrientation.changeFrame(worldFrame);
            chest.getBodyFixedFrame().getTwistRelativeToOther(worldFrame, (TwistBasics)twist);
            SO3TrajectoryPointMessage chestTrajectoryPoint = (SO3TrajectoryPointMessage)chestOrientationTrajectory.getTaskspaceTrajectoryPoints().add();
            chestTrajectoryPoint.setTime(waypointTime);
            chestTrajectoryPoint.getOrientation().set((QuaternionReadOnly)chestOrientation);
            pelvisPose.setToZero((ReferenceFrame)pelvis.getBodyFixedFrame());
            pelvisPose.changeFrame(worldFrame);
            pelvis.getBodyFixedFrame().getTwistRelativeToOther(worldFrame, (TwistBasics)twist);
            SE3TrajectoryPointMessage pelvisTrajectoryPoint = (SE3TrajectoryPointMessage)pelvisTrajectory.getTaskspaceTrajectoryPoints().add();
            pelvisTrajectoryPoint.setTime(waypointTime);
            pelvisTrajectoryPoint.getPosition().set((Tuple3DReadOnly)pelvisPose.getPosition());
            pelvisTrajectoryPoint.getOrientation().set((QuaternionReadOnly)pelvisPose.getOrientation());
        }
        WholeBodyTrajectoryMessage message = new WholeBodyTrajectoryMessage();
        block7: for (int i = 0; i < rigidBodiesToControl.length; ++i) {
            switch (rigidBodiesToControl[i]) {
                case CHEST: {
                    message.getChestTrajectoryMessage().set(chestTrajectoryMessage);
                    continue block7;
                }
                case PELVIS: {
                    message.getPelvisTrajectoryMessage().set(pelvisTrajectoryMessage);
                    continue block7;
                }
                case RIGHT_FOOT: {
                    message.getRightFootTrajectoryMessage().set(rightFootTrajectoryMessage);
                    continue block7;
                }
            }
        }
        return message;
    }

    private void checkJointNameHash(List<KinematicsToolboxSnapshotDescription> rawScript) {
        for (KinematicsToolboxSnapshotDescription item : rawScript) {
            if (item.getIkSolution().getJointNameHash() == this.jointNameHash) continue;
            throw new IllegalArgumentException("Incompatible script");
        }
    }

    private static TDoubleArrayList toTDoubleArrayList(TFloatArrayList input) {
        TDoubleArrayList output = new TDoubleArrayList(input.size());
        for (int i = 0; i < input.size(); ++i) {
            output.add((double)input.get(i));
        }
        return output;
    }

    private static TDoubleArrayList zeros(int size) {
        TDoubleArrayList output = new TDoubleArrayList(size);
        for (int i = 0; i < size; ++i) {
            output.add(0.0);
        }
        return output;
    }

    public void setDurationPerKeyframe(double durationPerKeyframe) {
        this.durationPerKeyframe = durationPerKeyframe;
    }

    public void setTrajectoryInitialDelay(double trajectoryInitialDelay) {
        this.trajectoryInitialDelay = trajectoryInitialDelay;
    }
}

