/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.avatar.multiContact.MultiContactEnvironmentDescription;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;

public class MultiContactScriptWriter {
    private File scriptFile = null;
    private final List<FrameShape3DReadOnly> environmentShapes = new ArrayList<FrameShape3DReadOnly>();
    private final List<KinematicsToolboxSnapshotDescription> messagesToWrite = new ArrayList<KinematicsToolboxSnapshotDescription>();

    public boolean startNewScript(File scriptFile, boolean overrideExistingFile) {
        if (!scriptFile.exists()) {
            try {
                FileTools.ensureDirectoryExists((Path)scriptFile.getParentFile().toPath());
                scriptFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!overrideExistingFile) {
            return false;
        }
        try {
            scriptFile.delete();
            scriptFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.scriptFile = scriptFile;
        return true;
    }

    public void clearEnvironment() {
        this.environmentShapes.clear();
    }

    public void addEnvironmentShape(FrameShape3DReadOnly environmentShape) {
        this.environmentShapes.add(environmentShape);
    }

    public void setEnvironmentShapes(List<FrameShape3DBasics> environmentShapes) {
        this.environmentShapes.clear();
        this.environmentShapes.addAll(environmentShapes);
    }

    public void clearScript() {
        this.messagesToWrite.clear();
    }

    public void recordConfiguration(KinematicsToolboxSnapshotDescription description) {
        this.messagesToWrite.add(description);
    }

    public int getCurrentScriptSize() {
        return this.messagesToWrite.size();
    }

    public KinematicsToolboxSnapshotDescription getKeyFrame(int index) {
        return this.messagesToWrite.get(index);
    }

    public void remove(int index) {
        this.messagesToWrite.remove(index);
    }

    public boolean isEmpty() {
        return this.messagesToWrite.isEmpty();
    }

    public List<KinematicsToolboxSnapshotDescription> getAllItems() {
        return this.messagesToWrite;
    }

    public boolean removeLast() {
        if (this.messagesToWrite.isEmpty()) {
            return false;
        }
        this.messagesToWrite.remove(this.messagesToWrite.size() - 1);
        return true;
    }

    public boolean writeScript() {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(this.scriptFile);
            JsonFactory jsonFactory = new JsonFactory();
            ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
            ObjectNode rootNode = objectMapper.createObjectNode();
            ArrayNode environmentNode = rootNode.putArray("environment");
            ArrayNode scriptNode = rootNode.putArray("script");
            for (FrameShape3DReadOnly environmentShape : this.environmentShapes) {
                environmentNode.add(MultiContactEnvironmentDescription.toJSON(environmentShape));
            }
            for (KinematicsToolboxSnapshotDescription message : this.messagesToWrite) {
                scriptNode.add(message.toJSON(objectMapper));
            }
            objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)printStream, (Object)rootNode);
            printStream.close();
            this.scriptFile = null;
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (printStream != null) {
                printStream.close();
            }
            return false;
        }
    }
}

